#ifndef CN_MEMMON_H
#define CN_MEMMON_H

#include <linux/types.h>
#include <linux/connector.h>

/* The following commands are valid for the memmon operations */
#define MONITOR_SET 1
#define MONITOR_CLR 2
#define MONITOR_COLLECT 3

/* The default for memmon collect operations is to return the number of dirty
* user-readable pages.  The following  options may be OR'd together to
* specify additional behaviour.
*/
#define CHECK_DIRTY_STATE              0x001
#define CHECK_FLAGS                    0x002
#define STORE_MATCHING_PAGES           0x004
#define CLEAN_STORED_PAGES             0x008
#define CLEAN_MATCHING_PAGES           0x010
#define STOP_WHEN_BUF_FULL             0x020
#define CHECK_SWAPPED_STATE            0x040
#define VALID_PAGES_ONLY               0x080


/* This is the data structure for memory monitor operations.
 * "cmd" is the requested operation
 * "start" and "end" give the address range of interest
 * "flags" is set/matched against the flags set for the memory pages
 *
 * When specifying the collect operation, there are more fields that
 * must be filled in.
 * "buf" is a userspace buffer where we will dump the information
 * "bufsize" is the size of the buffer in bytes.
 * "options" specify variants of the data collection
 */
struct memmon_info {
	unsigned char flags;
	unsigned char cmd;
	unsigned short options;
	int bufsize;
	unsigned int buf;
	unsigned int start;
	unsigned int end;
	pid_t pid;
};

int memmon_set_address_flags(struct mm_struct *mm, struct memmon_info *args);
void memmon_clr_address_flags(struct mm_struct *mm, struct memmon_info *args);
int memmon_collect_data(struct mm_struct *mm, struct memmon_info *args);

#endif /* CN_MEMMON_H */
