/*
 * (C) Copyright Nissin Systems 2008
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <asm/io.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/config.h>
#include <linux/mtd/partitions.h>

static struct mtd_info *mifaxadp_mtd = NULL;

struct map_info mifaxadp_map = {
	.name = "flash",
	.size = 0x2000000,
	.phys = 0xFE000000,
	.bankwidth	= 8,
};

static struct mtd_partition mifaxadp_parts[] = {
	{
		.name =		"Reset Configuration Word",
		.size =		0x8000,
		.offset =	0,
		.mask_flags =	MTD_WRITEABLE,  /* force read-only */
	}, {
		.name =		"DSP initialization module",
		.size =		0x38000,
		.offset =	MTDPART_OFS_APPEND,
	}, {
		.name =		"Linux Kernel",
		.size =		0x200000,
		.offset =	MTDPART_OFS_APPEND,
	}, {
		.name =		"RAMDISK Image",
		.size =		0x17C0000,
		.offset =	MTDPART_OFS_APPEND,
	}, {
		.name =		"etc",
		.size =		0x200000,
		.offset =	MTDPART_OFS_APPEND,
	}, {
		.name =		"log",
		.size =		0x300000,
		.offset =	MTDPART_OFS_APPEND,
	} , {
		.name =		"U-Boot",
		.size =		0x80000,
		.offset =	MTDPART_OFS_APPEND,
	} , {
		.name =		"U-Boot(environment)",
		.size =		0x40000,
		.offset =	MTDPART_OFS_APPEND,
	}
};

int __init init_mifaxadp_flash(void)
{
	printk(KERN_NOTICE "MIFAXADP %s (%ld MiB at %08lx)\n",
			mifaxadp_map.name, (mifaxadp_map.size >> 20), 
			mifaxadp_map.phys);

	mifaxadp_map.virt = ioremap(mifaxadp_map.phys,
			mifaxadp_map.size);
	if (!mifaxadp_map.virt) {
		printk("Failed to ioremap\n");
		return -1;
	}
	simple_map_init(&mifaxadp_map);
	mifaxadp_mtd = do_map_probe("cfi_probe", &mifaxadp_map);
	if (!mifaxadp_mtd) {
		return -1;
	}
	mifaxadp_mtd->owner = THIS_MODULE;
	add_mtd_partitions(mifaxadp_mtd, mifaxadp_parts, ARRAY_SIZE(mifaxadp_parts));

	return 0;
}

static void __exit cleanup_mifaxadp_flash(void)
{
	if (!mifaxadp_mtd) {
		return;
	}

	del_mtd_partitions(mifaxadp_mtd);
	map_destroy(mifaxadp_mtd);
	iounmap((void *)mifaxadp_map.virt);
}

module_init(init_mifaxadp_flash);
module_exit(cleanup_mifaxadp_flash);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Nissin Systems");
MODULE_DESCRIPTION("Flash map driver for MIFAXADP");
