
                           
/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  mptutil.h
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  03/31/2003
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */
 
#ifdef __KERNEL_2_6__
#include <sysfs/libsysfs.h>
#endif

/************** Custom Include Files ************/
//#include "../lsi/mpi_type.h"
#include "iopcnfg.h"
#include "mptutil.h"
//#include "iopcnfg.h"
#include "enum.h"
//#include "../mptctl.h"
                           
                           

#define SUPPORTED_24_DRIVER    20601
#define SUPPORTED_26_DRIVER    30205
#define SPLIT_DRIVER_26        30250



/*
**  This file will hold prototypes for all functions ......
*/


/*
**  Fucntions from do.c
*/
U8   doAutoDLChecksum     (PTR_IOC_CONFIG_PAGES PtrData, int Length);
int  doBiosFcodeDownload  (MPT_PORT *port);
int  doBiosFcodeUpload    (MPT_PORT *port, unsigned char **outBuf, int *outLen, int type);
int  doBIOSPage1          (MPT_PORT *port);
int  doBiosUpload         (MPT_PORT *port);
int  doConfigurationPage  (MPT_PORT *port);
void doDisplayNvdata      (MPT_PORT *port, U32 action );
void dogetch              (void);
void doFlashBiosFcode     ( MPT_PORT *port );
void doFlashBiosFcodeEFI  ( MPT_PORT *port );
int  doFirmwareDownload   (MPT_PORT *port);
int  doFirmwareDownloadBoot (MPT_PORT *port, U8 type);
int  doFirmwareUpload     (MPT_PORT *port);
int  doFwDownload         (MPT_PORT *port, int type, unsigned char *buf, int len, int offset);
int  doFwUpload           (MPT_PORT *port, int type, unsigned char *buf, int len, int offset, int *outLen);
void doHelp               ( void );
int  doInquiry            (MPT_PORT *port, int bus, int target, int lun);
int  doIocInit            (MPT_PORT *port, int WhoInit);
int  doIOCPage0           (MPT_PORT *port);
int  doIOCPage1           (MPT_PORT *port);
int  doIOUnitPage1        (MPT_PORT *port);
int  doIOUnitPage2        (MPT_PORT *port);
int  doIOUnitPage3        (MPT_PORT *port);
int  doManufacturingPage0 (MPT_PORT *port);
int  doManufacturingPage1 (MPT_PORT *port);
int  doManufacturingPage2 (MPT_PORT *port);
int  doManufacturingPage3 (MPT_PORT *port);
int  doManufacturingPage4 (MPT_PORT *port);
int  doManufacturingPage5 (MPT_PORT *port);
int  doModeSelect         (MPT_PORT *port, PTR_SAS_DEVICE ptrSasDev, U32 Buffer_Size);
int  doModeSense          (MPT_PORT *port, PTR_SAS_DEVICE ptrSasDev, U8 PCF, U8 Page, U8 Clear_Data, U32 Buffer_Size, U8 DBD);
int  doMptCommand         (MPT_PORT *port, void *req, int reqSize, void *rep, int repSize, void *payIn, int payInSize, void *payOut, int payOutSize, int timeOut);
void doNvdataImage        ( void );
int  doPHYPage0           (MPT_PORT *port);
int  doPHYPage1           (MPT_PORT *port);
int  doPort               (MPT_PORT *port);
int  doReadBuffer         (MPT_PORT *port, int bus, int target, int lun, int mode, U32 size);
int  doReadCapacity       (MPT_PORT *port, int bus, int target, int lun);
int  doResetPort          (MPT_PORT *port, U32 type);
void doSASAddress         (MPT_PORT *port);
int  doSASIOUnitPage0     (MPT_PORT *port);
int  doSASIOUnitPage1     (MPT_PORT *port);
int  doSASIOUnitPage2     (MPT_PORT *port);
int  doSASIOUnitPage3     (MPT_PORT *port);
void doSASManufacturing_Info ( MPT_PORT *port );
void doSASPagesStructure  (PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry, int Index, U32 Value, char *PtrString, int Counter);
int  doScsiIo             (MPT_PORT *port, SCSIIORequest_t *req, int reqSize, SCSI_REPLY *rep, int repSize, void *payIn, int payInSize, void *payOut, int payOutSize, int timeOut);
int  doSplitBiosImage     (unsigned char **buf1, int *len1, unsigned char **buf2, int *len2);
void doTBoxClean          (MPT_PORT *port, U32 value);
int  doToolBox            (MPT_PORT *port);
int  doTUR                (MPT_PORT *port, int bus, int target, int lun);
int  doWriteBuffer        (MPT_PORT *port, int bus, int target, int lun, int mode);
void doWriteReadBufferTest(MPT_PORT *port);
void doWriteReadCache     (MPT_PORT *port, char option);




/*
**  Fucntions from get.c
*/
int  getCompatible       (int deviceId);
int  getConfigPage       (MPT_PORT *port, int type, int number, int address, void *page, int pageSize);
int  getConfigPageAction (MPT_PORT *port, int action, int type, int number, int address, void *page, int pageSize);
int  getConfigPageHeader (MPT_PORT *port, int type, int number, int address, ConfigReply_t *repOut);
U8   getDeviceList       (MPT_PORT *port);
void getFileNames        (int i );
int  getHbaPciInfo       (struct mpt_ioctl_hbapciinfo *hba_pciinfop);
int  getIocFacts         (MPT_PORT *port, IOCFactsReply_t *rep);
void getLineBuffer       (FILE *ptrDataFile, char *ptrBuffer);
int  getMptPciInfo       (struct mpt_ioctl_mptpciinfo *mpt_pciinfop, char *host_number);
int  getNvdataString     (char *PtrString, char *ptrLine );
int  getNumberAnswer     (int low, int high, int defvalue);
int  getPortFacts        (MPT_PORT *port, PortFactsReply_t *rep);
int  getPortInfo         (MPT_PORT *port);
int  getString           (char *buf, int len, FILE *file);
int  getWhatFromFirmware ( MPT_PORT *port );


/*
**  Fucntions from mptutil.c
*/
int  checkBiosValidity     (MPT_PORT *port, U32 *incoming_address, int len);
int  checkCompatible       (int fromFile, int fromHBA);
void checkDriverVersion    ( void );
unsigned char checksum     ( unsigned char * PtrPage, unsigned int PageSize, unsigned int HeaderType );
int  checkFirmwareValidity (MPT_PORT *port, char *name, U32 *address);
int  checkRAIDVerification_BIOS     ( MPT_PORT *port, U32 *IncomingAddress, int length );
int  checkRAIDVerification_Firmware ( MPT_PORT *port, U16 ProductInfo );
int  find_adapters         ( void );
U32  Firmware_Download_Checksum (U32* file_data, long int length);
int  fixupBiosFcodeImage   (MPT_PORT *port, unsigned char *buf, int len, int last);
void Flash_Nvdata          ( void );
void general_init          ( void );
int lsi_sysfs_check_availability (void);
void logPrint              (char *fmt, ...);
int  main                  (int argc, char *argv[]);
int  ParseCommandLine      ( MPT_PORT *port, int numAdapters );
int  ParseImageFile        ( long int filesize, U32 *address);
int  ParseNvdataFile       ( void );
int  processString         (char *inputString);
int  readFile              (char *name, unsigned char **outBuf, int *outLen);
void Scan                  (char *WWNtag, char *tracertag, char *assemblytag, int style);
int  selectAdapter         (int numAdapter, int commandLineSelection);
int  setConfigPageAction   (MPT_PORT *port, int action, int type, int number, int address, void *page, int pageSize);
void stripcrlf             (char *temp);
void ZeroGlobalMemory      ( U16 clear );

/*
**  Fucntions from nvdata.c
*/
int BiosPage1Data         (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int BiosPage2Data         (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter); 
int iocPage0Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int iocPage1Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int iocPage2Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int iocPage3Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int iocPage4Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int iocPage5Data          (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index);
int ioUnitPage0Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int ioUnitPage1Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int ioUnitPage2Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int ioUnitPage3Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int ioUnitPage4Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int manufacturingPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, char *PtrString, int Counter);
int manufacturingPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, char *PtrString, int Counter);
int manufacturingPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int manufacturingPage3Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int manufacturingPage4Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry, char *PtrString, U32 Value, int Counter);
int manufacturingPage5Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int RaidPhysDsk0Data      (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int RaidPhysDsk1Data      (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int RaidVolume0Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int RaidVolume1Data       (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasDevice0Data        (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasDevice1Data        (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasDevice2Data        (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasEnclosure0Data     (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasExpander0Data      (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasExpander1Data      (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasIoUnitPage0Data    (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter); 
int SasIoUnitPage1Data    (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasIoUnitPage2Data    (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasIoUnitPage3Data    (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasPersistIdData      (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasPhy0Data           (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);
int SasPhy1Data           (PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter);






