

/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  nvdata.c
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  12/17/2004
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */

/************* System Include Files ************/

#include <ctype.h> 
#include <fcntl.h>
#include <malloc.h>
#include <stdarg.h> 
#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <unistd.h>
//#include <pci/pci.h>
#include <asm/types.h>
#include <linux/byteorder/little_endian.h>

#ifdef __KERNEL_2_6__
#include <sysfs/libsysfs.h>
#endif

/************** Custom Include Files ************/

#define MPI_IO_UNIT_PAGE_3_GPIO_VAL_MAX  8
#define MPI_SAS_IOUNIT0_PHY_MAX          8
#define MPI_SAS_IOUNIT1_PHY_MAX          MPI_SAS_IOUNIT0_PHY_MAX


#include "../lsi/mpi_type.h"
#include "../lsi/mpi.h"
#include "../lsi/mpi_cnfg.h"
#include "../lsi/mpi_init.h"
#include "../lsi/mpi_ioc.h"

#include "proto.h"
#include "enum.h"
#include "../mptctl.h"
#include "iopcnfg.h"

       
                               
                               

extern int  currentPort;
extern int  mptutil;
extern int  gargc; 
extern char **gargv;
extern unsigned char *buffer1;
extern unsigned char *buffer2;
extern unsigned char *buffer3;

extern U16                  SasSeepromVersion;
extern FILE                *log_file; 
extern HOST_FLAG_STRUCT     flag_struct;
extern HOST_FLAG_STRUCT    *flag_ptr;
extern FORCE_UPDATE_STRUCT  force_update_struct;
extern FORCE_UPDATE_STRUCT *force_update_ptr;
extern MPT_PORT            *mptPorts[MAX_SUPPORTED_ADAPTERS];

extern char *PtrSeeprom_Keywords[];





int BiosPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    BIOS_1_ENUM dataPos;

    dataPos = (BIOS_1_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->Bios1.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->Bios1.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->Bios1.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->Bios1.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->BIOS1                    = (U8)Value; break; }

    case BIOS1_OPTIONS:             {ptrIocConfigData->Bios1.BiosOptions                = Value;      break;}
    case BIOS1_IOCSETTINGS:         {ptrIocConfigData->Bios1.IOCSettings                = Value;      break;}
    case BIOS1_RESERVED1:           {ptrIocConfigData->Bios1.Reserved1                  = Value;      break;}
    case BIOS1_DEVSETTINGS:         {ptrIocConfigData->Bios1.DeviceSettings             = Value;      break;}
    case BIOS1_NUMOFDEVS:           {ptrIocConfigData->Bios1.NumberOfDevices            = (U16)Value; break;}
    case BIOS1_RESERVED2:           {ptrIocConfigData->Bios1.Reserved2                  = (U16)Value; break;}
    case BIOS1_IOTIMOUTBLKDEVNONRM: {ptrIocConfigData->Bios1.IOTimeoutBlockDevicesNonRM = (U16)Value; break;}
    case BIOS1_IOTIMOUTSEQUENTIAL:  {ptrIocConfigData->Bios1.IOTimeoutSequential        = (U16)Value; break;}
    case BIOS1_IOTIMOUTOTHER:       {ptrIocConfigData->Bios1.IOTimeoutOther             = (U16)Value; break;}
    case BIOS1_IOTIMOUTBLKDEVRM:    {ptrIocConfigData->Bios1.IOTimeoutBlockDevicesRM    = (U16)Value; break;}
    default: {break;}
    }
                     
    if (dataPos == BIOS1_IOTIMOUTBLKDEVRM) {
        ptrIocConfigData->Bios1.Header.PageNumber  = 1;
        ptrIocConfigData->Bios1.Header.PageVersion = MPI_BIOSPAGE1_PAGEVERSION;
        ptrIocConfigData->Bios1.Header.PageType    = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_BIOS;
        ptrIocConfigData->Bios1.Header.PageLength  = sizeof(CONFIG_PAGE_BIOS_1) >> 2;
        done = TRUE;
    }
    return (done);
}


int BiosPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) { 

    int         i;
    int     done = FALSE;
    BIOS_2_ENUM dataPos;

    dataPos = (BIOS_2_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->Bios2.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->Bios2.Header.PageLength = (U8)Value;  break; }
    case PAGENUMBER:  { ptrIocConfigData->Bios2.Header.PageNumber = (U8)Value;  break; }
    case PAGETYPE:    { ptrIocConfigData->Bios2.Header.PageType = (U8)Value;    break; }
    case FORCEUPDATE: { force_update_ptr->BIOS2 = (U8)Value;                    break; }

    case BIOS2_BOOTDEVICEFORM:  { ptrIocConfigData->Bios2.BootDeviceForm                    = (U8)Value; break; }
    case BIOS2_SASADDRESS_HIGH: { ptrIocConfigData->Bios2.BootDevice.SasWwn.SASAddress.High = Value;        break; }
    case BIOS2_SASADDRESS_LOW:  { ptrIocConfigData->Bios2.BootDevice.SasWwn.SASAddress.Low  = Value;        break; }
    case BIOS2_SASADDRESS_LUN:  { 
                                  for (i=0; i < 8; i++) {
                                      ptrIocConfigData->Bios2.BootDevice.SasWwn.LUN[i] = (U8)Value;
                                  }
                                  break; }
    default: { break; }
    } // ends switch(dataPos)


    if (dataPos == BIOS2_SASADDRESS_LUN) {
        ptrIocConfigData->Bios2.Header.PageNumber  = 2;
        ptrIocConfigData->Bios2.Header.PageVersion = MPI_BIOSPAGE2_PAGEVERSION;
        ptrIocConfigData->Bios2.Header.PageType    = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_BIOS;
        ptrIocConfigData->Bios2.Header.PageLength  = sizeof(CONFIG_PAGE_BIOS_2) >> 2;
        done = TRUE;
    }
    return (done);
}





int iocPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {

    int done = FALSE;
    U8 i;
    IOC_PAGE_0_ENUM dataPos;

    dataPos = (IOC_PAGE_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage0[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage0[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage0[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage0[index].Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOCPage0 = (U8)Value;
            break;

        case TOTALNVSTORE:
            ptrIocConfigData->IocPage0[index].TotalNVStore = Value;
            break;
        case FREENVSTORE:
            ptrIocConfigData->IocPage0[index].FreeNVStore = Value;
            break;
        case IOC0_VENDORID:
            ptrIocConfigData->IocPage0[index].VendorID = (U16)Value;
            break;
        case IOC0_DEVICEID:
            ptrIocConfigData->IocPage0[index].DeviceID = (U16)Value;
            break;
        case IOC0_REVISIONID:
            ptrIocConfigData->IocPage0[index].RevisionID = (U8)Value;
            break;
        case IOC0_RESERVED:
            for (i=0; i < 3; i++)
            {
                ptrIocConfigData->IocPage0[index].Reserved[i] = (U8)Value;
            }
            break;
        case IOC0_CLASSCODE:
            ptrIocConfigData->IocPage0[index].ClassCode = Value;
            break;
        case IOC0_SUBSYSTEMVENDORID:
            ptrIocConfigData->IocPage0[index].SubsystemVendorID = (U16)Value;
            break;
        case IOC0_SUBSYSTEMID:
            ptrIocConfigData->IocPage0[index].SubsystemID = (U16)Value;
            break;
        default:
            break;
    }

    if (dataPos == IOC1_RESERVED) {
        ptrIocConfigData->IocPage0[index].Header.PageNumber  = 1;
        ptrIocConfigData->IocPage0[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_0) >> 2;
        ptrIocConfigData->IocPage0[index].Header.PageVersion = MPI_IOCPAGE1_PAGEVERSION;
        ptrIocConfigData->IocPage0[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_IOC);
        done = TRUE;
    }
    return (done);
}



int iocPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {

    int done = FALSE;
    U8 i;
    IOC_PAGE_1_ENUM dataPos;

    dataPos = (IOC_PAGE_1_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage1[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage1[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage1[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage1[index].Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOCPage1 = (U8)Value;
            break;

        case FLAGS:
            ptrIocConfigData->IocPage1[index].Flags = Value;
            break;
        case COALESCINGTIMEOUT:
            ptrIocConfigData->IocPage1[index].CoalescingTimeout = Value;
            break;
        case COALESCINGDEPTH:
            ptrIocConfigData->IocPage1[index].CoalescingDepth = (U8)Value;
            break;
        case PCISLOTNUM:
            ptrIocConfigData->IocPage1[index].PCISlotNum = (U8)Value;
            break;
        case IOC1_RESERVED:
            for (i=0; i < 2; i++)
            {
                ptrIocConfigData->IocPage1[index].Reserved[i] = (U8)Value;
            }
            break;
        default:
            break;
    }

    if (dataPos == IOC1_RESERVED) {
        ptrIocConfigData->IocPage1[index].Header.PageNumber  = 1;
        ptrIocConfigData->IocPage1[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_1) >> 2;
        ptrIocConfigData->IocPage1[index].Header.PageVersion = MPI_IOCPAGE1_PAGEVERSION;
        ptrIocConfigData->IocPage1[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_IOC); 
        done = TRUE;
    }
    return (done);
}



int iocPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {

    int done = FALSE;
    U8 i;
    IOC_PAGE_2_ENUM dataPos;

    dataPos = (IOC_PAGE_2_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage2[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage2[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage2[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage2[index].Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOCPage2 = (U8)Value;
            break;

        case CAPFLAGS:
            ptrIocConfigData->IocPage2[index].CapabilitiesFlags = Value;
            break;
        case NUMACTIVEVOLS:
            ptrIocConfigData->IocPage2[index].NumActiveVolumes = (U8)Value;
            break;
        case MAXVOLS:
            ptrIocConfigData->IocPage2[index].MaxVolumes = (U8)Value;
            break;
        case NUMACTPHYSDSKS:
            ptrIocConfigData->IocPage2[index].NumActivePhysDisks = (U8)Value;
            break;
        case MAXPHYSDSKS:
            ptrIocConfigData->IocPage2[index].MaxPhysDisks = (U8)Value;
            break;

        case VOLID:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].VolumeID = (U8)Value;
            }
            break;
        case VOLBUS:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].VolumeBus = (U8)Value;
            }
            break;
        case VOLIOC:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].VolumeIOC = (U8)Value;
            }
            break;
        case VOLPAGENUM:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].VolumePageNumber = (U8)Value;
            }
            break;
        case VOLTYPE:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].VolumeType = (U8)Value;
            }
            break;
        case IOC2_FLAGS:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].Flags = (U8)Value;
            }
            break;
        case IOC2_RESERVED:
            for (i=0; i < MPI_IOC_PAGE_2_RAID_VOLUME_MAX; i++)
            {
                ptrIocConfigData->IocPage2[index].RaidVolume[i].Reserved3 = (U16)Value;
            }
            break;
        default:
            break;
    }


    if (dataPos == IOC2_RESERVED) {
        ptrIocConfigData->IocPage2[index].Header.PageNumber  = 2;
        ptrIocConfigData->IocPage2[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_2) >> 2;
        ptrIocConfigData->IocPage2[index].Header.PageVersion = MPI_IOCPAGE2_PAGEVERSION;
        ptrIocConfigData->IocPage2[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_IOC);
        done = TRUE;
    }
    return (done);
}



int iocPage3Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {

    int done = FALSE;
    U8 i;
    IOC_PAGE_3_ENUM dataPos;

    dataPos = (IOC_PAGE_3_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage3[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage3[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage3[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage3[index].Header.PageType = (U8)Value;
            break;
       case FORCEUPDATE:
            force_update_ptr->IOCPage3 = (U8)Value;
            break;

        case NUM_PHYS_DSKS:
            ptrIocConfigData->IocPage3[index].NumPhysDisks = (U8)Value;
            break;
        case IOC3_RESERVED1:
            ptrIocConfigData->IocPage3[index].Reserved1 = (U8)Value;
            break;
        case IOC3_RESERVED2:
            ptrIocConfigData->IocPage3[index].Reserved2 = (U16)Value;
            break;
        case PHYS_DSK_ID:
            for (i=0; i < MPI_IOC_PAGE_3_PHYSDISK_MAX; i++)
            {
                ptrIocConfigData->IocPage3[index].PhysDisk[i].PhysDiskID = (U8)Value;
            }
            break;
        case PHYS_DSK_BUS:
            for (i=0; i < MPI_IOC_PAGE_3_PHYSDISK_MAX; i++)
            {
                ptrIocConfigData->IocPage3[index].PhysDisk[i].PhysDiskBus = (U8)Value;
            }
            break;
        case PHYS_DSK_IOC:
            for (i=0; i < MPI_IOC_PAGE_3_PHYSDISK_MAX; i++)
            {
                ptrIocConfigData->IocPage3[index].PhysDisk[i].PhysDiskIOC = (U8)Value;
            }
            break;
        case PHYS_DSK_NUM:
            for (i=0; i < MPI_IOC_PAGE_3_PHYSDISK_MAX; i++)
            {
                ptrIocConfigData->IocPage3[index].PhysDisk[i].PhysDiskNum = (U8)Value;
            }
            break;
        default:
            break;
    }


    if (dataPos == PHYS_DSK_NUM) {
        ptrIocConfigData->IocPage3[index].Header.PageNumber  = 3;
        ptrIocConfigData->IocPage3[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_3) >> 2;
        ptrIocConfigData->IocPage3[index].Header.PageVersion = MPI_IOCPAGE1_PAGEVERSION;
        ptrIocConfigData->IocPage3[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_IOC); 
        done = TRUE;
    }
    return (done);
}



int iocPage4Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {

    int done = FALSE;
    U8 i;
    IOC_PAGE_4_ENUM dataPos;

    dataPos = (IOC_PAGE_4_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage4[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage4[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage4[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage4[index].Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOCPage4 = (U8)Value;
            break;

        case ACTIVESEP:
            ptrIocConfigData->IocPage4[index].ActiveSEP = (U8)Value;
            break;
        case MAXSEP:
            ptrIocConfigData->IocPage4[index].MaxSEP = (U8)Value;
            break;
        case IOC4_RESERVED1:
            ptrIocConfigData->IocPage4[index].Reserved1 = (U16)Value;
            break;
        case SEP_TARGET_ID:
            for (i=0; i < MPI_IOC_PAGE_4_SEP_MAX; i++)
            {
                ptrIocConfigData->IocPage4[index].SEP[i].SEPTargetID = (U8)Value;
            }
            break;
        case SEP_BUS:
            for (i=0; i < MPI_IOC_PAGE_4_SEP_MAX; i++)
            {
                ptrIocConfigData->IocPage4[index].SEP[i].SEPBus = (U8)Value;
            }
            break;
        case SEP_RESERVED:
            for (i=0; i < MPI_IOC_PAGE_4_SEP_MAX; i++)
            {
                ptrIocConfigData->IocPage4[index].SEP[i].Reserved = (U16)Value;
            }
            break;
        default:
            break;
    }


    if (dataPos == SEP_RESERVED) {
        ptrIocConfigData->IocPage4[index].Header.PageNumber  = 4;
        ptrIocConfigData->IocPage4[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_4) >> 2;
        ptrIocConfigData->IocPage4[index].Header.PageVersion = MPI_IOCPAGE1_PAGEVERSION;
        ptrIocConfigData->IocPage4[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_CHANGEABLE | MPI_CONFIG_PAGETYPE_IOC); 
        done = TRUE;
    }
    return (done);
}



int iocPage5Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter, int index) {
    
    int done = FALSE;
    U8 i;
    IOC_PAGE_5_ENUM dataPos;

    dataPos = (IOC_PAGE_5_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->IocPage5[index].Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IocPage5[index].Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IocPage5[index].Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IocPage5[index].Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOCPage5 = (U8)Value;
            break;

        case IOC5_RESERVED1:
            ptrIocConfigData->IocPage5[index].Reserved1 = Value;
            break;
        case NUMHOTSPARES:
            ptrIocConfigData->IocPage5[index].NumHotSpares = (U8)Value;
            break;
        case IOC5_RESERVED2:
            ptrIocConfigData->IocPage5[index].Reserved2 = (U8)Value;
            break;
        case IOC5_RESERVED3:
            ptrIocConfigData->IocPage5[index].Reserved3 = (U16)Value;
            break;
        case PHYSDSKNUM:
            for (i=0; i < MPI_IOC_PAGE_5_HOT_SPARE_MAX; i++)
            {
                ptrIocConfigData->IocPage5[index].HotSpare[i].PhysDiskNum = (U8)Value;
            }
            break;
        case HOTSPARE_RESERVED:
            for (i=0; i < MPI_IOC_PAGE_5_HOT_SPARE_MAX; i++)
            {
                ptrIocConfigData->IocPage5[index].HotSpare[i].Reserved = (U8)Value;
            }
            break;
        case HOTSPAREPOOL:
            for (i=0; i < MPI_IOC_PAGE_5_HOT_SPARE_MAX; i++)
            {
                ptrIocConfigData->IocPage5[index].HotSpare[i].HotSparePool = (U8)Value;
            }
            break;
        case HOTSPARE_FLAGS:
            for (i=0; i < MPI_IOC_PAGE_5_HOT_SPARE_MAX; i++)
            {
                ptrIocConfigData->IocPage5[index].HotSpare[i].Flags = (U8)Value;
            }
            break;
        default:
            break;
    }


    if (dataPos == HOTSPARE_FLAGS) {
        ptrIocConfigData->IocPage5[index].Header.PageNumber  = 5;
        ptrIocConfigData->IocPage5[index].Header.PageLength  = sizeof(CONFIG_PAGE_IOC_5) >> 2;
        ptrIocConfigData->IocPage5[index].Header.PageVersion = MPI_IOCPAGE1_PAGEVERSION;
        ptrIocConfigData->IocPage5[index].Header.PageType    = (MPI_CONFIG_PAGEATTR_CHANGEABLE | MPI_CONFIG_PAGETYPE_IOC);
        done = TRUE;
    }
    return (done);
}





int ioUnitPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    IO_UNIT_PAGE_0_ENUM dataPos;

    dataPos = (IO_UNIT_PAGE_0_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION:
            ptrIocConfigData->IoUnitPage0.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IoUnitPage0.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IoUnitPage0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IoUnitPage0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOUnitPage0 = (U8)Value;
            break;
        case IOU0_UVALUE:
            ptrIocConfigData->IoUnitPage0.UniqueValue.Low  = Value;
            ptrIocConfigData->IoUnitPage0.UniqueValue.High = Value;
            break;
        default:
            break;
    }

    if (dataPos == IOU0_UVALUE) {
        ptrIocConfigData->IoUnitPage0.Header.PageVersion = MPI_IOUNITPAGE0_PAGEVERSION;
        ptrIocConfigData->IoUnitPage0.Header.PageLength  = sizeof(CONFIG_PAGE_IO_UNIT_0) >> 2;
        ptrIocConfigData->IoUnitPage0.Header.PageNumber  = 0;
        ptrIocConfigData->IoUnitPage0.Header.PageType    = (MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_IO_UNIT);
        done = TRUE;
    }
    return (done);
}



int ioUnitPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {
    int done = FALSE;
    IO_UNIT_PAGE_1_ENUM dataPos;

    dataPos = (IO_UNIT_PAGE_1_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION:
            ptrIocConfigData->IoUnitPage1.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IoUnitPage1.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IoUnitPage1.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IoUnitPage1.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOUnitPage1 = (U8)Value;
            break;
        case IOU1_FLAGS:
            ptrIocConfigData->IoUnitPage1.Flags = Value;
            break;
        default:
            break;
    } 

    if (dataPos == IOU1_FLAGS) {
        ptrIocConfigData->IoUnitPage1.Header.PageVersion = MPI_IOUNITPAGE1_PAGEVERSION;
        ptrIocConfigData->IoUnitPage1.Header.PageLength  = sizeof(CONFIG_PAGE_IO_UNIT_1) >> 2;
        ptrIocConfigData->IoUnitPage1.Header.PageNumber  = 1;
        ptrIocConfigData->IoUnitPage1.Header.PageType    = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_IO_UNIT);
        done = TRUE;
    }
    return (done);
}



int ioUnitPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {
    
    int i;
    int done = FALSE;
    IO_UNIT_PAGE_2_ENUM dataPos;

    dataPos = (IO_UNIT_PAGE_2_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION:  { ptrIocConfigData->IoUnitPage2.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:   { ptrIocConfigData->IoUnitPage2.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:   { ptrIocConfigData->IoUnitPage2.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:     { ptrIocConfigData->IoUnitPage2.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE:  { force_update_ptr->IOUnitPage2                    = (U8)Value; break; }
    case IOU2_FLAGS:   { ptrIocConfigData->IoUnitPage2.Flags              = Value;        break; }
    case BIOSVERSION:  { ptrIocConfigData->IoUnitPage2.BiosVersion        = Value;        break; }
    case PCIBUSNUMBER: { 
                         for (i=0; i < 4; i++) {
                             ptrIocConfigData->IoUnitPage2.AdapterOrder[i].PciBusNumber = (U8)Value;
                         }
                         break; }
    case PCIDEVICEFUNCTIONNUMBER: {
                         for (i=0; i < 4; i++) {
                             ptrIocConfigData->IoUnitPage2.AdapterOrder[i].PciDeviceAndFunctionNumber = (U8)Value;
                         }
                         break; }
    case ADAPTERFLAGS: {
                         for (i=0; i < 4; i++) {
                             ptrIocConfigData->IoUnitPage2.AdapterOrder[i].AdapterFlags = (U16)Value;
                         }
                         break; }
    default:           { break; }
    } // ends switch(dataPos) {
    
    if (dataPos == ADAPTERFLAGS) {
        ptrIocConfigData->IoUnitPage2.Header.PageVersion = MPI_IOUNITPAGE2_PAGEVERSION;
        ptrIocConfigData->IoUnitPage2.Header.PageLength  = sizeof(CONFIG_PAGE_IO_UNIT_2) >> 2;
        ptrIocConfigData->IoUnitPage2.Header.PageNumber  = 2;
        ptrIocConfigData->IoUnitPage2.Header.PageType    = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_IO_UNIT);
        done = TRUE;
    }
    return (done);
}



int ioUnitPage3Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    IO_UNIT_PAGE_3_ENUM dataPos;

    dataPos = (IO_UNIT_PAGE_3_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION:
            ptrIocConfigData->IoUnitPage3.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IoUnitPage3.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IoUnitPage3.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IoUnitPage3.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOUnitPage3 = (U8)Value;
            break;
        case GPIOCOUNT:
            ptrIocConfigData->IoUnitPage3.GPIOCount = (U8)Value;
            break;
        case IOU3_RESERVED1:
            ptrIocConfigData->IoUnitPage3.Reserved1 = (U8)Value;
            break;
        case IOU3_RESERVED2:
            ptrIocConfigData->IoUnitPage3.Reserved2 = (U16)Value;
            break;
        case GPIOVAL_0:
            ptrIocConfigData->IoUnitPage3.GPIOVal[0] = (U16)Value;
            break;
        case GPIOVAL_1:
            ptrIocConfigData->IoUnitPage3.GPIOVal[1] = (U16)Value;
            break;
        case GPIOVAL_2:
            ptrIocConfigData->IoUnitPage3.GPIOVal[2] = (U16)Value;
            break;
        case GPIOVAL_3:
            ptrIocConfigData->IoUnitPage3.GPIOVal[3] = (U16)Value;
            break;
        case GPIOVAL_4:
            ptrIocConfigData->IoUnitPage3.GPIOVal[4] = (U16)Value;
            break;
        case GPIOVAL_5:
            ptrIocConfigData->IoUnitPage3.GPIOVal[5] = (U16)Value;
            break;
        case GPIOVAL_6:
            ptrIocConfigData->IoUnitPage3.GPIOVal[6] = (U16)Value;
            break;
        case GPIOVAL_7:
            ptrIocConfigData->IoUnitPage3.GPIOVal[7] = (U16)Value;
            break;
        default:
            break;
    }

    if (dataPos == GPIOVAL_7) {
        ptrIocConfigData->IoUnitPage3.Header.PageVersion = MPI_IOUNITPAGE3_PAGEVERSION;
        ptrIocConfigData->IoUnitPage3.Header.PageLength  = sizeof(CONFIG_PAGE_IO_UNIT_3) >> 2;
        ptrIocConfigData->IoUnitPage3.Header.PageNumber  = 3;
        ptrIocConfigData->IoUnitPage3.Header.PageType    = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_IO_UNIT);
        done = TRUE;
    }
    return (done);
}



int ioUnitPage4Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    IO_UNIT_PAGE_4_ENUM dataPos;

    dataPos = (IO_UNIT_PAGE_4_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION:
            ptrIocConfigData->IoUnitPage4.Header.PageVersion          = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->IoUnitPage4.Header.PageLength           = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->IoUnitPage4.Header.PageNumber           = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->IoUnitPage4.Header.PageType             = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->IOUnitPage4 = (U8)Value;
            break;
        case IOU4_RESERVED1:
            ptrIocConfigData->IoUnitPage4.Reserved1                   = Value;
            break;
        case FWIMAGE_FLAGS:
            ptrIocConfigData->IoUnitPage4.FWImageSGE.FlagsLength      = Value;
            break;
        case FWIMAGE_64HIGH:
            ptrIocConfigData->IoUnitPage4.FWImageSGE.u.Address64.High = Value;
            break;
        case FWIMAGE_64LOW:
            ptrIocConfigData->IoUnitPage4.FWImageSGE.u.Address64.Low  = Value;
            break;
        default:
            break;
    }

    if (dataPos == FWIMAGE_64LOW) {
        //ptrIocConfigData->IoUnitPage4.Header.PageVersion = MPI_IOUNITPAGE4_PAGEVERSION;
        //ptrIocConfigData->IoUnitPage4.Header.PageLength  = sizeof(CONFIG_PAGE_IO_UNIT_4) >> 2;
        //ptrIocConfigData->IoUnitPage4.Header.PageNumber  = 4;
        //ptrIocConfigData->IoUnitPage4.Header.PageType    = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_IO_UNIT);
        done = TRUE;
    }
    return (done);
}





int LogPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    LOG_0_ENUM dataPos;

    int done = FALSE;
    U8  i, *tmpptr;

    dataPos = (LOG_0_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION2:
            ptrIocConfigData->Log0.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->Log0.Header.Reserved1   = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->Log0.Header.PageNumber  = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->Log0.Header.PageType    = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->LOG0 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->Log0.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->Log0.Header.ExtPageType   = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->Log0.Header.Reserved2     = (U8)Value;
            break;
                
        case LOG0_ALL:
            tmpptr = (U8 *)&ptrIocConfigData->Log0.Reserved1;
            for (i = 0; i < sizeof(CONFIG_PAGE_LOG_0); i++)
            {
                tmpptr[i] = 0x00;
            }                  

        default:
            break;
    }


    if (dataPos == LOG0_ALL)
    {
        ptrIocConfigData->Log0.Header.PageNumber    = 0;
        ptrIocConfigData->Log0.Header.PageVersion   = MPI_LOG_0_PAGEVERSION;
        ptrIocConfigData->Log0.Header.PageType      = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->Log0.Header.ExtPageLength = sizeof(CONFIG_PAGE_LOG_0) >> 2;
        ptrIocConfigData->Log0.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_LOG;

        done = TRUE;
    }
    return (done);
}







int manufacturingPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, char *PtrString, int Counter) {

    int done = FALSE;
    MANUFACTURING_PAGE_0_ENUM dataPos;

    dataPos = (MANUFACTURING_PAGE_0_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->MfgPage0.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->MfgPage0.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->MfgPage0.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->MfgPage0.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->ManufacturingPage0          = (U8)Value; break; }

    case CHIPNAME:      { strcpy((char *)ptrIocConfigData->MfgPage0.ChipName,              PtrString); break; }
    case CHIPREVISION:  { strcpy((char *)ptrIocConfigData->MfgPage0.ChipRevision,          PtrString); break; }
    case BOARDNAME:     { strcpy((char *)ptrIocConfigData->MfgPage0.BoardName,             PtrString); break; }
    case BOARDASSEMBLY: { strcpy((char *)ptrIocConfigData->MfgPage0.BoardAssembly,         PtrString); break; }
    case BOARDTRACERNUMBER: { strcpy((char *)ptrIocConfigData->MfgPage0.BoardTracerNumber, PtrString); break; }
    default: { break; }
    }

    if (dataPos == BOARDTRACERNUMBER) {
        ptrIocConfigData->MfgPage0.Header.PageVersion = MPI_MANUFACTURING0_PAGEVERSION;
        ptrIocConfigData->MfgPage0.Header.PageLength = sizeof(CONFIG_PAGE_MANUFACTURING_0) / 4;
        ptrIocConfigData->MfgPage0.Header.PageNumber = 0;
        done = TRUE;
    }
    return (done);
}




int manufacturingPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, char *PtrString, int Counter) {

    int done = FALSE;
    MANUFACTURING_PAGE_1_ENUM dataPos;

    dataPos = (MANUFACTURING_PAGE_1_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->MfgPage1.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->MfgPage1.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->MfgPage1.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->MfgPage1.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->ManufacturingPage1          = (U8)Value; break; }

    case VPD: { strcpy((char *)ptrIocConfigData->MfgPage1.VPD, PtrString);         break; }
    default:  { break; }
    }

    if (dataPos == VPD) {
        ptrIocConfigData->MfgPage1.Header.PageVersion = MPI_MANUFACTURING1_PAGEVERSION;
        ptrIocConfigData->MfgPage1.Header.PageLength  =  sizeof(CONFIG_PAGE_MANUFACTURING_1) >> 2;
        ptrIocConfigData->MfgPage1.Header.PageNumber  = 1;
        done = TRUE;
    }
    return (done);
}



int manufacturingPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    IOC_CNFG_MFG_PAGE_2_ENUM dataPos;

    dataPos = (IOC_CNFG_MFG_PAGE_2_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->MfgPage2.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->MfgPage2.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->MfgPage2.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->MfgPage2.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->ManufacturingPage2          = (U8)Value; break; }

    case MP2_DEVICEID:      { ptrIocConfigData->MfgPage2.ChipId.DeviceID        = (U8)Value;  break; }
    case MP2_PCIREVISIONID: { ptrIocConfigData->MfgPage2.ChipId.PCIRevisionID   = (U8)Value;  break; }
    case MP2_RESERVED:      { ptrIocConfigData->MfgPage2.ChipId.Reserved        = (U8)Value;  break; }
    case SSIDFUNCTION0:     { ptrIocConfigData->MfgPage2.SubSystemIDFunc0       = (U16)Value; break; }
    case SSVIDFUNCTION0:    { ptrIocConfigData->MfgPage2.SubSystemVendorIDFunc0 = (U16)Value; break; }
    case PCIMEMDIAGSIZE:    { ptrIocConfigData->MfgPage2.PCIMemDiagSize         = (U8)Value;  break; }
    case PF_RESERVED0:      { ptrIocConfigData->MfgPage2.Reserved05             = (U8)Value;  break; }
    case SSIDFUNCTION1:     { ptrIocConfigData->MfgPage2.SubSystemIDFunc1       = (U16)Value; break; }
    case SSVIDFUNCTION1:    { ptrIocConfigData->MfgPage2.SubSystemVendorIDFunc1 = (U16)Value; break; }
    case PCIFACTORYSETTINGSCHECKSUM: { ptrIocConfigData->MfgPage2.AutoDownloadChecksum = (U8)Value; break; }
    case PF_RESERVED1:      { ptrIocConfigData->MfgPage2.Reserved0B             = (U8)Value;  break; }
    case VENDORIDDEVICEIDLOCK:       { ptrIocConfigData->MfgPage2.VendorIDDeviceIDLock = (U8)Value; break; }
    case PF_RESERVED2:      { ptrIocConfigData->MfgPage2.Reserved0D             = (U8)Value;  break; }
    case VENDORID0:         { ptrIocConfigData->MfgPage2.VendorID0              = (U16)Value; break; }
    case DEVICEID0:         { ptrIocConfigData->MfgPage2.DeviceID0              = (U16)Value; 
                              flag_ptr->Nvdata_DeviceID                         = (U16)Value; break; }
    case VENDORID1:         { ptrIocConfigData->MfgPage2.VendorID1              = (U16)Value; break; }
    case DEVICEID1:         { ptrIocConfigData->MfgPage2.DeviceID1              = (U16)Value; break; }
    case BASECLASS0:        { ptrIocConfigData->MfgPage2.ClassCode0[2]          = (U8)Value;  break; }
    case SUBCLASS0:         { ptrIocConfigData->MfgPage2.ClassCode0[1]          = (U8)Value;  break; }
    case SPECIFICCLASS0:    { ptrIocConfigData->MfgPage2.ClassCode0[0]          = (U8)Value;  break; }
    case PF_RESERVED3:      { ptrIocConfigData->MfgPage2.Reserved19             = (U8)Value;  break; }
    case BASECLASS1:        { ptrIocConfigData->MfgPage2.ClassCode1[2]          = (U8)Value;  break; }
    case SUBCLASS1:         { ptrIocConfigData->MfgPage2.ClassCode1[1]          = (U8)Value;  break; }
    case SPECIFICCLASS1:    { ptrIocConfigData->MfgPage2.ClassCode1[0]          = (U8)Value;  break; }
    case PF_RESERVED4:      { ptrIocConfigData->MfgPage2.Reserved1D             = (U8)Value;  break; }
    case HARDWARECONFIG:    { ptrIocConfigData->MfgPage2.HardwareConfig         = (U16)Value; break; }
    case OPTIONROMOFFSETFUNC0:       { ptrIocConfigData->MfgPage2.OptionRomOffset0   = Value; break; }
    case OPTIONROMOFFSETFUNC1:       { ptrIocConfigData->MfgPage2.OptionRomOffset1   = Value; break; }
    default: { break; }
    }

    if (dataPos == OPTIONROMOFFSETFUNC1) {
        ptrIocConfigData->MfgPage2.Header.PageVersion = MPI_MANUFACTURING2_PAGEVERSION;
        ptrIocConfigData->MfgPage2.Header.PageLength  = (sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2)) >> 2;
        ptrIocConfigData->MfgPage2.Header.PageNumber  = 2;
        done = TRUE;
    }
    return (done);
}                                    




int manufacturingPage3Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    IOC_CNFG_MFG_PAGE_3_ENUM dataPos;

    dataPos = (IOC_CNFG_MFG_PAGE_3_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->MfgPage3.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->MfgPage3.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->MfgPage3.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->MfgPage3.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->ManufacturingPage3          = (U8)Value; break; }
        
    case MP3_DEVICEID:         { ptrIocConfigData->MfgPage3.ChipId.DeviceID      = (U8)Value;  break; }
    case MP3_PCIREVISIONID:    { ptrIocConfigData->MfgPage3.ChipId.PCIRevisionID = (U8)Value;  break; }
    case MP3_RESERVED:         { ptrIocConfigData->MfgPage3.ChipId.Reserved      = (U8)Value;  break; }
    case MP3_GPIODEFINITION_0: { ptrIocConfigData->MfgPage3.GPIODefinition[0]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_1: { ptrIocConfigData->MfgPage3.GPIODefinition[1]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_2: { ptrIocConfigData->MfgPage3.GPIODefinition[2]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_3: { ptrIocConfigData->MfgPage3.GPIODefinition[3]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_4: { ptrIocConfigData->MfgPage3.GPIODefinition[4]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_5: { ptrIocConfigData->MfgPage3.GPIODefinition[5]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_6: { ptrIocConfigData->MfgPage3.GPIODefinition[6]    = (U16)Value; break; }
    case MP3_GPIODEFINITION_7: { ptrIocConfigData->MfgPage3.GPIODefinition[7]    = (U16)Value; break; }
    case FLASH_TIME:           { ptrIocConfigData->MfgPage3.FlashTime            = (U8)Value;  break; }
    case NVS_TIME:             { ptrIocConfigData->MfgPage3.NVTime               = (U8)Value;  break; }
    case FLAG:                 { ptrIocConfigData->MfgPage3.Flag                 = (U8)Value;  break; }
    case MP3_RESERVED1:        { ptrIocConfigData->MfgPage3.Reserved1[0]         = (U8)Value;
                                 ptrIocConfigData->MfgPage3.Reserved1[1]         = (U8)Value;  break; }
    case MP3_RESERVED2:        { ptrIocConfigData->MfgPage3.Reserved2[0]         = Value;
                                 ptrIocConfigData->MfgPage3.Reserved2[1]         = Value;
                                 ptrIocConfigData->MfgPage3.Reserved2[2]         = Value;      break; }

    case QUAD0HOTPLUGTIMEOUT:  { ptrIocConfigData->MfgPage3.QuadConfig[0].HotPlugTimeout = (U8)Value;  break; }
    case QUAD0MAXCMDFRAMES:    { ptrIocConfigData->MfgPage3.QuadConfig[0].MaxCmdFrames   = (U8)Value;  break; }
    case QUAD0RESERVED1:       { ptrIocConfigData->MfgPage3.QuadConfig[0].Reserved1      = (U16)Value; break; }
    case QUAD0RESERVED2:       { ptrIocConfigData->MfgPage3.QuadConfig[0].Reserved2[0]   = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[0].Reserved2[1]   = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[0].Reserved2[2]   = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[0].Reserved2[3]   = Value;      break; }
    case QUAD0PHY0GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[0].GigablazeConfig[0] = Value; break; }
    case QUAD0PHY0GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[0].GigablazeConfig[1] = Value; break; }
    case QUAD0PHY0GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[0].GigablazeConfig[2] = Value; break; }
    case QUAD0PHY0GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[0].GigablazeConfig[3] = Value; break; }
    case QUAD0PHY0RESERVED1:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[0].Reserved[0]      = Value; break; }
    case QUAD0PHY1GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[1].GigablazeConfig[0] = Value; break; }
    case QUAD0PHY1GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[1].GigablazeConfig[1] = Value; break; }
    case QUAD0PHY1GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[1].GigablazeConfig[2] = Value; break; }
    case QUAD0PHY1GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[1].GigablazeConfig[3] = Value; break; }
    case QUAD0PHY1RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[1].Reserved[0]        = Value; break; }
    case QUAD0PHY2GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[2].GigablazeConfig[0] = Value; break; }
    case QUAD0PHY2GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[2].GigablazeConfig[1] = Value; break; }
    case QUAD0PHY2GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[2].GigablazeConfig[2] = Value; break; }
    case QUAD0PHY2GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[2].GigablazeConfig[3] = Value; break; }
    case QUAD0PHY2RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[2].Reserved[0]        = Value; break; }
    case QUAD0PHY3GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[3].GigablazeConfig[0] = Value; break; }
    case QUAD0PHY3GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[3].GigablazeConfig[1] = Value; break; }
    case QUAD0PHY3GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[3].GigablazeConfig[2] = Value; break; }
    case QUAD0PHY3GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[3].GigablazeConfig[3] = Value; break; }
    case QUAD0PHY3RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[0].PhyConfig[3].Reserved[0]        = Value; break; }
    case QUAD1HOTPLUGTIMEOUT:  { ptrIocConfigData->MfgPage3.QuadConfig[1].HotPlugTimeout              = (U8)Value; break; }
    case QUAD1MAXCMDFRAMES:    { ptrIocConfigData->MfgPage3.QuadConfig[1].MaxCmdFrames                = (U8)Value;  break; }
    case QUAD1RESERVED1:       { ptrIocConfigData->MfgPage3.QuadConfig[1].Reserved1                  = (U16)Value; break; }
    case QUAD1RESERVED2:       { ptrIocConfigData->MfgPage3.QuadConfig[1].Reserved2[0]                    = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[1].Reserved2[1]                    = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[1].Reserved2[2]                    = Value;
                                 ptrIocConfigData->MfgPage3.QuadConfig[1].Reserved2[3]                    = Value; break; }
    case QUAD1PHY0GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[0].GigablazeConfig[0] = Value; break; }
    case QUAD1PHY0GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[0].GigablazeConfig[1] = Value; break; }
    case QUAD1PHY0GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[0].GigablazeConfig[2] = Value; break; }
    case QUAD1PHY0GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[0].GigablazeConfig[3] = Value; break; }
    case QUAD1PHY0RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[0].Reserved[0]        = Value; break; }
    case QUAD1PHY1GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[1].GigablazeConfig[0] = Value; break; }
    case QUAD1PHY1GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[1].GigablazeConfig[1] = Value; break; }
    case QUAD1PHY1GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[1].GigablazeConfig[2] = Value; break; }
    case QUAD1PHY1GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[1].GigablazeConfig[3] = Value; break; }
    case QUAD1PHY1RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[1].Reserved[0]        = Value; break; }
    case QUAD1PHY2GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[2].GigablazeConfig[0] = Value; break; }
    case QUAD1PHY2GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[2].GigablazeConfig[1] = Value; break; }
    case QUAD1PHY2GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[2].GigablazeConfig[2] = Value; break; }
    case QUAD1PHY2GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[2].GigablazeConfig[3] = Value; break; }
    case QUAD1PHY2RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[2].Reserved[0]        = Value; break; }
    case QUAD1PHY3GBCNFG0:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[3].GigablazeConfig[0] = Value; break; }
    case QUAD1PHY3GBCNFG1:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[3].GigablazeConfig[1] = Value; break; }
    case QUAD1PHY3GBCNFG2:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[3].GigablazeConfig[2] = Value; break; }
    case QUAD1PHY3GBCNFG3:     { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[3].GigablazeConfig[3] = Value; break; }
    case QUAD1PHY3RESERVED1:   { ptrIocConfigData->MfgPage3.QuadConfig[1].PhyConfig[3].Reserved[0]        = Value; break; }
    case RUNTIMECONFIG:        { ptrIocConfigData->MfgPage3.RuntimeConfig                             = (U8)Value; break; }
    case SGPIOTYPE:            { ptrIocConfigData->MfgPage3.SGPIOType                                 = (U8)Value; break; }
    case SGPIOFLAGS:           { ptrIocConfigData->MfgPage3.SGPIOFlags                                = (U8)Value; break;}
    default: { break; }
    }                  

    if (dataPos == QUAD1PHY3RESERVED1) {
        ptrIocConfigData->MfgPage3.Header.PageVersion = MPI_MANUFACTURING3_PAGEVERSION;
        ptrIocConfigData->MfgPage3.Header.PageLength  = sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3) >> 2;
        ptrIocConfigData->MfgPage3.Header.PageNumber  = 3;
        done = TRUE;
    }
    return (done);
}




int manufacturingPage4Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry, char *PtrString, U32 Value, int Counter) {
    
    int i, length;
    int done = FALSE;
    MANUFACTURING_PAGE_4_ENUM dataPos;
    
    dataPos = (MANUFACTURING_PAGE_4_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->MfgPage4.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->MfgPage4.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->MfgPage4.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->MfgPage4.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->ManufacturingPage4          = (U8)Value; break; }

    case MP4_RESERVED1: { ptrIocConfigData->MfgPage4.Reserved1   = Value;      break; }
    case INFOOFFSET0:   { ptrIocConfigData->MfgPage4.InfoOffset0 = (U8)Value;  break; }
    case INFOSIZE0:     { ptrIocConfigData->MfgPage4.InfoSize0   = (U8)Value;  break; }
    case INFOOFFSET1:   { ptrIocConfigData->MfgPage4.InfoOffset1 = (U8)Value;  break; }
    case INFOSIZE1:     { ptrIocConfigData->MfgPage4.InfoSize1   = (U8)Value;  break; }
    case INQUIRYSIZE:   { ptrIocConfigData->MfgPage4.InquirySize = (U8)Value;  break; }
    case MP4_FLAGS:     { ptrIocConfigData->MfgPage4.Flags       = (U8)Value;  break; }
    case MP4_RESERVED2: { ptrIocConfigData->MfgPage4.Reserved2   = (U16)Value; break; }

    /*
    ** Inquiry data.....
    */
    case DEVICE_TYPE:       { ptrInquiry->DeviceType         = (U8)Value; break; }
    case DEVICE_TYPE_MOD:   { ptrInquiry->DeviceTypeModifier = (U8)Value; break; }
    case VERSIONS:          { ptrInquiry->Versions           = (U8)Value; break; }
    case DATA_FORMAT:       { ptrInquiry->DataFormat         = (U8)Value; break; }
    case ADDITIONAL_LENGTH: { ptrInquiry->AdditionalLength   = (U8)Value; break; }
    case CAPABILITY_BITS: { ptrInquiry->CapabilityBits       = (U8)Value; break; }
    case VENDOR_ID:       { length = strlen(PtrString);
                            for (i=0; i < length; i++) {
                                ptrInquiry->VendorId[i] = *PtrString++;
                            } break; }
    case PRODUCT_ID:      { length = strlen(PtrString);
                            for (i=0; i < length; i++) {
                                ptrInquiry->ProductId[i] = *PtrString++;
                            } break; }
    case PRODUCT_REV:     { length = strlen(PtrString);
                            for (i=0; i < length; i++) {
                                ptrInquiry->ProductRevision[i] = *PtrString++;
                            } break; }
    case VENDOR_SPECIFIC: { length = strlen(PtrString);
                            for (i=0; i < length; i++) {
                                ptrInquiry->VendorSpecific[i] = *PtrString++;
                            } break; }
    case ISVOLUMESETTINGS:  { ptrIocConfigData->MfgPage4.ISVolumeSettings  = Value;     break; }
    case IMEVOLUMESETTINGS: { ptrIocConfigData->MfgPage4.IMEVolumeSettings = Value;     break; }
    case IMVOLUMESETTINGS:  { ptrIocConfigData->MfgPage4.IMVolumeSettings  = Value;     break; }
    case IS_DATASCRUBRATE:  { ptrIocConfigData->MfgPage4.ISDataScrubRate   = (U8)Value; break; }
    case IS_RESYNCRATE:     { ptrIocConfigData->MfgPage4.ISResyncRate      = (U8)Value; break; }
    case IME_DATASCRUBRATE: { ptrIocConfigData->MfgPage4.IMEDataScrubRate  = (U8)Value; break; }
    case IME_RESYNCRATE:    { ptrIocConfigData->MfgPage4.IMEResyncRate     = (U8)Value; break; }
    case IM_DATASCRUBRATE:  { ptrIocConfigData->MfgPage4.IMDataScrubRate   = (U8)Value; break; }
    case IM_RESYNCRATE:     { ptrIocConfigData->MfgPage4.IMResyncRate      = (U8)Value; break; }
    default: { break; }
    }

    if (dataPos == IM_RESYNCRATE) {
        ptrIocConfigData->MfgPage4.Header.PageVersion = MPI_MANUFACTURING4_PAGEVERSION;
        ptrIocConfigData->MfgPage4.Header.PageLength  = sizeof(CONFIG_PAGE_MANUFACTURING_4) >> 2;
        ptrIocConfigData->MfgPage4.Header.PageNumber  = 4;
        done = TRUE;
    }
    return (done);
}



int manufacturingPage5Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    MANUFACTURING_PAGE_5_ENUM dataPos;

    dataPos = (MANUFACTURING_PAGE_5_ENUM)Counter;

    switch(dataPos)
    {
        case PAGEVERSION:
            ptrIocConfigData->MfgPage5.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->MfgPage5.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->MfgPage5.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->MfgPage5.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->ManufacturingPage5 = (U8)Value;
            break;

        case BASEWWIDLOW:
            ptrIocConfigData->MfgPage5.BaseWWID.Low = Value;
            break;
        case BASEWWIDHIGH:
            ptrIocConfigData->MfgPage5.BaseWWID.High = Value;
            break;
        case MANUFACT_5_FLAGS:
            ptrIocConfigData->MfgPage5.Flags = (U8)Value;
            break;
        default:
            break;
    }

    if (dataPos == MANUFACT_5_FLAGS) {
        ptrIocConfigData->MfgPage5.Header.PageVersion = MPI_MANUFACTURING5_PAGEVERSION;
        ptrIocConfigData->MfgPage5.Header.PageLength  = sizeof(CONFIG_PAGE_MANUFACTURING_5) >> 2;
        ptrIocConfigData->MfgPage5.Header.PageNumber  = 5;
        done = TRUE;
    }
    return (done);
}




int RaidVolume0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    U8 i, *tmpptr;
    RAID_VOL_0_ENUM dataPos;

    dataPos = (RAID_VOL_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->RaidVolPage0.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->RaidVolPage0.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->RaidVolPage0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->RaidVolPage0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->RAIDVol0 = (U8)Value;
            break;

        case RAID0_ALL:
            tmpptr = (U8 *)&ptrIocConfigData->RaidVolPage0.VolumeID;
            for (i = 0; i < sizeof(CONFIG_PAGE_RAID_VOL_0); i++)
            {
                tmpptr[i] = 0x00;
            }                  

        default:
            break;
    }

    if (dataPos == RAID0_ALL) {
        ptrIocConfigData->RaidVolPage0.Header.PageNumber  = 0;
        ptrIocConfigData->RaidVolPage0.Header.PageVersion = MPI_RAIDVOLPAGE0_PAGEVERSION;
        ptrIocConfigData->RaidVolPage0.Header.PageType    = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_RAID_VOLUME;
        ptrIocConfigData->RaidVolPage0.Header.PageLength  = sizeof(CONFIG_PAGE_RAID_VOL_0) >> 2; 
        done = TRUE;
    }
    return (done);
}


int RaidVolume1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int         done = FALSE;
    RAID_VOL_1_ENUM dataPos;

    dataPos = (RAID_VOL_0_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->RaidVolPage1.Header.PageVersion = (U8)Value;  break; }
    case PAGELENGTH:  { ptrIocConfigData->RaidVolPage1.Header.PageLength  = (U8)Value;  break; }
    case PAGENUMBER:  { ptrIocConfigData->RaidVolPage1.Header.PageNumber  = (U8)Value;  break; }
    case PAGETYPE:    { ptrIocConfigData->RaidVolPage1.Header.PageType    = (U8)Value;  break; }
    case FORCEUPDATE: { force_update_ptr->RAIDVol1                        = (U8)Value;  break; }

    case RAIDVOL1_VOLUMEID:  { ptrIocConfigData->RaidVolPage1.VolumeID    = (U8)Value;  break; }
    case RAIDVOL1_VOLUMEBUS: { ptrIocConfigData->RaidVolPage1.VolumeBus   = (U8)Value;  break; }
    case RAIDVOL1_VOLUMEIOC: { ptrIocConfigData->RaidVolPage1.VolumeIOC   = (U8)Value;  break; }
    case RAIDVOL1_WWID_HIGH: { ptrIocConfigData->RaidVolPage1.WWID.High   = Value;      break; }
    case RAIDVOL1_WWID_LOW:  { ptrIocConfigData->RaidVolPage1.WWID.Low    = Value;      break; }

    default: { break; }
    } // ends switch(dataPos) {

    if (dataPos == RAIDVOL1_WWID_LOW) {
        ptrIocConfigData->RaidVolPage1.Header.PageNumber  = 1;
        ptrIocConfigData->RaidVolPage1.Header.PageVersion = MPI_RAIDVOLPAGE1_PAGEVERSION;
        ptrIocConfigData->RaidVolPage1.Header.PageType    = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_RAID_VOLUME;
        ptrIocConfigData->RaidVolPage1.Header.PageLength  = sizeof(CONFIG_PAGE_RAID_VOL_1) >> 2;
        done = TRUE;
    }
    return (done);
}




int RaidPhysDsk0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    U8 i, *tmpptr;
    RAID_PHYS_DSK_0_ENUM dataPos;

    dataPos = (RAID_PHYS_DSK_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION:
            ptrIocConfigData->RaidPhysDiskPage0.Header.PageVersion = (U8)Value;
            break;
        case PAGELENGTH:
            ptrIocConfigData->RaidPhysDiskPage0.Header.PageLength = (U8)Value;
            break;
        case PAGENUMBER:
            ptrIocConfigData->RaidPhysDiskPage0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE:
            ptrIocConfigData->RaidPhysDiskPage0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE:
            force_update_ptr->RAIDPhysDisk0 = (U8)Value;
            break;

        case RAID0_ALL:
            tmpptr = (U8 *)&ptrIocConfigData->RaidPhysDiskPage0.PhysDiskID;
            for (i = 0; i < sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0); i++)
            {
                tmpptr[i] = 0x00;
            }                  

        default:
            break;
    }

    if (dataPos == RAID0_ALL) {
        ptrIocConfigData->RaidPhysDiskPage0.Header.PageNumber  = 0;
        ptrIocConfigData->RaidPhysDiskPage0.Header.PageVersion = MPI_RAIDPHYSDISKPAGE0_PAGEVERSION;
        ptrIocConfigData->RaidPhysDiskPage0.Header.PageType    = MPI_CONFIG_PAGEATTR_READ_ONLY |
                                                                 MPI_CONFIG_PAGETYPE_RAID_PHYSDISK;
        ptrIocConfigData->RaidPhysDiskPage0.Header.PageLength  = sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0) >> 2;
        done = TRUE;
    }
    return (done);
}


int RaidPhysDsk1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int              done = FALSE;
    RAID_PHYS_DSK_1_ENUM dataPos;

    dataPos = (RAID_PHYS_DSK_1_ENUM)Counter;

    switch(dataPos) {
    case PAGEVERSION: { ptrIocConfigData->RaidPhysDiskPage1.Header.PageVersion = (U8)Value; break; }
    case PAGELENGTH:  { ptrIocConfigData->RaidPhysDiskPage1.Header.PageLength  = (U8)Value; break; }
    case PAGENUMBER:  { ptrIocConfigData->RaidPhysDiskPage1.Header.PageNumber  = (U8)Value; break; }
    case PAGETYPE:    { ptrIocConfigData->RaidPhysDiskPage1.Header.PageType    = (U8)Value; break; }
    case FORCEUPDATE: { force_update_ptr->RAIDPhysDisk0                        = (U8)Value; break; }

    case RAIDPHYDISK1_NUMPHYSDISKPATH: { ptrIocConfigData->RaidPhysDiskPage1.NumPhysDiskPaths = (U8)Value; break; }
    case RAIDPHYDISK1_PHYSDISKNUM:     { ptrIocConfigData->RaidPhysDiskPage1.PhysDiskNum      = (U8)Value; break; }

    default: { break; }
    } // ends switch(dataPos)

    if (dataPos == RAIDPHYDISK1_PHYSDISKNUM) {
        ptrIocConfigData->RaidPhysDiskPage1.Header.PageNumber  = 0;
        ptrIocConfigData->RaidPhysDiskPage1.Header.PageVersion = MPI_RAIDPHYSDISKPAGE0_PAGEVERSION;
        ptrIocConfigData->RaidPhysDiskPage1.Header.PageType    = MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_RAID_PHYSDISK;
        ptrIocConfigData->RaidPhysDiskPage1.Header.PageLength  = sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0) >> 2;
        done = TRUE;
    }
    return (done);
}




int SasDevice0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_DEVICE_0_ENUM dataPos;

    dataPos = (SAS_DEVICE_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasDevice0.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasDevice0.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasDevice0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasDevice0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
           force_update_ptr->SASDevice0 = (U8)Value;
           break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasDevice0.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasDevice0.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasDevice0.Header.Reserved2 = (U8)Value;
            break;

        case SAS_DEV0_SLOT:
            ptrIocConfigData->SasDevice0.Slot = (U16)Value;
            break;
        case SAS_DEV0_ENCLOSURE_HANDLE:
            ptrIocConfigData->SasDevice0.EnclosureHandle = (U16)Value;
            break;
        case SAS_DEV0_SASADRSHIGH:
            ptrIocConfigData->SasDevice0.SASAddress.High = Value;
            break;
        case SAS_DEV0_SASADRSLOW:
            ptrIocConfigData->SasDevice0.SASAddress.Low = Value;
            break;
        case SAS_DEV0_PARENTDEVHANDLE:
            ptrIocConfigData->SasDevice0.ParentDevHandle = (U16)Value;
            break;
        case SAS_DEV0_PHYNUM:
            ptrIocConfigData->SasDevice0.PhyNum = (U8)Value;
            break;
        case SAS_DEV0_ACCESSSTATUS:
            ptrIocConfigData->SasDevice0.AccessStatus = (U8)Value;
            break;
        case SAS_DEV0_DEVHNDL:
            ptrIocConfigData->SasDevice0.DevHandle = (U16)Value;
            break;
        case SAS_DEV0_TARGETID:
            ptrIocConfigData->SasDevice0.TargetID = (U16)Value;
            break;
        case SAS_DEV0_BUS:
            ptrIocConfigData->SasDevice0.Bus = (U8)Value;
            break;
        case SAS_DEV0_DEVICEINFO:
            ptrIocConfigData->SasDevice0.DeviceInfo = Value;
            break;
        case SAS_DEV0_FLAGS:
            ptrIocConfigData->SasDevice0.Flags = (U16)Value;
            break;
        case SAS_DEV0_PHYSICALPORT:
            ptrIocConfigData->SasDevice0.PhysicalPort = (U8)Value;
            break;
        case SAS_DEV0_RESERVED2:
            ptrIocConfigData->SasDevice0.Reserved2 = (U8)Value;
            break;
        default:
            break;
    } 

    if (dataPos == SAS_DEV0_RESERVED2) {
        ptrIocConfigData->SasDevice0.Header.PageNumber    = 0;
        ptrIocConfigData->SasDevice0.Header.PageVersion   = MPI_SASDEVICE0_PAGEVERSION;
        ptrIocConfigData->SasDevice0.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasDevice0.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_DEVICE_0) >> 2;
        ptrIocConfigData->SasDevice0.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE;
        done = TRUE;
    }
    return (done);
}


int SasDevice1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    U8 i;
    SAS_DEVICE_1_ENUM dataPos;

    dataPos = (SAS_DEVICE_1_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasDevice1.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasDevice1.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasDevice1.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasDevice1.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASDevice1 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasDevice1.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasDevice1.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasDevice1.Header.Reserved2 = (U8)Value;
            break;

        case SAS_DEV1_RESERVED1:
            ptrIocConfigData->SasDevice1.Reserved1 = Value;
            break;
        case SAS_DEV1_SASADRSHIGH:
            ptrIocConfigData->SasDevice1.SASAddress.High = Value;
            break;
        case SAS_DEV1_SASADRSLOW:
            ptrIocConfigData->SasDevice1.SASAddress.Low = Value;
            break;
        case SAS_DEV1_RESERVED2:
            ptrIocConfigData->SasDevice1.Reserved2 = Value;
            break;
        case SAS_DEV1_DEVHNDL:
            ptrIocConfigData->SasDevice1.DevHandle = (U16)Value;
            break;
        case SAS_DEV1_TARGETID:
            ptrIocConfigData->SasDevice1.TargetID = (U16)Value;
            break;
        case SAS_DEV1_BUS:
            ptrIocConfigData->SasDevice1.Bus = (U8)Value;
            break;
        case SAS_DEV1_INITREGDEVICEFIS:
            for (i=0; i < 20; i++)
            {
                ptrIocConfigData->SasDevice1.InitialRegDeviceFIS[i] = (U8)Value;
            }
            break;
        default:
            break;
    }

    if (dataPos == SAS_DEV1_INITREGDEVICEFIS) {
        ptrIocConfigData->SasDevice1.Header.PageNumber    = 1;
        ptrIocConfigData->SasDevice1.Header.PageVersion   = MPI_SASDEVICE1_PAGEVERSION;
        ptrIocConfigData->SasDevice1.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasDevice1.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_DEVICE_1) >> 2;
        ptrIocConfigData->SasDevice1.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE; 
        done = TRUE;
    }
    return (done);
}


int SasDevice2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_DEVICE_2_ENUM dataPos;

    dataPos = (SAS_DEVICE_2_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasDevice2.Header.PageVersion   = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasDevice2.Header.Reserved1     = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasDevice2.Header.PageNumber    = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasDevice2.Header.PageType      = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASDevice2 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasDevice2.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasDevice2.Header.ExtPageType   = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasDevice2.Header.Reserved2     = (U8)Value;
            break;


        case SAS_DEV2_PHYSICALIDHIGH:
            ptrIocConfigData->SasDevice2.PhysicalIdentifier.High = Value;
            break;
        case SAS_DEV2_PHYSICALIDLOW:
            ptrIocConfigData->SasDevice2.PhysicalIdentifier.Low  = Value;
            break;
        case SAS_DEV2_ENCLOSURE_MAPPING:
            ptrIocConfigData->SasDevice2.EnclosureMapping        = Value;
            break;
        default:
            break;
    }

    if (dataPos == SAS_DEV2_ENCLOSURE_MAPPING) {
        ptrIocConfigData->SasDevice1.Header.PageNumber    = 2;
        ptrIocConfigData->SasDevice1.Header.PageVersion   = MPI_SASDEVICE2_PAGEVERSION;
        ptrIocConfigData->SasDevice1.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasDevice1.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_DEVICE_2) >> 2;
        ptrIocConfigData->SasDevice1.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE;
        done = TRUE;
    }
    return (done);
}





int SasEnclosure0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    SAS_ENC_0_ENUM dataPos;
    int done = FALSE;

    dataPos = (SAS_ENC_0_ENUM)Counter;

    switch(dataPos){
    case PAGEVERSION2:
        ptrIocConfigData->SasEnclosure0.Header.PageVersion = (U8)Value;
        break;
    case PGHDR_RESERVED1:
        ptrIocConfigData->SasEnclosure0.Header.Reserved1 = (U8)Value;
        break;
    case PAGENUMBER2:
        ptrIocConfigData->SasEnclosure0.Header.PageNumber = (U8)Value;
        break;
    case PAGETYPE2:
        ptrIocConfigData->SasEnclosure0.Header.PageType = (U8)Value;
        break;
    case FORCEUPDATE2:
        force_update_ptr->SASEnclosure0 = (U8)Value;
        break;
    case EXTPAGELENGTH:
        ptrIocConfigData->SasEnclosure0.Header.ExtPageLength = (U16)Value;
        break;
    case EXTPAGETYPE:
        ptrIocConfigData->SasEnclosure0.Header.ExtPageType = (U8)Value;
        break;
    case PGHDR_RESERVED2:
        ptrIocConfigData->SasEnclosure0.Header.Reserved2 = (U8)Value;
        break;


    case SAS_ENC0_RESERVED1:
        ptrIocConfigData->SasEnclosure0.Reserved1 = (U32)Value;
        break;
    case SAS_ENC0_ENCLOSURE_LOGICAL_ID_LOW:
        ptrIocConfigData->SasEnclosure0.EnclosureLogicalID.Low = (U32)Value;
        break;
    case SAS_ENC0_ENCLOSURE_LOGICAL_ID_HIGH:
        ptrIocConfigData->SasEnclosure0.EnclosureLogicalID.High = (U32)Value;
        break;
    case SAS_ENC0_FLAGS:
        ptrIocConfigData->SasEnclosure0.Flags = (U16)Value;
        break;
    case SAS_ENC0_ENCLOSURE_HANDLE:
        ptrIocConfigData->SasEnclosure0.EnclosureHandle = (U16)Value;
        break;
    case SAS_ENC0_NUMSLOTS:
        ptrIocConfigData->SasEnclosure0.NumSlots = (U16)Value;
        break;
    case SAS_ENC0_START_SLOT:
        ptrIocConfigData->SasEnclosure0.StartSlot = (U16)Value;
        break;
    case SAS_ENC0_START_TARGET_ID:
        ptrIocConfigData->SasEnclosure0.StartTargetID = (U8)Value;
        break;
    case SAS_ENC0_START_BUS:
        ptrIocConfigData->SasEnclosure0.StartBus = (U8)Value;
        break;
    case SAS_ENC0_SEP_TARGET_ID:
        ptrIocConfigData->SasEnclosure0.SEPTargetID = (U8)Value;
        break;
    case SAS_ENC0_SEP_BUS:
        ptrIocConfigData->SasEnclosure0.SEPBus = (U8)Value;
        break;
    case SAS_ENC0_RESERVED2: 
        ptrIocConfigData->SasEnclosure0.Reserved2 = (U32)Value;
        break;
    case SAS_ENC0_RESERVED3:
        ptrIocConfigData->SasEnclosure0.Reserved3 = (U32)Value;
        break;


        default:
            break;
    }


    if (dataPos == SAS_ENC0_RESERVED3) {
        ptrIocConfigData->SasEnclosure0.Header.PageNumber  = 0;
        ptrIocConfigData->SasEnclosure0.Header.PageVersion = MPI_SASENCLOSURE0_PAGEVERSION;
        ptrIocConfigData->SasEnclosure0.Header.PageType    = MPI_CONFIG_PAGEATTR_READ_ONLY | MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasEnclosure0.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0) >> 2;
        ptrIocConfigData->SasEnclosure0.Header.ExtPageType = MPI_CONFIG_EXTPAGETYPE_ENCLOSURE;
        done = TRUE;
    }

    return (done);
}



int SasExpander0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_EXPANDER_0_ENUM dataPos;

    dataPos = (SAS_EXPANDER_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasExpander0.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasExpander0.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasExpander0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasExpander0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASExpnader0 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasExpander0.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasExpander0.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasExpander0.Header.Reserved2 = (U8)Value;
            break;

        case SAS_EXP0_PHYSICALPORT:
            ptrIocConfigData->SasExpander0.PhysicalPort = (U8)Value;
            break;
        case SASADRSHIGH:
            ptrIocConfigData->SasExpander0.SASAddress.High = Value;
            break;
        case SASADRSLOW:
            ptrIocConfigData->SasExpander0.SASAddress.Low = Value;
            break;
        case SAS_EXP0_DISCOVERYSTATUS:
            ptrIocConfigData->SasExpander0.DiscoveryStatus = Value;
            break;
        case SAS_EXP0_DEVHNDL:
            ptrIocConfigData->SasExpander0.DevHandle = (U16)Value;
            break;
        case PARENTDEVHNDL:
            ptrIocConfigData->SasExpander0.ParentDevHandle = (U16)Value;
            break;
        case EXPNDRCHGCNT:
            ptrIocConfigData->SasExpander0.ExpanderChangeCount = (U16)Value;
            break;
        case EXPNDRROUTEINDX:
            ptrIocConfigData->SasExpander0.ExpanderRouteIndexes = (U16)Value;
            break;
        case SAS_EXP0_NUMPHYS:
            ptrIocConfigData->SasExpander0.NumPhys = (U8)Value;
            break;
        case SASLEVEL:
            ptrIocConfigData->SasExpander0.SASLevel = (U8)Value;
            break;
        case SAS_EXP0_FLAGS:
            ptrIocConfigData->SasExpander0.Flags = (U8)Value;
            break;
        case DISCOVERYSTATUS:
            ptrIocConfigData->SasExpander0.DiscoveryStatus = (U8)Value;
            break;
        default:
            break;
    }

    if (dataPos == DISCOVERYSTATUS) {
        ptrIocConfigData->SasExpander0.Header.PageNumber    = 0;
        ptrIocConfigData->SasExpander0.Header.PageVersion   = MPI_SASEXPANDER0_PAGEVERSION;
        ptrIocConfigData->SasExpander0.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasExpander0.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_EXPANDER_0) >> 2;
        ptrIocConfigData->SasExpander0.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_EXPANDER;
        done = TRUE;
    }
    return (done);
}


int SasExpander1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_EXPANDER_1_ENUM dataPos;

    dataPos = (SAS_EXPANDER_1_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasExpander1.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasExpander1.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasExpander1.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasExpander1.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASExpnader1 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasExpander1.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasExpander1.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasExpander1.Header.Reserved2 = (U8)Value;
            break;

        case SAS_EXP1_PHYSICALPORT:
            ptrIocConfigData->SasExpander1.PhysicalPort = (U8)Value;
            break;
        case SAS_EXP1_NUMPHYS:
            ptrIocConfigData->SasExpander1.NumPhys = (U8)Value;
            break;
        case SAS_EXP1_PHY:
            ptrIocConfigData->SasExpander1.Phy = (U8)Value;
            break;
        case SAS_EXP1_RESERVED2:
            ptrIocConfigData->SasExpander1.Reserved2 = (U16)Value;
            break;
        case SAS_EXP1_PROGLINKRATE:
            ptrIocConfigData->SasExpander1.ProgrammedLinkRate = (U8)Value;
            break;
        case SAS_EXP1_HWLINKRATE:
            ptrIocConfigData->SasExpander1.HwLinkRate = (U8)Value;
            break;
        case SAS_EXP1_ATCHEDDEVHNDL:
            ptrIocConfigData->SasExpander1.AttachedDevHandle = (U16)Value;
            break;
        case SAS_EXP1_PHYINFO:
            ptrIocConfigData->SasExpander1.PhyInfo = Value;
            break;
        case SAS_EXP1_ATCHDDEVINFO:
            ptrIocConfigData->SasExpander1.AttachedDeviceInfo = Value;
            break;
        case SAS_EXP1_OWNERDEVHNDL:
            ptrIocConfigData->SasExpander1.OwnerDevHandle = (U16)Value;
            break;
        case SAS_EXP1_CHGCNT:
            ptrIocConfigData->SasExpander1.ChangeCount = (U8)Value;
            break;
        case SAS_EXP1_NEGLNKRATE:
            ptrIocConfigData->SasExpander1.NegotiatedLinkRate = (U8)Value;
            break;
        case SAS_EXP1_PHYIDENT:
            ptrIocConfigData->SasExpander1.PhyIdentifier = (U8)Value;
            break;
        case SAS_EXP1_ATCHDPHYIDENT:
            ptrIocConfigData->SasExpander1.AttachedPhyIdentifier = (U8)Value;
            break;
        case SAS_EXP1_NUMTBLENTPROG:
            ptrIocConfigData->SasExpander1.NumTableEntriesProg = (U8)Value;
            break;
        case SAS_EXP1_DISCOVERYINFO:
            ptrIocConfigData->SasExpander1.DiscoveryInfo = (U8)Value;
            break;
        case SAS_EXP1_RESERVED4:
            ptrIocConfigData->SasExpander1.Reserved2 = Value;
            break;
        default:
            break;
    }

    if (dataPos == SAS_EXP1_RESERVED4) {
        ptrIocConfigData->SasExpander1.Header.PageNumber    = 1;
        ptrIocConfigData->SasExpander1.Header.PageVersion   = MPI_SASEXPANDER1_PAGEVERSION;
        ptrIocConfigData->SasExpander1.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasExpander1.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_EXPANDER_1) >> 2;
        ptrIocConfigData->SasExpander1.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_EXPANDER;
        done = TRUE;
    }
    return (done);
}





int SasIoUnitPage0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) { 

    int done = FALSE;
    U8 i;
    SAS_IO_UNIT_0_ENUM dataPos;

    dataPos = (SAS_IO_UNIT_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasIoUnit0.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasIoUnit0.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasIoUnit0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasIoUnit0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASIOUnit0 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasIoUnit0.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasIoUnit0.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasIoUnit0.Header.Reserved2 = (U8)Value;
            break;

        case SAS0_RESERVED1:
            ptrIocConfigData->SasIoUnit0.Reserved1 = Value;
            break;
        case SAS0_NUMPHYS:
            ptrIocConfigData->SasIoUnit0.NumPhys = (U8)Value;
            break;
        case SAS0_RESERVED2:
            ptrIocConfigData->SasIoUnit0.Reserved2 = (U8)Value;
            break;
        case SAS0_RESERVED3:
            ptrIocConfigData->SasIoUnit0.Reserved3 = (U16)Value;
            break;
        case SAS0_PORT:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].Port = (U8)Value;
            }
            break;
        case SAS0_PORTFLGS:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].PortFlags = (U8)Value;
            }
            break;
        case SAS0_PHYFLGS:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].PhyFlags = (U8)Value;
            }
            break;
        case NEGOTLINKRATE:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].NegotiatedLinkRate = (U8)Value;
            }
            break;
        case CNTLRPHYDEVINFO:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].ControllerPhyDeviceInfo = Value;
            }
            break;
        case ATTCHDDEVHNDL:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].AttachedDeviceHandle = (U16)Value;
            }
            break;
        case CNTLRDEVHANDLE:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].ControllerDevHandle = (U16)Value;
            }
            break;
        case SAS0_DISCOVERYSTATUS:
            for (i=0; i < MPI_SAS_IOUNIT0_PHY_MAX; i++)
            {
                ptrIocConfigData->SasIoUnit0.PhyData[i].DiscoveryStatus = Value;
            }
            break;
        default:
            break;
    }


    if (dataPos == SAS0_DISCOVERYSTATUS) {
        ptrIocConfigData->SasIoUnit0.Header.PageNumber    = 0;
        ptrIocConfigData->SasIoUnit0.Header.PageVersion   = MPI_SASIOUNITPAGE0_PAGEVERSION;
        ptrIocConfigData->SasIoUnit0.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasIoUnit0.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_IO_UNIT_0) >> 2;
        ptrIocConfigData->SasIoUnit0.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
        done = TRUE;
    }
    return (done);
}


int SasIoUnitPage1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_IO_UNIT_1_ENUM dataPos;

    dataPos = (SAS_IO_UNIT_1_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasIoUnit1.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasIoUnit1.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasIoUnit1.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasIoUnit1.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASIOUnit1 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasIoUnit1.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasIoUnit1.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasIoUnit1.Header.Reserved2 = (U8)Value;
            break;

        case SAS1_CONTROLFLAGS:
            ptrIocConfigData->SasIoUnit1.ControlFlags = (U16)Value;
            break;
        case SAS1_MAXSATATARGETS:
            ptrIocConfigData->SasIoUnit1.MaxNumSATATargets = (U16)Value;
            break;
        case SAS1_RESERVED1:
            ptrIocConfigData->SasIoUnit1.Reserved1 = Value;
            break;
        case SAS1_NUMPHYS:
            ptrIocConfigData->SasIoUnit1.NumPhys = (U8)Value;
            break;
        case SAS1_SATAMAXQDEPTH:
            ptrIocConfigData->SasIoUnit1.SATAMaxQDepth = (U8)Value;
            break;
        case SAS1_RESERVED2:
            ptrIocConfigData->SasIoUnit1.Reserved2 = (U16)Value;
            break;

        case SAS1PHY0_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[0].Port = (U8)Value;
            break;
        case SAS1PHY0_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[0].PortFlags = (U8)Value;
            break;
        case SAS1PHY0_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[0].PhyFlags = (U8)Value;
            break;
        case SAS1PHY0_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[0].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY0_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[0].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY0_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[0].Reserved1 = Value;
            break;

        case SAS1PHY1_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[1].Port = (U8)Value;
            break;
        case SAS1PHY1_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[1].PortFlags = (U8)Value;
            break;
        case SAS1PHY1_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[1].PhyFlags = (U8)Value;
            break;
        case SAS1PHY1_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[1].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY1_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[1].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY1_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[1].Reserved1 = Value;
            break;

        case SAS1PHY2_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[2].Port = (U8)Value;
            break;
        case SAS1PHY2_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[2].PortFlags = (U8)Value;
            break;
        case SAS1PHY2_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[2].PhyFlags = (U8)Value;
            break;
        case SAS1PHY2_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[2].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY2_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[2].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY2_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[2].Reserved1 = Value;
            break;

        case SAS1PHY3_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[3].Port = (U8)Value;
            break;
        case SAS1PHY3_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[3].PortFlags = (U8)Value;
            break;
        case SAS1PHY3_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[3].PhyFlags = (U8)Value;
            break;
        case SAS1PHY3_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[3].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY3_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[3].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY3_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[3].Reserved1 = Value;
            break;         
    
        case SAS1PHY4_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[4].Port = (U8)Value;
            break;
        case SAS1PHY4_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[4].PortFlags = (U8)Value;
            break;
        case SAS1PHY4_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[4].PhyFlags = (U8)Value;
            break;
        case SAS1PHY4_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[4].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY4_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[4].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY4_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[4].Reserved1 = Value;
            break;

        case SAS1PHY5_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[5].Port = (U8)Value;
            break;
        case SAS1PHY5_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[5].PortFlags = (U8)Value;
            break;
        case SAS1PHY5_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[5].PhyFlags = (U8)Value;
            break;
        case SAS1PHY5_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[5].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY5_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[5].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY5_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[5].Reserved1 = Value;
            break;

        case SAS1PHY6_PORT:
            ptrIocConfigData->SasIoUnit1.PhyData[6].Port = (U8)Value;
            break;
        case SAS1PHY6_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[6].PortFlags = (U8)Value;
            break;
        case SAS1PHY6_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[6].PhyFlags = (U8)Value;
            break;
        case SAS1PHY6_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[6].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY6_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[6].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY6_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[6].Reserved1 = Value;
            break;

        case SAS1PHY7_PORT:    
            ptrIocConfigData->SasIoUnit1.PhyData[7].Port = (U8)Value;
            break;
        case SAS1PHY7_PORTFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[7].PortFlags = (U8)Value;
            break;
        case SAS1PHY7_PHYFLAGS:
            ptrIocConfigData->SasIoUnit1.PhyData[7].PhyFlags = (U8)Value;
            break;
        case SAS1PHY7_MINMAXLINKRATE:
            ptrIocConfigData->SasIoUnit1.PhyData[7].MaxMinLinkRate = (U8)Value;
            break;
        case SAS1PHY7_CNTLRPHYDEVINFO:
            ptrIocConfigData->SasIoUnit1.PhyData[7].ControllerPhyDeviceInfo = Value;
            break;
        case SAS1PHY7_RESERVED:
            ptrIocConfigData->SasIoUnit1.PhyData[7].Reserved1 = Value;
            break;
        default:
            break;
    }


    if (dataPos == SAS1PHY7_RESERVED) {
        ptrIocConfigData->SasIoUnit1.Header.PageNumber    = 1;
        ptrIocConfigData->SasIoUnit1.Header.PageVersion   = MPI_SASIOUNITPAGE1_PAGEVERSION;
        ptrIocConfigData->SasIoUnit1.Header.PageType      = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasIoUnit1.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_IO_UNIT_1) >> 2;
        ptrIocConfigData->SasIoUnit1.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
        done = TRUE;
    }
    return (done);
}


int SasIoUnitPage2Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_IO_UNIT_2_ENUM dataPos;

    dataPos = (SAS_IO_UNIT_2_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasIoUnit2.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasIoUnit2.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasIoUnit2.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasIoUnit2.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASIOUnit2 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasIoUnit2.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasIoUnit2.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasIoUnit2.Header.Reserved2 = (U8)Value;
            break;

        case SAS2_RESERVED1:
            ptrIocConfigData->SasIoUnit2.Reserved1 = Value;
            break;
        case MAXPERSISTIDS:
            ptrIocConfigData->SasIoUnit2.MaxPersistentIDs = (U16)Value;
            break;
        case NUMPERSISTIDSUSED:
            ptrIocConfigData->SasIoUnit2.NumPersistentIDsUsed = (U16)Value;
            break;
        case STATUS:
            ptrIocConfigData->SasIoUnit2.Status = (U8)Value;
            break;
        case SAS2_FLAGS:
            ptrIocConfigData->SasIoUnit2.Flags = (U8)Value;
            break;
        case SAS2_MAXNUMPHYMAPPEDID:
            ptrIocConfigData->SasIoUnit2.MaxNumPhysicalMappedIDs = (U16)Value;
            break;
        default:
            break;
    }


    if (dataPos == SAS2_MAXNUMPHYMAPPEDID) {
        ptrIocConfigData->SasIoUnit2.Header.PageNumber    = 2;
        ptrIocConfigData->SasIoUnit2.Header.PageVersion   = MPI_SASIOUNITPAGE2_PAGEVERSION;
        ptrIocConfigData->SasIoUnit2.Header.PageType      = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasIoUnit2.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_IO_UNIT_2) >> 2;
        ptrIocConfigData->SasIoUnit2.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
        done = TRUE;
    }
    return (done);
}




int SasPersistIdData(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_PERSIST_ID_ENUM dataPos;

    dataPos = (SAS_PERSIST_ID_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->PersistId.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->PersistId.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->PersistId.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->PersistId.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASPersistentID = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->PersistId.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->PersistId.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->PersistId.Header.Reserved2 = (U8)Value;
            break; 

        case PERSISTID_SASADDRESS_HIGH_0:
            ptrIocConfigData->PersistId.PersistId[0].SasAddress.High = Value;
            break;
        case PERSISTID_SASADDRESS_LOW_0:
            ptrIocConfigData->PersistId.PersistId[0].SasAddress.Low  = Value;
            break;
        case PERSISTID_RESERVED_0:
            ptrIocConfigData->PersistId.PersistId[0].Reserved        = Value;
            break;
    
        default:
            break;
    }
                    
    if (dataPos == PERSISTID_RESERVED_0) {
        ptrIocConfigData->SasPhy1.Header.PageNumber    = 0;
        ptrIocConfigData->SasPhy1.Header.PageVersion   = 1;
        ptrIocConfigData->SasPhy1.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasPhy1.Header.ExtPageLength = sizeof(IOC_CONFIG_PAGE_PERSISTENT_ID) >> 2;
        ptrIocConfigData->SasPhy1.Header.ExtPageType   = IOC_MPI_CONFIG_PAGETYPE_PERSIST_ID;
        done = TRUE;
    }

    return (done);
}




int SasIoUnitPage3Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_IO_UNIT_3_ENUM dataPos;

    dataPos = (SAS_IO_UNIT_3_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasIoUnit3.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasIoUnit3.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasIoUnit3.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasIoUnit3.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASIOUnit3 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasIoUnit3.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasIoUnit3.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasIoUnit3.Header.Reserved2 = (U8)Value;
            break;

        case SAS3_RESERVED1:
            ptrIocConfigData->SasIoUnit3.Reserved1 = Value;
            break;
        case MAXINVALIDDWRDCNT:
            ptrIocConfigData->SasIoUnit3.MaxInvalidDwordCount = Value;
            break;
        case INVALIDDWRDCNTTIME:
            ptrIocConfigData->SasIoUnit3.InvalidDwordCountTime = Value;
            break;
        case MAXRUNNINGDISPAREERRCNT:
            ptrIocConfigData->SasIoUnit3.MaxRunningDisparityErrorCount = Value;
            break;
        case RUNNINGDISPAREERRTIME:
            ptrIocConfigData->SasIoUnit3.RunningDisparityErrorTime = Value;
            break;
        case MAXLOSSDWRDSYNC_CNT:
            ptrIocConfigData->SasIoUnit3.MaxLossDwordSynchCount = Value;
            break;
        case LOSSDWRDSYNCCNTTIME:
            ptrIocConfigData->SasIoUnit3.LossDwordSynchCountTime = Value;
            break;
        case MAXPHYRESETPROBCNT:
            ptrIocConfigData->SasIoUnit3.MaxPhyResetProblemCount = Value;
            break;
        case PHYRESETPROBTIME:
            ptrIocConfigData->SasIoUnit3.PhyResetProblemTime = Value;
            break;
        default:
            break;
    }
                    
    if (dataPos == PHYRESETPROBTIME) {
        ptrIocConfigData->SasIoUnit3.Header.PageNumber    = 3;
        ptrIocConfigData->SasIoUnit3.Header.PageVersion   = MPI_SASIOUNITPAGE3_PAGEVERSION;
        ptrIocConfigData->SasIoUnit3.Header.PageType      = MPI_CONFIG_PAGEATTR_PERSISTENT|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasIoUnit3.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_IO_UNIT_3) >> 2;
        ptrIocConfigData->SasIoUnit3.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
        done = TRUE;
    }
    return (done);
}




int SasPhy0Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_PHY_0_ENUM dataPos;

    dataPos = (SAS_PHY_0_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasPhy0.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasPhy0.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasPhy0.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasPhy0.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASPhy0 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasPhy0.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasPhy0.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasPhy0.Header.Reserved2 = (U8)Value;
            break;

        case SAS_PHY0_RESERVED1:
            ptrIocConfigData->SasPhy0.Reserved1 = (U16)Value;
            break;
        case SAS_PHY0_OWNER_DEV_HANDLE:
            ptrIocConfigData->SasPhy0.Reserved1 = (U16)Value;
            break;
        case SAS_PHY0_SASADRSHIGH:
            ptrIocConfigData->SasPhy0.SASAddress.High = Value;
            break;
        case SAS_PHY0_SASADRSLOW:
            ptrIocConfigData->SasPhy0.SASAddress.Low = Value;
            break;
        case SAS_PHY0_ATTCHDDEVHNDL:
            ptrIocConfigData->SasPhy0.AttachedDevHandle = (U16)Value;
            break;
        case SAS_PHY0_ATTCHDPHYIDENTIFIER:
            ptrIocConfigData->SasPhy0.AttachedPhyIdentifier = (U8)Value;
            break;
        case SAS_PHY0_RESERVED2:
            ptrIocConfigData->SasPhy0.Reserved2 = (U8)Value;
            break;
        case SAS_PHY0_ATTCHDDEVINFO:
            ptrIocConfigData->SasPhy0.AttachedDeviceInfo = Value;
            break;
        case SAS_PHY0_PRGMDLINKRATE:
            ptrIocConfigData->SasPhy0.ProgrammedLinkRate = (U8)Value;
            break;
        case SAS_PHY0_HWLINKRATE:
            ptrIocConfigData->SasPhy0.HwLinkRate = (U8)Value;
            break;
        case SAS_PHY0_CHNGCOUNT:
            ptrIocConfigData->SasPhy0.ChangeCount = (U8)Value;
            break;
        case SAS_PHY0_FLAGS:
            ptrIocConfigData->SasPhy0.Flags = (U8)Value;
            break;
        case SAS_PHY0_PHYINFO:
            ptrIocConfigData->SasPhy0.PhyInfo = Value;
            break;
        default:
            break;
    }
                              
    if (dataPos == SAS_PHY0_FLAGS) {
        ptrIocConfigData->SasPhy0.Header.PageNumber    = 0;
        ptrIocConfigData->SasPhy0.Header.PageVersion   = MPI_SASPHY0_PAGEVERSION;
        ptrIocConfigData->SasPhy0.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasPhy0.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_PHY_0) >> 2;
        ptrIocConfigData->SasPhy0.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_PHY; 
        done = TRUE;
    }
    return (done);
}



int SasPhy1Data(PTR_IOC_CONFIG_PAGES ptrIocConfigData, U32 Value, int Counter) {

    int done = FALSE;
    SAS_PHY_1_ENUM dataPos;

    dataPos = (SAS_PHY_1_ENUM)Counter;

    switch(dataPos) {
        case PAGEVERSION2:
            ptrIocConfigData->SasPhy1.Header.PageVersion = (U8)Value;
            break;
        case PGHDR_RESERVED1:
            ptrIocConfigData->SasPhy1.Header.Reserved1 = (U8)Value;
            break;
        case PAGENUMBER2:
            ptrIocConfigData->SasPhy1.Header.PageNumber = (U8)Value;
            break;
        case PAGETYPE2:
            ptrIocConfigData->SasPhy1.Header.PageType = (U8)Value;
            break;
        case FORCEUPDATE2:
            force_update_ptr->SASPhy1 = (U8)Value;
            break;
        case EXTPAGELENGTH:
            ptrIocConfigData->SasPhy1.Header.ExtPageLength = (U16)Value;
            break;
        case EXTPAGETYPE:
            ptrIocConfigData->SasPhy1.Header.ExtPageType = (U8)Value;
            break;
        case PGHDR_RESERVED2:
            ptrIocConfigData->SasPhy1.Header.Reserved2 = (U8)Value;
            break;

        case SAS_PHY1_RESERVED1:
            ptrIocConfigData->SasPhy1.Reserved1 = Value;
            break;
        case SAS_PHY1_INVALIDDWRDCNT:
            ptrIocConfigData->SasPhy1.InvalidDwordCount = Value;
            break;
        case SAS_PHY1_RUNNGDISPARITYERRCNT:
            ptrIocConfigData->SasPhy1.RunningDisparityErrorCount = Value;
            break;
        case SAS_PHY1_LOSSDWRDSYNCCNT:
            ptrIocConfigData->SasPhy1.LossDwordSynchCount = Value;
            break;
        case SAS_PHY1_PHYRESETPROBCNT:
            ptrIocConfigData->SasPhy1.PhyResetProblemCount = Value;
            break;
        default:
            break;
    }

    if (dataPos == SAS_PHY1_PHYRESETPROBCNT) {
        ptrIocConfigData->SasPhy1.Header.PageNumber    = 0;
        ptrIocConfigData->SasPhy1.Header.PageVersion   = MPI_SASPHY1_PAGEVERSION;
        ptrIocConfigData->SasPhy1.Header.PageType      = MPI_CONFIG_PAGEATTR_READ_ONLY|MPI_CONFIG_PAGETYPE_EXTENDED;
        ptrIocConfigData->SasPhy1.Header.ExtPageLength = sizeof(CONFIG_PAGE_SAS_PHY_1) >> 2;
        ptrIocConfigData->SasPhy1.Header.ExtPageType   = MPI_CONFIG_EXTPAGETYPE_SAS_PHY;
        done = TRUE;
    }
    return (done);
}


