
/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  mptutil.h
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  03/31/2003
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */
 
 
  
/************** Custom Include Files ************/


#ifdef __KERNEL_2_6__

    #ifndef __user
    #define __user
    #endif
    
    typedef unsigned char  u8;
    typedef unsigned short u16;
    typedef unsigned int   u32;

#endif


#include <endian.h>
#include <linux/types.h>
#include "../lsi/mpi_type.h"
#include "../lsi/mpi_init.h"
#include "../mptctl.h"


/****************** Versions ******************/
#define mptutil_build   "07/05/05"
#define mptutil_version "1.00.01"

                             
/****************** Defines ******************/
//#define FALSE                  0
//#define TRUE                   1
#define MAX_SUPPORTED_ADAPTERS 64
#define SAS_NVDATA_VERSION     0x21
         
                          
#define get16(x) __le16_to_cpu(x)
#define get32(x) __le32_to_cpu(x)
#define set16(x) __cpu_to_le16(x)
#define set32(x) __cpu_to_le32(x)

#define min(x,y) ((int)(x) < (int)(y) ? (x) : (y))
#define max(x,y) ((int)(x) > (int)(y) ? (x) : (y))

#define O_BINARY 0

#define DEFAULT_FILENAME_LENGTH 256
#define BUFFER_SIZE             3072
#define GLOBAL_MEMORY_BYTES     0x80000


#define NUM_CONFIG_PAGES         (37) 
#define NUM_PERSIST_CONFIG_PAGES (17)

#define MPI_HEADER               (4)
#define MPI_EXTENDED_HEADER      (8)

#define MPI_HEAD_SIG2       0x5AEAA55A
#define MPI_HEAD_SIG3       0xA55AEAA5
#define MPI_HEAD_SIG4       0x5AA55AEA


#define HOST_RUN_DEVICE_PROPERTIES_1064FAMILY   0x00000001
#define HOST_RUN_DEVICE_PROPERTIES_1068FAMILY   0x00000002
#define HOST_RUN_DEVICE_PROPERTIES_1064EFAMILY  0x00000004
#define HOST_RUN_DEVICE_PROPERTIES_1068EFAMILY  0x00000008
#define HOST_RUN_DEVICE_PROPERTIES_SASFAMILY    0x10000000
#define HostRunIs1064Family(pHostRun)           (pHostRun->DeviceProperties & HOST_RUN_DEVICE_PROPERTIES_1064FAMILY)
#define HostRunIs1068Family(pHostRun)           (pHostRun->DeviceProperties & HOST_RUN_DEVICE_PROPERTIES_1068FAMILY)
#define HostRunIs1064EFamily(pHostRun)          (pHostRun->DeviceProperties & HOST_RUN_DEVICE_PROPERTIES_1064EFAMILY)
#define HostRunIs1068EFamily(pHostRun)          (pHostRun->DeviceProperties & HOST_RUN_DEVICE_PROPERTIES_1068EFAMILY)
#define HostRunIsSASFamily(pHostRun)            (pHostRun->DeviceProperties & HOST_RUN_DEVICE_PROPERTIES_SASFAMILY)
#define DEFAULT_FIRMWARE_1064                   "64it__l.fw"
#define DEFAULT_FIRMWARE_1068                   "68it__l.fw"
#define DEFAULT_FIRMWARE_106xE                  "6eit__l.fw"
#define DEFAULT_INT13_BIOS_SAS                  "mptsas.rom"
#define DEFAULT_FCODE_BIOS_SAS                  "lsi106xf.rom"
#define DEFAULT_EFI_BIOS_SAS                    "unknown.rom"

#ifndef FALSE
#define FALSE 0
#endif     

#ifndef TRUE
#define TRUE 1
#endif     


                            

                               






/****************** Typedef ******************/
typedef int            HANDLE;


/****************** Structures ******************/


typedef struct _IMAGE_INFO 
{
    U32    *ImageAddress;
    U32    PhyImageAddress;
    U32    ImageSz;
    U32    ImgLoadStrtAdrs;
    U16    SeepromVersion;
    U8     VendorId[8];
    U8     ProductId[16];
    U8     ProductRevision[4];
} IMAGE_INFO, *PTR_IMAGE_INFO;



/*
**  This structure is used to hold various flags needed througout the utitliy.
*/
typedef struct {


   U8  CmdLine,          //Used to tell if the user is using command line options or not.
       ManLogOpen,       //Used to hold values for the current Board Speed.
       doingSASConcat,   //Used to tell the utility if we are trying to concatenate a file.
       doingFWDLB,       //Used to tell the utility if we are doing a firmware download boot.
       VendorId[8],
       ProductId[16],
       ProductRevision[4],
       Manufacturing,
       DisplayHelp,
       DiagRest,
       DidErase,
       Handshake,
       DriverLoaded,     // Used to let the utility know if the driver is loaded or not.
       zDebug;           // Used to tell if debug is on or not.
   //    FCxxx_To_Use,     //Used to tell which card to initialize (default 1)
   //    Menu,             //Used to determine if we should display available adapters or not.
   //    FlashEnabled,     //Used to determine if FlashWriteEnable is set or not.
   //    Port,             //Used to determine which port is being needed.
   //    Loop_Option,      //Used to tell if we are Flashing BIOS or firmware.
   //    DDL,              //Used to tell if a direct download has been done.
   //    NumPorts,         //Used to tell if a direct download has been done.
   //    BoardSpeed_0,     //Used to hold values for the current Board Speed.
   //    BoardSpeed_1,     //Used to hold values for the current Board Speed.
   //    Topology_0,       //Used to hold values for the current Topology.
   //    Topology_1,       //Used to hold values for the current Topology.
   //    DevicePath,       //Used to hold values for the current DevicePath.
   //    Manufacturing,    //Used to tell if we are doing manufacturing.
   //    WhatFunc,         //Used to tell if we are doing manufacturing.
   //    Reset,            //Used to do a register reset .....
   //    ForceFDLB,        //Used to force a FDLB on a board in operational state.
   //    SaveMultiImage,   //Used to save FW/BL/NVDATA image to file, no download.
   //    SaveDefaults,     //Used to save defaults (NVDATA) image to file, no download.
   //    MergeFwDflts,     //Used to save FW/BL/NVDATA image to file, FW/BL from file.  Used as a flag now for the same process.
   //    option_d,         //Used as a flag for concatenating firmware / nvdata without a card present.
   //    flash_present,    //Used as a flag to see if the firmware thinks there is a flash part present
   //    help_display,     //Used as a flag to show the help screen or not.
   //    KeybrdInput;      //Used to force keyboard input instead of scanner.

   U16 SectionHeader,    //Used to hold the current section.
       SASAddPrefix,     //Used to hold the character expected at the  begining of a SAS address label.
       Nvdata_DeviceID,
       SeepromVersion;    
   //U16 version,        //Used to hold the current version of the firmware loaded.
   //    MaxPersistent,  //Used to hold data from PortFacts on the Max Number of Persistent Id's
   //    IocBlockSiz,    //
   //    IocReqFrmSiz,   //
   //    IocReplyFrmSiz; //
   
   U32 NvdataData,       //Used to hold NvdataRow's data.
       DriverVersion,    //Used to hold the driver version
       DeviceProperties; // Used to tell the properties of the current card

   char FileName[DEFAULT_FILENAME_LENGTH] ;   //Used to hold the name of files being passed in with command line arguments.
   char FileName1[DEFAULT_FILENAME_LENGTH];   //Used to hold the name of files being passed in with command line arguments.
   char FileName2[DEFAULT_FILENAME_LENGTH];   //Used to hold the name of files being passed in with command line arguments.
   char FWVersion[50];   //Used to hold the Version of firmware loaded on the FLASH
   char NvdataStr[256];  //Used to hold the row in nvdata
   char NvdataRow[256];  //Used to hold the row in nvdata
   char FirmwareWhat[0x21];  //Used to hold firmware version data
   char x86BIOSWhat[0x21];   //Used to hold x86 Bios version data
   //U32  DeviceID;
   //FILE *logfile;      //Used to hold the name of the log file for use with different functions.
   //FILE *man_log;      //Used to hold the name of the manufacturing log file.


   //U32 FCUTIL_DEBUG,   //Used to tell if Debug information should be displayed or not.
   //    BPTaskMask,     //Used to check for pauses of some sort ... unclear.
   //    FileState;      //Used to keep track if the file is in the open state or close.

   //U64 WWPN_0,         //These values are used to store the WWNN and WWPN of both ports for menu display.
   //    WWNN_0,
   //    WWPN_1,
   //    WWNN_1;

   //U32 FcPort1Flags0,   /* Used to store FcPortPage1 flags value for protocol display */
   //    FcPort1Flags1;

   IMAGE_INFO     nvdataHdr,
                  bootloaderHdr;

} HOST_FLAG_STRUCT;



typedef struct 
{
   U8  ManufacturingPage0,          
       ManufacturingPage1,     
       ManufacturingPage2, 
       ManufacturingPage3,             
       ManufacturingPage4,     
       ManufacturingPage5,             
       ManufacturingPage6,      
       IOUnitPage0,              
       IOUnitPage1,         
       IOUnitPage2,     
       IOUnitPage3,     
       IOUnitPage4,       
       IOCPage0,       
       IOCPage1,       
       IOCPage2,       
       IOCPage3,    
       IOCPage4,         
       IOCPage5,            
       SASIOUnit0,        
       SASIOUnit1,   
       SASIOUnit2,     
       SASIOUnit3,     
       SASExpnader0,         
       SASExpnader1,     
       SASDevice0,     
       SASDevice1,     
       SASDevice2,     
       SASPhy0,     
       SASPhy1,
       SASEnclosure0,
       SASPersistentID,     
       RAIDVol0,     
       RAIDVol1,     
       RAIDPhysDisk0,     
       RAIDPhysDisk1,     
       BIOS1,
       BIOS2,
       LOG0;
} FORCE_UPDATE_STRUCT;


typedef struct
{
	int		       portNumber;
	int		       ioctlValue;
	int		       mptVersion;
	int		       fwVersion;
	int		       whoInit;
	int		       payOff;
	int		       portType;
	int		       maxPersistentIds;
	int		       maxBuses;
	int		       maxTargets;
	int		       maxLuns;
	int		       hostScsiId;
	char	       portName[16];
	char	      *chipName;
	U8		       currentState;
	U16		       deviceId;
	U16		       vendorId;
	U16		       subSystemVendorId;
	U16		       subSystemId;
	U16		       productId;
	U16		       revisionId;
    U32            deviceProperties;
	HANDLE	       fileHandle;
	MPI_FW_VERSION fwVersion_new;
} MPT_PORT;


typedef struct {
	char			 signature[4];
	unsigned short	 vendorId;
	unsigned short	 deviceId;
	unsigned char	 reserved1[2];
	unsigned short	 pcirLength;
	unsigned char	 pcirRevision;
	unsigned char	 classCode[3];
	unsigned short	 imageLength;
	unsigned short	 imageRevision;
	unsigned char	 type;
	unsigned char	 indicator;
	unsigned char	 reserved2[2];
} PCIR;




typedef struct
{
    U32 ArmBranch1;
    U32 Sig2;
    U32 Sig3;
    U32 Sig4;
    U32 ArmBranch2;
    U32 ArmBranch3;
    U32 Reserved;
    U32 Checksum;
    U16 VendorId;
    U16 ProductId;
    U32 FirmwareVersion;
    U32 SeqCodeVersion;
    U32 ImageSize;
    U32 NextImageHeaderOffset;
    U32 LoadStartAddress;
    U32 IopResetVectorValue;
    U32 IopResetVectorRegAddr;
    U32 VersionNameWhat;
    U8  VersionName[0x20];
    U32 VendorNameWhat;
    U8  VendorName[0x20];
} MpiROMHeader_t;



typedef struct _SAS_DEVICE {
    U16  CtlrDevHandle;
    U8   PhyPort;
    U32  DevSasAdrsLo;
    U32  DevSasAdrsHi;
    U16  DeviceHandle;
    U8   BusNumber;
    U8   TargetId;
    U8   Lun;
    U8   TestStat;
    U32  BufferSize;
    char Model[35];
    char Version[10];
    float Capacity;
    struct _SAS_DEVICE  * PtrNext;
} SAS_DEVICE, * PTR_SAS_DEVICE;

typedef struct
{
	SCSIIOReply_t	 reply;
	U8				 sense[18];
} SCSI_REPLY;



/******* Option Rom Structures and #defines ******************/

#define BIOS_OPTIONS_MAX                        (4)

#define PCI_VENDOR_ID_LSI                       (0x1000)
#define OPTION_CODE_READ_ONLY                   (0x8000)

#define BIOS_OPTIONS_STRUCT_SIGNATURE1          (0x4C49534C)    /* "LSIL" */
#define BIOS_OPTIONS_STRUCT_SIGNATURE2          (0x54504F42)    /* "BOPT" */

#define BIOS_OPTION_LSI_0_SAS_SUPPORTED         (0x00000001)
#define BIOS_OPTION_LSI_0_SPI_SUPPORTED         (0x00000002)
#define BIOS_OPTION_LSI_0_FCP_SUPPORTED         (0x00000004)
#define BIOS_OPTION_LSI_0_FWDLB_SUPPORTED       (0x00000008)

#define BIOS_OPTION_LSI_0_IT_SUPPORTED          (0x00000010)
#define BIOS_OPTION_LSI_0_IM_SUPPORTED          (0x00000020)
#define BIOS_OPTION_LSI_0_IME_SUPPORTED         (0x00000040)
#define BIOS_OPTION_LSI_0_IS_SUPPORTED          (0x00000080)


typedef struct _BIOS_OPTION
{
    U32                     Key;
    U32                     Capabilities;
    U32                     Flags;
} BIOS_OPTION;


typedef struct _BIOS_OPTIONS
{
    U32                     Signature1;                 /* 00h */
    U32                     Signature2;                 /* 04h */
    U8                      StructureVersion;           /* 08h */
    U8                      Reserved1;                  /* 09h */
    U8                      Reserved2;                  /* 0Ah */
    U8                      NumProductOptions;          /* 0Bh */
    BIOS_OPTION             Option[BIOS_OPTIONS_MAX];   /* 0Ch */
} BIOS_OPTIONS;




typedef struct 
{
    /* First 2 values are defined by MPI */
    CONFIG_PAGE_HEADER      Header;                                 /* 00h */
    MPI_CHIP_REVISION_ID    ChipId;                                 /* 04h */

    U16                     SubSystemIDFunc0;                       /* 08h (0-1) */
    U16                     SubSystemVendorIDFunc0;                 /* 0Ah (2-3) */
    U8                      PCIMemDiagSize;                         /* 0Ch (4) */
    U8                      Reserved05;                             /* 0Dh (5) */
    U16                     SubSystemIDFunc1;                       /* 0Eh (6-7) */
    U16                     SubSystemVendorIDFunc1;                 /* 10h (8-9) */
    U8                      AutoDownloadChecksum;                   /* 12h (A) */
    U8                      Reserved0B;                             /* 13h (B) */
    U8                      VendorIDDeviceIDLock;                   /* 14h (C) */
    U8                      Reserved0D;                             /* 15h (D) */
    U16                     VendorID0;                              /* 16h (E-F) */
    U16                     DeviceID0;                              /* 18h (10-11) */
    U16                     VendorID1;                              /* 1Ah (12-13) */
    U16                     DeviceID1;                              /* 20h (14-15) */
    U8                      ClassCode0[3];                          /* 22h (16-18) */
    U8                      Reserved19;                             /* 25h (19) */
    U8                      ClassCode1[3];                          /* 26h (1A-1C) */
    U8                      Reserved1D;                             /* 29h (1D) */
    U16                     HardwareConfig;                         /* 2Ah (1E-1F) */
    U32                     OptionRomOffset0;                       /* 28h (20-23) */
    U32                     OptionRomOffset1;                       /* 2Ch (24-27) */
} CONFIG_PAGE_MANUFACTURING_2_SAS, *PTR_CONFIG_PAGE_MANUFACTURING_2_SAS,
    ManufacturingPage2_SAS_t, *pManufacturingPage2_SAS_t;



#ifdef __KERNEL_2_6__

    struct mpt_ioctl_mptpciinfo {
        U8  iocNumber;
        U8  iocState;
        U8  revisionID;
        U8  reserved1;
        U16 vendorID; 
        U16 deviceID;
        U16 subSystemVendorID;
        U16 subSystemID;
    };

    struct mpt_ioctl_hbapciinfo {
        mpt_ioctl_header            hdr;
        U8                          totalIOC;
        U8                          reserved[3];
        struct mpt_ioctl_mptpciinfo hbapciinfo[18];
    };

#endif
