
/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  mptutil.c
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  03/31/2003
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */

/************* System Include Files ************/

#include <ctype.h> 
#include <fcntl.h>
#include <malloc.h>
#include <stdarg.h> 
#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <unistd.h>
//#include <pci/pci.h>
#include <asm/types.h>
#include <linux/byteorder/little_endian.h>
#include <stdio.h>

#ifdef __KERNEL_2_6__

  #include <sysfs/libsysfs.h>

#endif
               
/************** Proto Types ************/
#define MPI_IO_UNIT_PAGE_3_GPIO_VAL_MAX  8
#define MPI_SAS_IOUNIT0_PHY_MAX          8
#define MPI_SAS_IOUNIT1_PHY_MAX          MPI_SAS_IOUNIT0_PHY_MAX


/************** Custom Include Files ************/
#include "../lsi/mpi_type.h"
#include "../lsi/mpi.h"                                        
#include "../lsi/mpi_cnfg.h"
#include "../lsi/mpi_init.h"
#include "../lsi/mpi_ioc.h"

//#include "mptutil.h"
#include "iopcnfg.h"
#include "enum.h"
#include "imageHeader.h"
#include "proto.h"
#include "../mptctl.h"


/************** Proto's ************/
void parseData (FILE *ptrDataFile, U8 Index, PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry);



/************** Globals ************/
int    NvDataImageLen;
int    currentPort;
int    mptutil;
int    gargc; 
char **gargv;
char   name[DEFAULT_FILENAME_LENGTH];
unsigned char *buffer1;
unsigned char *buffer2;
unsigned char *buffer3;
unsigned char *buffer4;

U8                   *ptrSasNvdataImage;
U8                    SasAdrsPreFix[10];  
U16                   SasSeepromVersion;

FILE                 *log_file; 
HOST_FLAG_STRUCT      flag_struct;
HOST_FLAG_STRUCT     *flag_ptr;
FORCE_UPDATE_STRUCT   force_update_struct;
FORCE_UPDATE_STRUCT  *force_update_ptr;
MPT_PORT             *mptPorts[MAX_SUPPORTED_ADAPTERS];
PTR_IOC_CONFIG_PAGES  ptrIocConfigPages;
PTR_IOC_CONFIG_PAGES  ptrIocConfigData;
IMAGE_INFO            BootLdr_hdr;
IMAGE_INFO            NVData_hdr;
PTR_SAS_DEVICE        ptrSasDev;
PTR_SAS_DEVICE        ptrAllSasDevs;
CONFIG_PROD_ID        CustomNvdata;
CONFIG_PROD_ID       *CustomNvdataPtr;

char *PtrSeeprom_Keywords[] =
{
   "SECTION_GENERAL_DATA",
   "SECTION_MANUFACTURING_PAGE_0",
   "SECTION_MANUFACTURING_PAGE_1",
   "SECTION_IOC_MFG_PAGE_2",
   "SECTION_IOC_MFG_PAGE_3",
   "SECTION_MANUFACTURING_PAGE_4",
   "SECTION_MANUFACTURING_PAGE_5",
   //"SECTION_MANUFACTURING_PAGE_6",
   "SECTION_IO_UNIT_PAGE_0",
   "SECTION_IO_UNIT_PAGE_1",
   "SECTION_IO_UNIT_PAGE_2",
   "SECTION_IO_UNIT_PAGE_3",
   "SECTION_IO_UNIT_PAGE_4",
   "SECTION_IOC_PAGE_0",
   "SECTION_IOC_PAGE_1",
   "SECTION_IOC_PAGE_2",
   "SECTION_IOC_PAGE_3",
   "SECTION_IOC_PAGE_4",
   "SECTION_IOC_PAGE_5",
   "SECTION_SAS_IO_UNIT_0",
   "SECTION_SAS_IO_UNIT_1",
   "SECTION_SAS_IO_UNIT_2",
   "SECTION_SAS_IO_UNIT_3",
   "SECTION_SAS_EXPANDER_0",
   "SECTION_SAS_EXPANDER_1",
   "SECTION_SAS_DEVICE_0",
   "SECTION_SAS_DEVICE_1",
   "SECTION_SAS_DEVICE_2",
   "SECTION_SAS_PHY_0",
   "SECTION_SAS_PHY_1",
   "SECTION_SAS_ENCLOSURE_0",
   "SECTION_PERSISTENT_ID",
   "SECTION_RAID_VOL_PAGE_0",
   "SECTION_RAID_VOL_PAGE_1",
   "SECTION_RAID_PHYS_DISK_PAGE_0",
   "SECTION_RAID_PHYS_DISK_PAGE_1",
   "SECTION_BIOS_1",
   "SECTION_BIOS_2",
   "SECTION_LOG_0",
   "SECTION_PRIVATE_IR_PAGE",
   0
};


/***********************************/
      

int checkBiosValidity (MPT_PORT *port, U32 *incoming_address, int len) {


    int   status, i;
	U8	  checksum, *tempPtr;
    U32	  n;
    PCIR *pcir;
    
    logPrint ("*Entering checkBiosValidity()");
    tempPtr = (U8 *)incoming_address; 

    /*
    **  The first word of an option rom should be 0xAA55
    */
    n = incoming_address[0x00] & 0x0000FFFF ;
    
    if (n != 0xaa55) {

        logPrint("     Option Rom Sig Invalid: 0x%08x", n);
        return 1;

	} else {

        /*
        **  Valid checksum?
        */
		checksum = 0;
		for (i = 0; i < len; i++) {
			checksum += tempPtr[i];
        }

		if (checksum != 0) {

            logPrint("     Checksum Invalid");
            return 1;

        } else {

            /*
            **  Let's check for a valid PCIR
            */
            n = (tempPtr[0x19]<<8) + tempPtr[0x18];

            if ( n + (int)sizeof *pcir < len ) {

                pcir = (PCIR *)(tempPtr + n);

                if (pcir->signature[0] != 'P' ||
                    pcir->signature[1] != 'C' ||
                    pcir->signature[2] != 'I' ||
                    pcir->signature[3] != 'R') {
                    
                    logPrint("     PCIR signature is invalid.", n);
                    return 1;

                } else {

                    if (checkCompatible(pcir->deviceId, port->deviceId) != 1) {

                        logPrint("     PCIR Device ID 0x%04x is not compatible.", pcir->deviceId);
                        return 1;

                    } else {


                        /*
                        **  Only run the Raid check on x86 option roms.
                        */
                        logPrint("     PCIR type: 0x%04x .", pcir->type);
                        if ( HostRunIsSASFamily(flag_ptr) && pcir->type == 0x00) {

                            /*
                            **  RAID Verification
                            */
                            status = checkRAIDVerification_BIOS ( port, incoming_address, len );

                            if (status != 0) {
                                return 1;
                            }
                        }
                    }

                }  // ends if (pcir->signature[0] != 'P' ||

            } else {

                logPrint("     PCIR offset of 0x%04x is invalid.", n);
                return 1;

            } // ends if ( n + (int)sizeof *pcir < len )

		} // ends if (checksum != 0)

    } // ends if (n != 0xaa55)

    logPrint("*Leaving checkBiosValidity()");
	return 0;

}




int checkCompatible(int fromFile, int fromHBA) {

	int	id1, id2;

    /*
    **  Let's compare device ID from file and from HBA
    */
    id1 = getCompatible(fromFile);
	id2 = getCompatible(fromHBA );

	return id1 == id2;
}

                                                            


void checkDriverVersion ( void ) {

    int  count, i;
    char version[30];
    
    FILE *filePtr;

    logPrint ("*Entering checkDriverVersion()");

    count = 0;

    if ( (filePtr = fopen("/proc/mpt/version", "r")) == NULL) {

        printf("\n\nERROR:  Can't open /proc/mpt/version");
        flag_ptr->DriverLoaded = FALSE;
        //exit(1);
    } else {

        flag_ptr->DriverLoaded = TRUE;
        fgets (version, 25, filePtr);
        fclose(filePtr);

        for (i=0; i <= strlen(version); i++) {

            if ( isdigit(version[i]) || isxdigit(version[i]) ) {

                version[count] = version[i];
                count++;

            } else if ( version[i] == '\0') {

                version[count] = '\0';
                break;
            }
        } // ends for (i=0; i < strlen(version); i++)


        /*
        **  Store this data off ....
        */
        flag_ptr->DriverVersion = atoi(version);
        logPrint ("     Driver Version: 0x%08x", flag_ptr->DriverVersion);

        /*
        **  For this utility to work we need to add a new IOCTL to the driver and therefore has a minimum 
        **  driver version to work with.
        */
#if __KERNEL_2_4__

        if (flag_ptr->DriverVersion < SUPPORTED_24_DRIVER) {
            printf("\n\nERROR:  You need to upgrade your mpt driver to a minimum of 2.06.01\n\n");
            exit(1);
        } 
#endif 


#if __KERNEL_2_6__

        if (flag_ptr->DriverVersion < SUPPORTED_26_DRIVER) {
            printf("\n\nERROR:  You need to upgrade your mpt driver to a minimum of 3.02.05\n\n");
            exit(1);
        } 
#endif

    }

    logPrint ("*Leaving checkDriverVersion()");
}



int checkRAIDVerification_BIOS ( MPT_PORT *port, U32 *IncomingAddress, int length ) {

    int  i, error = 0;
    U8   *findString;
    U32  filesize, *filestart, *filecurrent, CurrentProductID, IncomingProductID;

    BIOS_OPTIONS *biosStruct;
    

    logPrint("*Entering RAIDVerification_BIOS()");

    CurrentProductID = IncomingProductID = 0xFFFFFFFF;
        
    /*
    **  Let's work with the incoming file.
    */
    findString  = (U8 *)IncomingAddress;
    
    /*
    **  Let's see if we can find the magic string 
    */
    for (i = 0; i < length; i++) {

        if ( *((U32 *) &(findString[i]))   == BIOS_OPTIONS_STRUCT_SIGNATURE1 && 
             *((U32 *) &(findString[i+4])) == BIOS_OPTIONS_STRUCT_SIGNATURE2) {
            biosStruct = (BIOS_OPTIONS *) &(findString[i]);
            break;
        }
    }

    if (i < length) {

        for (i = 0; i < biosStruct->NumProductOptions; i++) {

            logPrint("                   Key: 0x%08x", biosStruct->Option[i].Key);

            if ( biosStruct->Option[i].Key == ((PCI_VENDOR_ID_LSI << 16) | OPTION_CODE_READ_ONLY) ) {
                IncomingProductID = (biosStruct->Option[i].Capabilities & 0x000000F0);
                logPrint("     IncomingProductID: 0x%08x", IncomingProductID);
                break;
            } 
        }

        if (IncomingProductID == 0xFFFFFFFF) {
            printf("\n\nERROR:  No LSI Key Found in New File");
            return 1;
        } 


    } else {

        printf("\n\nERROR:  BIOS Options Structure Not Found in New File");
        return 1;
    }

    ZeroGlobalMemory(0x8);
    filestart = (U32 *)buffer4;

    /*
    **  Get the BIOS
    */
    if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_BIOS_FLASH, buffer4, GLOBAL_MEMORY_BYTES, 0, &filesize) != 1) {
         ;
    }

    if (filesize != 0) {

        filecurrent = filestart = (U32 *)buffer4;
        findString  = (U8 *)filestart;

        /*
        **  Let's see if we can find the magic string 
        */
        for (i = 0; i < filesize; i++) {

            if ( *((U32 *) &(findString[i]))   == BIOS_OPTIONS_STRUCT_SIGNATURE1 && 
                 *((U32 *) &(findString[i+4])) == BIOS_OPTIONS_STRUCT_SIGNATURE2) {
                biosStruct = (BIOS_OPTIONS *) &(findString[i]);
                break;
            } 
        }


        if (i < filesize) {

            for (i = 0; i < biosStruct->NumProductOptions; i++) {

                logPrint("                   Key: 0x%08x", biosStruct->Option[i].Key);

                if ( biosStruct->Option[i].Key == ((PCI_VENDOR_ID_LSI << 16) | OPTION_CODE_READ_ONLY) ) {

                    CurrentProductID = (biosStruct->Option[i].Capabilities & 0x000000F0);
                    logPrint("      CurrentProductID: 0x%08x", CurrentProductID);
                    break;
                }  
            }

            if (CurrentProductID != 0xFFFFFFFF) {

                if (CurrentProductID != IncomingProductID) {
                    error++;

                    printf("\n\nERROR:  Mismatching Option Roms");

                    printf("\n\tCurrent BIOS supports:  ");
                    if (CurrentProductID == BIOS_OPTION_LSI_0_IT_SUPPORTED) {
                        printf("IT ");
                    }
                    if (CurrentProductID == BIOS_OPTION_LSI_0_IM_SUPPORTED) {
                        printf("IM ");
                    }
                    if (CurrentProductID == BIOS_OPTION_LSI_0_IME_SUPPORTED) {
                        printf("IME ");
                    }
                    if (CurrentProductID == BIOS_OPTION_LSI_0_IS_SUPPORTED) {
                        printf("IS");
                    }

                    printf("\n\t    New BIOS supports:  ");
                    if (IncomingProductID == BIOS_OPTION_LSI_0_IT_SUPPORTED) {
                        printf("IT ");
                    }
                    if (IncomingProductID == BIOS_OPTION_LSI_0_IM_SUPPORTED) {
                        printf("IM ");
                    }
                    if (IncomingProductID == BIOS_OPTION_LSI_0_IME_SUPPORTED) {
                        printf("IME ");
                    }
                    if (IncomingProductID == BIOS_OPTION_LSI_0_IS_SUPPORTED) {
                        printf("IS");
                    }
                }

            } else {

                printf("\n\nERROR:  No LSI Key Found");
                return 1;
            }

        } else {
            
            printf("\n\nERROR:  BIOS Options Structure Not Found");
            return 1;
        }

    } else {

        /*
        **  There wasn't a BIOS loaded ... do nothing here.
        */
        logPrint("     No option roms loaded!!");

    } //ends if (filesize != 0)


    logPrint("Leaving RAIDVerification_BIOS()");
    
    return 0;       
}


int checkRAIDVerification_Firmware ( MPT_PORT *port, U16 ProductInfo ) {

    int              error = 0;
    U32              CurrentProductInfo, IncomingProductInfo;
    IOCFactsReply_t	 IOCFacts;



    logPrint("*Entering checkRAIDVerification_Firmware()");
    
    error = 0;

    /*
    **  I need to get the information from the current firmware.
    */
    if (getIocFacts(port, &IOCFacts) != 1)
        return 0;
    
    if (IOCFacts.IOCStatus == MPI_IOCSTATUS_SUCCESS) {

        CurrentProductInfo  = (IOCFacts.ProductID & MPI_FW_HEADER_PID_PROD_MASK) >> 8;
        IncomingProductInfo = (ProductInfo        & MPI_FW_HEADER_PID_PROD_MASK) >> 8;
        logPrint("      Current Product Info: 0x%04x", CurrentProductInfo);
        logPrint("     Incoming Product Info: 0x%04x", IncomingProductInfo);

        if (CurrentProductInfo != IncomingProductInfo) {

            error++;
            printf("\n\nERROR:  RAID Verification Test");

            printf("\n\t      Current Firmware Loaded:  ");
            switch(IOCFacts.ProductID & MPI_FW_HEADER_PID_PROD_MASK) {
            case 0x0100: {printf("Initiator (0x0100)");          break; }
            case 0x0200: {printf("Initiator & Target (0x0200)"); break; }
            case 0x0300: {printf("Target (0x0300)");             break; }
            case 0x0400: {printf("IM (0x0400)");                 break; }
            case 0x0500: {printf("IS (0x0500)");                 break; }
            case 0x0600: {printf("CTX (0x0600)");                break; }
            case 0x0700: {printf("IR (0x0700)");                 break; }
            }
            
            printf("\n\tTrying to Flash Firmware Type:  ");
            switch(ProductInfo & MPI_FW_HEADER_PID_PROD_MASK) {
            case 0x0100: {printf("Initiator (0x0100)");          break; }
            case 0x0200: {printf("Initiator & Target (0x0200)"); break; }
            case 0x0300: {printf("Target (0x0300)");             break; }
            case 0x0400: {printf("IM (0x0400)");                 break; }
            case 0x0500: {printf("IS (0x0500)");                 break; }
            case 0x0600: {printf("CTX (0x0600)");                break; }
            case 0x0700: {printf("IR (0x0700)");                 break; }
            }
        }

    } else {

        printf("\n\nERROR: Failed IOCFacts");
        error++;

    } // ends if (status == 0x00) IOCFacts

    logPrint("*Leaving RAIDVerification_Firmware(%d)", error);

    return error;       
}



unsigned char checksum( unsigned char * PtrPage, unsigned int PageSize, unsigned int HeaderType ) {

    unsigned int  i;
    unsigned char checksum = 0;

    for (i=HeaderType; i < PageSize; i++) {
        checksum += (PtrPage[i] & 0xFF);
    }

    return ( (unsigned char)(0x100 - checksum) );
}




int checkFirmwareValidity (MPT_PORT *port, char *name, U32 *address) {

    int              i, status;
    U32              checksum;
    MpiROMHeader_t	*fwHeader;


    logPrint ("*Entering checkValidity()");

    fwHeader = (MpiROMHeader_t *)address;
    logPrint("*Entering checkFirmwareValidity()");
    logPrint("     Checking Firware: %s"            , name);
    logPrint("       Buffer Address: 0x%08x"        , address);
    logPrint("        Arm Signature: 0x%08x%08x%08x", fwHeader->Sig2, fwHeader->Sig3, fwHeader->Sig4);
    logPrint("              Version: 0x%08x"        , fwHeader->FirmwareVersion);
    logPrint("           Image Size: 0x%08x"        , fwHeader->ImageSize);
    logPrint("           Product ID: 0x%04lx"       , fwHeader->ProductId);
    logPrint("            Vendor ID: 0x%04lx"       , fwHeader->VendorId);
    logPrint("             Seq Code: 0x%08x"        , fwHeader->SeqCodeVersion);
    logPrint("        Arm Instruct2: 0x%08x"        , fwHeader->ArmBranch2);
    if (flag_ptr->doingSASConcat == FALSE) {
        logPrint("          Revision ID: 0x%04x"        , port->revisionId);
    }

    /*
    **  Check the MPI Header Signature is correct
    */
    if (fwHeader->Sig2 != MPI_FW_HEADER_SIGNATURE_0 ||
        fwHeader->Sig3 != MPI_FW_HEADER_SIGNATURE_1 || 
        fwHeader->Sig4 != MPI_FW_HEADER_SIGNATURE_2 ) {

        printf("\n\nThe header signature string for firmware file: %s is incorrect.\n\n", name);
        printf("\n\tSig0: 0x%08x\n\tSig1: 0x%08x\n\tSig2: 0x%08x", fwHeader->Sig2, fwHeader->Sig3, fwHeader->Sig4);
        strcpy(flag_ptr->FileName, "UNKNOWN");
        return 1;

    } else {

        /*
        **  Run a checksum on the image
        */
        checksum = 0;

        for (i = 0; i < fwHeader->ImageSize / 4; i++)
            checksum += get32(((U32 *)address)[i]);
        
        if (checksum != 0) {

            printf("\n\nThe firmware file: %s has an incorrect checksum.\n", name);
            strcpy(flag_ptr->FileName, "UNKNOWN");
            return 1;

        } else {

            /*
            **  This is where I check to see if I need to check the family type becuase if I'm 
            **  just concatenating firmware and nvdata it's currently only going to SAS ...
            **  so just check to see if it's a valid sas firmware.
            */
            if (flag_ptr->doingSASConcat == TRUE) {

                if (!(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS)) {

                    printf("\n\nThe firmware file: %s is not for the LSI SAS HBA family.", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                } else if ((fwHeader->ProductId & MPI_FW_HEADER_PID_FAMILY_1064_SAS)          && 
                           (flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1078  ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1068E ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1068  ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1066E ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1066) ) {

                           printf("\n\nERROR:  You are trying to concatenate 1064 family firmware");
                           printf("  \n        with 1068 family nvdata.\n\n");
                           exit(1);

                } else if ((fwHeader->ProductId & MPI_FW_HEADER_PID_FAMILY_1068_SAS)           && 
                           (flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1064   ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1064A  ||
                            flag_ptr->Nvdata_DeviceID == MPI_MANUFACTPAGE_DEVID_SAS1064E) ) {

                           printf("\n\nERROR:  You are trying to concatenate 1068 family firmware");
                           printf("  \n        with 1064 family nvdata.\n\n");
                           exit(1);
                }


            } else {

                /*
                **  Is this in the correct family?
                */
                if (HostRunIs1064Family(flag_ptr) && 
                          (!(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS) || 
                           !(fwHeader->ProductId & MPI_FW_HEADER_PID_FAMILY_1064_SAS) )) {

                    printf("\n\nThe firmware file: %s is not for the 1064 HBA family.", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                } else if (HostRunIs1068Family(flag_ptr) && 
                          (!(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS) || 
                           !(fwHeader->ProductId & MPI_FW_HEADER_PID_FAMILY_1068_SAS) )) {

                    printf("\n\nThe firmware file: %s is not for the 1068 HBA family.", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                } else if ((HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr))  && 
                          (!(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS) || 
                           !(fwHeader->ProductId & MPI_FW_HEADER_PID_FAMILY_106xE_SAS) )) {
                
                    printf("\n\nThe firmware file: %s is not for the 106xE HBA family.", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                } else if (HostRunIsSASFamily(flag_ptr)  && !(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS)) {

                    printf("\n\nThe firmware file: %s is not for the LSI SAS HBA family.", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                /*
                **  This check is making sure that we are not trying to flash SAS A1 firmware on a A2 card
                */
                } else if ( HostRunIs1064Family(flag_ptr) && 
                            ((port->revisionId == 0x0 && fwHeader->SeqCodeVersion != 0x1064a1) ||
                             (port->revisionId == 0x1 && fwHeader->SeqCodeVersion != 0x1064a2) ||
                             (port->revisionId == 0x2 && fwHeader->SeqCodeVersion != 0x1064a3) )) {

                    if (fwHeader->SeqCodeVersion == 0x1064a1) {
                        printf("\n\nThe firmware file: %s is intended for an A1 SAS HBA.", name);
                    } else if (fwHeader->SeqCodeVersion == 0x1064a2) {
                        printf("\n\nThe firmware file: %s is intended for an A2 SAS HBA.", name);
                    } else if (fwHeader->SeqCodeVersion == 0x1064a3) {
                        printf("\n\nThe firmware file: %s is intended for an A3 SAS HBA.", name);
                    } else {
                        printf("\n\nThe firmware file: %s is intended for an unknown SAS HBA.", name);
                    }
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                /*
                **  This check is making sure that we are not trying to flash SAS A0 firmware on a B0 card
                */
                } else if ( HostRunIs1068Family(flag_ptr) &&                         
                            ((port->revisionId == 0x0 && fwHeader->SeqCodeVersion != 0x1068a0) ||
                             (port->revisionId == 0x1 && fwHeader->SeqCodeVersion != 0x1068b0) )) {

                    if (fwHeader->SeqCodeVersion == 0x1068a0) {
                        printf("\n\nThe firmware file: %s is intended for an 1068(A0) SAS HBA.", name);
                    } else if (fwHeader->SeqCodeVersion == 0x1068b0) {
                        printf("\n\nThe firmware file: %s is intended for an 1068(B0) SAS HBA.", name);
                    } else {
                        printf("\n\nThe firmware file: %s is intended for an unknown SAS HBA.", name);
                    }
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;

                } else if (!(fwHeader->ProductId & MPI_FW_HEADER_PID_TYPE_SAS) ) {

                    printf("\n\nThe firmware file: %s is of unknown product type.\n", name);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                    return 1;
                }

            }  //ends if (type == 1)


            /*
            **  dsf -- 9/29/04
            **
            **  I am suppose to check and see if there is a zero length nvdata section in the firmware
            **  and if there is reject the image for flashing.
            */         
            if (HostRunIsSASFamily(flag_ptr) || flag_ptr->doingSASConcat == TRUE) {

                ParseImageFile(fwHeader->ImageSize, address);


                if (flag_ptr->doingSASConcat == TRUE) {

                    //logPrint("    Nvdata Image Size: 0x%08x .. 0x%08x", flag_ptr->nvdataHdr.ImageSz, sizeof(MPI_EXT_IMAGE_HEADER));
                    //printf  ("\n    Nvdata Image Size: 0x%08x .. 0x%08x", flag_ptr->nvdataHdr.ImageSz, sizeof(MPI_EXT_IMAGE_HEADER));
                    //dogetch();

                    if (flag_ptr->nvdataHdr.ImageSz <= sizeof(MPI_EXT_IMAGE_HEADER)) {

                        /*
                        **  This is good ... kick back good signal
                        */
                        return 0;

                    } else {

                        printf("\n\nThe firmware file: %s already has a nvdata concatenated to it.\n", name);
                        return 1;
                    }

                } else if (flag_ptr->nvdataHdr.ImageSz <= sizeof(MPI_EXT_IMAGE_HEADER) ) {

                    printf("\n\nERROR:  This is an invalid firmware image!!");
                    printf("\n        This image does not contain a valid nvdata");
                    return 1;
                }

                if (flag_ptr->doingFWDLB == FALSE) {

                    /*
                    **  Vendor ID = 0xFF means there is something incorrect with the nvdata
                    */
                    if (flag_ptr->nvdataHdr.VendorId[0] != 0xFF) {

                        /*
                        **  Vendor ID = 0x0 means it is probably old nvdata and flash the newer one.
                        */
                        if (flag_ptr->nvdataHdr.VendorId != 0x0) {

                            /*
                            ** Let's get data from firmware already on the card.
                            */
                            doDisplayNvdata(port, 2);                                        

                            if (strcmp(flag_ptr->ProductId, "ERROR") == 0) {

                                return 1;

                            } else if (strcmp(flag_ptr->ProductId, "UNKNOWN") != 0) {

                                /*
                                **  If the string is "UNKNOWN" the current nvdata is younger than 0x1E so
                                **  flash it anyways.  (don't increase error)
                                **
                                **  Do they compare?
                                */
                                if (strncmp(flag_ptr->nvdataHdr.VendorId, flag_ptr->VendorId, sizeof(flag_ptr->nvdataHdr.VendorId)) != 0) {
                                    printf("\n\n Error: Vendor ID's don't match");
                                    printf("\n\t From File : "); 
                                    fwrite(flag_ptr->nvdataHdr.VendorId, sizeof(U8), 8, stdout);
                                    printf("\n\t From Flash: "); 
                                    fwrite(flag_ptr->VendorId, sizeof(U8), 8, stdout);
                                    return 1;

                                } else if (strcmp(flag_ptr->nvdataHdr.ProductId, flag_ptr->ProductId) != 0) {
                                    printf("\n\n Error: Product ID's don't match");
                                    printf("\n\t From File : "); 
                                    fwrite(flag_ptr->nvdataHdr.ProductId, sizeof(U8), 16, stdout);
                                    printf("\n\t From Flash: "); 
                                    fwrite(flag_ptr->ProductId, sizeof(U8), 16, stdout);
                                    return 1;
                                }
                            }

                        } else {

                            /*
                            **  Okay ... flash it anyways.  But I want to log this for debug.
                            */
                            logPrint("     VendorID = 0x0000000 -- Flashing anyways");


                        } // ends if (NVData_hdr.VendorId != 0x0) 

                    } else {

                        printf("\n\nERROR:  This image does not have a proper VendorID and/or ProductID in the nvdata.");
                        return 1;

                    } // ends NVData_hdr.VendorId != 0xFF

                    /*
                    **  Check to see if the image has a valid bootloader image.
                    */
                    if (flag_ptr->bootloaderHdr.ImageAddress == NULL) {

                        printf("\n\nERROR:  This image does not have a proper boot loader.");
                        return 1;
                    }

                    /*
                    **  Need to also check and see if the new nvdata version is >= uploaded nvdata version
                    */
                    if (flag_ptr->nvdataHdr.SeepromVersion < flag_ptr->SeepromVersion) {
                        printf("\n\n ERROR:  New firmware's nvdata version is less than the upload one.");
                        printf("\n\t     New NVDATA Version: 0x%04x", flag_ptr->nvdataHdr.SeepromVersion);
                        printf("\n\t Current NVDATA Version: 0x%04x", flag_ptr->SeepromVersion);
                        return 1;

                    } //ends if (NVData_hdr.SeepromVersion < flag_ptr->SeepromVersion)

                } // ends if (flag_ptr->doingFWDLB == FALSE)

                /*
                **  Raid Verification
                */
                if (flag_ptr->doingSASConcat == FALSE && flag_ptr->doingFWDLB == FALSE) {

                    status = checkRAIDVerification_Firmware (port, fwHeader->ProductId);

                    if (status) {
                        return 1;
                    }

                } // ends if (flag_ptr->doingSASConcat == FALSE)
            } // ends if ( HostRunIsSASFamily(flag_ptr) )
        } // ends if (checksum != 0)
    } // ends if (pHeader->Sig2 != MPI_FW_HEADER_SIGNATURE_0 ||

    logPrint ("*Successful checkValidity()");
    return 0;
}



int find_adapters ( void ) {

    int      count, flag, i, status;

#if __KERNEL_2_4__
    int      size;
#endif 

	char     portName[16], *chipName;
    U32      numPorts = 0;
	HANDLE   fileHandle;
	MPT_PORT *port;
    
    struct mpt_ioctl_hbapciinfo *hbapciinfo;

#if __KERNEL_2_6__
    struct mpt_ioctl_hbapciinfo hba_pciinfo;
#endif    


    logPrint ("*Entering find_adapters()");

    count = flag = numPorts = 0;
     
    if (flag_ptr->DriverLoaded == TRUE) {

        /*
        **  Let's try to modprobe mptctl three times. 
        */
        while (flag == 0 && count < 3) {

            if ( system("lsmod | grep mptctl > /dev/null" ) ) {

                printf("\n\nMPTCTL not loaded, modprobing mptctl");
                system("modprobe mptctl");
                count++;

            } else {

                flag++;

            } //ends if ( system("lsmod | grep mptctl" ))
        } //ends while (flag == 0)

        if (count >= 3) {
            printf("\n\nERROR:  Trouble getting mptctl running ....\n\n");
            exit(1);
        }

        /*
        **  Does /dev/mptctl exist and can we open it?
        */
        if ((fileHandle = open("/dev/mptctl", O_RDWR)) < 0) {

            printf("\nFILEHANDLE: %d", fileHandle);
            perror("  error");

            printf("\n\n /dev/mptctl does not exist, creating it now.");
            system ("mknod /dev/mptctl c 10 220");

            if ((fileHandle = open("/dev/mptctl", O_RDWR)) < 0) {
                printf("\nCouldn't open or create /dev/mptctl!\n");
                exit(1);
            }


        } // ends if ((fileHandle = open("/dev/mptctl", O_RDWR)) < 0)


#ifdef __KERNEL_2_4__

        logPrint("    __2.4 Kernel__");

        /*
        **  Memeory please ....
        */
        size       = sizeof (struct mpt_ioctl_hbapciinfo);
        hbapciinfo = (struct mpt_ioctl_hbapciinfo *)malloc(size);
        memset(hbapciinfo, 0, size);

        hbapciinfo->hdr.maxDataSize = size;
        hbapciinfo->hdr.iocnum      = 0;
        hbapciinfo->hdr.port        = 0;

        /*
        **  Let's see what information we can get about all hba's in the system
        */
        status = ioctl(fileHandle, MPTHBAPCIINFO, hbapciinfo);

        if (status == 1) {
            return 0;
        }


#elif __KERNEL_2_6__

        /*
        **  Check for 2.6 kernel
        */
        if(!lsi_sysfs_check_availability()) {

            logPrint("    __2.6 Kernel__");

            if(getHbaPciInfo(&hba_pciinfo)){ 

                fprintf(stderr, "Didn't detect MPT Fusion controllers\n");
                return 0;
            }

            /*
            **  Set the pointer for the 2.6 structure
            */
            hbapciinfo = &hba_pciinfo;
        }
#endif

        logPrint("     totalIOC: %d", hbapciinfo->totalIOC);

        for (i=0; i <= hbapciinfo->totalIOC; i++) {

            if (hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064  ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064A ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064E ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1066  ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1066E ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1068  ||
                hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1068E ) {

                /*
                **  Malloc some memory .....
                */
                port    = (MPT_PORT *)malloc(sizeof *port);

                if (buffer1 == NULL) {

                    buffer1 = (unsigned char *)malloc(GLOBAL_MEMORY_BYTES); // 512K
                    buffer2 = (unsigned char *)malloc(GLOBAL_MEMORY_BYTES); // 512K
                    buffer3 = (unsigned char *)malloc(GLOBAL_MEMORY_BYTES); // 512K
                    buffer4 = (unsigned char *)malloc(GLOBAL_MEMORY_BYTES); // 512K
                }

                port->portNumber        = hbapciinfo->hbapciinfo[i].iocNumber;
                port->currentState      = hbapciinfo->hbapciinfo[i].iocState;
                port->deviceId          = hbapciinfo->hbapciinfo[i].deviceID;
                port->vendorId          = hbapciinfo->hbapciinfo[i].vendorID;
                port->subSystemId       = hbapciinfo->hbapciinfo[i].subSystemID;
                port->subSystemVendorId = hbapciinfo->hbapciinfo[i].subSystemVendorID;
                port->revisionId        = hbapciinfo->hbapciinfo[i].revisionID;
                port->fileHandle        = fileHandle;
                port->mptVersion        = 0;
                port->fwVersion         = 0;

                if (hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064  ||
                    hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064A ) {

                    port->deviceProperties = HOST_RUN_DEVICE_PROPERTIES_SASFAMILY | 
                                             HOST_RUN_DEVICE_PROPERTIES_1064FAMILY;

                } else if (hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1068) {                              

                    port->deviceProperties = HOST_RUN_DEVICE_PROPERTIES_SASFAMILY |
                                             HOST_RUN_DEVICE_PROPERTIES_1068FAMILY;

                } else if (hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1064E) {                              

                    port->deviceProperties = HOST_RUN_DEVICE_PROPERTIES_SASFAMILY |
                                             HOST_RUN_DEVICE_PROPERTIES_1064EFAMILY;

                } else if (hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1066E ||
                           hbapciinfo->hbapciinfo[i].deviceID == MPI_MANUFACTPAGE_DEVID_SAS1068E ) {                              

                    port->deviceProperties = HOST_RUN_DEVICE_PROPERTIES_SASFAMILY |
                                             HOST_RUN_DEVICE_PROPERTIES_1068EFAMILY;

                } else {
                    port->deviceProperties = 0;
                }

                sprintf(portName, "/proc/mpt/ioc%d", hbapciinfo->hbapciinfo[i].iocNumber);
                strcpy(port->portName, portName);

                switch (port->deviceId) {

                case MPI_MANUFACTPAGE_DEVID_SAS1064:{

                        chipName = "SAS1064";
                        switch (port->subSystemId) {
                        case 0x1000: { // LSI Logic

                               switch (port->subSystemVendorId) {
                               case 0x3010: { chipName = "SAS3040X";    break; }
                               case 0x3020: { chipName = "SAS3041X";    break; }
                               case 0x3060: { chipName = "SAS3440X";    break; }
                               case 0x30F0: { chipName = "SAS3041XL-S"; break; }
                               } // ends switch (port->subSystemVendorId)

                        break;} // ends case 0x1000
                        } // ends switch (port->subSystemId)
                break;} // ends case MPI_MANUFACTPAGE_DEVID_SAS1064


                case MPI_MANUFACTPAGE_DEVID_SAS1068:{

                        chipName = "SAS1068";    
                        switch (port->subSystemId) {
                        case 0x1000: { // LSI Logic

                               switch (port->subSystemVendorId) {
                               case 0x3030: { chipName = "SAS3080X";    break; }
                               case 0x3040: { chipName = "SAS3441X";    break; }
                               case 0x3050: { chipName = "SAS3442X";    break; }
                               case 0x3070: { chipName = "SAS3800X";    break; }
                               } // ends switch (port->subSystemVendorId)
                        break;} // ends case 0x1000

                        case 0x103C: { // HP

                               switch (port->subSystemVendorId) {
                               case 0x3228: { chipName = "SAS3080X-HP"; break; }
                               } // ends switch (port->subSystemVendorId)

                        break;} // ends case 0x103C
                        } // ends switch (port->subSystemId)
                break; } //ends case MPI_MANUFACTPAGE_DEVID_SAS1068


                case MPI_MANUFACTPAGE_DEVID_SAS1064E:{    

                        chipName = "SAS1064E";   
                        switch (port->subSystemId) {
                        case 0x1000: { // LSI Logic

                               switch (port->subSystemVendorId) {
                               case 0x3090: { chipName = "SAS3041E";    break; }
                               } // ends switch (port->subSystemVendorId)

                        break;} // ends case 0x1000
                        } // ends switch (port->subSystemId)
                break;} // ends case MPI_MANUFACTPAGE_DEVID_SAS1064E


                case MPI_MANUFACTPAGE_DEVID_SAS1068E:{    

                        chipName = "SAS1068E";   
                        switch (port->subSystemId) {
                        case 0x1000: { // LSI Logic

                               switch (port->subSystemVendorId) {
                               case 0x3080: { chipName = "SAS3442E";    break; }
                               } // ends switch (port->subSystemVendorId)

                        break;} // ends case 0x1000
                        } // ends switch (port->subSystemId)
                break;} // ends case MPI_MANUFACTPAGE_DEVID_SAS1068E


                case MPI_MANUFACTPAGE_DEVID_SAS1066:     chipName = "SAS1066";    break;
                case MPI_MANUFACTPAGE_DEVID_SAS1064A:    chipName = "SAS1064A";   break;
                case MPI_MANUFACTPAGE_DEVID_SAS1066E:    chipName = "SAS1066E";   break;

                default: { logPrint("     Unsupported HBA: 0x%04x", port->deviceId); 
                           return 0; 
                         }
                } // ends switch (port->deviceId)

                port->chipName = chipName;

                logPrint("     Current State: 0x%x", port->currentState);

                if (port->currentState == (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT) ) {

                    /*
                    **  Let's go ahead and get some more information since we know that this card is
                    **  up and running.
                    */
                    if (getPortInfo(port) == 1) {

                        mptPorts[numPorts++] = port;

                        logPrint("     ***************************");
                        logPrint("     Port Number ........ %d"    , port->portNumber);
                        logPrint("     Port Name .......... %s"    , port->portName);
                        logPrint("     Chip Name .......... %s"    , port->chipName);
                        logPrint("     Device ID .......... 0x%04x", port->deviceId);                      
                        logPrint("     Vendor ID .......... 0x%04x", port->vendorId);
                        logPrint("     Revision ID ........ 0x%04x", port->revisionId);
                        logPrint("     SubSystem VendorID . 0x%04x", port->subSystemVendorId);
                        logPrint("     SubSystem ID ....... 0x%04x", port->subSystemId);
                        logPrint("     Current State ...... 0x%02x", port->currentState);
                        logPrint("     Who Init ........... 0x%02x", port->whoInit);
                        logPrint("     Max Buses .......... 0x%02x", port->maxBuses);
                        logPrint("     Max Targets ........ 0x%02x", port->maxTargets);
                        logPrint("     MPT Version ........ 0x%04x", port->mptVersion);
                        logPrint("     Product ID ......... 0x%04x", port->productId);
                        logPrint("     FW Version ......... 0x%08x", port->fwVersion);

                    } else {
                        free(port);
                    }

                } else {

                    logPrint("     ***************************");
                    logPrint("     Port Number ........ %d"    , port->portNumber);
                    logPrint("     Port Name .......... %s"    , port->portName);
                    logPrint("     Chip Name .......... %s"    , port->chipName);
                    logPrint("     Device ID .......... 0x%04x", port->deviceId);                      
                    logPrint("     Vendor ID .......... 0x%04x", port->vendorId);
                    logPrint("     Revision ID ........ 0x%04x", port->revisionId);
                    logPrint("     SubSystem VendorID . 0x%04x", port->subSystemVendorId);
                    logPrint("     SubSystem ID ....... 0x%04x", port->subSystemId);
                    logPrint("     Current State ...... 0x%02x", port->currentState);

                    mptPorts[numPorts++] = port;

               } // ends if (port->currentState == (MPI_IOC_STATE_OPERATIONAL << MPI_IOC_STATE_SHIFT)
            } // ends if (hbapciinfo->hbapciinfo[i].hbaType == 3)
        } // ends for (i=0; i <= hbapciinfo->totalIOC; i++)

    } else {

        numPorts = 0;

    } // ends if (flag_ptr->DriverLoaded == TRUE)



    if (numPorts == 0) {

        printf("\n\nWARNING: No PCI chips found!!\n\n");
        
        /*
        **  We need to see if the user wants to concatenate firmware.
        */
        printf("\n\n\tDo you wish to create a SAS defaults image from a .dat ");
        printf("  \n\tfile (this is the only functionality available here)? ");

        getString( name, 256, stdin );

        if (name[0] == 'Y' || name[0] =='y') {
            
            flag_ptr->doingSASConcat = TRUE;

            /*
            **  Need to grab three file names.
            */
            system("clear");

            printf("\n\nPlease enter the name of the firmware file: ");
            getString( flag_ptr->FileName, 256, stdin );
            
            printf("\n\n  Please enter the name of the nvdata file: ");
            getString( flag_ptr->FileName1, 256, stdin );
            
            printf("\n\n  Please enter the name of the output file: ");
            getString( flag_ptr->FileName2, 256, stdin );

            /*
            **  Time to concatenate
            */
            status = 0;
            status = ParseNvdataFile();

            if (status == TRUE ) {
                doNvdataImage();
                Flash_Nvdata();
            }
        } // ends if (name[0] == 'Y' || name[0] =='y')

        close(fileHandle);
    }

#ifdef __KERNEL_2_4__
    free(hbapciinfo);
#endif

    return numPorts;
}





int fixupBiosFcodeImage(MPT_PORT *port, unsigned char *buf, int len, int last) {

    int	   i, n;
	U8	   checksum;
	PCIR  *pcir;

	n = (buf[0x19]<<8) + buf[0x18];

	if (n + (int)sizeof *pcir < len) {

		pcir = (PCIR *)(buf + n);

		if (pcir->signature[0] == 'P' &&
			pcir->signature[1] == 'C' &&
			pcir->signature[2] == 'I' &&
			pcir->signature[3] == 'R')   {

            logPrint("     PCIR found");

			if (pcir->type != 255)
				pcir->deviceId = port->deviceId;


            if (HostRunIsSASFamily(flag_ptr)) {

                /*
                **  Class code should be 0x010000
                */
                pcir->classCode[0] = 0x00;
                pcir->classCode[1] = 0x00;
                pcir->classCode[2] = 0x01;
            }

            if (last) {
				pcir->indicator |= 0x80;
                logPrint("     Last Setting: 0x%04x", pcir->indicator);
            } else {
				pcir->indicator &= ~0x80;
                logPrint("     Last ~ Setting: 0x%04x", pcir->indicator);
            }

		} else {

            logPrint("     No PCIR found");
        }
	}

	checksum = 0;
	for (i = 0; i < pcir->imageLength * 512 - 1; i++)
		checksum += buf[i];
	buf[i] = -checksum;
    
    return 1;
}





U32 Firmware_Download_Checksum (U32* file_data, long int length) {

    U32 i, checksum, *ptr;

    checksum = 0;
    ptr = file_data;

    printf("\n");
    for (i = 0; i < (length +3) / 4; i++) {

        if (i % 100 == 0) {
            printf("\r\tChecksum ................ 0x%06x", i);
        }

        checksum += *ptr;
        ptr++;
    }

    printf("\r\tChecksum ................ 0x%08x", -checksum);

    return (-checksum);
}




void Flash_Nvdata ( void ) {
        
    U8     good_file_name, good_file;
    U8    *imagestart, *imagecurrent, *ptrWrkBuf, *p; 
    
    U32   *wrkBuffer,  *ptrNvDataImg, *firmwareBuffer;
    U32    i, imagesize, size, clr_loop;
    U32    finalsize = 0;
    U32    NvdataImageChkSum = 0;
    
    int   error = 0, n;
    char  key[2];
    char  image_file_name[DEFAULT_FILENAME_LENGTH];
    char  source_file_name[DEFAULT_FILENAME_LENGTH];
    
    FILE  *fPtr;

    IMAGE_HEADER          *FWImageHdr;
    MPI_EXT_IMAGE_HEADER  *ExtImageHdr, NvDataHdr;
    MpiROMHeader_t        *pHeader;    

    struct stat stat_p; 

    logPrint("*Entering FLASH_nvdata()");

    good_file_name = good_file = FALSE;

    /*
    **  Going to change all of this over to using buffer1 as firmware and buffer2 as work 
    */
    wrkBuffer      = (U32 *)malloc(GLOBAL_MEMORY_BYTES);    // allocate 512KB work buffer....
    firmwareBuffer = (U32 *)malloc(GLOBAL_MEMORY_BYTES);
    
    if (wrkBuffer == NULL || firmwareBuffer == NULL) {
        logPrint("     ERRROR:  Couldn't Malloc the Memory");
        printf("\n\n\tERRROR:  Couldn't Malloc the Memory");
        exit(1);
    }

    /*
    **  Zero out the memory  
    */
    for (clr_loop = 0; clr_loop < 0x20000; clr_loop++) {
        wrkBuffer[clr_loop]      = 0x00;
        firmwareBuffer[clr_loop] = 0x00;
    }


    ptrWrkBuf = (U8 *) wrkBuffer;
    p         = (U8 *) wrkBuffer;
    
    image_file_name[0] = '\0';
    imagesize          = GLOBAL_MEMORY_BYTES;
    imagestart         = (U8 *)firmwareBuffer; //daffy
    

    /*
    **  Get the firmware
    */
    while (good_file == FALSE) {

        while (good_file_name == FALSE) {

            if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0) {

                if (HostRunIs1064Family(flag_ptr)) {
                    printf("\n\nEnter name of FW image (default: %s):  ", DEFAULT_FIRMWARE_1064);
                } else if (HostRunIs1068Family(flag_ptr)) {
                    printf("\n\nEnter name of FW image (default: %s):  ", DEFAULT_FIRMWARE_1068);
                } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                    printf("\n\nEnter name of FW image (default: %s):  ", DEFAULT_FIRMWARE_106xE);
                } else {
                    printf("\n\nEnter name of FW image: ");
                }

                n = getString(source_file_name, sizeof source_file_name, stdin);

                /*
                **  Did they just hit <enter>?
                */
                if(strlen(source_file_name) == 0) {

                    if (HostRunIs1064Family(flag_ptr)) {
                        strcpy(source_file_name, DEFAULT_FIRMWARE_1064);

                    } else if (HostRunIs1068Family(flag_ptr)) {
                        strcpy(source_file_name, DEFAULT_FIRMWARE_1068);
                    } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                        strcpy(source_file_name, DEFAULT_FIRMWARE_106xE);
                    }
                }  // ends if(strlen(source_file_name) == 0)

            } else {

                strcpy(source_file_name, flag_ptr->FileName);
                strcpy(flag_ptr->FileName, "UNKNOWN");
            }

            /*
            **  Open the file
            */
            if((fPtr = fopen(source_file_name, "rb")) == NULL) {

                printf("\nERROR: Could not find file %s!\n", source_file_name);
                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");

                n = getString(key, sizeof key, stdin);

                if((key[0] == 'q') || (key[0] == 'Q')) {
                    return;
                } else {
                    source_file_name[0] = '\0';
                    printf("\n\n");
                }

            } else {
                
                good_file_name = TRUE;
            }

        } // ends while (good_file_name == FALSE) {


        /*
        **  Get the file information .....
        */
        //imagesize    = filelength(fileno(fPtr));
        fstat(fileno(fPtr), &stat_p);
        imagesize    = stat_p.st_size;
        logPrint("     ### FileSize: 0x%08x", imagesize);
        imagecurrent = imagestart;

        /*
        **  Copy the firmware information to memory .....
        */
        printf("\n\nReading in source Firmware image...\n");
        if ((size = fread(imagecurrent, 1, imagesize, fPtr)) != imagesize) {
            printf("\n\nDOH -- Flash_firmware .. read: 0x%08x ... size: 0x%08x .. %s", size, imagesize, source_file_name);
            n = getString(key, sizeof key, stdin);
            exit(1);
        }      


        /*
        **  I need to check and see if the NVDATA versions match before proceding
        */
        pHeader = (MpiROMHeader_t *)imagecurrent;

        if (pHeader->ArmBranch2 != SasSeepromVersion) {

            printf("\n\nERROR:  The firmware and NVDATA have different versions.");
            printf("  \nFirmware NVDATA Version: 0x%04x", pHeader->ArmBranch2);
            printf("  \n         NVDATA Version: 0x%04x\n\n", SasSeepromVersion);
            exit(1);
        }


        /*
        **  Is this a valid firmware image?
        */                                                                                   
        error = checkFirmwareValidity(NULL, source_file_name, (U32 *)imagecurrent);
        
        if (error) {

            printf("\n\n%s is not a valid firmware image.", source_file_name);
            printf("\nPress any key to reenter file name, otherwise press q to quit:  ");

            n = getString(key, sizeof key, stdin);

            if((key[0] == 'q') || (key[0] == 'Q')) {
                return;
            } else {
                
                good_file_name = FALSE;
                good_file      = FALSE;

                printf("\n\n");
            }

        } else {

            good_file = TRUE;
        }

    } //ends while (good_file == FALSE) {
    

    if (imagesize != 0) {

        imagecurrent  = imagestart;
        FWImageHdr    = (IMAGE_HEADER *) imagestart;
        /*
        **  Let's see some of the data in the  MPI headers ......
        */
        logPrint("            Image Size: 0x%08x", FWImageHdr->MpiHeader.ImageSize);
        logPrint("     Next Image Offset: 0x%08x", FWImageHdr->MpiHeader.NextImageHeaderOffset);

        /*
        ** we know we have to have the F/W image... copy it to the work buffer.
        */
        memcpy(ptrWrkBuf, imagestart, FWImageHdr->MpiHeader.ImageSize);
        
        /*
        ** Keep the buffer pointers up to date...
        */
        imagecurrent = imagestart + FWImageHdr->MpiHeader.ImageSize;
        ptrWrkBuf   += FWImageHdr->MpiHeader.ImageSize;
        finalsize   += FWImageHdr->MpiHeader.ImageSize;

        FWImageHdr->MpiHeader.NextImageHeaderOffset = FWImageHdr->MpiHeader.ImageSize;

        /*
        ** The uploaded image will contain F/W at least,  maybe Bootloader & nvdata as well.
        ** Check it out to determine what we have.
        */
        //if (flag_ptr->MergeFwDflts == FALSE) {
        //    ParseImageFile( imagesize, (U32 *)imagestart, globalcontig3);
        //} else {
        //    ParseImageFile_malloc( imagesize, (U32 *)imagestart, (U32 *)firmwareBuffer);
        //}
        ParseImageFile(imagesize, (U32 *)firmwareBuffer);

        /*
        ** move uploaded BootLoader image to the work buffer...
        */
        if (flag_ptr->bootloaderHdr.ImageAddress) {

            /*
            ** A bootloader image was in the uploaded image...
            ** Move it to the work buffer.
            */                                         
            ExtImageHdr = (MPI_EXT_IMAGE_HEADER *) (imagestart + FWImageHdr->MpiHeader.NextImageHeaderOffset);
            memcpy(ptrWrkBuf, imagecurrent, ExtImageHdr->ImageSize);
            /*
            ** Keep the buffer pointers up to date...
            */
            imagecurrent = imagestart + ExtImageHdr->ImageSize;
            ptrWrkBuf += ExtImageHdr->ImageSize;
            finalsize += ExtImageHdr->ImageSize;
            ExtImageHdr->NextImageHeaderOffset = (FWImageHdr->MpiHeader.NextImageHeaderOffset + ExtImageHdr->ImageSize);
        }

        /*
        ** should now be able to move the new NVDATA image into the work buffer.
        */

        /*
        ** Fill out the extended image header for the NvData image...
        */
        NvDataHdr.ImageType             = MPI_EXT_IMAGE_TYPE_NVDATA;
        NvDataHdr.Reserved              = 0x00;
        NvDataHdr.Reserved1             = 0x0000;
        NvDataHdr.Checksum              = 0x00;
        NvDataHdr.ImageSize             = NvDataImageLen + 0x18;  // image len + hdr len
        NvDataHdr.NextImageHeaderOffset = 0x00;                   // no plans to tack on another...
        NvDataHdr.LoadStartAddress      = (U32) FWImageHdr->SeepromImageLoadStartAddress;
        NvDataHdr.Reserved2             = 0x00000000;
        finalsize += (NvDataImageLen + 0x18);

        ptrNvDataImg = (U32 *) ptrWrkBuf; 
        ExtImageHdr = (MPI_EXT_IMAGE_HEADER *) ptrNvDataImg;
        memcpy(ptrWrkBuf, (U8 *) &NvDataHdr.ImageType, sizeof(MPI_EXT_IMAGE_HEADER));

        /*
        ** Keep the buffer pointers up to date...
        */
        ptrWrkBuf += sizeof(MPI_EXT_IMAGE_HEADER);
        memcpy(ptrWrkBuf, ptrSasNvdataImage, NvDataImageLen);

        /*
        ** Need to calculate the checksum for the NVDATA image and put it in
        ** the extended image header...
        **
        **
        **  The 32-bit checksum is formed by adding each 32-bit word in the
        **  contained in the NVData image, and then taking the 2's complement 
        ** (1's complement + 1) of the result"
        */

        for (i = 0; i < (NvDataHdr.ImageSize/4); i++, ptrNvDataImg++) {
            NvdataImageChkSum += *ptrNvDataImg;
        }

        ExtImageHdr->Checksum = (~NvdataImageChkSum + 1);


        /*
        ** Okay, move the newly built multi-image mass backinto the global memory
        ** buffer used to upload the data in the first place.
        */
        memcpy( firmwareBuffer, wrkBuffer, finalsize );

        //if (flag_ptr->MergeFwDflts == FALSE) {
        //    memcpy( pgcontig3, wrkBuffer, finalsize );
        //} else {
        //    memcpy( firmwareBuffer, wrkBuffer, finalsize );
        //}

        /*
        ** Check here to see if we're to save the image as is out to a file or
        ** proceed with the download...  won't do both because we won't have asked
        ** for the board specific info if the destination was to a file.
        */

        
        strcpy(image_file_name, flag_ptr->FileName2);
        strcpy(flag_ptr->FileName2, "UNKNOWN");

        fPtr = fopen(image_file_name,"wb");

        for (i=0; i<finalsize; i++) {

            if (fprintf(fPtr, "%c", p[i] ) == EOF) {
                printf("\n\n\nERROR when writing the concatenated image .....");
                logPrint("     ERROR when writiing the concatenated image");
                printf("\n\nPress Return to Continue");
                n = getString(key, sizeof key, stdin);
                break;
            }

        }
        fclose(fPtr);

    } else {
        printf("\n\nERROR:Firmware upload ... imagesize returned equals zero.");
        printf("\n\nPress Return to continue ....");
        n = getString(key, sizeof key, stdin);
    } // ends if (imagesize != 0)

    free(wrkBuffer); 
    free(firmwareBuffer); 
    logPrint("*Leaving FLASH_nvdata()");
}





void general_init( void ) {

    int   i, status;
    
    flag_ptr         = &flag_struct;
    force_update_ptr = &force_update_struct;
    ptrAllSasDevs    = ptrSasDev = NULL; 

    buffer1 = buffer2 = buffer3 = buffer4 = NULL;

    /*
    ** Setup some defaults
    */
    flag_ptr->CmdLine            = FALSE;
    flag_ptr->ManLogOpen         = FALSE;
    flag_ptr->zDebug             = FALSE;
    flag_ptr->doingSASConcat     = FALSE;
    flag_ptr->doingFWDLB         = FALSE;
    flag_ptr->Manufacturing      = FALSE;
    flag_ptr->DiagRest           = FALSE;
    flag_ptr->DisplayHelp        = FALSE;
    flag_ptr->DidErase           = FALSE;
    flag_ptr->Handshake          = FALSE;
    flag_ptr->SectionHeader      = -1;
    flag_ptr->SASAddPrefix       = 48;    // equivalent of '0'
    strcpy(flag_ptr->FileName,     "UNKNOWN");
    strcpy(flag_ptr->FileName1,    "UNKNOWN");
    strcpy(flag_ptr->FileName2,    "UNKNOWN");
    strcpy(flag_ptr->FWVersion,    "UNKNOWN");
    strcpy(flag_ptr->FirmwareWhat, "UNKNOWN");
    strcpy(flag_ptr->x86BIOSWhat,  "UNKNOWN");

    /*
    **  Setting up a default for SasAdrsPreFix
    */
    SasAdrsPreFix[0] = '\0';
    //strcpy(SasAdrsPreFix, "500062B");


    /*
    **  Setup defaults for ForceUpdate
    */
    force_update_ptr->BIOS1              = 0;
    force_update_ptr->BIOS2              = 0;
    force_update_ptr->IOCPage0           = 0;
    force_update_ptr->IOCPage1           = 0;
    force_update_ptr->IOCPage2           = 0;
    force_update_ptr->IOCPage3           = 0;
    force_update_ptr->IOCPage4           = 0;
    force_update_ptr->IOCPage5           = 0;
    force_update_ptr->IOUnitPage0        = 0;
    force_update_ptr->IOUnitPage1        = 0;
    force_update_ptr->IOUnitPage2        = 0;
    force_update_ptr->IOUnitPage3        = 0;
    force_update_ptr->IOUnitPage4        = 0;
    force_update_ptr->LOG0               = 0;
    force_update_ptr->ManufacturingPage0 = 0;
    force_update_ptr->ManufacturingPage1 = 0;
    force_update_ptr->ManufacturingPage2 = 0;
    force_update_ptr->ManufacturingPage3 = 0;
    force_update_ptr->ManufacturingPage4 = 0;
    force_update_ptr->ManufacturingPage5 = 0;
    force_update_ptr->ManufacturingPage6 = 0;
    force_update_ptr->RAIDPhysDisk0      = 0;
    force_update_ptr->RAIDPhysDisk1      = 0;
    force_update_ptr->RAIDVol0           = 0;
    force_update_ptr->RAIDVol1           = 0;
    force_update_ptr->SASDevice0         = 0;
    force_update_ptr->SASDevice1         = 0;
    force_update_ptr->SASDevice2         = 0;
    force_update_ptr->SASExpnader0       = 0;
    force_update_ptr->SASIOUnit0         = 0;
    force_update_ptr->SASIOUnit1         = 0;
    force_update_ptr->SASIOUnit2         = 0;
    force_update_ptr->SASIOUnit3         = 0;
    force_update_ptr->SASPersistentID    = 0;
    force_update_ptr->SASPhy0            = 0;
    force_update_ptr->SASPhy1            = 0;
    force_update_ptr->SASEnclosure0      = 0;

    /*
    **  Let's see if we are suppose to log data ....
    */ 
    if (gargc >= 2) {

        flag_ptr->CmdLine = TRUE;

        /*
        **  Let's look for a -o or -z first before anything else
        */
        for (i = 0; i < gargc; i++) {

            if ( strcmp(gargv[i], "-o") == 0 || strcmp(gargv[i], "-O") == 0 ) {
                
                mptutil  = TRUE;
                
                if (gargc == 2) {
                    flag_ptr->CmdLine = FALSE;
                } 

            } else if ( strcmp(gargv[i], "-z") == 0 || strcmp(gargv[i], "-Z") == 0 ) {

                if (gargc == 2) {
                    flag_ptr->CmdLine = FALSE;
                } else if (gargc == 3 && mptutil) {
                    flag_ptr->CmdLine = FALSE;
                }

                flag_ptr->zDebug = TRUE;

                openlog ("mptutil", LOG_CONS, LOG_USER);
                logPrint("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                logPrint("MPTUtil System Logging started.");
                logPrint("     ***************************");
                logPrint("     Version . %s", mptutil_version);
                logPrint("     Build ... %s", mptutil_build);
                logPrint("     gargc ... %d", gargc);

                if (flag_ptr->CmdLine == FALSE) {
                    logPrint("     CmdLine . FALSE", gargc);
                } else {
                    logPrint("     CmdLine . TRUE", gargc);
                }
            }
        }

        /*
        **  Let's see what else we have.
        */
        for (i = 0; i < gargc; i++) {


            if ( strcmp(gargv[i], "-m") == 0 || strcmp(gargv[i], "-M") == 0 ) {
                
                flag_ptr->Manufacturing = TRUE;

            } else if ( strcmp(gargv[i], "-y") == 0 || strcmp(gargv[i], "-Y") == 0 ) {
                
                flag_ptr->DiagRest = TRUE;

            } else if ( strcmp(gargv[i], "-?") == 0 ) {
                
                flag_ptr->DisplayHelp = TRUE;

            } else if ( strcmp(gargv[i], "-d") == 0 || strcmp(gargv[i], "-D") == 0 ) {
                
                flag_ptr->doingSASConcat = TRUE;

                if (mptutil) {

                    logPrint("     ***************************");
                    logPrint("     FileName .. %s", flag_ptr->FileName );
                    logPrint("     FileName1 . %s", flag_ptr->FileName1);
                    logPrint("     FileName2 . %s", flag_ptr->FileName2);
                    logPrint("     Length .... %d", strlen(gargv[i+1]));

                    /*
                    **  Need to grab three file names.
                    */
                    getFileNames(i+1);

                    /*
                    **  Time to concatenate
                    */
                    status = FALSE;
                    status = ParseNvdataFile();

                    if (status == TRUE) {
                        doNvdataImage();
                        Flash_Nvdata();
                    }
                }
            }
        } // ends for (i=1;i <= gargc;i++)

        if (flag_ptr->DisplayHelp == TRUE) {
            doHelp();
            exit(0);
        }

    } // ends if (gargc >= 1)
}



void logPrint (char *fmt, ...) {

    va_list argptr;
    int cnt;
    char str[2048];
    
    if (flag_ptr->zDebug == TRUE) {
        va_start(argptr, fmt);
        cnt = vsnprintf(str, 2048, fmt, argptr);
        syslog  (LOG_INFO, str);
        va_end(argptr);
    }
}



#if __KERNEL_2_6__
int lsi_sysfs_check_availability(void) {

	char	sysfsroot[SYSFS_PATH_MAX];

	if (sysfs_get_mnt_path(sysfsroot, SYSFS_PATH_MAX)) {

		/*
        ** sysfs not available. Try mounting...
        */ 
		if (system("mount -t sysfs none /sys 2> /dev/null")) {
			fprintf(stderr, "syfs fs not mounted\n");
			return 1;
		}
	}
	return 0;
}
#endif


int main(int argc, char *argv[]) {


    int numAdapters, currentAdapter, status = 1;
    int temp_currentAdapter = 0xFF;

//#ifdef __KERNEL_2_4__
//    int       size;
//    hp_host_info_t *hp_hostinfo;
//#endif


    mptutil = FALSE;

    if (argc >= 1) {
        gargc = argc;
        gargv = argv;
    }

    /*
    **  Intialize global flags
    */
    general_init();

    /*
    **  Do we have the correct driver?
    */
    checkDriverVersion();

    /*
    **  Find host adapters
    */
    numAdapters = find_adapters();

    if (numAdapters != 0) {

        while (TRUE) {

            currentAdapter = selectAdapter(numAdapters, 1);

            /*
            ** What to do ... what to do ....
            */
            if (currentAdapter == 0) {
                
                break;

            } else if (flag_ptr->CmdLine == TRUE) {

                temp_currentAdapter = ParseCommandLine(mptPorts[currentAdapter-1], numAdapters);

                if (temp_currentAdapter != 0xFF) {
                    currentAdapter = temp_currentAdapter;
                }

                break;

            } else {

                status = doPort(mptPorts[currentAdapter-1]);

                if (status == 0) {
                    break;
                } else if (status == 1) {

                    /*
                    **  We need to reset the card before moving on.
                    */
                    doResetPort(mptPorts[currentAdapter-1], MPTHARDRESET);
                }

            } // ends if (flag_ptr->CmdLine == TRUE)
        } // ends while (TRUE)

    } else {

        currentAdapter = 0;
    }
    
    //ends if (numAdapters != 0)

    if (mptutil) {
        closelog();
    }

    /*
    **  Free Memory
    */
    free(buffer1);
    free(buffer2);
    free(buffer3);
    free(buffer4);

    /*
    **  Reset everything on the way out.
    */
    if (currentAdapter != 0 && flag_ptr->doingSASConcat == FALSE && flag_ptr->DidErase == FALSE) {
        doResetPort(mptPorts[currentAdapter-1], MPTHARDRESET);
//#ifdef __KERNEL_2_4__
//    } else if (currentAdapter != 0 && flag_ptr->doingSASConcat == FALSE && flag_ptr->DidErase == TRUE) {
//        doResetPort(mptPorts[currentAdapter-1], MPTDIAGRESET);
//#endif
    }

    /*
    **  We need to update the driver to let them know if the state of the host adapter has changed.
    */      

//#ifdef __KERNEL_2_4__
//   if (flag_ptr->DidErase == TRUE) {
//
//        /*
//        **  We need to see if the card moved to the OPERATIONAL state.
//        */
//        size        = sizeof (hp_host_info_t);
//        hp_hostinfo = (hp_host_info_t *)malloc(size);
//        memset(hp_hostinfo, 0, size);
//        hp_hostinfo->hdr.iocnum  = mptPorts[currentAdapter-1]->portNumber;
//
//        /*
//        **  Let's see what information we can get about all hba's in the system
//        */
//        logPrint("     Sending HP_GETHOSTINFO IOCTL to update state.", hp_hostinfo->ioc_status);
//        status = ioctl(mptPorts[currentAdapter-1]->fileHandle, HP_GETHOSTINFO, hp_hostinfo);
//        logPrint("     Host Adapter State: 0x%08x", hp_hostinfo->ioc_status);
//        free(hp_hostinfo);
//    }
//#endif
    printf("\n\n");

	return 0;
}




int ParseCommandLine ( MPT_PORT *port, int numAdapters ) {

    int  i;
    int  currentAdapter = 0xFF;
    char choice;

    logPrint("*Entering ParseCommandLine()");

    for (i = 0; i < gargc; i++) {

        if (gargv[i][0] == '-') {
            choice = gargv[i][1];

            /*
            **  Move everything to lower case
            */
            if (isupper(choice)) {
                choice = choice + 32;
            }

        } else {
            choice = '*';
        }

        switch (choice) {
        case 'a': { break;}
        
        case 'b': { if (i + 1  <=  gargc - 1) {
                        if (gargv[i+1][0] != '-') {
                            strcpy(flag_ptr->FileName, gargv[i+1]);
                        }
                    }
                    
                    doBiosFcodeDownload(port);
                    break;}
        
        case 'c': { if (i+1 < gargc) {
                        if (gargv[i+1][0] != '-') {
                            doResetPort(port, MPTHARDRESET);
                            currentAdapter = selectAdapter(numAdapters, (int)atoi(gargv[i+1]));
                        } else {
                            printf("\n\n ERROR:  A host adapter number is required for the -c");
                            printf("  \n         command line option.  Ensure that you put a ");
                            printf("  \n         space between the -c and the host adapter number.");
                            printf("\n\n EXAMPLE:  mptutil -c 2 -f <filename>\n\n");
                            exit(1);
                        }
                    }
                    port = mptPorts[currentAdapter-1];
                    break;}

        case 'd': { break;} // look in general_init() for this functionality.
        case 'e': { if (mptutil) {
                        if (i + 1  <=  gargc - 1) {
                            if (gargv[i+1][0] != '-') {

                            #ifdef __KERNEL_2_4__
                               doTBoxClean(port, (U32)atoi(gargv[i+1]));
                            #endif
                            
                            }

                        } else {
                            printf("\n\nError:  No option provided for Erase functionality");
                            printf("  \nPress <return> to continue");
                            dogetch();
                        }
                    }
                    break;}

        case 'f': { if (i + 1  <=  gargc - 1) {
                        if (gargv[i+1][0] != '-') {
                            strcpy(flag_ptr->FileName, gargv[i+1]);
                        }
                    }
                    
                    doFirmwareDownload(port);
                    break;}

        case 'g': { if (mptutil && i+2 < gargc) {
                        
                        if (gargv[i+1][0] != '-') {
                            strcpy(flag_ptr->FileName, gargv[i+1]);

                            if (gargv[i+2][0] != '-') {
                                strcpy(flag_ptr->FileName1, gargv[i+2]);
                            }
                        } 

                        doFlashBiosFcode(port);
                        strcpy (flag_ptr->FileName,  "UNKNOWN");
                        strcpy (flag_ptr->FileName1, "UNKNOWN");
                    } // ends if (mptutil)
                    break;}

        case 'h': { if (mptutil && i+3 < gargc) {
            
                        if (gargv[i+1][0] != '-') {
                            strcpy(flag_ptr->FileName, gargv[i+1]);

                            if (gargv[i+2][0] != '-') {
                                strcpy(flag_ptr->FileName1, gargv[i+2]);

                                if (gargv[i+3][0] != '-') {
                                    strcpy(flag_ptr->FileName2, gargv[i+3]);
                                }
                            }
                        }

                        doFlashBiosFcodeEFI(port);
                        strcpy (flag_ptr->FileName,  "UNKNOWN");
                        strcpy (flag_ptr->FileName1, "UNKNOWN");
                        strcpy (flag_ptr->FileName2, "UNKNOWN");
                    } // ends if (mptutil)
                    break;}

        case 'i': { break;}
        case 'j': { break;}
        case 'k': { break;}
        case 'l': { break;}
        case 'm': { break;}
        case 'n': { break;}
        case 'o': { break;}
        case 'p': { break;}
        case 'q': { break;}
        case 'r': { break;}

        case 's': { if (mptutil) {

                        if (strlen (SasAdrsPreFix) == 0) {
                            printf("\n\n ERROR: No SAS address prefix found!");
                            printf("\n        Prefix (-w) must preceed the -s option on the command line.");
                            printf("\n\nHit any key to continue...");
                            dogetch();
                        } else {
                            doSASManufacturing_Info(port); 
                        }

                    }
                    break;}

        case 't': { if (mptutil) {
                         
                        if (strlen (SasAdrsPreFix) == 0) {
                            printf("\n\n ERROR: No SAS address prefix found!");
                            printf("\n        Prefix (-w) must preceed the -t option on the command line.");
                            printf("\n\nHit any key to continue...");
                            dogetch();
                        } else {
                            doSASAddress(port); 
                        }
                    }
                    break;}

        case 'u': { if (mptutil) {
                        if (i+1 < gargc) {
                            if (gargv[i+1][0] != '-') {
                                flag_ptr->SASAddPrefix = gargv[i+1][0];  
                                logPrint("     SASAddPrefix: %c", flag_ptr->SASAddPrefix);
                            }
                        }
                    }
                    break;}


        case 'v': { if (mptutil) {
                        if (gargv[i+1][0] != '-') {
                            doWriteReadCache(port, gargv[i+1][0]);  
                        }  else {
                            doWriteReadCache(port, '9');  
                        }
                    }
                    break;}


        case 'w': { if (i+1 < gargc && mptutil) {
                        if (gargv[i+1][0] != '-') {
                            strcpy(SasAdrsPreFix, gargv[i+1]);
                            logPrint("     SasAdrsPreFix: %s", SasAdrsPreFix);
                        }
                    }
                    break;}
        
        case 'x': { break;}

        case 'y': { 
                    if (mptutil) { 
                        doResetPort(port, MPTHARDRESET);
                    }
                    break;}

        case 'z': { break;}

        case '?': { break;}
        } // ends switch (choice)
    } // ends for (i = 0; i < gargc; i++)

    if (currentAdapter != 0xFF) {
        return currentAdapter;
    } else {
        return 0xFF;
    }

} // ends int ParseCommandLine ( MPT_PORT *port )





void parseData(FILE *ptrDataFile, U8 Index, PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry) {
    
    char *ptrData;
    char *ptrString;

    U8    length;  // length of a key word in the input data file
    U8    counter = 0;

    U32   value = 0;

    fpos_t filePosition;


    logPrint("*Entering parseData()");

    ptrData   = (char *)malloc(256);
    ptrString = (char *)malloc(256);

    getLineBuffer(ptrDataFile, ptrData);

    length = strlen(ptrData);

    while( strncmp(ptrData,PtrSeeprom_Keywords[Index+1],length-1) != 0 ) {

        if (getNvdataString(ptrString, ptrData) == TRUE) {

            value = strtoul( ptrString, NULL, 16 );
            
            if (*ptrString ==  '\"') {

                if (processString(ptrString) != TRUE) {
                    strcpy(ptrString, "ERROR");
                } else {
                    //ptrString = flag_ptr->NvdataStr;
                    strcpy(ptrString, flag_ptr->NvdataStr);
                }

            } // ends if (*ptrString ==  '\"') {
        } // ends if (getNvdataString(ptrString, ptrData) == TRUE) {
        

        /* 
        ** Need to differentiate from strings and numbers 
        */
        doSASPagesStructure(ptrIocConfigData, ptrInquiry, Index, value, ptrString, counter);

        fgetpos(ptrDataFile, &filePosition);

        getLineBuffer(ptrDataFile, ptrData);

        if (ptrData == NULL) {
            break;
        }

        if ( feof(ptrDataFile) ) {
            break;
        }

        counter++;
        length = strlen(ptrData);
        value  = 0;

    } // ends while( strncmp(ptrData,PtrSeeprom_Keywords[Index+1],length-1) != 0 )

    fsetpos(ptrDataFile, &filePosition);
    free(ptrString);
    free(ptrData);
    logPrint("*Leaving parseData()");

}








int ParseImageFile ( long int filesize, U32 *address) {

    U8                   *ptrInputImg; 
    MPI_FW_HEADER        *FWImageHdr;
    MPI_EXT_IMAGE_HEADER *ExtImageHdr;
    CONFIG_DIR_HEADER    *ConfigDirHeader;
    CONFIG_PROD_ID       *ConfigProdId;
    U32                   NextImgOffset;

        
    logPrint("*Entering ParseImageFile()");
    
    FWImageHdr = (MPI_FW_HEADER *) address;
    
    /*
    ** At this point, PhysAdrs is the physical memory pointer for the FW
    ** Base image found in the incoming buffer...
    */

    if (FWImageHdr->Signature0 == MPI_FW_HEADER_SIGNATURE_0 &&
        FWImageHdr->Signature1 == MPI_FW_HEADER_SIGNATURE_1 &&
        FWImageHdr->Signature2 == MPI_FW_HEADER_SIGNATURE_2 ) {

        /*
        ** We've got a valid FW image in the input buffer.
        */
        ptrInputImg = (U8 *) address;     /* setup a temp ptr to the incoming buffer */
        
        /*
        ** Initialize these to NULL in case we don't find an image
        ** of the correct type to set in there;
        */
        flag_ptr->bootloaderHdr.ImageAddress = (U32 *) NULL;
        flag_ptr->nvdataHdr.ImageAddress     = (U32 *) NULL;

        if (FWImageHdr->NextImageHeaderOffset) {

            /*
            ** There is more than 1 image in the input buffer...
            ** Set up a pointer to the Extended image header for the next image
            */
            ExtImageHdr   = (MPI_EXT_IMAGE_HEADER *) (ptrInputImg + FWImageHdr->NextImageHeaderOffset);
            NextImgOffset = FWImageHdr->NextImageHeaderOffset;

            do {

                switch (ExtImageHdr->ImageType) {
                case MPI_EXT_IMAGE_TYPE_BOOTLOADER:
                    
                    /*
                    ** bump past the extended image pointer to get to the image...
                    */
                    logPrint("    Found a BootLoader image type.");
                    flag_ptr->bootloaderHdr.ImageAddress    = (U32 *) ExtImageHdr;   
                    flag_ptr->bootloaderHdr.PhyImageAddress = NextImgOffset;  
                    flag_ptr->bootloaderHdr.ImgLoadStrtAdrs = ExtImageHdr->LoadStartAddress;  
                    flag_ptr->bootloaderHdr.ImageSz         = ExtImageHdr->ImageSize;
                    logPrint("     Image Load Start Address: 0x%08x", flag_ptr->bootloaderHdr.ImgLoadStrtAdrs);
                    logPrint("                Image Address: 0x%08x", flag_ptr->bootloaderHdr.ImageAddress);
                    logPrint("                   Image Size: 0x%08x", flag_ptr->bootloaderHdr.ImageSz);
                    break;

                case MPI_EXT_IMAGE_TYPE_NVDATA:
                    
                    /*
                    ** bump past the extended image pointer to get to the image...
                    */
                    logPrint("    Found a NVData image type.");
                    flag_ptr->nvdataHdr.ImageAddress    = (U32 *) ExtImageHdr;   
                    flag_ptr->nvdataHdr.PhyImageAddress = NextImgOffset;  
                    flag_ptr->nvdataHdr.ImgLoadStrtAdrs = ExtImageHdr->LoadStartAddress;  
                    flag_ptr->nvdataHdr.ImageSz         = ExtImageHdr->ImageSize;

                    ConfigDirHeader = (CONFIG_DIR_HEADER *) (flag_ptr->nvdataHdr.ImageAddress + (sizeof(MPI_EXT_IMAGE_HEADER) / 4) );
                    logPrint("     ConfigDirHead: 0x%08x", ConfigDirHeader->Signature);
                    logPrint("    SeepromVersion: 0x%04lx", ConfigDirHeader->SeepromVersion);

                    /*
                    **  Save off the SEEPROM version for possible comparison later
                    */
                    flag_ptr->nvdataHdr.SeepromVersion = ConfigDirHeader->SeepromVersion;


                    /*
                    **  Save off the SEEPROM version for possible comparison later
                    */
                    flag_ptr->nvdataHdr.SeepromVersion = ConfigDirHeader->SeepromVersion;


                    /*
                    **  I'm going to check and see if the Seeprom Version is >= 0x1E
                    **  Versions before 0x1E did not have the Config_Prod_Id added in 
                    */
                    if (ConfigDirHeader->SeepromVersion >= 0x1E00) {

                        ConfigProdId = (CONFIG_PROD_ID *) (flag_ptr->nvdataHdr.ImageAddress + (sizeof(MPI_EXT_IMAGE_HEADER) / 4)  + (sizeof(CONFIG_DIR_HEADER) / 4));

                        if (ConfigProdId->Signature == CONFIG_PROD_ID_SIGNATURE) {

                            strcpy(flag_ptr->nvdataHdr.ProductId,       ConfigProdId->ProductId);
                            strcpy(flag_ptr->nvdataHdr.VendorId,        ConfigProdId->VendorId);
                            strcpy(flag_ptr->nvdataHdr.ProductRevision, ConfigProdId->ProductRevision);

                        } else if (ConfigProdId->Signature == 0x00000000) {

                            memset(flag_ptr->nvdataHdr.ProductId,       0, sizeof(flag_ptr->nvdataHdr.ProductId));
                            memset(flag_ptr->nvdataHdr.VendorId,        0, sizeof(flag_ptr->nvdataHdr.VendorId));
                            memset(flag_ptr->nvdataHdr.ProductRevision, 0, sizeof(flag_ptr->nvdataHdr.ProductRevision));

                        } else {

                            flag_ptr->nvdataHdr.VendorId[0]        = 0xFF;
                            flag_ptr->nvdataHdr.ProductId[0]       = 0xFF;
                            flag_ptr->nvdataHdr.ProductRevision[0] = 0xFF;
                        }

                    } else {

                        memset(flag_ptr->nvdataHdr.ProductId,       0, sizeof(flag_ptr->nvdataHdr.ProductId));
                        memset(flag_ptr->nvdataHdr.VendorId,        0, sizeof(flag_ptr->nvdataHdr.VendorId));
                        memset(flag_ptr->nvdataHdr.ProductRevision, 0, sizeof(flag_ptr->nvdataHdr.ProductRevision));
                    }
                    break;


                default:
                    logPrint("    Found an uknown image type.");
                    return 1;
                    break;
                }

                if (ExtImageHdr->NextImageHeaderOffset) {

                    ExtImageHdr   = (MPI_EXT_IMAGE_HEADER *) (ptrInputImg + ExtImageHdr->NextImageHeaderOffset);
                    NextImgOffset = ExtImageHdr->NextImageHeaderOffset;

                } else {

                    break;

                } // ends if (ExtImageHdr->NextImageHeaderOffset)

            } while ( ExtImageHdr );

        } // ends if (FWImageHdr->NextImageHeaderOffset)

    } else {

        return 1;

    } // ends if (FWImageHdr->Signature0 == MPI_FW_HEADER_SIGNATURE_0
        
    logPrint("*Leaving ParseImageFile()");

    return 0;
}





int ParseNvdataFile( void ) {

    int     status = TRUE;
    int     length = 0, n;

    char    buffer[90];
    char    data[90];
    char    source_file[DEFAULT_FILENAME_LENGTH];
    char   *ptrKeyWord;
    char   *ptrBuffer = &buffer[0];
    char   *ptrData   = &data[0];

    U8      goodFile  = FALSE;
    U8      source_file_concat[280];
    U8      *ptrSource_file_concat = &source_file_concat[0];

    U32     index;
    U32     value     = 0;

    FILE   *ptrDataFile;

    PTR_INQUIRY_DATA ptrInquiry;
    


    logPrint("*Entering ParseNvdataFile()");

    /* 
    **  Let's see if we can open the NVDATA DAT file 
    */
    while (goodFile == FALSE) {

        if (strcmp(flag_ptr->FileName1, "UNKNOWN") == 0) {

            /*
            **  The file has not been provided ... must ask for it.
            */
            printf("\n\nPress 'q' to quit or type the name of the nvdata file: ");
            n = getString(source_file, sizeof source_file, stdin);

            if ( strcmp(source_file, "q") == 0 || strcmp(source_file, "Q") == 0 ) {
                strcpy(flag_ptr->FileName1, "UNKNOWN"              );
                return FALSE;
            }

        } else {

            strcpy(source_file        , flag_ptr->FileName1);
            strcpy(flag_ptr->FileName1, "UNKNOWN"              );
        }

        /*
        **  dsf -- 12/20/04
        **
        **  Because this is Linux and the dat file are made in a DOS system I have to 
        **  run dos2unix command on the file.
        */

        sprintf(ptrSource_file_concat, "dos2unix --quiet %s", source_file);
        system(source_file_concat);

        if ((ptrDataFile = fopen( source_file, "r" )) == NULL) {
            printf("\nERROR:  Input file %s not found", source_file);
            goodFile = FALSE;
        } else {
            goodFile = TRUE;
            logPrint("     NvData File: %s", source_file);
        }

    } // ends while (goodFile == FALSE)

    getLineBuffer(ptrDataFile, ptrBuffer);

    if (getNvdataString(ptrData, ptrBuffer) == TRUE) {
        value = strtoul( ptrData, NULL, 16 );
    } else {
        printf("\n\n Error: Found an error in .DAT file! (getNvdataString)");
        fclose(ptrDataFile);
        return(FALSE);
    }
    

    if (value != SAS_NVDATA_VERSION) {
        
        logPrint("     ERROR:  SAS Data Version does not match");
        logPrint("     ERROR:  File NVDATA Version: 0x%08x", value);
        logPrint("     ERROR:    Should be Version: 0x%08x", SAS_NVDATA_VERSION);

        printf("\n\nERROR:  SAS Data Version does not match");
        printf("\n\tERROR:  File NVDATA Version: 0x%08x", value);
        printf("\n\tERROR:    Should be Version: 0x%08x", SAS_NVDATA_VERSION);
        
        /*
        **  Print something to manufacturing log here ..... daffy
        */

        //printf("\n\n");
        //sprintf(gPtrLogBuf, "Error: SAS Data Version does not match!\n");
        //fprintf(stdout, gPtrLogBuf);
        //if (flag_ptr->ManLogOpen == TRUE) {
        //   fprintf(Man_PTR, gPtrLogBuf);
        //}

        //sprintf(gPtrLogBuf, "SAS Data Version is 0x%04X, SAS Data Version must be 0x%04X\n",
        //       (UINT16)value, SAS_NVDATA_VERSION);
        //fprintf(stdout, gPtrLogBuf);
        //if (flag_ptr->ManLogOpen == TRUE) {
        //   fprintf(Man_PTR, gPtrLogBuf);
        //}

        fclose(ptrDataFile);
        //Continue_Delay(5);
        return(FALSE);

    } else {
        SasSeepromVersion = (U16)(value << 8);
    }

    CustomNvdataPtr   = (PTR_CONFIG_PROD_ID)calloc(1, sizeof(CONFIG_PROD_ID));
    ptrIocConfigPages = (PTR_IOC_CONFIG_PAGES)calloc(1, sizeof(IOC_CONFIG_PAGES));
    ptrInquiry        = (PTR_INQUIRY_DATA)calloc(1, sizeof(INQUIRY_DATA));

    ptrIocConfigData  = ptrIocConfigPages;
    memset(ptrIocConfigPages, 0, sizeof(IOC_CONFIG_PAGES));

    /* 
    **  Initialize Inquiry string data with spaces 
    */
    memset(ptrInquiry->ProductId,       ' ', sizeof(ptrInquiry->ProductId));
    memset(ptrInquiry->ProductRevision, ' ', sizeof(ptrInquiry->ProductRevision));
    memset(ptrInquiry->VendorId,        ' ', sizeof(ptrInquiry->VendorId));
    memset(ptrInquiry->VendorSpecific,  ' ', sizeof(ptrInquiry->VendorSpecific));

    /*
    **  Initialize Custom NVDATA information
    */
    memset(CustomNvdataPtr->ProductId,        ' ', sizeof(CustomNvdataPtr->ProductId));
    memset(CustomNvdataPtr->ProductRevision,  ' ', sizeof(CustomNvdataPtr->ProductRevision));
    memset(CustomNvdataPtr->VendorId,         ' ', sizeof(CustomNvdataPtr->VendorId));

    /* 
    **  Parse the Dat file and match the board id input on the command line.
    **  If the board ids match then parse the subsystem id, subsystemvendor id
    **  and starting offset. If Manufacturing Data exists (GPIO2, GPIO3 and GPIO4)
    **  then also parse for GPIO settings.
    */
    while( !feof( ptrDataFile ) ) {

        getLineBuffer(ptrDataFile, ptrBuffer);
        
        if (*ptrBuffer == 'S') {

            /*
            **  Work our way through the major headers
            */
            for (index = SECTION_GENERAL_DATA; index <= SECTION_LOG_0; index++) {

                //logPrint("     Current section to process - %s", ptrBuffer);
                
                ptrKeyWord = PtrSeeprom_Keywords[index];
                length     = strlen(ptrKeyWord);
                 
                /* 
                **  Look for a SECTION in the Data file 
                */
                if ((strncmp( ptrBuffer, PtrSeeprom_Keywords[index], length-1)) == 0) {

                    /* 
                    **  Start parsing the data file for values 
                    */
                    parseData(ptrDataFile, index, ptrIocConfigData, ptrInquiry);
                }
                
                getLineBuffer(ptrDataFile, ptrBuffer);
            }

            free(ptrInquiry);

        } else {


            logPrint("     Unrecognized Identifier encountered in the input file: %c", *ptrBuffer);
            printf("\n\tUnrecognized Identifier encountered in the input file: %c", *ptrBuffer);
            status = FALSE;

            /*
            **  Print something to manufacturing log here ..... daffy
            */

            //sprintf(gPtrLogBuf, "Unrecognized Identifier encountered in the input file. %c\n", *ptrBuffer);
            //fprintf(stdout, gPtrLogBuf);
            //if (flag_ptr->ManLogOpen == TRUE) {
            //   fprintf(Man_PTR, gPtrLogBuf);
            //}
        }

    } /* end of while */

    free(CustomNvdataPtr);

    fclose( ptrDataFile );
    logPrint("*Exiting ParseNvdataFile(%d)", status);

    return status;
}




//int ParseSASImageFile( long int filesize, U32* filestart, CONTIGUOUS_MEMORY incoming_contig) {
int ParseSASImageFile( long int filesize, U32* filestart) {
    
    U8  *ptrInputImg; 
    
    MPI_FW_HEADER         *FWImageHdr;
    MPI_EXT_IMAGE_HEADER  *ExtImageHdr;
    //PHYSICAL_ADDRESS      PhysAdrs, tmpPhysAdrs;


    logPrint("*Entering ParseSASImageFile()");


    /*
    ** for images that will be downloaded with a firmware download message,
    ** we'll need to keep track of its physical address as well since that
    ** address is used in the scatter gather list.
    */ 
    //PhysAdrs = incoming_contig.PhyPtrContiguous;
    FWImageHdr = (MPI_FW_HEADER *) filestart;

    /*
    ** At this point, PhysAdrs is the physical memory pointer for the FW
    ** Base image found in the incoming buffer...
    */
    if (FWImageHdr->Signature0 == MPI_FW_HEADER_SIGNATURE_0 &&
        FWImageHdr->Signature1 == MPI_FW_HEADER_SIGNATURE_1 &&
        FWImageHdr->Signature2 == MPI_FW_HEADER_SIGNATURE_2 ) {

        /*
        ** Setup a temp ptr to the incoming buffer
        */
        logPrint("     Found a valid FW image.");
        ptrInputImg = (U8 *) filestart;

        /*
        ** Initialize these to NULL in case we don't find an image
        ** of the correct type to set in there;
        */
        BootLdr_hdr.ImageAddress = (U32 *) NULL;
        NVData_hdr.ImageAddress  = (U32 *) NULL;

        if (FWImageHdr->NextImageHeaderOffset) {

            /*
            ** There is more than 1 image in the input buffer...
            ** Set up a pointer to the Extended image header for the next image
            */
            ExtImageHdr = (MPI_EXT_IMAGE_HEADER *) (ptrInputImg + FWImageHdr->NextImageHeaderOffset);
            //tmpPhysAdrs = PhysAdrs + FWImageHdr->NextImageHeaderOffset;

            do {

                switch (ExtImageHdr->ImageType) {
                    case MPI_EXT_IMAGE_TYPE_BOOTLOADER:
                        /*
                        ** bump past the extended image pointer to get to the image...
                        */
                        BootLdr_hdr.ImageAddress    = (U32 *) ExtImageHdr;   
                        //BootLdr_hdr.PhyImageAddress = tmpPhysAdrs;  
                        BootLdr_hdr.ImgLoadStrtAdrs = ExtImageHdr->LoadStartAddress;  
                        BootLdr_hdr.ImageSz         = ExtImageHdr->ImageSize;
                        logPrint("     Found a BootLoader image type.");
                        break;
                    case MPI_EXT_IMAGE_TYPE_NVDATA:
                        /*
                        ** bump past the extended image pointer to get to the image...
                        */
                        //NVData_hdr.ImageAddress    = ((U32 *) ExtImageHdr) + 6;   
                        //NVData_hdr.PhyImageAddress = tmpPhysAdrs + 0x18; // 24d  
                        //NVData_hdr.ImgLoadStrtAdrs = ExtImageHdr->LoadStartAddress;  
                        //NVData_hdr.ImageSz         = ExtImageHdr->ImageSize - 0x18; // 24d

                        NVData_hdr.ImageAddress    = (U32 *) ExtImageHdr;   
                        //NVData_hdr.PhyImageAddress = tmpPhysAdrs;  
                        NVData_hdr.ImgLoadStrtAdrs = ExtImageHdr->LoadStartAddress;  
                        NVData_hdr.ImageSz         = ExtImageHdr->ImageSize;
                        logPrint("     Found a NVData image type.");
                        logPrint("     **NVData Image Size:  0x%08x", NVData_hdr.ImageSz);
                        break;
                    default:
                        logPrint("     Found an uknown image type.");
                        return 1;
                        break;
                }

                if (ExtImageHdr->NextImageHeaderOffset) {
                    ExtImageHdr = (MPI_EXT_IMAGE_HEADER *) (ptrInputImg + ExtImageHdr->NextImageHeaderOffset);
                    //tmpPhysAdrs = PhysAdrs + ExtImageHdr->NextImageHeaderOffset;
                }
                else
                    break;
            } while ( ExtImageHdr );
        }
    }
    else
        return 1;

    //if (flag_ptr->MergeFwDflts == FALSE) {
    //    if ( !(BootLdr_hdr.ImageAddress) ){
    //        printf("\nERROR: Did not find a separate Boot Loader image!");
    //        printf("\nPress any key to continue.");
    //        getch();
    //        return 1;
    //    }
    //}

    logPrint("Leaving ParseImageFile()");

    return 0;
}







int processString (char *inputString) {

    int i=1,j=0;
    int found = FALSE;


    /*
    **  We are going to copy data while looking for an ending quote?
    */
    while (found == FALSE && i < strlen(inputString)) {

        if (inputString[i] != '\"') {

            flag_ptr->NvdataStr[j] = inputString[i];
            j++;
            i++;

        } else {

            found = TRUE;
            flag_ptr->NvdataStr[j] = '\0';
        }

    }

    if (i >= strlen(inputString)) {
        printf("\nERROR:  No tailing \" found in string: %s", inputString);
        return(FALSE);

    } 

    return(TRUE);
}





int readFile(char *name, unsigned char **outBuf, int *outLen) {

	int				 file;
	struct stat		 stat;
	unsigned char	*buf = NULL;
	int				 len;
	int				 t;

	file = open(name, O_RDONLY | O_BINARY);

	if (file < 0) {
		printf("Open failure for file %s\n", name);
		perror("Error is");
		return 0;
	}

	t = fstat(file, &stat);

	if (t < 0) {
		printf("Couldn't get size of file %s\n", name);
		perror("Error is");
		close(file);
		return 0;
	}

	len = stat.st_size;

    /*
    **  Let's stick this in buffer1
    */
	t = read(file, buffer1, len);

	if (t != len) {
		printf("Read failed for file %s\n", name);
		perror("Error is");
		free(buf);
		close(file);
		return 0;
	}

	close(file);

	*outLen = len;

	return 1;
}




void Scan(char *WWNtag, char *tracertag, char *assemblytag, int style) {
    
    int  n;
    char inputstr[45], tmpstr[45];

    WWNtag[0] = tracertag[0] = assemblytag[0] = 0;

    while (1) {

        system("clear");
        
        if (HostRunIsSASFamily(flag_ptr)) {

            if (style == 0) {                  
                printf("\n\nAssembly code: a 12-character value, entered in this format xx-xxxxx-xxx.");
                printf("  \n  Tracer code: a 10-11 character value.");
                printf("  \n  SAS Address: displayed on barcode as x-xxxx-xxxx but entered as xxxxxxxxx.");
                printf("  \n               DO NOT enter the dashes.");
                printf("\n\nData values can be entered in any order.\n\n\n");

            } else if (style == 1) {
                printf("\n\n\n  SAS Address: displayed on barcode as x-xxxx-xxxx but entered as xxxxxxxxx.");
                printf("    \n               DO NOT enter the dashes.\n\n\n");
            }
            
            if (style == 0) {

                if (assemblytag[0] == 0) {
                    printf("\nAssembly code (12 character value) ... xx-xxxxx-xxx");
                } else {
                    printf("\nAssembly code (12 character value) ... %s", assemblytag);
                }

                if (tracertag[0] == 0) {
                    printf("\nTracer code (10-11 character value) .. xxxxxxxxxx");
                } else {
                    printf("\nTracer code (10-11 character value) .. %s", tracertag);
                }
            }

            if (WWNtag[0] == 0) {
                printf("\nSAS Address (9 character value) ...... xxxxxxxxx");
            } else {
                printf("\nSAS Address (9 character value) ...... %s", WWNtag);
            }
        }
        
        if (WWNtag[0] && tracertag[0] && assemblytag[0] && style == 0) {

            if (flag_ptr->Manufacturing == FALSE) {

                printf("\n\nAre the values correct (Y/N)? ");
                n = getString(name, sizeof name, stdin);

                if ( name[0] == 'y' || name[0] == 'Y' ) {
                    printf("\n\n");
                    return;

                } else { 
                    WWNtag[0] = tracertag[0] = assemblytag[0] = 0;
                }

            } else {

                printf("\n\n");
                return;
            }

        } else if (WWNtag[0] && style == 1) {

            if (flag_ptr->Manufacturing == FALSE) {

                printf("\n\nIs ths address correct (Y/N)? ");
                n = getString(name, sizeof name, stdin);

                if ( name[0] == 'y' || name[0] == 'Y' ) {
                    printf("\n\n");
                    return;
                } else { 
                    WWNtag[0] = tracertag[0] = assemblytag[0] = 0;
                }

            } else {

                printf("\n\n");
                return;
            }

        } else {

            printf("\n\nValue: ");
            
            n = getString(inputstr, sizeof inputstr, stdin);
            stripcrlf(inputstr);
            logPrint("     Scan Length: %d", strlen(inputstr));

            if (HostRunIsSASFamily(flag_ptr)) {

                switch (strlen(inputstr)) {
                    case  9: { // Hand entered SAS Address
                        strcpy(tmpstr, SasAdrsPreFix);
                        strcat(tmpstr, inputstr);
                        strcpy(WWNtag, tmpstr);
                        break;
                    } 
                    
                    case 10:
                    case 11: { 
                        /*
                        **  This one is a little more tricky.  If there is a alpha character at the
                        **  begining it is a Tracer tag.  If there is one at the end it is a WWN Tag.
                        */
                        if ( isalpha(inputstr[0]) ) {
                            strcpy(tracertag, inputstr);
                            break;
                        } else if ( isalpha(inputstr[ (strlen(inputstr) - 1) ]) ) {
                            strcpy(tmpstr, SasAdrsPreFix);
                            inputstr[strlen(inputstr)-1] = '\0';
                            strcat(tmpstr, &inputstr[1]);
                            strcpy(WWNtag, tmpstr);
                            break;
                        } else {
                            
                            /*
                            **  We are going to assume that this is a WWN address
                            */
                            if (inputstr[0] == flag_ptr->SASAddPrefix) {
                                strcpy(tmpstr, SasAdrsPreFix);
                                strcat(tmpstr, &inputstr[1]);
                                strcpy(WWNtag, tmpstr);
                            } else {
                                printf("\a\nThe SAS address should start with: %c\n", flag_ptr->SASAddPrefix);  
                                logPrint("     SAS Address should start with:  %c", flag_ptr->SASAddPrefix);
                                //Continue_Delay(2);
                            }
                            break;
                        }
                    }

                    case 12: { strcpy(assemblytag, inputstr); 
                               //strupr(assemblytag); 
                               break; }
                    default: { printf("\aBad scan!\n");                            break; }
                } // end switch

            } // ends if (HostRunIsSASFamily(host_run_ptr))
        } // ends if (WWNtag[0] && tracertag[0] && assemblytag[0])
    } /* end while (1) */
}





int selectAdapter (int numAdapter, int commandLineSelection) {

    int       i, ValidChoice;
    MPT_PORT *port;
        
#ifdef __KERNEL_2_4__
    int       size, status, count;
    hp_host_info_t *hp_hostinfo;
#endif


    logPrint("*Entering selectAdapter()");

    ValidChoice = FALSE;

    while (ValidChoice == FALSE) {
        
        if (flag_ptr->CmdLine == TRUE) {
            
            currentPort = commandLineSelection;
            
        } else {
            
            system("clear");

            printf("\n\nLSIMPTUtil-%s ", mptutil_version);
            printf("\n\n     Port Name          Chip Vendor/Type     Firmware Rev   Current State");
            printf("\n************************************************************************\n");

            for (i = 0; i < numAdapter; i++) {

                port = mptPorts[i];
                printf("%2d.  %-16s LSILogic %-11s   ", i+1, port->portName, port->chipName);

                if (port->mptVersion == 0) {
                    printf("unknown       ");
                } else {

                    if (port->mptVersion < 0x0102) {
                        printf("%08x       ", port->fwVersion);
                    } else {
                        printf("%02x.%02x.%02x.%02x    ", 
                               port->fwVersion_new.Struct.Major, 
                               port->fwVersion_new.Struct.Minor, 
                               port->fwVersion_new.Struct.Unit,
                               port->fwVersion_new.Struct.Dev);
                    }
                }

                if ( port->currentState == (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT) ) {
                    printf("OPERATIONAL\n");
                } else if ( port->currentState == (MPI_IOC_STATE_RESET >> MPI_IOC_STATE_SHIFT) ) {
                    printf("RESET\n");
                } else if ( port->currentState == (MPI_IOC_STATE_READY >> MPI_IOC_STATE_SHIFT) ) {
                    printf("READY\n");
                } else if ( port->currentState == (MPI_IOC_STATE_FAULT >> MPI_IOC_STATE_SHIFT) ) {
                    printf("FAULT\n");
                } else {
                    printf("UNKNOWN\n");
                }
            } // ends for (i = 0; i < numAdapter; i++)

            printf("\nSelect a device:  [1-%d or 0 to quit] ", numAdapter);
            currentPort = getNumberAnswer(0, numAdapter, -1);

        } // ends if (flag_ptr->CmdLine == TRUE)

        logPrint("    Port Selected: %d", currentPort);

        /*
        **  Is this a valid choice
        */
        if (currentPort >=1 && currentPort <= numAdapter) {
            ValidChoice = TRUE;

            /*
            **  Copy over the corrct device properties for this hba
            */
            flag_ptr->DeviceProperties = mptPorts[currentPort-1]->deviceProperties;

        } else if (currentPort == 0) {
            return 0;
        }

    }  // ends while (ValidChoice == FALSE)

    /*
    **  Do we need to reset the card?
    */
    if ((flag_ptr->DiagRest == TRUE) && (gargc <= 3)) {

        doResetPort(mptPorts[currentPort-1], MPTHARDRESET);
        exit(0);

    }
    

/*
**  A host adapter not in OPERATIONAL or READY is only handeled in 2.4 kernels.
*/
#ifdef __KERNEL_2_4__

    /*
    **  If we are in any state other than OPERATIONAL or READY we need to do a FWDLB.
    */
    logPrint("    Do we need to do a FWDLB?  State:  0x%08x", mptPorts[currentPort-1]->currentState);
    count = 0;

    /*
    **  Trolling for a broking host adapter
    */
    if ((currentPort != 0) && (mptPorts[currentPort-1]->currentState == (MPI_IOC_STATE_READY >> MPI_IOC_STATE_SHIFT)) ) {

        logPrint("    Trolling for a bad host adapter ...");

        flag_ptr->Handshake = TRUE;

        /*
        **  Just a quick check to see if the host adapter is hosed up.
        */
        status = doIocInit(mptPorts[currentPort-1], MPI_WHOINIT_MANUFACTURER);
        
        logPrint("    Status from doIocInit(Trolling): 0x%04x", status);

        /*
        **  Set the state to something that will casue the FWDLB below
        */
        if (status == 0x00) {
            mptPorts[currentPort-1]->currentState = 0x0;
        }

        logPrint("    State Leaving Trolling: 0x%02x", mptPorts[currentPort-1]->currentState);
    }

    if ((currentPort != 0)                                                                             &&
        (mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_READY       >> MPI_IOC_STATE_SHIFT))  &&
        (mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT))) {

        while (mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT) && count < 3  ) {

            flag_ptr->Handshake = TRUE;

            /*
            **  We need to do a firmware download boot at this time to get the card into operational state.
            */
            doFirmwareDownloadBoot(mptPorts[currentPort-1], 1);

            /*
            **  We are going to do an IOCInit to see to try and move it into an OPERATIONAL state
            */                    
            status = doIocInit(mptPorts[currentPort-1], MPI_WHOINIT_MANUFACTURER);
            
            if (status == 0x00) {

                /*
                **  The IOCInt failed ....
                */
                count++;
                logPrint("    IOCInit FAILED after FWDLB !!!!");

            } else {

                /*
                **  We need to see if the card moved to the OPERATIONAL state.
                */
                size        = sizeof (hp_host_info_t);
                hp_hostinfo = (hp_host_info_t *)malloc(size);
                memset(hp_hostinfo, 0, size);
                hp_hostinfo->hdr.iocnum  = mptPorts[currentPort-1]->portNumber;

                /*
                **  Let's see what information we can get about all hba's in the system
                */
                status = ioctl(mptPorts[currentPort-1]->fileHandle, HP_GETHOSTINFO, hp_hostinfo);

                if (status != 0) {

                    logPrint("    HP Host Info IOCTL FAILED !!!!");
                    return 0;

                } else  {

                    if (hp_hostinfo->ioc_status == (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT)) {
                        mptPorts[currentPort-1]->currentState = (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT);
                    } else {
                        logPrint("    HP Host Still says State not OPERATIONAL !!!!");
                        count++;
                    }
                }

                free(hp_hostinfo);
            }
        } //ends while (((currentPort != 0)
        
        if (count >= 3) {

            printf("\n\nERROR:  Your host adapter is malfunctioning.");
            printf("  \nExiting the utility.");
            logPrint("     ERROR:  Your host adapter is malfunctioning(doIocInit)");

            if (mptutil) {
                closelog();
            }
            exit(1);
        } // ends if (count >= 3)
    }  //ends if ((currentPort != 0)


    /*
    **  Even if this card is in the OPERATIONAL state I need to move to a Who Init of MANUFACTURING
    */
    if (getPortInfo(mptPorts[currentPort-1]) == 1) {

        logPrint("     ***************************");
        logPrint("     Port Number ........ %d"    , mptPorts[currentPort-1]->portNumber);
        logPrint("     Port Name .......... %s"    , mptPorts[currentPort-1]->portName);
        logPrint("     Chip Name .......... %s"    , mptPorts[currentPort-1]->chipName);
        logPrint("     Device ID .......... 0x%04x", mptPorts[currentPort-1]->deviceId);                      
        logPrint("     Vendor ID .......... 0x%04x", mptPorts[currentPort-1]->vendorId);
        logPrint("     Revision ID ........ 0x%04x", mptPorts[currentPort-1]->revisionId);
        logPrint("     SubSystem VendorID . 0x%04x", mptPorts[currentPort-1]->subSystemVendorId);
        logPrint("     SubSystem ID ....... 0x%04x", mptPorts[currentPort-1]->subSystemId);
        logPrint("     Current State ...... 0x%02x", mptPorts[currentPort-1]->currentState);
        logPrint("     Who Init ........... 0x%02x", mptPorts[currentPort-1]->whoInit);
        logPrint("     Max Buses .......... 0x%02x", mptPorts[currentPort-1]->maxBuses);
        logPrint("     Max Targets ........ 0x%02x", mptPorts[currentPort-1]->maxTargets);
        logPrint("     MPT Version ........ 0x%04x", mptPorts[currentPort-1]->mptVersion);
        logPrint("     Product ID ......... 0x%04x", mptPorts[currentPort-1]->productId);
        logPrint("     FW Version ......... 0x%08x", mptPorts[currentPort-1]->fwVersion);
    } 

    /*
    **  Let's find out if we moved to OPERATIONAL state .....
    */
    size        = sizeof (hp_host_info_t);
    hp_hostinfo = (hp_host_info_t *)malloc(size);
    memset(hp_hostinfo, 0, size);
    hp_hostinfo->hdr.iocnum  = mptPorts[currentPort-1]->portNumber;

    /*
    **  Let's see what information we can get about all hba's in the system
    */
    status = ioctl(mptPorts[currentPort-1]->fileHandle, HP_GETHOSTINFO, hp_hostinfo);

    if (status == 1) {

        logPrint("    HP Host Info IOCTL FAILED !!!!");
        return 0;

    } else  {

        logPrint("=======================");
        logPrint("HP Host Info Data");
        logPrint("    Vendor: 0x%04x", hp_hostinfo->vendor);
        logPrint("    Device: 0x%04x", hp_hostinfo->device);
        logPrint("      SSVD: 0x%04x", hp_hostinfo->subsystem_vendor);
        logPrint("      SSID: 0x%04x", hp_hostinfo->subsystem_id);
        logPrint(" IOCStatus: 0x%08x", hp_hostinfo->ioc_status);

        if (hp_hostinfo->ioc_status == (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT)) {
            mptPorts[currentPort-1]->currentState = (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT);
        }
    }
    free(hp_hostinfo);

#endif


#ifdef __KERNEL_2_6__

    /*
    **  If we are in any state other than OPERATIONAL or READY we need to do a FWDLB.
    */
    logPrint("    What State:  0x%08x", mptPorts[currentPort-1]->currentState);
    if ( (currentPort != 0)                                                                            && 
         (mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_READY       >> MPI_IOC_STATE_SHIFT)) &&
         (mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT)) ) {

        /*
        **  2.6 kernel can not handle any state other than READY or OPERATIONAL
        */
        printf("\n\n The host adapter is currently in a state that is not supported");
        printf("  \n by this utility.\n\n");
        exit(1);
    }

#endif

    if ( mptPorts[currentPort-1]->currentState != (MPI_IOC_STATE_OPERATIONAL >> MPI_IOC_STATE_SHIFT) ) {
        exit(0);
    } else {
        return currentPort;
    }
}




int setConfigPageAction(MPT_PORT *port, int action, int type, int number, int address, void *page, int pageSize) {

    Config_t			 req;
	ConfigReply_t		 rep;
	ConfigPageHeader_t	 header;
	int					 length;

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	if (getConfigPageHeader(port, type, number, address, &rep) != 1) {
        return 0;
    }

	header            = rep.Header;
	length            = get16(rep.ExtPageLength);
	req.Function      = MPI_FUNCTION_CONFIG;
    req.ExtPageType	  = rep.ExtPageType;
	req.ExtPageLength = rep.ExtPageLength;
	req.Header		  = rep.Header;
	req.PageAddress	  = set32(address);

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }
    
	if (action != -1) {
		req.Action = action;
    } else if ((rep.Header.PageType & MPI_CONFIG_PAGEATTR_MASK) == MPI_CONFIG_PAGEATTR_PERSISTENT ||
               (rep.Header.PageType & MPI_CONFIG_PAGEATTR_MASK) == MPI_CONFIG_PAGEATTR_RO_PERSISTENT) {
		req.Action = MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM;
    } else {
		req.Action	= MPI_CONFIG_ACTION_PAGE_WRITE_CURRENT;
    }


	if (doMptCommand(port, &req, sizeof req - sizeof req.PageBufferSGE, &rep, sizeof rep, NULL, 0, page, pageSize, 10) != 1) {
		return 0;
    }

    logPrint("     IOCSTATUS: 0x%04x", get16(rep.IOCStatus));
	if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS) {
		return 0;
    }

	if (type > MPI_CONFIG_PAGETYPE_EXTENDED) {

		if (get16(rep.ExtPageLength) == 0)
			return 0;
/*		
        if (rep.Action != MPI_CONFIG_ACTION_PAGE_HEADER) {

            if (memcmp(&header, &rep.Header, sizeof header) != 0)
                printf("WARNING, header in HEADER reply does not match header in READ reply (%08x vs. %08x)\n", get32(*(U32 *)&header), get32(*(U32 *)&rep.Header));

            if (length != get16(rep.ExtPageLength))
                printf("WARNING, length in HEADER reply does not match length in READ reply (%d vs. %d)\n", length, get16(rep.ExtPageLength));

            if (get16(rep.ExtPageLength) != get16(((ConfigExtendedPageHeader_t *)page)->ExtPageLength))
                printf("WARNING, page length in reply does not match page length in buffer (%d vs. %d)\n", get16(rep.ExtPageLength), get16(((ConfigExtendedPageHeader_t *)page)->ExtPageLength));
        }
*/
	} else {

		if (rep.Header.PageLength == 0)
			return 0;
/*
        if (rep.Action != MPI_CONFIG_ACTION_PAGE_HEADER) {

            if (memcmp(&header, &rep.Header, sizeof header) != 0)
                printf("warning, header in HEADER reply does not match header in READ reply (%08x vs. %08x)\n", get32(*(U32 *)&header), get32(*(U32 *)&rep.Header));

            if (rep.Header.PageLength != ((ConfigPageHeader_t *)page)->PageLength)
                printf("warning, page length in reply does not match page length in buffer (%d vs. %d)\n", rep.Header.PageLength, ((ConfigPageHeader_t *)page)->PageLength);
        }
*/
	}

	return 1;
}



void stripcrlf(char *temp) {

   while ((temp[strlen(temp)-1] == 13) || (temp[strlen(temp)-1] == 10)) {

      temp[strlen(temp)-1] = 0;                                
   }
}




void ZeroGlobalMemory ( U16 clear ) {

    U32 i;

    for (i = 0; i < 131072; i++) {

        if ( (clear & 0x1) != 0 ) {
            buffer1[i] = 0;
        }

        if ( (clear & 0x2) != 0 ) {
            buffer2[i] = 0;
        }

        if ( (clear & 0x4) != 0 ) {
            buffer3[i] = 0;
        }

        if ( (clear & 0x8) != 0 ) {
            buffer4[i] = 0;
        }
    }
}

