/***************************************************************************
 *                                                                         *
 *  Copyright 2003 LSI Logic Corporation.  All rights reserved.            *
 *                                                                         *
 *  This file is confidential and a trade secret of LSI Logic.  The        *
 *  receipt of or possession of this file does not convey any rights to    *
 *  reproduce or disclose its contents or to manufacture, use, or sell     *
 *  anything it may describe, in whole, or in part, without the specific   *
 *  written consent of LSI Logic Corporation.                              *
 *                                                                         *
 ***************************************************************************
 *
 *           Name:  iopConfig.H
 *          Title:  IOP Config Header File
 *     Programmer:  Brad Besmer
 *  Creation Date:  April 14, 2003
 *
 *
 *  Version History
 *  ---------------
 *
 *  Last Updated
 *  -------------
 *  Version         %version: 0.00.08 %
 *  Date Updated    %date_modified: %
 *  Programmer      %created_by: dfrazier %
 *
 *  Date      Who   Description
 *  --------  ---   -------------------------------------------------------
 *  04/14/03  BDB   Initial version.
 *  07/13/04  dsf   Changed IOC_NUM_PERSIST_IDS_PER_PAGE values from 0x2 to 0x1.
 *
 * Description
 * ------------
 *
 *-------------------------------------------------------------------------
 */

#define IOC_NUM_PCI_FUNCTIONS     1

#ifndef IOP_CONFIG_H_INCLUDED
#define IOP_CONFIG_H_INCLUDED

/* These structures and definitions describe the data structures that implement Persistent
 * Config Pages.  This implementation is for both Flash and SeeProm.
 */
 
#define SAS_CONFIG_STRUCT_VERSION   0x0C

typedef struct _CONFIG_DIR_HEADER
{
    U32         Signature;
    U8          State;
    U8          Checksum;
    U16         TotalBytes;
    U16         SeepromVersion;             /* Seeprom only */
    U16         MpiVersion;
    U8          CdhSize;
    U8          CdeSize;
    U8          PphSize;
    U8          ProdIdSize;
    U32         NbrDirEntries;              /* # of Dir Entries */
    U32         NbrPersistDirEntries;       /* # of Dir Entries that have PERSISTENT Attribute */
    U32         SeepromFwVarsOffset;        /* Seeprom only */
    U32         SeepromBufferOffset;        /* Seeprom only */
    U32         Reserved;

} CONFIG_DIR_HEADER, *PTR_CONFIG_DIR_HEADER;

#define CONFIG_DIR_HEADER_SIGNATURE              (0x4E69636B)

#define CONFIG_DIR_HEADER_STATE_ERASED           (0xFF)
#define CONFIG_DIR_HEADER_STATE_INITIALIZATION   (CONFIG_DIR_HEADER_STATE_ERASED            & ~0x01)
#define CONFIG_DIR_HEADER_STATE_RCV_DATA         (CONFIG_DIR_HEADER_STATE_INITIALIZATION    & ~0x02)
#define CONFIG_DIR_HEADER_STATE_VALID            (CONFIG_DIR_HEADER_STATE_RCV_DATA          & ~0x04)
#define CONFIG_DIR_HEADER_STATE_XFER_COMPLETE    (CONFIG_DIR_HEADER_STATE_VALID             & ~0x08)



typedef struct _CONFIG_DIR_ENTRY
{
    U32 State               : 4;
    U32 AllocUnits          : 12;   /* Number of DWORDs */
    U32 PageType            : 8;
    U32 PageNum             : 4;
    U32 ForceNvdataUpdate   : 1;    /* When migrating NVDATA, ALWAYS use the New Data. Only used with NVDATA defaults */
    U32 PersistPageUpdated  : 1;    /* Indicates that the Persistent Page has been updated, see definitions below */
    U32 FlagRsvd1           : 1;    /* Not currently used */
    U32 FlagRsvd2           : 1;    /* Not currently used */
    U32 DwordOffset         : 15;
    U32 IocNum              : 1;
    U32 PageAddress         : 16;

} CONFIG_DIR_ENTRY, *PTR_CONFIG_DIR_ENTRY;


/*
**  Old structure ... replaced 8/9/04
*/
//typedef struct _CONFIG_DIR_ENTRY
//{
//    U32 State       : 4;
//    U32 AllocUnits  : 12;
//    U32 PageType    : 8;
//    U32 PageNum     : 8;
//    U32 DwordOffset : 15;
//    U32 IocNum      : 1;
//    U32 PageAddress : 16;
//
//} CONFIG_DIR_ENTRY, *PTR_CONFIG_DIR_ENTRY;



#define CONFIG_DIR_ENTRY_STATE_ERASED           (0xF)
#define CONFIG_DIR_ENTRY_STATE_BEGIN_UPDATE     (CONFIG_DIR_ENTRY_STATE_ERASED       & ~0x1)  /* 0xE */
#define CONFIG_DIR_ENTRY_STATE_IN_USE           (CONFIG_DIR_ENTRY_STATE_BEGIN_UPDATE & ~0x2)  /* 0xC */



typedef struct _PERSISTENT_PAGE_HEADER
{
    U8          State;
    U8          Checksum;
    U16         DwordOffset;

} PERSISTENT_PAGE_HEADER, *PTR_PERSISTENT_PAGE_HEADER;


#define CONFIG_PERSISTENT_HEADER_STATE_ERASED           (0xFF)
#define CONFIG_PERSISTENT_HEADER_STATE_BEGIN_UPATE      (CONFIG_PERSISTENT_HEADER_STATE_ERASED            & ~0x01)
#define CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE  (CONFIG_PERSISTENT_HEADER_STATE_BEGIN_UPATE       & ~0x02)
#define CONFIG_PERSISTENT_HEADER_STATE_USE_NEXT_COPY    (CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE   & ~0x04)


/* These defines describe the amount of memroy in the IOP_FLASH_MFG_INFORMATION region
 * that is allocated for the INDEX and for each of the MFG Config Pages.
 */

#define ALLOCATED_CONFIG_INDEX_SIZE                         (1024)
#define ALLOCATED_MFG_PAGE_SIZE                             (1024)

/* Number of MFG Page Indexes defined */
#define IOP_NUM_MFG_PAGE_INDEX                              (16)

/* MFG Config Index Structure. This is contained at the beginning of the
   MFG Config area. It indicates validity of the page and the offset of where
   the page begins
*/
typedef struct _MFG_CONFIG_INDEX
{
    U32 ValidSignature;

    struct
    {
        U16 PageDwordOffset;
        U8  Reserved2;
        U8  State;
    } Page[IOP_NUM_MFG_PAGE_INDEX];
} MFG_CONFIG_INDEX, *PTR_MFG_CONFIG_INDEX;

/* Unique signature indicating presence of a valid MFG_CONFIG_INDEX structure */
#define MFG_CONFIG_INDEX_VALID_SIGNATURE                    (0x42726164)

/* The MfgConfigIndex.Page[].State field starts as erased (0xff), then is updated by clearing individual bits in sequence
   to indicate how much of the data has been written.
*/

#define MFG_CONFIG_INDEX_STATE_NOT_VALID            (0xFF)
#define MFG_CONFIG_INDEX_STATE_BEGIN_PAGE_UPDATE    (MFG_CONFIG_INDEX_STATE_NOT_VALID         & ~0x01)
#define MFG_CONFIG_INDEX_STATE_UPDATE_COMPLETE      (MFG_CONFIG_INDEX_STATE_BEGIN_PAGE_UPDATE & ~0x02)

#if 0 // see definition above  np, remove this later...
/* Persistent Page Header */
typedef struct _PERSISTENT_PAGE_HEADER
{
    U8                          Checksum;
    U8                          IocNumber;
    U16                         Reserved;

} PERSISTENT_PAGE_HEADER, *PTR_PERSISTENT_PAGE_HEADER;
#endif


#if 0
/* Persistent MFG Page 2 structure */
typedef struct _PERSISTENT_MANUFACTURING_2
{
    PERSISTENT_PAGE_HEADER          PageHeader;
    IOC_CONFIG_PAGE_MFG_PAGE_2      MfgPage2;

} PERSISTENT_MANUFACTURING_2, *PTR_PERSISTENT_MANUFACTURING_2;
#endif


typedef struct _IOC_CONFIG_PAGE_MFG_PAGE_2
{
    /* First 2 values are defined by MPI */
    CONFIG_PAGE_HEADER      Header;                                 /* 00h */
    MPI_CHIP_REVISION_ID    ChipId;                                 /* 04h */

    U16                     SubSystemIDFunc0;                       /* 08h (0-1) */
    U16                     SubSystemVendorIDFunc0;                 /* 0Ah (2-3) */
    U8                      PCIMemDiagSize;                         /* 0Ch (4) */
    U8                      Reserved05;                             /* 0Dh (5) */
    U16                     SubSystemIDFunc1;                       /* 0Eh (6-7) */
    U16                     SubSystemVendorIDFunc1;                 /* 10h (8-9) */
    U8                      AutoDownloadChecksum;                   /* 12h (A) */
    U8                      Reserved0B;                             /* 13h (B) */
    U8                      VendorIDDeviceIDLock;                   /* 14h (C) */
    U8                      Reserved0D;                             /* 15h (D) */
    U16                     VendorID0;                              /* 16h (E-F) */
    U16                     DeviceID0;                              /* 18h (10-11) */
    U16                     VendorID1;                              /* 1Ah (12-13) */
    U16                     DeviceID1;                              /* 20h (14-15) */
    U8                      ClassCode0[3];                          /* 22h (16-18) */
    U8                      Reserved19;                             /* 25h (19) */
    U8                      ClassCode1[3];                          /* 26h (1A-1C) */
    U8                      Reserved1D;                             /* 29h (1D) */
    U16                     HardwareConfig;                         /* 2Ah (1E-1F) */
    U32                     OptionRomOffset0;                       /* 28h (20-23) */
    U32                     OptionRomOffset1;                       /* 2Ch (24-27) */
} IOC_CONFIG_PAGE_MFG_PAGE_2, *PTR_IOC_CONFIG_PAGE_MFG_PAGE_2;


/* 1064 only has 4 GPIOs & Phy Configurations, but we will leave some room for future */
#define IOC_MFG_PAGE3_GPIO_DEFS                             (8)
#define IOC_MFG_PAGE3_NUM_PHYS_PER_QUAD                     (4)
#define IOC_MFG_PAGE3_NUM_QUADS                             (2)

typedef struct _IOC_PHY_CONFIG          /* 20 bytes total */
{
    U32                                 GigablazeConfig[4];
    U32                                 Reserved[1];          /* Future Use */
} IOC_PHY_CONFIG, *PTR_IOC_IOC_PHY_CONFIG;

typedef struct _IOC_QUAD_CONFIG         /* 100 bytes total (20*4) + 4 + 16 */
{
    U8                                  HotPlugTimeout; /* 0=F/W Default, Timeout = 50ms * HotPlugTimeout (500ms max) */
    U8                                  MaxCmdFrames;   /* 0=F/W Default */
    U16                                 Reserved1;      /* Pad */
    U32                                 Reserved2[4];   /* Future Use */
    IOC_PHY_CONFIG                      PhyConfig[IOC_MFG_PAGE3_NUM_PHYS_PER_QUAD];
} IOC_QUAD_CONFIG, *PTR_IOC_QUAD_CONFIG;

#define IOC_MFG_PAGE_3_FLAG_FAST_SEEPROM (0x01)

/*
**  Old structure ... Removed 7/26/04 dsf
*/
//typedef struct _IOC_CONFIG_PAGE_MFG_PAGE_3
//{
//    CONFIG_PAGE_HEADER                  Header;                                            /* 00h */
//    MPI_CHIP_REVISION_ID                ChipId;                                            /* 04h */
//    U16                                 GPIODefinition[IOC_MFG_PAGE3_GPIO_DEFS];           /* 08h */
//    U8                                  FlashTime;                                         /* 18h */
//    U8                                  NVTime;                                            /* 19h */
//    U8                                  Flag;                                              /* 1Ah */
//    U8                                  Reserved1;    /* Pad */                            /* 1Bh */
//    U32                                 Reserved2[4]; /* Future Use */                     /* 1Ch */
//    IOC_QUAD_CONFIG                     QuadConfig[IOC_MFG_PAGE3_NUM_QUADS];               /* 2Ch */
//} IOC_CONFIG_PAGE_MFG_PAGE_3, *PTR_IOC_CONFIG_PAGE_MFG_PAGE_3;

typedef struct _IOC_CONFIG_PAGE_MFG_PAGE_3
{
    CONFIG_PAGE_HEADER                  Header;                                            /* 00h */
    MPI_CHIP_REVISION_ID                ChipId;                                            /* 04h */
    U16                                 GPIODefinition[IOC_MFG_PAGE3_GPIO_DEFS];           /* 08h */
    U8                                  FlashTime;                                         /* 18h */
    U8                                  NVTime;                                            /* 19h */
    U8                                  Flag;                                              /* 1Ah */
    U8                                  RuntimeConfig;                                     /* 1Bh */
    U8                                  SGPIOType;                                         /* 1Ch */
    U8                                  SGPIOFlags;                                        /* 1Dh */
    U8                                  Reserved1[2];                                      /* 1Eh */
    U32                                 Reserved2[3]; /* Future Use */                     /* 20h */
    IOC_QUAD_CONFIG                     QuadConfig[IOC_MFG_PAGE3_NUM_QUADS];               /* 2Ch */
} IOC_CONFIG_PAGE_MFG_PAGE_3, *PTR_IOC_CONFIG_PAGE_MFG_PAGE_3;


/* GPIO Defines */
#define CNFG_GPIO_OUTPUT                    (0x0001)
#define CNFG_GPIO_ACT_HI_MASK               (0x0002)
#define CNFG_GPIO_FUNCTION_MASK             (0xFFFC)
#define CNFG_GPIO_FUNCTION_SHIFT            (2)
#define CNFG_GPIO_FUNCTION_GENERAL_PURPOSE  (0x0001 << CNFG_GPIO_FUNCTION_SHIFT)


/*********************************************************
**
Defaults:
GBConfig[0]: 680000F8
GBConfig[1]: 1E1E1E1E
GBConfig[2]: 281A281A
GBConfig[3]: 28132813

HotPlugTimeout 0
MaxCmdFrames 0
FlashTime 120 (0x78)
NVTime     50 (0x32)
Flag 0
GPIO Definition: 0x6 (General Purpose Input, Active High)
**
*********************************************************/


/*  Private IR Config Page. */
typedef struct _IM_REDUCED_PHYS_DISK_0
{
    U8                          PhysDiskID;
    U8                          PhysDiskBus;
    U8                          PhysDiskIOC;
    U8                          PhysDiskNum;
    RAID_PHYS_DISK0_SETTINGS    PhysDiskSettings;
    RAID_PHYS_DISK0_STATUS      PhysDiskStatus;
    U8                          DiskIdentifier[16];
} IM_REDUCED_PHYS_DISK_0, *PTR_IM_REDUCED_PHYS_DISK_0;

//TODO these defines are normally in irDefines.h, but that file is not yet implemented
#define IR_CONFIG_MAX_PHYS_DISKS            (3)
#define IR_MAX_PHYS_DISKS                   (6)
#define IOC_IR_INVALID_TARGET_ID         (0xff)



#define IOC_DEVICE_PAGE1_DEFAULTS               (MPI_SCSIDEVPAGE1_RP_IU                    \
                                                | MPI_SCSIDEVPAGE1_RP_DT                   \
                                                | MPI_SCSIDEVPAGE1_RP_QAS                  \
                                                | (8 << 8) /* Min Sync Period */           \
                                                | (0x7F << 16) /* Max Offset */             \
                                                | MPI_SCSIDEVPAGE1_RP_WIDE                 \
                                                | MPI_SCSIDEVPAGE1_RP_AIP                  \
                                                )


#define IOC_DEVICE_PAGE_1_DEF_CONFIGURATION (MPI_SCSIDEVPAGE1_CONF_WDTR_DISALLOWED | MPI_SCSIDEVPAGE1_CONF_SDTR_DISALLOWED)




typedef struct _IM_REDUCED_VOLUME
{
    CONFIG_PAGE_RAID_VOL_0      RaidVolPage0;
    IM_REDUCED_PHYS_DISK_0      RaidPhysDisk0[IR_CONFIG_MAX_PHYS_DISKS];
} IM_REDUCED_VOLUME, *PTR_IM_REDUCED_VOLUME;


typedef struct _PRIVATE_CONFIG_PAGE_IR_0
{
    IM_REDUCED_VOLUME           ImVolume;
    U8                          ActiveVolUniqueId[16]; /* Size must be identical to METADATA_UVID_LENGTH */
} PRIVATE_CONFIG_PAGE_IR_0, *PTR_PRIVATE_CONFIG_PAGE_IR_0;


typedef struct _SAS_ADDRESS
{
    U32     High;
    U32     Low;
} SAS_ADDRESS;

typedef struct _IOC_CONFIG_PAGE_PERSISTENT_ID_ENTRY
{
    SAS_ADDRESS        SasAddress;
    U32                Reserved;
} IOC_CONFIG_PAGE_PERSISTENT_ID_ENTRY, *PTR_IOC_CONFIG_PAGE_PERSISTENT_ID_ENTRY;

#define IOC_NUM_PERSIST_IDS_PER_PAGE    (0x01)

typedef struct _IOC_CONFIG_PAGE_PERSISTENT_ID
{
    /* First 2 values are defined by MPI */
    CONFIG_EXTENDED_PAGE_HEADER            Header;                                   /* 00h */
    IOC_CONFIG_PAGE_PERSISTENT_ID_ENTRY    PersistId[IOC_NUM_PERSIST_IDS_PER_PAGE];  /* 04h */
} IOC_CONFIG_PAGE_PERSISTENT_ID, *PTR_IOC_CONFIG_PAGE_PERSISTENT_ID;



//  OLD ONE
//typedef struct _IOC_CONFIG_PAGE_PERSISTENT_ID
//{
//    /* First 2 values are defined by MPI */
//    CONFIG_EXTENDED_PAGE_HEADER Header;                             /* 00h */
//    U32 DeviceId[2];                                                /* 08h */
//} IOC_CONFIG_PAGE_PERSISTENT_ID, *PTR_IOC_CONFIG_PAGE_PERSISTENT_ID;
//

/* This page type is internal and not defined by MPI */
#define IOC_MPI_CONFIG_PAGETYPE_PERSIST_ID                  (0xEE)



/*
 * IOC_CONFIG_PAGES are the config pages that the will IOP control
 */
typedef struct _IOC_CONFIG_PAGES
{
    CONFIG_PAGE_MANUFACTURING_0         MfgPage0;
    CONFIG_PAGE_MANUFACTURING_1         MfgPage1;
    IOC_CONFIG_PAGE_MFG_PAGE_2          MfgPage2;
    IOC_CONFIG_PAGE_MFG_PAGE_3          MfgPage3;
    CONFIG_PAGE_MANUFACTURING_4         MfgPage4;
    CONFIG_PAGE_MANUFACTURING_5         MfgPage5;
    CONFIG_PAGE_MANUFACTURING_6         MfgPage6;
    CONFIG_PAGE_IO_UNIT_0               IoUnitPage0;
    CONFIG_PAGE_IO_UNIT_1               IoUnitPage1;
    CONFIG_PAGE_IO_UNIT_2               IoUnitPage2;
    CONFIG_PAGE_IO_UNIT_3               IoUnitPage3;
    CONFIG_PAGE_IO_UNIT_4               IoUnitPage4;
    CONFIG_PAGE_IOC_0                   IocPage0[IOC_NUM_PCI_FUNCTIONS];
    CONFIG_PAGE_IOC_1                   IocPage1[IOC_NUM_PCI_FUNCTIONS];
    CONFIG_PAGE_IOC_2                   IocPage2[IOC_NUM_PCI_FUNCTIONS];
    CONFIG_PAGE_IOC_3                   IocPage3[IOC_NUM_PCI_FUNCTIONS];
    CONFIG_PAGE_IOC_4                   IocPage4[IOC_NUM_PCI_FUNCTIONS];
    CONFIG_PAGE_IOC_5                   IocPage5[IOC_NUM_PCI_FUNCTIONS];

    CONFIG_PAGE_SAS_IO_UNIT_0           SasIoUnit0;
    CONFIG_PAGE_SAS_IO_UNIT_1           SasIoUnit1;
    CONFIG_PAGE_SAS_IO_UNIT_2           SasIoUnit2;
    CONFIG_PAGE_SAS_IO_UNIT_3           SasIoUnit3;
    CONFIG_PAGE_SAS_EXPANDER_0          SasExpander0;
    CONFIG_PAGE_SAS_EXPANDER_1          SasExpander1;
    CONFIG_PAGE_SAS_DEVICE_0            SasDevice0;
    CONFIG_PAGE_SAS_DEVICE_1            SasDevice1;
    CONFIG_PAGE_SAS_DEVICE_2            SasDevice2;
    CONFIG_PAGE_SAS_PHY_0               SasPhy0;
    CONFIG_PAGE_SAS_PHY_1               SasPhy1;
    CONFIG_PAGE_SAS_ENCLOSURE_0         SasEnclosure0;

    IOC_CONFIG_PAGE_PERSISTENT_ID       PersistId;

    CONFIG_PAGE_RAID_VOL_0              RaidVolPage0;
    CONFIG_PAGE_RAID_VOL_1              RaidVolPage1;
    CONFIG_PAGE_RAID_PHYS_DISK_0        RaidPhysDiskPage0;
    CONFIG_PAGE_RAID_PHYS_DISK_1        RaidPhysDiskPage1;

    CONFIG_PAGE_BIOS_1                  Bios1;
    CONFIG_PAGE_BIOS_2                  Bios2;

    CONFIG_PAGE_LOG_0                   Log0;

} IOC_CONFIG_PAGES, *PTR_IOC_CONFIG_PAGES;   


/* 
 *
 */


typedef struct _IOC_CONFIG_PAGE_ROUTER_TABLE
{
    U8  PageType;
    U8  PageNum;
    U8  PageVersion;
    U8  PageOwner;              /* who controls this page?  IOP, IR, PL */
    
    U16 PageSize;               /* in DWORDS */
    U8  FlagsIocNum;            /* combined MPI_ATTRIBUTES 7:4, internal flags 3:1, IocNum 0 */
    U8  NumInstances;           /* # of of instances of this page type, 0=256 */

    PU8 CurrPageAddr;           /* address the Current Config Page in IOC_CONFIG_PAGES */
    U32 ReadFunction;           /* call this function for Config Page reads */
    U32 WriteFunction;          /* call this function for Config Page writes */

} IOC_CONFIG_PAGE_ROUTER_TABLE, * PTR_IOC_CONFIG_PAGE_ROUTER_TABLE;



typedef struct _CONFIG_PROD_ID
{
    U32 Signature;
    U8  VendorId[8];
    U8  ProductId[16];
    U8  ProductRevision[4];
    U32 Reserved1;
    U32 Reserved2;
    U32 Reserved3;
    U32 Reserved4;
    U32 Reserved5;
    U32 Reserved6;
    U32 Reserved7;
    U32 Reserved8;

} CONFIG_PROD_ID, *PTR_CONFIG_PROD_ID;

#define CONFIG_PROD_ID_SIGNATURE              (0x4672617A)


#endif
