/***************************************************************************
 *                                                                         *
 *  Copyright 2003 LSI Logic Corporation.  All rights reserved.            *
 *                                                                         *
 *  This file is confidential and a trade secret of LSI Logic.  The        *
 *  receipt of or possession of this file does not convey any rights to    *
 *  reproduce or disclose its contents or to manufacture, use, or sell     *
 *  anything it may describe, in whole, or in part, without the specific   *
 *  written consent of LSI Logic Corporation.                              *
 *                                                                         *
 ***************************************************************************
 *
 *           Name:  imageHeader.H
 *          Title:  Header File ROMIMAGE header
 *     Programmer:
 *  Creation Date:  October 23, 2002
 *
 *
 *  Version History
 *  ---------------
 *
 *  Last Updated
 *  -------------
 *  Version         %version: 4 %
 *  Date Updated    %date_modified: %
 *  Programmer      %created_by: bbesmer %
 *
 *  Date      Who   Description
 *  --------  ---   -------------------------------------------------------
 *  10/23/02  BDB   Initial version.
 *
 *
 * Description
 * ------------
 *
 *-------------------------------------------------------------------------
 */
#ifndef IMAGE_HDR_H_INCLUDED
#define IMAGE_HDR_H_INCLUDED

/* Definition of a memory region defined in image header */
typedef struct
{
    U32 Offset;
    U32 Size;
} REGION_INFO;

/* Region definitions in image header - order dependent */
enum
{
    REGION_IOP_INST,
    REGION_IOP_DATA,
    REGION_CONTEXT_RO_RW,
    REGION_EXTMEM,
    NUM_REGIONS
};

/* Image Header */
typedef struct
{
    MPI_FW_HEADER MpiHeader;
    U32 CompressedNvsramImageSize;
    U32 UncompressedNvsramImageSize;
    REGION_INFO RegionInfo[NUM_REGIONS];
    U8 *NvsramImageLoadStartAddress;
    U8 *SeepromImageLoadStartAddress;
} IMAGE_HEADER, *PTR_IMAGE_HEADER;

#endif
