
/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  mptutil.c
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  03/31/2003
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */

/************* System Include Files ************/

#include <ctype.h> 
#include <fcntl.h>
#include <malloc.h>
#include <stdarg.h> 
#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <unistd.h>
//#include <pci/pci.h>
#include <asm/types.h>
#include <linux/byteorder/little_endian.h>

#ifdef __KERNEL_2_6__
  #include <sysfs/libsysfs.h>
#endif

/************** Custom Include Files ************/

#include "../lsi/mpi_type.h"
#include "../lsi/mpi.h"
#include "../lsi/mpi_cnfg.h"
#include "../lsi/mpi_init.h"
#include "../lsi/mpi_ioc.h"

#include "proto.h"
#include "../mptctl.h"


       

extern int  currentPort;
extern int  mptutil;
extern int  gargc; 
extern char **gargv;
extern unsigned char *buffer1;
extern unsigned char *buffer2;
extern unsigned char *buffer3;

extern FILE             *log_file; 
extern HOST_FLAG_STRUCT flag_struct;
extern HOST_FLAG_STRUCT *flag_ptr;
extern MPT_PORT         *mptPorts[MAX_SUPPORTED_ADAPTERS];
extern PTR_SAS_DEVICE    ptrSasDev;
extern PTR_SAS_DEVICE    ptrAllSasDevs;





int getCompatible(int deviceId) {

	switch (deviceId) {
	case MPI_MANUFACTPAGE_DEVID_SAS1064:  { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1064A: { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1064E: { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1066:  { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1066E: { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1068:  { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1068E: { return 1;  break; }
	case MPI_MANUFACTPAGE_DEVID_SAS1078:  { return 1;  break; }
	}

	return deviceId + 714;
}




int getConfigPage(MPT_PORT *port, int type, int number, int address, void *page, int pageSize) {
	return getConfigPageAction(port, -1, type, number, address, page, pageSize);
}


int getConfigPageAction(MPT_PORT *port, int action, int type, int number, int address, void *page, int pageSize) {

	Config_t			 req;
	ConfigReply_t		 rep;
	ConfigPageHeader_t	 header;
	int					 length;


    logPrint ("*Entering getConfigPageAction()");

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	if (getConfigPageHeader(port, type, number, address, &rep) != 1)
		return 0;

	header         = rep.Header;
	length         = get16(rep.ExtPageLength);
	req.Function   = MPI_FUNCTION_CONFIG;
    
	if (action != -1) {

		req.Action			= action;

    } else if ((rep.Header.PageType & MPI_CONFIG_PAGEATTR_MASK) == MPI_CONFIG_PAGEATTR_PERSISTENT    ||
               (rep.Header.PageType & MPI_CONFIG_PAGEATTR_MASK) == MPI_CONFIG_PAGEATTR_RO_PERSISTENT ) {

		req.Action			= MPI_CONFIG_ACTION_PAGE_READ_NVRAM;

    } else {

		req.Action			= MPI_CONFIG_ACTION_PAGE_READ_CURRENT;

    }

	req.ExtPageType   = rep.ExtPageType;
    req.ExtPageLength = rep.ExtPageLength;
	req.Header        = rep.Header;
	req.PageAddress   = set32(address);

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }
    
	if (doMptCommand(port, &req, sizeof req - sizeof req.PageBufferSGE, &rep, sizeof rep, page, pageSize, NULL, 0, 10) != 1)
		return 0;

	if (get16(rep.IOCStatus) == MPI_IOCSTATUS_CONFIG_INVALID_DATA) {

		if (action == MPI_CONFIG_ACTION_PAGE_READ_NVRAM) {

			printf("\nNon-volatile storage for this page is invalid!\n");
#if 1
			printf("The current values for this page will be used instead\n");
			req.Action = MPI_CONFIG_ACTION_PAGE_READ_NVRAM;
#else
			return 0;
#endif
		}

		if (req.Action == MPI_CONFIG_ACTION_PAGE_READ_NVRAM) {
            
            req.Action  = MPI_CONFIG_ACTION_PAGE_READ_CURRENT;

			if (doMptCommand(port, &req, sizeof req - sizeof req.PageBufferSGE, &rep, sizeof rep, page, pageSize, NULL, 0, 10) != 1)
				return 0;
		}
	} // ends if (get16(rep.IOCStatus) == MPI_IOCSTATUS_CONFIG_INVALID_DATA)


	if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS) {
		return (get16(rep.IOCStatus));
    }


	if (type > MPI_CONFIG_PAGETYPE_EXTENDED) {

		if (get16(rep.ExtPageLength) == 0)
			return 0;

		if (memcmp(&header, &rep.Header, sizeof header) != 0)
			printf("warning, header in HEADER reply does not match header in READ reply (%08x vs. %08x)\n",
				   get32(*(U32 *)&header), get32(*(U32 *)&rep.Header));
		
        if (length != get16(rep.ExtPageLength))
			printf("warning, length in HEADER reply does not match length in READ reply (%d vs. %d)\n",
				   length, get16(rep.ExtPageLength));
		
        if (get16(rep.ExtPageLength) != get16(((ConfigExtendedPageHeader_t *)page)->ExtPageLength))
			printf("warning, page length in reply does not match page length in buffer (%d vs. %d)\n",
				   get16(rep.ExtPageLength), get16(((ConfigExtendedPageHeader_t *)page)->ExtPageLength));

	} else {

		if (rep.Header.PageLength == 0)
			return 0;
		
        if (memcmp(&header, &rep.Header, sizeof header) != 0)
			printf("warning, header in HEADER reply does not match header in READ reply (%08x vs. %08x)\n",
				   get32(*(U32 *)&header), get32(*(U32 *)&rep.Header));
		
        if (rep.Header.PageLength != ((ConfigPageHeader_t *)page)->PageLength)
			printf("warning, page length in reply does not match page length in buffer (%d vs. %d)\n",
				   rep.Header.PageLength, ((ConfigPageHeader_t *)page)->PageLength);
	}


    logPrint ("*Leaving getConfigPageAction(1)");

    return (get16(rep.IOCStatus));
//	return 1;
}



int getConfigPageHeader(MPT_PORT *port, int type, int number, int address, ConfigReply_t *repOut) {

	Config_t		 req;
	ConfigReply_t	 rep;

    logPrint ("*Entering getConfigPageHeader()");

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function = MPI_FUNCTION_CONFIG;
	req.Action   = MPI_CONFIG_ACTION_PAGE_HEADER;

	if (type > MPI_CONFIG_PAGETYPE_EXTENDED) {
		req.Header.PageType	= MPI_CONFIG_PAGETYPE_EXTENDED;
		req.ExtPageType		= type;
	} else {
		req.Header.PageType	= type;
	}

    req.Header.PageNumber   = number;
    req.MsgContext          = 0x02012020;
    
    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }
    
	req.PageAddress			= set32(address);

	if (doMptCommand(port, &req, sizeof req - sizeof req.PageBufferSGE, &rep, sizeof rep, NULL, 0, NULL, 0, 10) != 1) {

        logPrint ("*Leaving getConfigPageHeader(0)");
		return 0;

    } else {

        if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS) {

            return 0;

        } else {

            if (repOut != NULL) {

                memcpy(repOut, &rep, sizeof rep);

            } // ends if (repOut != NULL)
        } // ends if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS)
    } // ends if (doMptCommand(port, &req, sizeof req - sizeof req.PageBufferSGE, &rep, sizeof rep, NULL, 0, NULL, 0, 10) != 1)

    logPrint ("*Leaving getConfigPageHeader(1)");
	return 1;
}





U8 getDeviceList (MPT_PORT *port) {

    U8                 status = 0;
    U8                 TargetDevice = 0;
    U16                DevHandle;
    U32                count = 0;       // used as a place holder
    ConfigReply_t      rep;
    SasDevicePage0_t  *configpage;
    PTR_SAS_DEVICE     ptrSasDev;       // Current device pointer 
    PTR_SAS_DEVICE     ptrLastSasDev;   // End of our list of devices
 
    logPrint("*Entering getDeviceList()");

    ptrAllSasDevs = ptrLastSasDev = NULL; /* init pointers */

    printf("\nDevices Attached:");
    printf("\n  Device Type         Address        Bus   Target ");
    printf("\n------------------------------------------------- ");
    
    /*
    **  Allocate memory
    */
	configpage = malloc(sizeof(SasDevicePage0_t));

    /*
    **  Let's read the header first to get the correct information
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE,  // type
                            0,                                  // page number
                            0,                                  // address
                            &rep) != 1) {

        printf("\nFailed to read page header -- that page might not exist\n\n");
        free(configpage);
        return 0;

    } else {
        
        /*
        **  We are going to use Get Next Handle Page Addressing on SAS Device Page 0.
        */
        while (status != MPI_IOCSTATUS_CONFIG_INVALID_PAGE) {

            if (count == 0) {
                DevHandle = 0xFFFF;
            } else {
                DevHandle = configpage->DevHandle;
            }
            count++;

            /*
            **  Read the configuration page.
            */
            status = getConfigPageAction(port,                                // adapter
                                         MPI_CONFIG_ACTION_PAGE_READ_CURRENT, // action
                                         MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE,   // type
                                         0,                                   // page number
                                         ((MPI_SAS_DEVICE_PGAD_FORM_GET_NEXT_HANDLE <<  MPI_SAS_EXPAND_PGAD_FORM_SHIFT) | DevHandle ),  // address
                                         configpage, 
                                         sizeof(SasDevicePage0_t));

            if (status == MPI_IOCSTATUS_SUCCESS) {

                /*
                **  What Type of Device is this?
                */
                if ( (configpage->DeviceInfo & 0x00000007) == 0x1) {

                    /*
                    **  We have an End Device, but is it a Target Device?
                    */
                    if ((configpage->DeviceInfo & 0x00002780)) {

                        /*
                        **  What type is it?
                        */
                        if ( (configpage->DeviceInfo & 0x00000080) ) {

                            /*
                            **  We have a SATA Target Device
                            */
                            printf("\n  SATA Device    0x%08x%08x  0x%02x   0x%02x", configpage->SASAddress.High, configpage->SASAddress.Low, configpage->Bus, configpage->TargetID);
                            TargetDevice++;
                            count++;

                        } else if ( (configpage->DeviceInfo & 0x00002000) ) {

                            /*
                            **  We have a ATAPI Target Device
                            */
                            printf("\n ATAPI Device    0x%08x%08x  0x%02x   0x%02x", configpage->SASAddress.High, configpage->SASAddress.Low, configpage->Bus, configpage->TargetID);
                            TargetDevice++;
                            count++;

                        } else {

                            /*
                            **  We have a SAS Target Device
                            */
                            printf("\n  SAS Device     0x%08x%08x  0x%02x   0x%02x", configpage->SASAddress.High, configpage->SASAddress.Low, configpage->Bus, configpage->TargetID);
                            TargetDevice++;
                            count++;

                        } //ends if ( (configpage->DeviceInfo & 0x00000080) ) {


                        /*
                        **  If this is a Target Device Let's add it to the list of devices
                        */
                        if (TargetDevice) {

                            ptrSasDev = (PTR_SAS_DEVICE)malloc(sizeof(SAS_DEVICE));

                            if(ptrSasDev == NULL) {
                                printf("\n\nMemory allocation error!\n");
                                //Continue_Delay(3);
                                return(1);
                            }

                            ptrSasDev->DevSasAdrsLo  = configpage->SASAddress.Low;
                            ptrSasDev->DevSasAdrsHi  = configpage->SASAddress.High;
                            ptrSasDev->BusNumber     = configpage->Bus;
                            ptrSasDev->TargetId      = configpage->TargetID;
                            ptrSasDev->Lun           = 0;
                            ptrSasDev->PtrNext       = NULL;

                            if(ptrLastSasDev == NULL) {
                                ptrAllSasDevs = ptrLastSasDev = ptrSasDev;
                            } else {
                                ptrLastSasDev->PtrNext = ptrSasDev;
                                ptrLastSasDev = ptrSasDev;
                            }

                            TargetDevice = 0;
                        } //ends if (TargetDevice) 
                    } //ends if ((ConfigData2->DeviceInfo & 0x00000780)) {


                } else if ((configpage->DeviceInfo & 0x00000007) == 0x2) {

                    /*
                    **  We have an Edge Expander
                    */
                    printf("\n Edge Expander   0x%08x%08x  0x%02x   0x%02x", configpage->SASAddress.High, configpage->SASAddress.Low, configpage->Bus, configpage->TargetID);

                } else if ((configpage->DeviceInfo & 0x00000007) == 0x3) {

                    /*
                    **  We have an Fanout Expander
                    */
                    printf("\nFanout Expander  0x%08x%08x  0x%02x   0x%02x", configpage->SASAddress.High, configpage->SASAddress.Low, configpage->Bus, configpage->TargetID);
                    
                } //ends if ( (configpage->DeviceInfo & 0x00000007) == 0x1) {

            } // ends if (getConfigPageAction(port,
        } // ends while (status != MPI_IOCSTATUS_CONFIG_INVALID_PAGE) {
    } // ends if (getConfigPageHeader(port,

    if (status == MPI_IOCSTATUS_CONFIG_INVALID_PAGE) {
        status = 0;
    }

    /*
    **  Did we actually find any devices?
    */
    if (count == 0) {
        status = 1;
    }

    //Continue_Delay(3);    
    logPrint("*Leaving getDeviceList( Status: %d )", status);
    free(configpage);
    return (status);
}







void getFileNames (int i ) {

    int   error, count, count2, CommaCount, Comma1, Comma2, z;
    char *fileptr;

    error = count = count2 = CommaCount = Comma1 = Comma2 = 0;

    count  = 0;
    count2 = 0;
    fileptr = gargv[i];
    logPrint("     ***************************");
    logPrint("     FileName .. %s", flag_ptr->FileName );
    logPrint("     FileName1 . %s", flag_ptr->FileName1);
    logPrint("     FileName2 . %s", flag_ptr->FileName2);
    logPrint("     Length .... %d", strlen(gargv[i]));

    /*
    **  Let's first count the number of commas in the file names.
    */
    for (z = 0; z < strlen(gargv[i]); z++){

        if (gargv[i][z] == ',') {
            CommaCount++;
            if (Comma1 == 0) {
                Comma1 = z;
            } else {
                Comma2 = z;
            }
        }
    }

    logPrint("     CommaCount: %d", CommaCount);

    /*
    **  if any of the following are TRUE I will need to reask for file names.
    **  -- if there are less than or more than 2 commas
    **  -- if the first comma occurs at the beginning [0]
    **  -- if the second comma occurs at the strlen of the string
    **  -- if the two commas are adjacent
    **
    */
    if (CommaCount != 2 ) {
        error++;

    } else if (Comma1 == 0) {
        error++;

    } else if (Comma2 == (strlen(gargv[i]) - 1)) {
        error++;
    
    } else if (Comma2 - Comma1 <= 1) {
        error++;
    }


    if (error) {

        /*
        **  We have a problem ... we will need to ask for the file names again.
        */
        printf("\n\n There is a problem with the list of files provided with the -d option.");
        printf("\n\nPlease enter the name of the firmware file: ");
        getString( flag_ptr->FileName, 256, stdin );

        printf("  \n  Please enter the name of the nvdata file: ");
        getString( flag_ptr->FileName1, 256, stdin );

        printf("  \n  Please enter the name of the output file: ");
        getString( flag_ptr->FileName2, 256, stdin );

    } else {

        /*
        **  The fist should be the firmware name
        */
        while (gargv[i][count2] != ',') {

            flag_ptr->FileName[count] = gargv[i][count2];
            count2++;
            count++;

        }

        flag_ptr->FileName[count] = '\0';
        count = 0;
        count2++;
        logPrint("     FileName .. %s", flag_ptr->FileName );

        /*
        **  The second should be the nvdata file
        */
        while (gargv[i][count2] != ',') {

            flag_ptr->FileName1[count] = gargv[i][count2];
            count2++;
            count++;

        }

        flag_ptr->FileName1[count] = '\0';
        count = 0;
        count2++;
        logPrint("     FileName1 . %s", flag_ptr->FileName1);

        /*
        **  The third should be the output file
        */
        while (gargv[i][count2] != ',' && count2 < strlen(gargv[i])) {

            flag_ptr->FileName2[count] = gargv[i][count2];
            count2++;
            count++;

        }

        flag_ptr->FileName2[count] = '\0';
        logPrint("     FileName2 . %s", flag_ptr->FileName2);

    }
}



                         

#if __KERNEL_2_6__
int getHbaPciInfo(struct mpt_ioctl_hbapciinfo *hba_pciinfop) {

	struct sysfs_class          *sclassp;
	struct sysfs_class_device   *scdevp;
	struct dlist                *lcdevp;
	struct sysfs_attribute      *sattrp;
	int				             rc=0;
	
	struct mpt_ioctl_mptpciinfo	*mpt_pciinfop;

	memset(hba_pciinfop,0,sizeof(struct mpt_ioctl_hbapciinfo));

	sclassp = sysfs_open_class("scsi_host");
	if (!sclassp) {
		fprintf(stderr, "No scsi host seems to be installed\n");
		return 1;
        }

	lcdevp = sysfs_get_class_devices(sclassp);
	if (!lcdevp) {
		fprintf(stderr, "No devices found\n");
		sysfs_close_class(sclassp);
		return 1;
	}

	mpt_pciinfop = hba_pciinfop->hbapciinfo;
	dlist_for_each_data(lcdevp, scdevp, struct sysfs_class_device) {

		/* find out if this is our scsi device */
		sattrp = sysfs_get_classdev_attr(scdevp,"proc_name");
		if(!sattrp) {
			continue;
        }

        if (flag_ptr->DriverVersion >= SPLIT_DRIVER_26) {
            if (strncmp(sattrp->value,"mptsas",6) != 0) {
                continue;
            }
        } else if (strncmp(sattrp->value,"mptscsih",8) != 0) {
			continue;
        }

		if(getMptPciInfo(mpt_pciinfop, scdevp->name)) {
			continue;
        }
              
		/* get the IOC Number for this respective controller */
		sattrp = sysfs_get_classdev_attr(scdevp,"unique_id");
		if (sattrp) {
			mpt_pciinfop->iocNumber = strtol(sattrp->value,NULL,16);
		}

		/* get controller state */
		sattrp = sysfs_get_classdev_attr(scdevp,"iocstate");
		if (sattrp) {
			mpt_pciinfop->iocState = strtol(sattrp->value,NULL,16);
		}

		mpt_pciinfop++;
		hba_pciinfop->totalIOC++;
	}

	sysfs_close_class(sclassp);
    return rc;
}
#endif


int getIocFacts(MPT_PORT *port, IOCFactsReply_t *rep) {

	IOCFacts_t	 req;

    logPrint ("*Entering getIocFacts()");

	memset(&req, 0, sizeof req );
	memset(rep,  0, sizeof *rep);

	req.Function   = MPI_FUNCTION_IOC_FACTS;

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }
    
	return doMptCommand(port, &req, sizeof req, rep, sizeof *rep, NULL, 0, NULL, 0, 10);
}





void getLineBuffer(FILE *ptrDataFile, char *ptrBuffer) {

    int   foundLine = FALSE;
    char  ptrLine[256];
    char *ptrLocalBuffer;

    if (!feof( ptrDataFile )) {

        while (foundLine == FALSE) {

            if (fgets( ptrLine, 256, ptrDataFile ) == NULL) {
                foundLine = FALSE;
                ptrBuffer = NULL;
                break;
            }
            ptrLocalBuffer = ptrLine;

            /* 
            **  blank line ... get the next one
            */
            if (strcmp( ptrLocalBuffer, "\n") == 0 || strlen(ptrLocalBuffer) == 0) {
                continue;
            }

            /* 
            **  oops ... someone entered white spaces 
            */
            while (isspace( *ptrLocalBuffer )) {
                ptrLocalBuffer++;
            }

            /* 
            ** if this line is true then it is a blank line or a comment so get the next line for processing
            */
            //if ((ptrLocalBuffer == '\0') || (ptrLocalBuffer == ';') || (ptrLocalBuffer == NULL)) {
            if (((int)*ptrLocalBuffer == '\0') || ((int)*ptrLocalBuffer == ';') || (ptrLocalBuffer == NULL)) {
                continue;
            }

            strcpy(ptrBuffer, ptrLocalBuffer);
            foundLine = TRUE;
        } // ends while (foundLine == FALSE)
    } // ends if (!feof( ptrDataFile ))
}





#if __KERNEL_2_6__
int getMptPciInfo(struct mpt_ioctl_mptpciinfo *mpt_pciinfop, char *host_number) {
    
	struct sysfs_bus        *pci_bus_handle;
	struct sysfs_driver	    *driver_handle;
	struct dlist            *device_list;
	struct sysfs_device	    *device_handle;
	struct sysfs_attribute	*sysfs_attrib;
	struct sysfs_directory  *sysfs_directory_handle;
	char                     tmp_buffer[100], tmp_path[100];
	int                      rc=0, file, t;
    unsigned char            config_data[500];
    struct stat              stat;


	pci_bus_handle = sysfs_open_bus("pci");
	if (!pci_bus_handle) {
		fprintf(stderr, "ERROR: sysfs_open_bus: failed to get handle \n");
		return 1;
        }


    if (flag_ptr->DriverVersion >= SPLIT_DRIVER_26) {
        driver_handle = sysfs_get_bus_driver(pci_bus_handle,"mptsas");
    } else {
        driver_handle = sysfs_get_bus_driver(pci_bus_handle,"mptbase");
    }

	if (!driver_handle) {

        if (flag_ptr->DriverVersion >= SPLIT_DRIVER_26) {
            fprintf(stderr, "ERROR: sysfs_get_bus_driver: failed to get handle for mptsas\n");
        } else {
            fprintf(stderr, "ERROR: sysfs_get_bus_driver: failed to get handle for mptbase\n");
        }

		rc=1;
		goto get_mpt_pci_info_out;
        }


	device_list = sysfs_get_driver_devices(driver_handle);

	if (!device_list) {

        if (flag_ptr->DriverVersion >= SPLIT_DRIVER_26) {
            fprintf(stderr, "no pci devices attached for mptsas\n");
        } else {
            fprintf(stderr, "no pci devices attached for mptbase\n");
        }

		rc=1;
		goto get_mpt_pci_info_out;
	}

	dlist_for_each_data(device_list, device_handle, struct sysfs_device) {

        sprintf(tmp_buffer,"%s/%s",device_handle->path,host_number);
		sysfs_directory_handle = sysfs_open_directory(tmp_buffer);

		if(!sysfs_directory_handle)
			continue;
		sysfs_close_directory(sysfs_directory_handle);

		sysfs_attrib = sysfs_get_device_attr(device_handle,"device");
		if (sysfs_attrib) {
			mpt_pciinfop->deviceID = strtol(sysfs_attrib->value,NULL,16);
		}
		sysfs_attrib = sysfs_get_device_attr(device_handle,"vendor");
		if (sysfs_attrib) {
			mpt_pciinfop->vendorID = strtol(sysfs_attrib->value,NULL,16);
		}
		sysfs_attrib = sysfs_get_device_attr(device_handle,"subsystem_device");
		if (sysfs_attrib) {
			mpt_pciinfop->subSystemID = strtol(sysfs_attrib->value,NULL,16);
		}
		sysfs_attrib = sysfs_get_device_attr(device_handle,"subsystem_vendor");
		if (sysfs_attrib) {
			mpt_pciinfop->subSystemVendorID = strtol(sysfs_attrib->value,NULL,16);
		}
		//sysfs_attrib = sysfs_get_device_attr(device_handle,"class");
		//if (sysfs_attrib) {
		//	mpt_pciinfop->revisionID = strtol(sysfs_attrib->value,NULL,16) & 0xFF;
		//}

        /*
        **  To get the revisionID I will need to open a different file to read it.
        */

        strcpy(tmp_path, device_handle->path);
        strcat(tmp_path, "/config");
        logPrint("    Path: %s", tmp_path);
        
        file = open(tmp_path, O_RDONLY | O_BINARY);

        if (file < 0) {
            printf("Open failure for file %s\n", tmp_path);
            perror("Error is");
            return 0;
        }

        t = fstat(file, &stat);

        if (t < 0) {
            printf("Couldn't get size of file %s\n", tmp_path);
            perror("Error is");
            close(file);
            return 0;
        }

        t = read(file, config_data, stat.st_size);
        
        if (t != stat.st_size) {
            printf("Read failed for file %s\n", tmp_path);
            perror("Error is");
            close(file);
            return 0;
        }

        mpt_pciinfop->revisionID = config_data[8];
        close(file);
	}

    get_mpt_pci_info_out:
        sysfs_close_bus(pci_bus_handle);

    return 0;
}
#endif


int getNumberAnswer(int low, int high, int defvalue) {

	char  buf[16];
	int	  i;
	int	  n;
	int	  answer;

	while (TRUE) {

		n = getString(buf, sizeof buf, stdin);

		if (n == 0)
			return defvalue;

		for (i = 0; i < n; i++)
			if (!isdigit((int)buf[i]))
				break;

		if (i == n) {

			if (sscanf(buf, "%d", &answer) == 1)
				if (answer >= low && answer <= high)
					return answer;
		}

		printf("Invalid response, try again: ");
	} // ends while (TRUE) {
}




int getNvdataString(char *PtrString, char *ptrLine ) {

    int foundEq = FALSE; 
    
    //logPrint("     Current line to process - %s", ptrLine);

    /*
    ** Parse out the Resource Name keyword value.
    ** Go til the '=' is found 
    */
    while (*ptrLine != '\0') {

        if (*ptrLine == '=') {

            foundEq = TRUE;
            
            ptrLine++;
            while (isspace(*ptrLine)) {
                ptrLine++;
            }

            /* 
            ** copy the keyword value for later processing 
            */
            strcpy(PtrString, ptrLine);

            break;
        }

        ptrLine++;
    }

    
    if (foundEq == FALSE) {
        
        printf("\n Current line to process - %s", ptrLine);
        printf("\n ERROR:  Found an error in the .dat file: %d", foundEq);

        if (flag_ptr->ManLogOpen == TRUE) {
           //fprintf(Man_PTR, "ERROR:  Found an error in the .dat file.");  daffy
        }

    }
    
    return (foundEq);
}





int getPortFacts(MPT_PORT *port, PortFactsReply_t *rep) {

	IOCFacts_t	 req;

	memset(&req, 0, sizeof req);
	memset(rep, 0, sizeof *rep);

	req.Function   = MPI_FUNCTION_PORT_FACTS;

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }

	return doMptCommand(port, &req, sizeof req, rep, sizeof *rep, NULL, 0, NULL, 0, 10);
}




int getPortInfo (MPT_PORT *port) {
    
    int               status; 
	IOCFactsReply_t	  IOCFacts;
	PortFactsReply_t  PortFacts;
	//IOCPage0_t		  IOCPage0;


    logPrint ("*Entering getPortInfo()");
    
    port->payOff = 0;

    if (getIocFacts(port, &IOCFacts) != 1) {

        return 0;

    } else {

        port->mptVersion = get16(IOCFacts.MsgVersion);
        port->productId  = get16(IOCFacts.ProductID);
        port->payOff     = get16(IOCFacts.CurReplyFrameSize);
        //port->whoInit    = IOCFacts.WhoInit;
        port->maxBuses   = IOCFacts.MaxBuses;
        port->maxTargets = IOCFacts.MaxDevices;

        if (IOCFacts.WhoInit != MPI_WHOINIT_MANUFACTURER) {
            status = doIocInit(port, MPI_WHOINIT_MANUFACTURER);

#ifdef  __KERNEL_2_6__
            if (status == 0x00) {
                
                /*
                **  Can't do anything about it ... get out
                */
                printf("\n\nERROR:  Your host adapter is malfunctioning.");
                printf("  \nExiting the utility.");
                logPrint("     ERROR:  Your host adapter is malfunctioning(doIocInit)");

                if (mptutil) {
                    closelog();
                }
                exit(1);
            }
#endif

            port->whoInit = MPI_WHOINIT_MANUFACTURER;
        }


        if (port->maxBuses == 0){
            port->maxBuses = 1;
        }

        if (port->maxTargets == 0) {
            port->maxTargets = 255;  /* Linux limit! */
        }

        if (port->mptVersion < 0x0102) {
            port->fwVersion = get16(IOCFacts.Reserved_0101_FWVersion);
        } else {
            port->fwVersion = -1;
            port->fwVersion_new.Struct.Dev   = IOCFacts.FWVersion.Struct.Dev; 
            port->fwVersion_new.Struct.Major = IOCFacts.FWVersion.Struct.Major; 
            port->fwVersion_new.Struct.Minor = IOCFacts.FWVersion.Struct.Minor; 
            port->fwVersion_new.Struct.Unit  = IOCFacts.FWVersion.Struct.Unit; 
        }


        if (getPortFacts(port, &PortFacts) != 1) {

            return 0;

        } else {

            port->portType         = PortFacts.PortType;
            port->maxPersistentIds = get16(PortFacts.MaxPersistentIDs);
            port->hostScsiId       = get16(PortFacts.PortSCSIID);

            if (port->maxTargets > get16(PortFacts.MaxDevices)) {
                port->maxTargets = get16(PortFacts.MaxDevices);
            }

            if (port->portType == MPI_PORTFACTS_PORTTYPE_FC || port->portType == MPI_PORTFACTS_PORTTYPE_SAS) {
                port->maxLuns = 32;
            }

        } // ends if (getPortFacts(port, &PortFacts) != 1)

    }  // ends if (getConfigPage(port, MPI_CONFIG_PAGETYPE_IOC, 0, 0, &IOCPage0, sizeof IOCPage0) != 1)

    logPrint ("*Leaving getPortInfo(1)");
	return 1;
}




int getString(char *buf, int len, FILE *file) {

	int	n;

	if (fgets(buf, len, file) == NULL)
		exit(0);

	buf[len - 1] = '\0';
	n = strlen(buf);

	while (n != 0   &&   (buf[n-1] == ' '   ||   buf[n-1] == '\n'))
		buf[--n] = '\0';

	return n;
}



int getWhatFromFirmware ( MPT_PORT *port ) {

	int	i,n;
    int	actualImageLen = 0;

    U8 *tmpPtr;
    U16 len;

    PCIR            *pcir;
    MpiROMHeader_t	*fwHeader;

    logPrint ("*Entering getWhatFromFirmware()");

    /*
    **  Let's get the current firmware loaded.
    */
    if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_FW_FLASH, buffer1, 0x80000, 0, &actualImageLen) != 1) {
        strcpy(flag_ptr->FirmwareWhat, "UNKNOWN");
        logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->FirmwareWhat);
        return 0;
    }

    fwHeader = (MpiROMHeader_t *)buffer1;

    for (n = 0; n < 0x20; n++) {

        flag_ptr->FirmwareWhat[n] = fwHeader->VersionName[n];
    }

    flag_ptr->FirmwareWhat[0x21] = '\0';

    /*
    **  Let's try to get the x86 what string
    */
    if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_BIOS_FLASH, buffer1, 0x80000, 0, &actualImageLen) != 1) {
        strcpy(flag_ptr->x86BIOSWhat, "UNKNOWN");
        logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->x86BIOSWhat);
        return 0;
    }

    tmpPtr = (U8 *)buffer1;
    n      = (tmpPtr[0x19]<<8) + tmpPtr[0x18];
    pcir   = (PCIR *)(tmpPtr + n);

    if (pcir->signature[0] != 'P' ||
        pcir->signature[1] != 'C' ||
        pcir->signature[2] != 'I' ||
        pcir->signature[3] != 'R') {

        logPrint("     PCIR signature is invalid.");
        strcpy(flag_ptr->x86BIOSWhat, "UNKNOWN");
        logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->x86BIOSWhat);
        return 0;

    } else if (pcir->type != 0) { // 0 is x86 BIOS

        logPrint("     Not an x86 BIOS.");
        strcpy(flag_ptr->x86BIOSWhat, "UNKNOWN");
        logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->x86BIOSWhat);
        return 0;

    } else {

        len = get16(pcir->imageLength) * 512;
        for (i = 0; i < len; i++) {
            if (buffer1[i] == '@' && buffer1[i+1] == '(' && buffer1[i+2] == '#' && buffer1[i+3] == ')') {
                break;
            }
        }

        if (i >= len) {
            logPrint("     x86 WHAT string not found.");
            strcpy(flag_ptr->x86BIOSWhat, "UNKNOWN");
            logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->x86BIOSWhat);
            return 0;
        }

        /* Get to the what string*/
        i += 4;
        for (n = 0; n < 0x20; n++) {
            flag_ptr->x86BIOSWhat[n] = buffer1[i];
            i++;
        }

        flag_ptr->x86BIOSWhat[0x21] = '\0';

    }
    

    logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->FirmwareWhat);
    logPrint ("*Leaving getWhatFromFirmware(%s)", flag_ptr->x86BIOSWhat);
	return 0;
}

