
/***************************************************************************
 *                                                                         *
 *  Copyright 2003 LSI Logic.  All rights reserved.                        *
 *                                                                         *
 *  This file is confidential and a trade secret of LSI Logic.  The        *
 *  receipt of or possession of this file does not convey any rights to    *
 *  reproduce or disclose its contents or to manufacture, use, or sell     *
 *  anything it may describe, in whole, or in part, without the specific   *
 *  written consent of LSI Logic.                                          *
 *                                                                         *
 ***************************************************************************/

/*           Name:  PARSE.H
 *          Title:
 *     Programmer:  Steve Denny 
 *  Creation Date:  December 16, 2003       
 *
 *  Version History
 *  ---------------
 *
 *    Date    Who?  Description
 *  --------  ----  -------------------------------------------------------
 *  12/16/03  SPD   Adapted for MPTUtil from NVDATA parse.h.
 *  07/13/04  dsf   Added SASMaxQDepth to enum SAS IOUnit Page 1
 *                  Changed all enum in SAS Persistent ID
 *
 *-------------------------------------------------------------------------
 *
 */

#if !defined PARSE_H
#define PARSE_H


#define MAX_ARG_LEN             16
#define MAX_KEYWORD_NAME_LEN    20
#define MAX_LINE_LEN            100
#define MAX_VPD_LEN             256
#define MAX_NVM_SIZE            2048
#define MAX_SERIAL_NO_LEN       50


/*  default to a 14 character barcode, per manufacturing request */
#define DEFAULT_TRACER_NUM_LENGTH   14

/* Define macros for correct dos errorlevel handling. This must be the opposite
 * of the SUCCESS/FAIL macros defined.
 */
#define EXIT_PASS               0
#define EXIT_FAIL               1

#define CMD_LINE_DEBUG          FALSE

/*
** Adding a #define for the SAS Nvdata start
*/                                          
#define SAS_NVDATA_START       0x4E69636B
                                          
/* define modes of NVM operation. */
typedef enum
{
    MODE_INVALID,
    MODE_MENU,
    MODE_DOWNLOAD_DAT,
    MODE_DOWNLOAD_IMG,
    MODE_UPLOAD_IMG,
    MODE_CONVERT,
    MODE_CONCAT_IMAGE,
    MODE_SHOW_IMG_DATA
} NVM_MODES;


typedef enum
{
    ARG_HELP,
    ARG_DNLD,
    ARG_UPLD,
    ARG_CONV,
    ARG_CI,
    ARG_MATCH,
    ARG_NOTEST,
    ARG_TRACERSCAN,
    ARG_TRACERKEY,
    ARG_VPD,
    ARG_SNKEY,
    ARG_PRE,
//  ARG_SHOW,
    MAX_NUM_ARGS
} CMD_LINE_ARGS;

#define CMD_LINE_ARG_STRINGS {  \
    "/?",                       \
    "/DNLD",                    \
    "/UPLD",                    \
    "/CONV",                    \
    "/CI",                      \
    "/MATCH",                   \
    "/NOTEST",                  \
    "/TRCRS",                   \
    "/TRCRK",                   \
    "/VPD",                     \
    "/K",                        \
    "/PRE"                      \
/*  "/SHOW" */                  \
};



#define MAX_FNAME_LEN   (80)
#define MAX_NUM_FNAMES  (3)
#define MAX_PRE_LEN     (4)


/* Describes what the user entered on the command line */
typedef struct _CMD_LINE_INFO
{
    char       *ArgStr[ MAX_NUM_ARGS ];
    int         Arg[ MAX_NUM_ARGS ];
    int         NumArgsFound;
    int         UsageMode;
    int         NumFileNames;
    char       *FName[ MAX_NUM_FNAMES ];
} CMD_LINE_INFO, *PTR_CMD_LINE_INFO;

extern CMD_LINE_INFO gCmdLineInfo;


/* defines a set of types to access different keyword matching code blocks,
 * which is dependent on the keywords found in the VPD input data file.
 *
 * LR_ID_STRING_TAG_TYPE acts on the format:
 *              Large Resource Type ID String Tag
 *              Length
 *              Data
 * LR_VPD_TAG_TYPE acts on the format:
 *              Large Resource Type VPD Tag
 *              Length
 * VPD_KEYWORD_TYPE acts on the format:
 *              VPD Keyword
 *              Length
 *              Data - Data can be specified in the VPD input file or it
 *                     can be the following keyword:
 *
 *                      SCAN_READ_SN - Tells NVM to prompt the user to scan
 *                                    the serial number from an item with
 *                                    a prelabeled tag.
 * SR_END_TAG_TYPE acts on the format:
 *              Small Resource Type End Tag
 */
typedef enum
{
    LR_ID_STRING_TAG_TYPE,
    LR_VPD_TAG_TYPE,
    VPD_KEYWORD_TYPE,
    SR_END_TAG_TYPE
} TAGGED_SET;


/* The identifying enumeration index value for each VPD data file keyword. */
typedef enum
{
    LR_ID_STRING_TAG,
    LR_ID_STRING_LENGTH,
    LR_ID_STRING,
    LR_VPD_TAG,
    LR_VPD_LENGTH,
    VPD_KEYWORD,
    VPD_LENGTH,
    VPD_DATA,
    SR_END_TAG

} VPD_KEYWORDS;


typedef enum
{
    SECTION_GENERAL_DATA,
    SECTION_MANUFACTURING_PAGE_0,
    SECTION_MANUFACTURING_PAGE_1,
    SECTION_IOC_MFG_PAGE_2,
    SECTION_IOC_MFG_PAGE_3,
    SECTION_MANUFACTURING_PAGE_4,
    SECTION_MANUFACTURING_PAGE_5,
    //SECTION_MANUFACTURING_PAGE_6,
    SECTION_IO_UNIT_PAGE_0,
    SECTION_IO_UNIT_PAGE_1,
    SECTION_IO_UNIT_PAGE_2,
    SECTION_IO_UNIT_PAGE_3,
    SECTION_IO_UNIT_PAGE_4,
    SECTION_IOC_PAGE_0,
    SECTION_IOC_PAGE_1,
    SECTION_IOC_PAGE_2,
    SECTION_IOC_PAGE_3,
    SECTION_IOC_PAGE_4,
    SECTION_IOC_PAGE_5,
    SECTION_SAS_IO_UNIT_0,
    SECTION_SAS_IO_UNIT_1,
    SECTION_SAS_IO_UNIT_2,
    SECTION_SAS_IO_UNIT_3,
    SECTION_SAS_EXPANDER_0,
    SECTION_SAS_EXPANDER_1,
    SECTION_SAS_DEVICE_0,
    SECTION_SAS_DEVICE_1,
    SECTION_SAS_DEVICE_2,
    SECTION_SAS_PHY_0,
    SECTION_SAS_PHY_1,
    SECTION_SAS_ENCLOSURE_0,
    SECTION_PERSISTENT_ID,
    SECTION_RAID_VOL_PAGE_0,
    SECTION_RAID_VOL_PAGE_1,
    SECTION_RAID_PHYS_DISK_PAGE_0,
    SECTION_RAID_PHYS_DISK_PAGE_1,
    SECTION_BIOS_1,
    SECTION_BIOS_2,
    SECTION_LOG_0
//    SECTION_PRIVATE_IR_PAGE
} SEEEPROM_KEYWORDS_ENUM;


typedef enum
{
    SAS_ADRS_PREFIX,
    USER_VERSION,
    NVDATA_VENDORID,
    NVDATA_PRODUCTID,
    NVDATA_PRODUCT_REVISION
} GENERAL_DATA_ENUM;


typedef enum
{
    PAGEVERSION,
    PAGELENGTH,
    PAGENUMBER,
    PAGETYPE,
    FORCEUPDATE // This really doesn't belong here, but I don't really have another place to put it.
} HEADERS_ENUM;


typedef enum
{
    PAGEVERSION2,
    PGHDR_RESERVED1,
    PAGENUMBER2,
    PAGETYPE2,
    FORCEUPDATE2, // This really doesn't belong here, but I don't really have another place to put it.
    EXTPAGELENGTH,
    EXTPAGETYPE,
    PGHDR_RESERVED2
} EXT_HEADERS_ENUM;


typedef enum
{
//    CHIPNAME=4,
    CHIPNAME=5,
    CHIPREVISION,
    BOARDNAME,
    BOARDASSEMBLY,
    BOARDTRACERNUMBER
} MANUFACTURING_PAGE_0_ENUM;


typedef enum
{
//    VPD=4
    VPD=5
} MANUFACTURING_PAGE_1_ENUM;


typedef enum
{
//    MP2_DEVICEID=4,
    MP2_DEVICEID=5,
    MP2_PCIREVISIONID,
    MP2_RESERVED,
    SSIDFUNCTION0,
    SSVIDFUNCTION0,
    PCIMEMDIAGSIZE,
    PF_RESERVED0,
    SSIDFUNCTION1,
    SSVIDFUNCTION1,
    PCIFACTORYSETTINGSCHECKSUM,
    PF_RESERVED1,
    VENDORIDDEVICEIDLOCK,
    PF_RESERVED2,
    VENDORID0,
    DEVICEID0,
    VENDORID1,
    DEVICEID1,
    SPECIFICCLASS0,
    SUBCLASS0,
    BASECLASS0,
    PF_RESERVED3,
    SPECIFICCLASS1,
    SUBCLASS1,
    BASECLASS1,
    PF_RESERVED4,
    HARDWARECONFIG,
    OPTIONROMOFFSETFUNC0,
    OPTIONROMOFFSETFUNC1
} IOC_CNFG_MFG_PAGE_2_ENUM;


typedef enum
{
//    MP3_DEVICEID=4,
    MP3_DEVICEID=5,
    MP3_PCIREVISIONID,
    MP3_RESERVED,
    MP3_GPIODEFINITION_0,
    MP3_GPIODEFINITION_1,
    MP3_GPIODEFINITION_2,
    MP3_GPIODEFINITION_3,
    MP3_GPIODEFINITION_4,
    MP3_GPIODEFINITION_5,
    MP3_GPIODEFINITION_6,
    MP3_GPIODEFINITION_7,
    FLASH_TIME,
    NVS_TIME,
    FLAG,
    RUNTIMECONFIG,
    SGPIOTYPE,
    SGPIOFLAGS,
    MP3_RESERVED1,
    MP3_RESERVED2,
    QUAD0HOTPLUGTIMEOUT,
    QUAD0MAXCMDFRAMES,
    QUAD0RESERVED1,
    QUAD0RESERVED2,
    QUAD0PHY0GBCNFG0,   
    QUAD0PHY0GBCNFG1,   
    QUAD0PHY0GBCNFG2,   
    QUAD0PHY0GBCNFG3,   
    QUAD0PHY0RESERVED1,
    QUAD0PHY1GBCNFG0,   
    QUAD0PHY1GBCNFG1,   
    QUAD0PHY1GBCNFG2,   
    QUAD0PHY1GBCNFG3,   
    QUAD0PHY1RESERVED1,
    QUAD0PHY2GBCNFG0,   
    QUAD0PHY2GBCNFG1,   
    QUAD0PHY2GBCNFG2,   
    QUAD0PHY2GBCNFG3,   
    QUAD0PHY2RESERVED1,
    QUAD0PHY3GBCNFG0,   
    QUAD0PHY3GBCNFG1,   
    QUAD0PHY3GBCNFG2,   
    QUAD0PHY3GBCNFG3,   
    QUAD0PHY3RESERVED1,
    /*********/
    QUAD1HOTPLUGTIMEOUT,
    QUAD1MAXCMDFRAMES,
    QUAD1RESERVED1,
    QUAD1RESERVED2,
    QUAD1PHY0GBCNFG0,   
    QUAD1PHY0GBCNFG1,   
    QUAD1PHY0GBCNFG2,   
    QUAD1PHY0GBCNFG3,   
    QUAD1PHY0RESERVED1,
    QUAD1PHY1GBCNFG0,   
    QUAD1PHY1GBCNFG1,   
    QUAD1PHY1GBCNFG2,   
    QUAD1PHY1GBCNFG3,   
    QUAD1PHY1RESERVED1,
    QUAD1PHY2GBCNFG0,   
    QUAD1PHY2GBCNFG1,   
    QUAD1PHY2GBCNFG2,   
    QUAD1PHY2GBCNFG3,   
    QUAD1PHY2RESERVED1,
    QUAD1PHY3GBCNFG0,   
    QUAD1PHY3GBCNFG1,   
    QUAD1PHY3GBCNFG2,   
    QUAD1PHY3GBCNFG3,   
    QUAD1PHY3RESERVED1
} IOC_CNFG_MFG_PAGE_3_ENUM;

typedef enum
{
//    MP4_RESERVED1=4,
    MP4_RESERVED1=5,
    INFOOFFSET0,
    INFOSIZE0,
    INFOOFFSET1,
    INFOSIZE1,
    INQUIRYSIZE,
    MP4_FLAGS,
    MP4_RESERVED2,
    DEVICE_TYPE,
    DEVICE_TYPE_MOD,
    VERSIONS,
    DATA_FORMAT,
    ADDITIONAL_LENGTH,
    CAPABILITY_BITS,
    VENDOR_ID,
    PRODUCT_ID,
    PRODUCT_REV,
    VENDOR_SPECIFIC,
    ISVOLUMESETTINGS,
    IMEVOLUMESETTINGS,
    IMVOLUMESETTINGS,
    IS_DATASCRUBRATE, 
    IS_RESYNCRATE,
    IME_DATASCRUBRATE,
    IME_RESYNCRATE,
    IM_DATASCRUBRATE, 
    IM_RESYNCRATE
} MANUFACTURING_PAGE_4_ENUM;


typedef enum
{
//    BASEWWIDLOW=4,
    BASEWWIDLOW=5,
    BASEWWIDHIGH,
    MANUFACT_5_FLAGS
} MANUFACTURING_PAGE_5_ENUM;


typedef enum
{
//    PRODSPECINFO=4
    PRODSPECINFO=5
} MANUFACTURING_PAGE_6_ENUM;


typedef enum
{
//    IOU0_UVALUE=4
    IOU0_UVALUE=5
} IO_UNIT_PAGE_0_ENUM;


typedef enum
{
//    IOU1_FLAGS=4
    IOU1_FLAGS=5
} IO_UNIT_PAGE_1_ENUM;


typedef enum
{
//    IOU2_FLAGS=4,
    IOU2_FLAGS=5,
    BIOSVERSION,
    PCIBUSNUMBER,
    PCIDEVICEFUNCTIONNUMBER,
    ADAPTERFLAGS
} IO_UNIT_PAGE_2_ENUM;


typedef enum
{
//    GPIOCOUNT=4,
    GPIOCOUNT=5,
    IOU3_RESERVED1,
    IOU3_RESERVED2,
    GPIOVAL_0,
    GPIOVAL_1,
    GPIOVAL_2,
    GPIOVAL_3,
    GPIOVAL_4,
    GPIOVAL_5,
    GPIOVAL_6,
    GPIOVAL_7
} IO_UNIT_PAGE_3_ENUM;


typedef enum
{   
//    IOU4_RESERVED1=4,
    IOU4_RESERVED1=5,
    FWIMAGE_FLAGS,
    FWIMAGE_64HIGH,
    FWIMAGE_64LOW
} IO_UNIT_PAGE_4_ENUM;


typedef enum
{
//    TOTALNVSTORE=4,
    TOTALNVSTORE=5,
    FREENVSTORE,
    IOC0_VENDORID,
    IOC0_DEVICEID,
    IOC0_REVISIONID,
    IOC0_RESERVED,
    IOC0_CLASSCODE,
    IOC0_SUBSYSTEMVENDORID,
    IOC0_SUBSYSTEMID
} IOC_PAGE_0_ENUM;


typedef enum
{
//    FLAGS=4,
    FLAGS=5,
    COALESCINGTIMEOUT,
    COALESCINGDEPTH,
    PCISLOTNUM,
    IOC1_RESERVED
} IOC_PAGE_1_ENUM;


typedef enum
{
//    CAPFLAGS=4,
    CAPFLAGS=5,
    NUMACTIVEVOLS,
    MAXVOLS,
    NUMACTPHYSDSKS,
    MAXPHYSDSKS,
    // RAID volume....
    VOLID,
    VOLBUS,
    VOLIOC,
    VOLPAGENUM,
    VOLTYPE,
    IOC2_FLAGS,
    IOC2_RESERVED
} IOC_PAGE_2_ENUM;


typedef enum
{
//    NUM_PHYS_DSKS=4,
    NUM_PHYS_DSKS=5,
    IOC3_RESERVED1,
    IOC3_RESERVED2,
    // Physical disk data
    PHYS_DSK_ID,
    PHYS_DSK_BUS,
    PHYS_DSK_IOC,
    PHYS_DSK_NUM
} IOC_PAGE_3_ENUM;


typedef enum
{
//    ACTIVESEP=4,
    ACTIVESEP=5,
    MAXSEP,
    IOC4_RESERVED1,
    // SEP data
    SEP_TARGET_ID,
    SEP_BUS,
    SEP_RESERVED
} IOC_PAGE_4_ENUM;


typedef enum
{
//    IOC5_RESERVED1=4,
    IOC5_RESERVED1=5,
    NUMHOTSPARES,
    IOC5_RESERVED2,
    IOC5_RESERVED3,
    // Hot Spare struct....
    PHYSDSKNUM,
    HOTSPARE_RESERVED,
    HOTSPAREPOOL,
    HOTSPARE_FLAGS
} IOC_PAGE_5_ENUM;


typedef enum
{
//    SAS0_RESERVED1=7,    // deal with extended header length
    SAS0_RESERVED1=8,    // deal with extended header length
    SAS0_NUMPHYS,
    SAS0_RESERVED2,
    SAS0_RESERVED3,
    SAS0_PORT,
    SAS0_PORTFLGS,
    SAS0_PHYFLGS,
    NEGOTLINKRATE,
    CNTLRPHYDEVINFO,
    ATTCHDDEVHNDL,
    CNTLRDEVHANDLE,
    SAS0_DISCOVERYSTATUS
} SAS_IO_UNIT_0_ENUM;


typedef enum
{
//    SAS1_CONTROLFLAGS=7,
    SAS1_CONTROLFLAGS=8,
    SAS1_MAXSATATARGETS,
    SAS1_RESERVED1,
    SAS1_NUMPHYS,
    SAS1_SATAMAXQDEPTH,
    SAS1_RESERVED2,
    SAS1PHY0_PORT,
    SAS1PHY0_PORTFLAGS,
    SAS1PHY0_PHYFLAGS,
    SAS1PHY0_MINMAXLINKRATE,
    SAS1PHY0_CNTLRPHYDEVINFO,
    SAS1PHY0_RESERVED,
    SAS1PHY1_PORT,
    SAS1PHY1_PORTFLAGS,
    SAS1PHY1_PHYFLAGS,
    SAS1PHY1_MINMAXLINKRATE,
    SAS1PHY1_CNTLRPHYDEVINFO,
    SAS1PHY1_RESERVED,
    SAS1PHY2_PORT,
    SAS1PHY2_PORTFLAGS,
    SAS1PHY2_PHYFLAGS,
    SAS1PHY2_MINMAXLINKRATE,
    SAS1PHY2_CNTLRPHYDEVINFO,
    SAS1PHY2_RESERVED,
    SAS1PHY3_PORT,
    SAS1PHY3_PORTFLAGS,
    SAS1PHY3_PHYFLAGS,
    SAS1PHY3_MINMAXLINKRATE,
    SAS1PHY3_CNTLRPHYDEVINFO,
    SAS1PHY3_RESERVED,
    SAS1PHY4_PORT,
    SAS1PHY4_PORTFLAGS,
    SAS1PHY4_PHYFLAGS,
    SAS1PHY4_MINMAXLINKRATE,
    SAS1PHY4_CNTLRPHYDEVINFO,
    SAS1PHY4_RESERVED,
    SAS1PHY5_PORT,
    SAS1PHY5_PORTFLAGS,
    SAS1PHY5_PHYFLAGS,
    SAS1PHY5_MINMAXLINKRATE,
    SAS1PHY5_CNTLRPHYDEVINFO,
    SAS1PHY5_RESERVED,
    SAS1PHY6_PORT,
    SAS1PHY6_PORTFLAGS,
    SAS1PHY6_PHYFLAGS,
    SAS1PHY6_MINMAXLINKRATE,
    SAS1PHY6_CNTLRPHYDEVINFO,
    SAS1PHY6_RESERVED,
    SAS1PHY7_PORT,
    SAS1PHY7_PORTFLAGS,
    SAS1PHY7_PHYFLAGS,
    SAS1PHY7_MINMAXLINKRATE,
    SAS1PHY7_CNTLRPHYDEVINFO,
    SAS1PHY7_RESERVED
} SAS_IO_UNIT_1_ENUM;
    
    
typedef enum
{   
//    SAS2_RESERVED1=7,
    SAS2_RESERVED1=8,
    MAXPERSISTIDS,
    NUMPERSISTIDSUSED,
    STATUS,
    SAS2_FLAGS,
    SAS2_MAXNUMPHYMAPPEDID
} SAS_IO_UNIT_2_ENUM;


typedef enum
{
//    SAS3_RESERVED1=7,
    SAS3_RESERVED1=8,
    MAXINVALIDDWRDCNT,
    INVALIDDWRDCNTTIME,
    MAXRUNNINGDISPAREERRCNT,
    RUNNINGDISPAREERRTIME,
    MAXLOSSDWRDSYNC_CNT,
    LOSSDWRDSYNCCNTTIME,
    MAXPHYRESETPROBCNT,
    PHYRESETPROBTIME
} SAS_IO_UNIT_3_ENUM;


typedef enum
{
//    SAS_EXP0_RESERVED1=7,
//    SAS_EXP0_RESERVED1=8,
    SAS_EXP0_PHYSICALPORT=8,
    SASADRSHIGH,
    SASADRSLOW,
    SAS_EXP0_DISCOVERYSTATUS,
    SAS_EXP0_DEVHNDL,
    PARENTDEVHNDL,
    EXPNDRCHGCNT,
    EXPNDRROUTEINDX,
    SAS_EXP0_NUMPHYS,
    SASLEVEL,
    SAS_EXP0_FLAGS,
    DISCOVERYSTATUS
} SAS_EXPANDER_0_ENUM;


typedef enum
{
//    SAS_EXP1_RESERVED1=7,
//    SAS_EXP1_RESERVED1=8,
    SAS_EXP1_PHYSICALPORT=8,
    SAS_EXP1_NUMPHYS,
    SAS_EXP1_PHY,
    SAS_EXP1_RESERVED2,
    SAS_EXP1_PROGLINKRATE,
    SAS_EXP1_HWLINKRATE,
    SAS_EXP1_ATCHEDDEVHNDL,
    SAS_EXP1_PHYINFO,
    SAS_EXP1_ATCHDDEVINFO,
    SAS_EXP1_OWNERDEVHNDL,
    SAS_EXP1_CHGCNT,
    SAS_EXP1_NEGLNKRATE,
    SAS_EXP1_PHYIDENT,
    SAS_EXP1_ATCHDPHYIDENT,
    SAS_EXP1_NUMTBLENTPROG,
    SAS_EXP1_DISCOVERYINFO,
    SAS_EXP1_RESERVED4
} SAS_EXPANDER_1_ENUM;



typedef enum
{
//    SAS_DEV0_RESERVED1=7,
    SAS_DEV0_SLOT=8,
    SAS_DEV0_ENCLOSURE_HANDLE,
    SAS_DEV0_SASADRSHIGH,
    SAS_DEV0_SASADRSLOW,
    SAS_DEV0_PARENTDEVHANDLE,
    SAS_DEV0_PHYNUM,
    SAS_DEV0_ACCESSSTATUS,
    SAS_DEV0_DEVHNDL,
    SAS_DEV0_TARGETID,
    SAS_DEV0_BUS,
    SAS_DEV0_DEVICEINFO,
    SAS_DEV0_FLAGS,
    SAS_DEV0_PHYSICALPORT,
    SAS_DEV0_RESERVED2
} SAS_DEVICE_0_ENUM;



typedef enum
{
//    SAS_DEV1_RESERVED1=7,
    SAS_DEV1_RESERVED1=8,
    SAS_DEV1_SASADRSHIGH,
    SAS_DEV1_SASADRSLOW,
    SAS_DEV1_RESERVED2,
    SAS_DEV1_DEVHNDL,
    SAS_DEV1_TARGETID,
    SAS_DEV1_BUS,
    SAS_DEV1_INITREGDEVICEFIS
} SAS_DEVICE_1_ENUM;


typedef enum
{
//    SAS_DEV2_PHYSICALIDHIGH=7,
    SAS_DEV2_PHYSICALIDHIGH=8,
    SAS_DEV2_PHYSICALIDLOW,
    SAS_DEV2_ENCLOSURE_MAPPING //Added 1.05.10
} SAS_DEVICE_2_ENUM;




typedef enum
{
//    SAS_PHY0_RESERVED1=7,
    SAS_PHY0_RESERVED1=8,
    SAS_PHY0_OWNER_DEV_HANDLE, //Added 1.05.10
    SAS_PHY0_SASADRSHIGH,
    SAS_PHY0_SASADRSLOW,
    SAS_PHY0_ATTCHDDEVHNDL,
    SAS_PHY0_ATTCHDPHYIDENTIFIER,
    SAS_PHY0_RESERVED2,
    SAS_PHY0_ATTCHDDEVINFO,
    SAS_PHY0_PRGMDLINKRATE,
    SAS_PHY0_HWLINKRATE,
    SAS_PHY0_CHNGCOUNT,
    SAS_PHY0_FLAGS,            //Added 1.05.10
    SAS_PHY0_PHYINFO
} SAS_PHY_0_ENUM;


typedef enum
{
//    SAS_PHY1_RESERVED1=7,
    SAS_PHY1_RESERVED1=8,
    SAS_PHY1_INVALIDDWRDCNT,
    SAS_PHY1_RUNNGDISPARITYERRCNT,
    SAS_PHY1_LOSSDWRDSYNCCNT,
    SAS_PHY1_PHYRESETPROBCNT
} SAS_PHY_1_ENUM;


typedef enum
{
//    PERSISTID_SASADDRESS_HIGH_0=7,
    PERSISTID_SASADDRESS_HIGH_0=8,
    PERSISTID_SASADDRESS_LOW_0,
    PERSISTID_RESERVED_0
} SAS_PERSIST_ID_ENUM;


typedef enum
{
//    RAID0_ALL=4
    RAID0_ALL=5
    /*
    RAID0_VOLID=4,
    RAID0_VOLBUS,
    RAID0_VOLIOC,
    RAID0_VOLTYPE,
    RAID0_VOLSTATUS,     // struct
    RAID0_VOLSETTNGS,    // struct
    RAID0_MAXLBA,
    RAID0_RESERVED1,
    RAID0_STRIPESIZ,
    RAID0_RESERVED2,
    RAID0_RESERVED3,
    RAID0_NUMPHYSDSKS,
    RAID0_RESERVED4,
    RAID0_RESERVED5,
    RAID0_PHYSDSK        // struct
    */
} RAID_VOL_0_ENUM;


typedef enum
{
//    RAID0_ALL=4
    RAIDVOL1_VOLUMEID=5,
    RAIDVOL1_VOLUMEBUS,
    RAIDVOL1_VOLUMEIOC,
    RAIDVOL1_WWID_HIGH,
    RAIDVOL1_WWID_LOW
} RAID_VOL_1_ENUM;


typedef enum
{
    //PHYS_DSK_PHYSDSKID=4,
    PHYS_DSK_PHYSDSKID=5,
    PHYS_DSK_PHYSDSKBUS,
    PHYS_DSK_PHYSDSKIOC,
    PHYS_DSK_PHYSDSKNUM,
    PHYS_DSK_PHYSDSKSETTNGS,    // struct
    PHYS_DSK_RESERVED1,
    PHYS_DSK_RESERVED2,
    PHYS_DSK_RESERVED3,
    PHYS_DSK_DSKIDENT,          // array
    PHYS_DSK_INQUIRYDATA,       // struct
    PHYS_DSK_PHYSDSKSTATUS,     // struct
    PHYS_DSK_MAXLBA,
    PHYS_DSK_ERRORDATA          // struct
} RAID_PHYS_DSK_0_ENUM;


typedef enum
{
//    PHYS_DSK_PHYSDSKID=4,
    RAIDPHYDISK1_NUMPHYSDISKPATH=5,
    RAIDPHYDISK1_PHYSDISKNUM
} RAID_PHYS_DSK_1_ENUM;



typedef enum
{
//    VOLUME_ID=4,
    VOLUME_ID=5,
    VOLUME_BUS,
    VOLUME_IOC,
    VOLUME_TYPE,
    RAID_VOL0_STATUS_FLAGS,
    RAID_VOL0_STATUS_STATE,
    RAID_VOL0_STATUS_RESERVED,
    SETTINGS,
    RAID_VOL0_SETTINGS_HOTSPAREPOOL,
    RAID_VOL0_SETTINGS_RESERVED,
    MAX_LBA,
    CONFIG_PAGE_RAID_VOL_0_RESERVED1,
    STRIPESIZE,
    CONFIG_PAGE_RAID_VOL_0_RESERVED2,
    CONFIG_PAGE_RAID_VOL_0_RESERVED3,
    NUM_PHYS_DISKS,
    CONFIG_PAGE_RAID_VOL_0_RESERVED4,
    CONFIG_PAGE_RAID_VOL_0_RESERVED5,
    RAID_VOL0_PHYS_DISK_RESERVED,
    PHYSDISKMAP,
    RAID_VOL0_PHYS_DISK_PHYSDISKNUM,
    PHYSDISKID,
    PHYSDISKBUS,
    PHYSDISKIOC,
    IM_REDUCED_PHYS_DISK_0_PHYSDISKNUM,
    SEPID,
    SEPBUS,
    RAID_PHYS_DISK0_SETTINGS_HOTSPAREPOOL,
    PHYSDISKSETTINGS,
    RAID_PHYS_DISK0_STATUS_FLAGS,
    RAID_PHYS_DISK0_STATUS_STATE,
    RAID_PHYS_DISK0_STATUS_RESERVED,
    DISKIDENTIFIER,
    PRIVATE_CONFIG_PAGE_IR_0_RESERVED
} PRIVATE_IR_PAGE_0_ENUM;


typedef enum
{
//    BIOS1_OPTIONS=4,
    BIOS1_OPTIONS=5,
    BIOS1_IOCSETTINGS,
    BIOS1_RESERVED1,
    BIOS1_DEVSETTINGS,
    BIOS1_NUMOFDEVS,
    BIOS1_RESERVED2,
    BIOS1_IOTIMOUTBLKDEVNONRM,
    BIOS1_IOTIMOUTSEQUENTIAL,
    BIOS1_IOTIMOUTOTHER,
    BIOS1_IOTIMOUTBLKDEVRM
} BIOS_1_ENUM;


typedef enum
{
//    BIOS1_OPTIONS=4,
    BIOS2_BOOTDEVICEFORM=5,
    BIOS2_SASADDRESS_HIGH,
    BIOS2_SASADDRESS_LOW,
    BIOS2_SASADDRESS_LUN
} BIOS_2_ENUM;


typedef struct _INQUIRY_DATA
{
    //UINT8   DeviceType;
    //UINT8   DeviceTypeModifier;
    //UINT8   Versions;
    //UINT8   DataFormat;
    //UINT8   AdditionalLength;
    //UINT8   Reserved[ 2 ];
    //UINT8   CapabilityBits;
    U8     DeviceType;
    U8     DeviceTypeModifier;
    U8     Versions;
    U8     DataFormat;
    U8     AdditionalLength;
    U8     Reserved[ 2 ];
    U8     CapabilityBits;
    char   VendorId[ 8 ];
    char   ProductId[ 16 ];
    char   ProductRevision[ 4 ];
    char   VendorSpecific[ 20 ];
} INQUIRY_DATA, * PTR_INQUIRY_DATA;


typedef enum
{
//    SAS_ENCLOSURE0_RESERVED1=7,
    SAS_ENC0_RESERVED1=8,
    SAS_ENC0_ENCLOSURE_LOGICAL_ID_LOW,
    SAS_ENC0_ENCLOSURE_LOGICAL_ID_HIGH,
    SAS_ENC0_FLAGS,
    SAS_ENC0_ENCLOSURE_HANDLE,
    SAS_ENC0_NUMSLOTS,
    SAS_ENC0_START_SLOT,
    SAS_ENC0_START_TARGET_ID,
    SAS_ENC0_START_BUS,
    SAS_ENC0_SEP_TARGET_ID,
    SAS_ENC0_SEP_BUS,
    SAS_ENC0_RESERVED2, 
    SAS_ENC0_RESERVED3
} SAS_ENC_0_ENUM;



typedef enum
{
    LOG0_ALL=8
} LOG_0_ENUM;











/* prototypes */
//int ConvertDatToImgMode(void);
//BOOLEAN TypeBoardTracerNumber(char *PtrSerialNumber, int Length);
//BOOLEAN ScanBoardTracerNumber(char *PtrSerialNumber, int Length);
//int nvmUsage( PTR_CMD_LINE_INFO PtrInfo );
//void CmdLineInit( PTR_CMD_LINE_INFO PtrCmdLineInfo );
//int doArgParsing(int Argc, char *Argv[], PTR_CMD_LINE_INFO PtrCmdLineInfo);
//BOOLEAN parseVPD(void);
//int  readFromScan(char *PtrSerialNumber, int Length);
//UINT DownloadImgMode( UINT numberOfChipsFound );
//void MenuMode( UINT numberOfAdaptersFound, UINT hbaWithNvm );
//UINT DownloadDatMode( UINT numberOfChipsFound );
//void UploadImgMode( UINT numberOfChipsFound );
//int  ConcatenateImgMode( void );
//void showHelp( void );
//void showHba( UINT HbaNumber, PTR_ADAPTER_TABLE PtrAdapter );
//BOOLEAN parseInputFile( void );
//UINT8 calcVPDChecksum(UINT8 *PtrData, int Length);

#endif
