
/****************************************************************************
 *  Copyright (c) 2004 LSI Logic Corporation. All rights reserved.
 *  Copyright (c) 2003 LSI Logic Corporation. All rights reserved.
 *
 *  This file is confidential and a trade secret of LSI Logic.  The receipt
 *  of or possession of this file does not convey any rights to reproduce
 *  or disclose its contents or to manufacture, use, or sell anything it
 *  may describe, in whole, or in part, without the specific written
 *  consent of LSI Logic.
 ****************************************************************************/

/*
 *           NAME:  mptutil.c
 *        SUMMARY:
 *    DESCRIPTION:
 *
 *  CREATION DATE:  03/31/2003
 *     PROGRAMMER:  Darin Frazier
 *       SEE ALSO:
 *             ID:
 */

/************* System Include Files ************/

#include <ctype.h> 
#include <fcntl.h>
#include <malloc.h>
#include <stdarg.h> 
#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <unistd.h>
//#include <pci/pci.h>
#include <asm/types.h>
#include <linux/byteorder/little_endian.h>

#ifdef __KERNEL_2_6__
#include <sysfs/libsysfs.h>
#endif

/************** Proto Types ************/
#define MPI_IO_UNIT_PAGE_3_GPIO_VAL_MAX  (8)
#define MPI_SAS_IOUNIT0_PHY_MAX          (8)
#define MPI_SAS_IOUNIT1_PHY_MAX          (MPI_SAS_IOUNIT0_PHY_MAX)

/************** Custom Include Files ************/

#include "../lsi/mpi_type.h"
#include "../lsi/mpi.h"
#include "../lsi/mpi_cnfg.h"
#include "../lsi/mpi_init.h"
#include "../lsi/mpi_ioc.h"
#include "../lsi/mpi_tool.h"

#include "proto.h"
#include "enum.h"
#include "../mptctl.h"
#include "iopcnfg.h"

       

extern int  NvDataImageLen;
extern int  currentPort;
extern int  mptutil;
extern int  gargc; 
extern char **gargv;
extern unsigned char *buffer1;
extern unsigned char *buffer2;
extern unsigned char *buffer3;
extern unsigned char *buffer4;

extern U8                   *ptrSasNvdataImage;
extern U16                   SasSeepromVersion;
extern FILE                 *log_file; 
extern FORCE_UPDATE_STRUCT   force_update_struct;
extern FORCE_UPDATE_STRUCT  *force_update_ptr;
extern HOST_FLAG_STRUCT      flag_struct;
extern HOST_FLAG_STRUCT     *flag_ptr;
extern MPT_PORT             *mptPorts[MAX_SUPPORTED_ADAPTERS];
extern PTR_IOC_CONFIG_PAGES  ptrIocConfigData;
extern PTR_SAS_DEVICE        ptrSasDev;
extern PTR_SAS_DEVICE        ptrAllSasDevs;
extern CONFIG_PROD_ID        CustomNvdata;
extern CONFIG_PROD_ID       *CustomNvdataPtr;



extern char *PtrSeeprom_Keywords[];

extern char  name[DEFAULT_FILENAME_LENGTH];






/* 
**  Notes:
**  This calculates the checksum value.
**  The checksum does not need to be seeded before calling this.
**  This does not fill in the checksum value.
*/
U8 doAutoDLChecksum( PTR_IOC_CONFIG_PAGES PtrData, int Length ) {

    int  i;             // Loop counter
    U8   checksum = 0;  // Our calculated checksum
    U8   *Data;

    /*  
    **  The 8-bit checksum is formed by adding, byte-wise, each byte
    **  contained in the data to the seed value A5h, and then taking the 2's
    **  complement (1's complement + 1) of the result"
    */
    checksum = 0xA5;
    Data = (U8 *) &PtrData->MfgPage2.SubSystemIDFunc0;

    for (i = 0; i < Length; i++, Data++) {
        checksum += *Data;
    }

    return((U8)(~checksum + 1) );
}



int doBiosFcodeDownload(MPT_PORT *port) {

    int				 d, n, error, imageLen, status;
    U8               goodFileName, goodFile;

    
    logPrint ("*Entering doBiosFcodeDownload()");

    system("clear");
    goodFileName = goodFile = 0;


    /*
    **  need to lowercase the filename if it equals NULL.
    */
    if (strcmp(flag_ptr->FileName, "UNKNOWN") != 0) {

        if (  flag_ptr->FileName[0] == 'N' &&
             (flag_ptr->FileName[1] == 'U' || flag_ptr->FileName[1] == 'u') &&
             (flag_ptr->FileName[2] == 'L' || flag_ptr->FileName[2] == 'l') &&
             (flag_ptr->FileName[3] == 'L' || flag_ptr->FileName[3] == 'l') ) {

            for (d = 0; d < 4; d++) {
                flag_ptr->FileName[d] = tolower(flag_ptr->FileName[d]);
                logPrint("    Lowered: %c", flag_ptr->FileName[d]);
            }
        }
    }

    while (goodFile == 0 && strcmp(flag_ptr->FileName, "null") != 0) {

        while (goodFileName == 0) {

            if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 ) {
               
                strcpy(name, flag_ptr->FileName);
                strcpy(flag_ptr->FileName, "UNKNOWN");

            } else {
                
                 printf("\n\nBIOS files:\n");
                 system ("ls *.rom *.ROM");
                printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_INT13_BIOS_SAS);
                n = getString(name, sizeof name, stdin);

                if ( strcmp(name, "q") == 0 || strcmp(name, "Q") == 0 ) {
                    return 9;
                } else if (n <= 0) {
                    strcpy(name, DEFAULT_INT13_BIOS_SAS);
                }
            } // ends if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 )
          
            /*
            **  This is going to open up the file and read it into a buffer.
            **  Return Values:  0 - Can't find file
            **  Return Values:  1 - Opened and Read File.
            */
            if (readFile(name, &buffer1, &imageLen) == 1) {
                goodFileName++;
            }

        } // ends while (good_file_name == FALSE)



        error = checkBiosValidity(port, (U32 *)buffer1, imageLen);

        if (error != 0 && mptutil) {

            printf("\nThere are problems with this image, continue with flashing [y/n/q]: ");
            n = getString(name, sizeof name, stdin);

            if ( strcmp(name, "n") == 0 || strcmp(name, "N") == 0 ) {

                /*
                **  Reset and try again.
                */
                goodFileName = goodFile = 0;

            } else if ( strcmp(name, "q") == 0 || strcmp(name, "Q") == 0 ) {

                return 0;

            } else {

                goodFile++;

            }

        } else if (error != 0) {

            printf("\nThere are problems with this image, please provide another. ");
            goodFileName = goodFile = 0;

        } else {

            goodFile++;

        } //ends if (error != 0 && mptutil)

    } // ends while (good_file == FALSE)

    /*
    **  Fix the option rom image.
    */
    if (strcmp(flag_ptr->FileName, "null") != 0) {
        fixupBiosFcodeImage(port, buffer1, imageLen, 1);
    } else {
        imageLen   = 1;
        buffer1[0] = 0xFF;
    }

	status = doFwDownload(port, MPI_FW_DOWNLOAD_ITYPE_BIOS, buffer1, imageLen, 0);
    
    if (status != MPI_IOCSTATUS_SUCCESS) {

        printf("\n\nERROR:  BIOS download failed with status: 0x%04x", status);
        printf("  \nPress <Enter> to continue");
        dogetch();
    }

	return status;
}




int doBiosFcodeUpload(MPT_PORT *port, unsigned char **outBuf, int *outLen, int type) {

	int				 file;
	unsigned char	*imageBuf = NULL;
	int				 imageLen;
	int				 actualImageLen;
	int				 offset;
	unsigned char	*buf;
	int				 len;
	int				 i;
	int				 n;
	PCIR			*pcir;
	int				 t;


    logPrint ("*Entering doBiosFcodeUpload()");

	if (outBuf == NULL || outLen == NULL)
		printf("Searching for BIOS and/or FCode images\n");

	imageLen = 0x80000;
	//imageLen = 0x10000;
	//imageBuf = (unsigned char *)malloc(imageLen);

	offset = 0;
	while (offset < 0x40000) {

		//if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_BIOS_FLASH, imageBuf, imageLen, offset, &actualImageLen) != 1)
        if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_BIOS_FLASH, buffer1, imageLen, offset, &actualImageLen) != 1)
			break;

		for (i = 0; i < imageLen; i += 512) {

			//buf = imageBuf + i;
			buf = buffer1 + i;

			n = (buf[0x01]<<8) + buf[0x00];

			if (n != 0xaa55)
				continue;

			n = (buf[0x19]<<8) + buf[0x18];

			if (i + n + (int)sizeof *pcir >= imageLen) {
				// not all of the image is in the buffer, so quit now and read more of the image
				break;
			}

			pcir = (PCIR *)(buf + n);

			if (pcir->signature[0] != 'P' ||
				pcir->signature[1] != 'C' ||
				pcir->signature[2] != 'I' ||
				pcir->signature[3] != 'R')  {

				continue;
			}

			len = get16(pcir->imageLength) * 512;

			if (i + len > imageLen) {

				// not all of the image is in the buffer, so quit now and read more of the image
				if (len > imageLen) {
					//free(imageBuf);
					imageLen = len;
					imageBuf = (unsigned char *)malloc(len);
				}
				break;
			}

			if (outBuf == NULL || outLen == NULL) {

				switch (pcir->type) {
				case 0:  {printf("\nEnter x86 BIOS filename: ");               break;}
				case 1:  {printf("\nEnter FCode filename: ");                  break;}
				case 3:  {printf("\nEnter EFI BIOS filename: ");               break;}
				default: {printf("\nImage type is unknown, enter filename: "); break;}
				}

				n = getString(name, sizeof name, stdin);

				if (n > 0) {
					file = open(name, O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0644);

					if (file < 0) {
						printf("Open failure for file %s\n", name);
						perror("Error is");
					}

					t = write(file, buf, len);
					if (t != len) {
						printf("Write failed for file %s, t = %x\n", name, t);
						perror("Error is");

					} else {

						printf("\nWrote %d bytes to file %s\n", len, name);
                    }

					close(file);

				} else {

					printf("Image won't be uploaded\n");
				}

			} else {

				if (pcir->type == type) {

					*outBuf = (unsigned char *)malloc(len);
					*outLen = len;
					memcpy(*outBuf, buf, len);
					free(imageBuf);
					return 1;
				}
			}

			if (pcir->indicator & 0x80) {
				// last image, so make sure we quit after this
				i += 0x40000;
			}

			i += len - 512;
		}

		offset += i;
	}

	free(imageBuf);

	return 1;
}




int doBIOSPage1 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pBIOSPage1_t pbuf; // message data
    
    logPrint("*Entering doBIOSPage1()");

    pbuf  = (pBIOSPage1_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_BIOS,  // type
                            1,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_BIOS,       // type
                                     1,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(BIOSPage1_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nBIOS Page 1 \n");
                printf("\n\ta - BIOS Options ....................... 0x%08x", pbuf->BiosOptions);
                printf("\n\tb - IOC Settings ....................... 0x%08x", pbuf->IOCSettings);
                printf("\n\td - Device Settings .................... 0x%08x", pbuf->DeviceSettings);
                printf("\n\te - Number of Devices .................. 0x%04x", pbuf->NumberOfDevices);
                printf("\n\tf - IO Timeout Block Devices (Non RM) .. 0x%04x", pbuf->IOTimeoutBlockDevicesNonRM);
                printf("\n\tg - IO Timeout Sequential .............. 0x%04x", pbuf->IOTimeoutSequential);
                printf("\n\th - IO Timeout Other ................... 0x%04x", pbuf->IOTimeoutOther);
                printf("\n\ti - IO Timeout Block Devices (RM) ...... 0x%04x", pbuf->IOTimeoutBlockDevicesRM);

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'i') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->BiosOptions = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->IOCSettings = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->DeviceSettings = strtoul(name, NULL, 16);
                            break; }
                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->NumberOfDevices = strtoul(name, NULL, 16);
                            break; }
                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->IOTimeoutBlockDevicesNonRM = strtoul(name, NULL, 16);
                            break; }
                case 'g': { getString(name, sizeof(name), stdin);  
                            pbuf->IOTimeoutSequential = strtoul(name, NULL, 16);
                            break; }
                case 'h': { getString(name, sizeof(name), stdin);  
                            pbuf->IOTimeoutOther = strtoul(name, NULL, 16);
                            break; }
                case 'i': { getString(name, sizeof(name), stdin);  
                            pbuf->IOTimeoutBlockDevicesRM = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_BIOS,  // type
                                1,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(BIOSPage1_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doBIOSPage1()");
    return 0;
}



int doBiosUpload(MPT_PORT *port) {

	int				 file;
	unsigned char	*imageBuf = NULL;
	int				 imageLen;
	int				 actualImageLen;
	int				 offset;
	int				 n;
	int				 t;


    logPrint("*Entering doBiosUpload()");

    system("clear");
	printf("\n\nEnter BIOS filename: ");
	n = getString(name, sizeof name, stdin);


	if (n > 0) {

		file = open(name, O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0644);

		if (file < 0) {
			printf("Open failure for file %s\n", name);
			perror("Error is");
			return 0;
		}
	
    } else {

		printf("Image won't be uploaded\n");
		return 1;
	}

    imageLen = GLOBAL_MEMORY_BYTES;
    //imageLen = 0x10000;
	//imageBuf = (unsigned char *)malloc(imageLen);

	offset = 0;
	while (TRUE) {

		if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_BIOS_FLASH, buffer1, imageLen, offset, &actualImageLen) != 1)
			break;

		if (offset + GLOBAL_MEMORY_BYTES > actualImageLen)
			imageLen = actualImageLen - offset;
        logPrint("            Image Length: %d", imageLen);
        logPrint("     Actual Image Length: %d", actualImageLen);

		t = write(file, buffer1, imageLen);
		
        if (t != imageLen) {
			printf("Write failed for file %s, t = %x\n", name, t);
			perror("Error is");
			break;
		}

		offset += imageLen;

		if (offset >= actualImageLen)
			break;
	}


	logPrint("     Wrote %d bytes to file %s\n", offset, name);

	close(file);

	free(imageBuf);

    logPrint("*Leaving doBiosUpload()");
	return 1;
}




int doConfigurationPage (MPT_PORT *port) {

    int    keep_running = TRUE;
    
    
    logPrint ("*Entering doConfigurationPage()");

    /*
    **  I need to send a Port Facts and Port Enable before entering .....
    */



	while (keep_running == TRUE) {

        system("clear");
		
        printf("\n\n              View/Edit Configuration Pages");
        printf("\n*****************************************************************\n");

        printf("\n\t a - Manufacturing Page 0");
        printf("\n\t b - Manufacturing Page 1");
        printf("\n\t c - Manufacturing Page 2");
        printf("\n\t d - Manufacturing Page 3");
        printf("\n\t e - Manufacturing Page 4");
        printf("\n\t f - Manufacturing Page 5");
        printf("\n\t g - IOUnit Page 1");
        printf("\n\t h - IOUnit Page 2");
        printf("\n\t i - IOUnit Page 3");
        printf("\n\t j - IOC Page 0 ------ (View Only)");
        printf("\n\t k - IOC Page 1");
        printf("\n\t l - SAS IOUnit Page 0 (View Only)");
        printf("\n\t m - SAS IOUnit Page 1");
        printf("\n\t n - SAS IOUnit Page 2");
        printf("\n\t o - SAS IOUnit Page 3");
        printf("\n\t p - PHY Page 0 ------ (View Only)");
        printf("\n\t r - PHY Page 1 ------ (View Only)");
        printf("\n\t s - BIOS Page 1");
        printf("\n\t q - Quit");


        printf("\n\nSelection:  ");
        getString( name, 256, stdin );
        
        switch (name[0]) {
        case 'a': {doManufacturingPage0(port);  break;}
        case 'b': {doManufacturingPage1(port);  break;}
        case 'c': {doManufacturingPage2(port);  break;}
        case 'd': {doManufacturingPage3(port);  break;}
        case 'e': {doManufacturingPage4(port);  break;}
        case 'f': {doManufacturingPage5(port);  break;}
        case 'g': {doIOUnitPage1(port);         break;}
        case 'h': {doIOUnitPage2(port);         break;}
        case 'i': {doIOUnitPage3(port);         break;}
        case 'j': {doIOCPage0(port);            break;}
        case 'k': {doIOCPage1(port);            break;}
        case 'l': {doSASIOUnitPage0(port);      break;}
        case 'm': {doSASIOUnitPage1(port);      break;}
        case 'n': {doSASIOUnitPage2(port);      break;}
        case 'o': {doSASIOUnitPage3(port);      break;}
        case 'p': {doPHYPage0(port);            break;}
        case 'r': {doPHYPage1(port);            break;}
        case 's': {doBIOSPage1(port);           break;}

        case 'Q': 
        case 'q': {keep_running = FALSE;        break;}                         

        }       
        
    } // ends while (TRUE)

    logPrint ("*Leaving doConfigurationPage()");
    return 0;

}




/*
**  dsf - 7/30/04
**
**  This function will display the currently loaded nvdata on the screen and will have the ablility
**  to dump the data to a binary file.
**  Action: 0 = Display
**  Action: 1 = Write Binary File
**  Actopm: 2 = Get Vendor, Product and Product Revision from the current nvdata
*/
void doDisplayNvdata ( MPT_PORT *port, U32 action ) {

    U32  *filestart, *filecurrent, filesize, i, DataCounter = 1, Offset = 0, index = 0, vertical = 1, tIndex, tCount;
    U32   image_offset, image_data;
    U8   *p;
    int   n;
    FILE *fPtr;

    logPrint("*Entering doDisplayNvdata()");

    if (action != 2) {
        system("clear");
    }

    /*
    **  Let's start by upload the firmware ....
    */
    ZeroGlobalMemory(0x8);

    /*
    **  Using global memory.
    */
    filestart = (U32 *)buffer4;

    /*
    **  Get the firmware
    */
    if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_FW_FLASH, buffer4, GLOBAL_MEMORY_BYTES, 0, &filesize) != 1) {
         ;
    }
        


    filecurrent = filestart;
    p  =  (U8 *)filecurrent;

    /*
    **  Let's see if we can find this a more intelligent way .....
    **  Offset 0x30 should have the next image ... so let's read that and see if there is an extended image attached. 
    */
    image_offset = filecurrent[0xC];  //0x30 is in bytes.

    logPrint("     Is there another image:  0x%08lx", image_offset);

    if (image_offset == 0) {

        printf("\n\n There was no Nvdata found on this host adapter.\n");
        exit(1);

    } else {

        /*
        **  Okay ... let's jump to that spot and see what type of image it is.
        */
        image_data = filecurrent[image_offset / 4];
        logPrint("       Nvdata:  0x%08lx", image_data);

        while (image_data != MPI_FW_DOWNLOAD_ITYPE_NVDATA && image_data != MPI_FW_DOWNLOAD_ITYPE_RESERVED) {

            /*
            **  Let's get the next offset
            */
            image_offset = filecurrent[(image_offset / 4) + 3];
            logPrint("  Next offset:  0x%08lx", image_offset);
            
            /*
            **  Okay ... what type of image is it?
            */
            image_data = filecurrent[image_offset / 4];
            logPrint("       Nvdata:  0x%08lx", image_data);
            
        }
        
        /*
        **  Debug
        */
        //LogPrintf("\n\t\tImage Data: 0x%08x", image_data);
        //LogPrintf("\n\t\t   Header1: 0x%08x", filecurrent[(image_offset / 4) +1]);
        //LogPrintf("\n\t\t   Header2: 0x%08x", filecurrent[(image_offset / 4) +2]);
        //LogPrintf("\n\t\t   Header3: 0x%08x", filecurrent[(image_offset / 4) +3]);
        //LogPrintf("\n\t\t   Header4: 0x%08x", filecurrent[(image_offset / 4) +4]);
        //LogPrintf("\n\t\t   Header5: 0x%08x", filecurrent[(image_offset / 4) +5]);
        //LogPrintf("\n\t\t   Header6: 0x%08x", filecurrent[(image_offset / 4) +6]);
        //LogPrintf("\n\t\t   Header7: 0x%08x", filecurrent[(image_offset / 4) +7]);
        
        if (image_data == MPI_FW_DOWNLOAD_ITYPE_NVDATA && filecurrent[(image_offset /4) + 6] == SAS_NVDATA_START) {
            
            /*
            **  Let's move to the begining of the header
            */
            index = (image_offset /4) + 6;
            logPrint("       Nvdata:  0x%08lx", image_data);
            logPrint("        Index:  0x%08lx", index);

            /*
            **  Okay ... what action do you want me to do now that we have found a good image.
            */
            if (action == 0) {

                logPrint("     Displaying Data");

                printf("\nRAW NVADATA .... \n");

                /*
                **  Let's plan on displaying 4 dwords across and 40 rows vertically till the end of file
                */
                for (i = index; i < filesize / 4; i++) {
                //for (i = index; i < filesize ; i++) {

                    if (DataCounter == 1) {
                        printf("\n\t0x%04x: ", Offset);
                        printf("0x%08x ", filecurrent[i]);
                        DataCounter++;

                    } else if (DataCounter == 4) {
                        printf("0x%08x ", filecurrent[i]);
                        DataCounter = 1;
                        vertical++;
                        Offset += 16;

                        if (vertical == 20) {
                            printf("\n\nPress Return to continue or 'q' to quit.");
                            n = getString(name, sizeof name, stdin);

                            if (name[0] == 'Q' || name[0] == 'q') {
                                break;
                            } else {

                                /*
                                **  Start the display over
                                */
                                system("clear");
                                printf("\n\nRAW NVADATA .... \n");
                                vertical = 1;
                            }

                        } // ends if (vertical == 20)

                    } else {

                        printf("0x%08x ", filecurrent[i]);
                        DataCounter++;
                    }

                } // ends for (i = index; i <= filesize; i++)

                if (i >= filesize / 4) {
                    printf("\n\nPress Return to continue.");
                    n = getString(name, sizeof name, stdin);
                }

            } else if (action == 1) {

                /*
                **  index is setup for U32 pointers ... need to change the offset to U8
                */
                index = index * 4;

                logPrint("     Writing Data ... Index: 0x%08lx", index);

                /*
                **  We need to get a file name to write to ....
                */
                printf("\n\nPlease enter the name of the output file: ");
                n = getString(name, sizeof name, stdin);
                
                /*
                ** open the output file, BINARY format 
                */
                fPtr = fopen(name,"wb");

                for (i = index; i < filesize ; i++) {
                    fprintf(fPtr, "%c", p[i] );
                }

                fclose(fPtr);



            } else if (action == 2) {
            
                /*
                **  What version of nvdata are we using?
                */
                index = index + 2;

                /*
                **  Store off the SEEPROM version of the uploaded nvdata
                */
                flag_ptr->SeepromVersion = (filecurrent[index] & 0x0000FFFF);
                
                if ( (filecurrent[index] & 0x0000FFFF) >= 0x1E00 ) {

                    index  = index + 7;

                    /*
                    **  We should have a CONFIG_PROD_ID structure here
                    */
                    if (filecurrent[index] == CONFIG_PROD_ID_SIGNATURE) {

                        index++;
                        tIndex = index * 4;
                        tCount = 0;

                        /*
                        **  Copy over the VendorID
                        */
                        for (i = tIndex; i < (tIndex + 8); i++) {
                            flag_ptr->VendorId[tCount] = p[i];
                            tCount++;
                        }


                        /*
                        **  Copy over the ProductID
                        */
                        tCount = 0;
                        tIndex += 8;
                        for (i = tIndex; i < (tIndex + 16); i++) {
                            flag_ptr->ProductId[tCount] = p[i];
                            tCount++;
                        }


                        /*
                        **  Copy over the ProductRevision
                        */
                        tCount = 0;
                        tIndex += 16;
                        for (i = tIndex; i < (tIndex + 4); i++) {
                            flag_ptr->ProductRevision[tCount] = p[i];
                            tCount++;
                        }

                        logPrint("       Vendor: %8s", flag_ptr->VendorId);
                        logPrint("      Product: %s",  flag_ptr->ProductId);
                        logPrint("     Revision: %s",  flag_ptr->ProductRevision);
                                                     
                    } else {

                        /*
                        **  Not sure what to do if the SEEPROM doesn't have a CONFIG_PROD_ID structure
                        */
                        printf("\n\nERROR:  Missing Configuration Product Signature");
                        strcpy(flag_ptr->VendorId,  "ERROR");
                        strcpy(flag_ptr->ProductId, "ERROR");

                    }

                } else {
                    
                    /*
                    **  If the SEEPROM is younger that 0x1E00 put "unknown" in
                    */
                    strcpy(flag_ptr->VendorId,  "UNKNOWN");
                    strcpy(flag_ptr->ProductId, "UNKNOWN");

                }

            } else {

                printf("\n\n\nUndefined Action for this function:  %d", action);
                exit(1);

            } // ends if (action == 0)


        } else {

            if (image_data == MPI_FW_DOWNLOAD_ITYPE_NVDATA) {

                logPrint("     NVDATA Header:  0x%08lx", filecurrent[(image_offset /4) + 6]);
                printf("\n\nInvalid Nvdata image found.\n\n");
                exit(1);
                
            } else {

                printf("\n\n There was no Nvdata found on this host adapter.\n");
                exit(1);

            } // ends if (image_data == MPI_FW_DOWNLOAD_ITYPE_NVDATA)
        } // ends if (image_data == MPI_FW_DOWNLOAD_ITYPE_NVDATA && filecurrent[(image_offset /4) + 6] == SAS_NVDATA_START])
    } // ends if (image_offset == 0) {

    logPrint("Leaving DisplayNvdata()");
}




int doFirmwareDownload(MPT_PORT *port) {

    U32              *filestart;
	int				 n, error, imageLen, goodFileName, goodFile, status;
    MpiFwHeader_t	*fwHeader;
    
    logPrint ("*Entering doFirmwareDownload()");

    error = goodFile = goodFileName = 0;
    
    system("clear");

    while (goodFile == 0) {

        while (goodFileName == 0) {

            if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 ) {
                strcpy(name, flag_ptr->FileName);
                strcpy(flag_ptr->FileName, "UNKNOWN");

            } else {

                 printf("\n\nFirmware files:\n");
                 system ("ls *.fw *.FW");
                 if (HostRunIs1064Family(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_1064);
                 } else if (HostRunIs1068Family(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_1068);
                 } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_106xE);
                 }

                 n = getString(name, sizeof name, stdin);

                 if ( strcmp(name, "q") == 0 || strcmp(name, "Q") == 0 ) {
                     return 9;

                 } else if (n <= 0) {

                     if (HostRunIs1064Family(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_1064);
                     } else if (HostRunIs1068Family(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_1068);
                     } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_106xE);
                     }
                 }
            } // ends if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 )

            /*
            **  This is going to open up the file and read it into a buffer.
            **  Return Values:  0 - Can't find file
            **  Return Values:  1 - Opened and Read File.
            */
            if (readFile(name, &buffer1, &imageLen) == 1) {
                
                goodFileName++;
            }
        } // ends while (goodFileName == 0)

        /*
        **  Let's do some checking to see if this is a good image for this HBA
        */
        filestart = (U32 *)buffer1;
        fwHeader  = (MpiFwHeader_t *)buffer1;
        logPrint("     ***************************");
        logPrint("     FileName     : %s",      name);
        logPrint("     Image Version: %s",      fwHeader->VersionName);
        logPrint("     Product ID   : 0x%04lx", fwHeader->ProductId);

        if (HostRunIs1064Family(flag_ptr)) {
            logPrint("     Chip Revsion : 0x%08lx", fwHeader->SeqCodeVersion);
        }

        logPrint("     Signature 0  : 0x%08lx", fwHeader->Signature0);
        logPrint("     Signature 1  : 0x%08lx", fwHeader->Signature1);
        logPrint("     Signature 2  : 0x%08lx", fwHeader->Signature2);
        
        error = checkFirmwareValidity(port, name, filestart);

        /*
        **  Did we have any errors?
        */
        if (error == 99) {

            /*
            ** No nvdata .... get out
            */
            return 0;
            
        } else if (error != 0 && mptutil) {

            printf("\nThere are problems with this image, continue with flashing [y/n/q]: ");
            n = getString(name, sizeof name, stdin);

            if ( strcmp(name, "n") == 0 || strcmp(name, "N") == 0 ) {

                /*
                **  Reset and try again.
                */
                goodFileName = goodFile = 0;

            } else if ( strcmp(name, "q") == 0 || strcmp(name, "Q") == 0 ) {

                return 0;

            } else {
                goodFile++;

            }

        } else if (error != 0) {

            printf("\nThere are problems with this image, please provide another. ");
            goodFileName = goodFile = 0;

        } else {

            goodFile++;

        } //ends if (error == 99)
    } // ends while (goodFile == 0)

	status = doFwDownload(port, MPI_FW_DOWNLOAD_ITYPE_FW, buffer1, imageLen, 0);

    if (status != MPI_IOCSTATUS_SUCCESS) {

        printf("\n\nERROR:  Firmware download failed with status: 0x%04x", status);
        printf("  \nPress <Enter> to continue");
        dogetch();
    }

    logPrint ("*Leaving doFirmwareDownload()");     
	return status;
}




#ifdef __KERNEL_2_4__
int doFirmwareDownloadBoot (MPT_PORT *port, U8 type) {

    U32                *filestart;
	int				    n, error, imageLen, goodFileName, goodFile, status;
    MpiFwHeader_t      *fwHeader;
	struct mpt_fw_xfer *FWDLB_IOCTL;
    
    logPrint ("*Entering doFirmwareDownloadBoot()");

    flag_ptr->doingFWDLB = TRUE;
    error = goodFile = goodFileName = 0;
    
    system("clear");

    while (goodFile == 0) {

        while (goodFileName == 0) {

            if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 ) {
                strcpy(name, flag_ptr->FileName);
                strcpy(flag_ptr->FileName, "UNKNOWN");

            } else {

                 printf("\n\nFirmware files:\n");
                 system ("ls *.fw *.FW");
                 if (HostRunIs1064Family(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_1064);
                 } else if (HostRunIs1068Family(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_1068);
                 } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                     printf("\n\nPress 'q' to quit or enter a new file name [default: %s]: ", DEFAULT_FIRMWARE_106xE);
                 }

                 n = getString(name, sizeof name, stdin);

                 if ( strcmp(name, "q") == 0 || strcmp(name, "Q") == 0 ) {
                     return 9;

                 } else if (n <= 0) {

                     if (HostRunIs1064Family(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_1064);
                     } else if (HostRunIs1068Family(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_1068);
                     } else if (HostRunIs1064EFamily(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                         strcpy(name, DEFAULT_FIRMWARE_106xE);
                     }
                 }
            } // ends if (flag_ptr->CmdLine == TRUE && strcmp("UNKNOWN", flag_ptr->FileName) != 0 )

            /*
            **  This is going to open up the file and read it into a buffer.
            **  Return Values:  0 - Can't find file
            **  Return Values:  1 - Opened and Read File.
            */
            if (readFile(name, &buffer1, &imageLen) == 1) {
                
                goodFileName++;

            }
        } // ends while (goodFileName == 0)
        
        /*
        **  Let's do some checking to see if this is a good image for this HBA
        */
        filestart = (U32 *)buffer1;
        fwHeader  = (MpiFwHeader_t *)buffer1;
        logPrint("     ***************************");
        logPrint("     FileName     : %s",      name);
        logPrint("     Image Version: %s",      fwHeader->VersionName);
        logPrint("     Product ID   : 0x%04lx", fwHeader->ProductId);

        if (HostRunIs1064Family(flag_ptr)) {
            logPrint("     Chip Revsion : 0x%08lx", fwHeader->SeqCodeVersion);
        }

        logPrint("     Signature 0  : 0x%08lx", fwHeader->Signature0);
        logPrint("     Signature 1  : 0x%08lx", fwHeader->Signature1);
        logPrint("     Signature 2  : 0x%08lx", fwHeader->Signature2);
        
        error = checkFirmwareValidity(port, name, filestart);

        /*
        **  Did we have any errors?
        */
        if (error == 99) {

            /*
            ** No nvdata .... get out
            */
            flag_ptr->doingFWDLB = FALSE;
            return 1;
            
        } else if (error != 0 && mptutil) {

            printf("\nThere are problems with this image, continue with flashing [y/n/q]: ");
            n = getString(name, sizeof name, stdin);

            if ( strcmp(name, "n") == 0 || strcmp(name, "N") == 0 ) {

                /*
                **  Reset and try again.
                */
                goodFileName = goodFile = 0;

            } else if (strcmp(name, "q") == 0 || strcmp(name, "Q") == 0) {
                flag_ptr->doingFWDLB = FALSE;
                return 1;
            } else {
                goodFile++;
            }

        } else if (error != 0) {

            printf("\nThere are problems with this image, please provide another or 'q' to quit. ");
            
            n = getString(name, sizeof name, stdin);

            if (strcmp(name, "q") == 0 || strcmp(name, "Q") == 0) {
                flag_ptr->doingFWDLB = FALSE;
                return 1;
            } else {
                goodFileName = goodFile = 0;
            }

        } else {

            goodFile++;

        } //ends if (error == 99)
    } // ends while (goodFile == 0)


	FWDLB_IOCTL = (struct mpt_fw_xfer *)malloc(sizeof *FWDLB_IOCTL);
	memset(FWDLB_IOCTL, 0, sizeof *FWDLB_IOCTL);

    FWDLB_IOCTL->iocnum = port->portNumber;
    FWDLB_IOCTL->fwlen  = imageLen;
    FWDLB_IOCTL->bufp   = buffer1;

    logPrint("         Port Number: %d", FWDLB_IOCTL->iocnum);
    logPrint("     Firmware Length: %d", FWDLB_IOCTL->fwlen);
    logPrint("      Buffer Pointer: 0x%08x", FWDLB_IOCTL->bufp);
	
    status = ioctl(port->fileHandle, MPTFWDOWNLOADBOOT, FWDLB_IOCTL);
	free(FWDLB_IOCTL);

    if (status != MPI_IOCSTATUS_SUCCESS) {

        printf("\n\nERROR:  Firmware download boot failed with status: 0x%04x", status);
        printf("  \nPress <Enter> to continue");
        dogetch();

    } else if (type == 1) {

        /*
        **  Need to do a download of the firmware to run it out of flash now.
        */
        status = doFwDownload(port, MPI_FW_DOWNLOAD_ITYPE_FW, buffer1, imageLen, 0);

        if (status != MPI_IOCSTATUS_SUCCESS) {

            printf("\n\nERROR:  Firmware download failed with status: 0x%04x", status);
            printf("  \nPress <Enter> to continue");
            dogetch();

        } else {

            doResetPort(port, MPTDIAGRESET);
        }
    }

    logPrint ("*Leaving doFirmwareDownloadBoot()");     
    flag_ptr->doingFWDLB = FALSE;
	return status;
}
#endif


void doFlashBiosFcode ( MPT_PORT *port ) {

    U8  good_filename_FCode = FALSE;
    U8  good_filename_INT13 = FALSE;
    U8  good_file_int13     = FALSE;
    U8  good_file_fcode     = FALSE;
    U8  int13_fileopen      = FALSE;
    U8  fcode_fileopen      = FALSE;
    U8  error               = 0;
    
    U32 *filestart, *filecurrent, StartAddress;

	int	imageLen  = 0;
	int	image1Len = 0;
	int	image2Len = 0;
	int	image3Len = 0;
	int	imageOff  = 0, n;
    int	t, X86len, Fcodelen, X86file, Fcodefile, status;

    char source_file_name[DEFAULT_FILENAME_LENGTH];
    char source_file_name_fcode[DEFAULT_FILENAME_LENGTH];
    
	unsigned char	*image1Buf = NULL;
	unsigned char	*image2Buf = NULL;
	unsigned char	*image3Buf = NULL;
	unsigned char	*WorkBuf   = NULL;

    struct stat		 stat;
    


    logPrint("*Entering doFlashBiosFcode()");
    logPrint("     FileName : %s", flag_ptr->FileName);
    logPrint("     Filename1: %s", flag_ptr->FileName1);

    system("clear");
    
    source_file_name[0]       = '\0';
    source_file_name_fcode[0] = '\0';
    


    while (good_file_int13 == FALSE || good_file_fcode == FALSE) {

        /*
        **  Let's get the filename for the INT13 BIOS
        */
        while (good_filename_INT13 == FALSE || int13_fileopen == FALSE) {

            if (good_filename_INT13 == FALSE) {

                /*
                **  Are we in a manufacturing environment?
                */
                if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0 && flag_ptr->ManLogOpen == TRUE) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        strcpy(source_file_name, DEFAULT_INT13_BIOS_SAS);
                    }

                /*
                **  Do we need to ask for the filename?
                */
                } else if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0) {
                    
                    if (HostRunIsSASFamily(flag_ptr)) {
                        printf("\n\nEnter name of BIOS (default: %s):  ", DEFAULT_INT13_BIOS_SAS);
                        n = getString(source_file_name, sizeof source_file_name, stdin);
                    }

                    /*
                    **  Did they just hit return?
                    */
                    if(strlen(source_file_name) == 0) {
                        if (HostRunIsSASFamily(flag_ptr)) {
                            strcpy(source_file_name, DEFAULT_INT13_BIOS_SAS);
                        }
                    }

                /*
                **  Must be waiting on us
                */
                } else {

                    strcpy(source_file_name, flag_ptr->FileName);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                }
            } // ends if (good_filename_INT13 == FALSE)

            /*
            **  Can we open the file?
            */
            X86file = open(source_file_name, O_RDONLY | O_BINARY);

            if (X86file < 0) {
                printf("Open failure for file %s\n", source_file_name);
                perror("Error is");

                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");
                n = getString(name, sizeof name, stdin);

                if((name[0] == 'q') || (name[0] == 'Q')) {
                    return;
                } else {
                    source_file_name[0] = '\0';
                    printf("\n\n");
                }

            } else {

                good_filename_INT13 = TRUE;
                int13_fileopen      = TRUE;
                
                t = fstat(X86file, &stat);

                if (t < 0) {
                    printf("Couldn't get size of file %s\n", source_file_name);
                    perror("Error is");
                    int13_fileopen = FALSE;
                    close(X86file);
                } else {
                    X86len = stat.st_size;
                }
            } // ends if (X86file < 0)
        } // ends while (good_filename_INT13 == FALSE)


        

        /*
        **  Let's get the filename for the FCode
        */
        while (good_filename_FCode == FALSE || fcode_fileopen == FALSE) {

            if (good_filename_FCode == FALSE) {
                /*
                **  Are we in a manufacturing environment?
                */
                if (strcmp(flag_ptr->FileName1, "UNKNOWN") == 0 && flag_ptr->ManLogOpen == TRUE) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        strcpy(source_file_name_fcode, DEFAULT_FCODE_BIOS_SAS);
                    }

                /*
                **  Do we need to ask for the filename?
                */
                } else if (strcmp(flag_ptr->FileName1, "UNKNOWN") == 0) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        printf("\n\nEnter name of FCode (default: %s):  ", DEFAULT_FCODE_BIOS_SAS);
                        n = getString(source_file_name_fcode, sizeof source_file_name_fcode, stdin);
                    }

                    /*
                    **  Did they just hit return?
                    */
                    if(strlen(source_file_name_fcode) == 0) {
                        
                        if (HostRunIsSASFamily(flag_ptr)) {
                            strcpy(source_file_name_fcode, DEFAULT_FCODE_BIOS_SAS);
                        }
                    }

                /*
                **  Must be waiting on us
                */
                } else {

                    strcpy(source_file_name_fcode , flag_ptr->FileName1);
                    strcpy(flag_ptr->FileName1, "UNKNOWN");
                }
            } // ends if (good_filename_FCode == FALSE)

            /*
            **  Let's see if we can open it
            */
            Fcodefile = open(source_file_name_fcode, O_RDONLY | O_BINARY);

            if (Fcodefile < 0) {
                printf("Open failure for file %s\n", source_file_name_fcode);
                perror("Error is");

                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");
                n = getString(name, sizeof name, stdin);

                if((name[0] == 'q') || (name[0] == 'Q')) {
                    return;
                } else {
                    source_file_name[0] = '\0';
                    printf("\n\n");
                }

            } else {

                good_filename_FCode = TRUE;
                fcode_fileopen      = TRUE;
                
                t = fstat(Fcodefile, &stat);

                if (t < 0) {
                    printf("Couldn't get size of file %s\n", source_file_name_fcode);
                    perror("Error is");
                    fcode_fileopen = FALSE;
                    close(Fcodefile);
                } else {
                    Fcodelen = stat.st_size;
                }
            } // ends if (X86file < 0)
        } // ends while (good_filename_FCode == FALSE)


        
        image1Len = X86len;
        image2Len = Fcodelen;

        logPrint("     source_file_name: ..... %s -- Size: 0x%08lx", source_file_name,       image1Len);
        logPrint("     source_file_name_fcode: %s -- Size: 0x%08lx", source_file_name_fcode, image2Len);

        /*
        **  Get some memory .....
        */
        image1Buf = (unsigned char *)malloc(image1Len);
        image2Buf = (unsigned char *)malloc(image2Len);

        if (image1Buf == NULL || image2Buf == NULL) {
            logPrint("     Allocating Buffer Problems ......");
            return;
        }


        /*
        **  Copy the int13 bios information to memory .....
        */
        t = read(X86file, image1Buf, X86len);

        if (t != X86len) {
            printf("Read failed for file %s\n", source_file_name);
            perror("Error is");
            free(image1Buf);
            close(X86file);
            int13_fileopen = FALSE;
        }

        close(X86file);
        int13_fileopen = FALSE;

        /*
        **  Copy the fcode information to memory .....
        */
        t = read(Fcodefile, image2Buf, Fcodelen);

        if (t != Fcodelen) {
            printf("Read failed for file %s\n", source_file_name_fcode);
            perror("Error is");
            free(image2Buf);
            close(Fcodefile);
            fcode_fileopen = FALSE;
        }

        close(Fcodefile);
        fcode_fileopen = FALSE;


        /*
        **  Valdiate them to ensure they are good images.
        */
        error = checkBiosValidity(port, (U32 *)image1Buf, image1Len);

        if (error) {

            /*
            **  Bad image, were going to need to get a new file 
            */
            good_file_int13     = FALSE;
            good_filename_INT13 = FALSE;

        } else {
            
            good_file_int13 = TRUE;

            error = checkBiosValidity(port, (U32 *)image2Buf, image2Len);

            if (error) {

                /*
                **  Bad image, were going to need to get a new file 
                */
                good_file_fcode     = FALSE;
                good_filename_FCode = FALSE;

            } else {

                good_file_fcode     = TRUE;

            } // ends if (error)            
        } // ends if (error)


        /*
        **  Close the file pointers
        */
        close(X86file);
        close(Fcodefile);

        /*
        **  This file could be really messed up, but the user may want to flash it anyway.
        */
        if (mptutil) {

            if (good_file_fcode == FALSE || good_file_int13 == FALSE) {
                 
                /*
                **  Give the user one last chance to not flash this image.
                */
                if (good_file_fcode == FALSE) {
                    printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_fcode);
                } else if (good_file_int13 == FALSE) {
                    printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name);
                } else if (good_file_int13 == FALSE && good_file_fcode == FALSE) {
                    printf("\nFlashing either of these files could make your card permanently non-functional.");
                }
                printf("\nWould you like flash this image or quit? [y/n/q]  ");
                n = getString(name, sizeof name, stdin);
                
                if ((name[0] == 'Y') || (name[0] == 'y')) {
                    good_file_int13 = TRUE;
                    good_file_fcode = TRUE;
                } else if ((name[0] == 'Q') || (name[0] == 'q')) {
                    free(image1Buf);
                    free(image2Buf);
                    return;
                }
            } // ends if (good_file_fcode == FALSE || good_file_int13)

        } else if (good_file_fcode == FALSE || good_file_int13 == FALSE) {

            /*
            **  Tell the user about the problem and leave.
            */
            if (good_file_fcode == FALSE) {
                printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_fcode);
            } else if (good_file_int13 == FALSE) {
                printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name);
            } else if (good_file_int13 == FALSE && good_file_fcode == FALSE) {
                printf("\nFlashing either of these files could make your card permanently non-functional.");
            }
            printf("\nPress Return to enter a new file name or 'q' to quit");
            n = getString(name, sizeof name, stdin);

            if ((name[0] == 'Q') || (name[0] == 'q')) {
                free(image1Buf);
                free(image2Buf);
                return;
            }
        } // ends if (FCUtil)

    } // ends while (good_file_int13 == FALSE || good_file_fcode == FALSE)

    /*
    **  Start combining the images.
    */
    doSplitBiosImage(&image1Buf, &image1Len, &image3Buf, &image3Len);

    logPrint("     Image1Len: 0x%04lx", image1Len);
    logPrint("     Image2Len: 0x%04lx", image2Len);
    logPrint("     Image3Len: 0x%04lx", image3Len);

    fixupBiosFcodeImage(port, image1Buf, image1Len, 0);
    fixupBiosFcodeImage(port, image2Buf, image2Len, 1);

    /*
    **  Copy the memory over ....
    */	
    imageLen = image1Len + image2Len + image3Len;
    logPrint("      ImageLen: 0x%04lx", imageLen);
	
    if (imageLen == 0) {
        free(image1Buf);
        free(image2Buf);
        return;
    }

    WorkBuf = (unsigned char *)malloc(imageLen);

    filestart    = (U32 *)WorkBuf;
    filecurrent  = filestart;
    StartAddress = (U32)filecurrent;
    imageOff     = 0;
	
    /*
    **  Copy x86 core over
    */
    logPrint("     Copying x86");
    memcpy(filecurrent + (imageOff / 4), image1Buf, image1Len);
    imageOff += image1Len;
    free(image1Buf);
    logPrint("     Ending imageOff: 0x%08x", imageOff);

    /*
    **  Copy Fcode core over
    */
    logPrint("     Copying FCode");
    memcpy(filecurrent + (imageOff / 4), image2Buf, image2Len);
    imageOff += image2Len;
    free(image2Buf);
    logPrint("     Ending imageOff: 0x%08x", imageOff);

    /*
    **  Copy x86 CU over
    */
    if (image3Buf != NULL) {
        logPrint("     Copying x86 Cu");
		memcpy(filecurrent + (imageOff / 4), image3Buf, image3Len);
		imageOff += image3Len;
		free(image3Buf);
        logPrint("     Ending imageOff: 0x%08x", imageOff);
	}

    /*
    **  Reset
    */
    filecurrent = filestart;
    
	status = doFwDownload(port, MPI_FW_DOWNLOAD_ITYPE_BIOS, WorkBuf, imageLen, 0);
    
    if (status != MPI_IOCSTATUS_SUCCESS) {

        printf("\n\nERROR:  BIOS download failed with status: 0x%04x", status);
        printf("  \nPress <Enter> to continue");
        dogetch();
    }
    
    free(WorkBuf);
    logPrint("*Leaving doFlashBiosFcode()");
}





void doFlashBiosFcodeEFI ( MPT_PORT *port ) {

    U8  good_filename_EFI   = FALSE;
    U8  good_filename_FCode = FALSE;
    U8  good_filename_INT13 = FALSE;
    U8  good_file_EFI       = FALSE;
    U8  good_file_int13     = FALSE;
    U8  good_file_fcode     = FALSE;
    U8  int13_fileopen      = FALSE;
    U8  fcode_fileopen      = FALSE;
    U8  EFI_fileopen        = FALSE;
    U8  error               = 0;
    
    U32 *filestart, *filecurrent, StartAddress;

	int	imageLen  = 0;
	int	image1Len = 0;
	int	image2Len = 0;
	int	image3Len = 0;
	int	image4Len = 0;
	int	image5Len = 0;
	int	imageOff  = 0, n;
    int	t, X86len, Fcodelen, EFIlen, X86file, Fcodefile, EFIfile, status;

    char source_file_name[DEFAULT_FILENAME_LENGTH];
    char source_file_name_fcode[DEFAULT_FILENAME_LENGTH];
    char source_file_name_EFI[DEFAULT_FILENAME_LENGTH];
    
	unsigned char	*image1Buf = NULL;
	unsigned char	*image2Buf = NULL;
	unsigned char	*image3Buf = NULL;
	unsigned char	*image4Buf = NULL;
	unsigned char	*image5Buf = NULL;
	unsigned char	*WorkBuf   = NULL;

    struct stat		 stat;



    logPrint("*Entering doFlashBiosFcode()");
    logPrint("     FileName : %s", flag_ptr->FileName);
    logPrint("     Filename1: %s", flag_ptr->FileName1);
    logPrint("     Filename2: %s", flag_ptr->FileName2);

    system("clear");
    
    source_file_name[0]       = '\0';
    source_file_name_fcode[0] = '\0';
    source_file_name_EFI[0]   = '\0';
    


    while (good_file_int13 == FALSE || good_file_fcode == FALSE) {

        /*
        **  Let's get the filename for the INT13 BIOS
        */
        while (good_filename_INT13 == FALSE || int13_fileopen == FALSE) {

            if (good_filename_INT13 == FALSE) {

                /*
                **  Are we in a manufacturing environment?
                */
                if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0 && flag_ptr->ManLogOpen == TRUE) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        strcpy(source_file_name, DEFAULT_INT13_BIOS_SAS);
                    }

                /*
                **  Do we need to ask for the filename?
                */
                } else if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0) {
                    
                    if (HostRunIsSASFamily(flag_ptr)) {
                        printf("\n\nEnter name of BIOS (default: %s):  ", DEFAULT_INT13_BIOS_SAS);
                        n = getString(source_file_name, sizeof source_file_name, stdin);
                    }

                    /*
                    **  Did they just hit return?
                    */
                    if(strlen(source_file_name) == 0) {
                        if (HostRunIsSASFamily(flag_ptr)) {
                            strcpy(source_file_name, DEFAULT_INT13_BIOS_SAS);
                        }
                    }

                /*
                **  Must be waiting on us
                */
                } else {

                    strcpy(source_file_name, flag_ptr->FileName);
                    strcpy(flag_ptr->FileName, "UNKNOWN");
                }
            } // ends if (good_filename_INT13 == FALSE)

            /*
            **  Can we open the file?
            */
            X86file = open(source_file_name, O_RDONLY | O_BINARY);

            if (X86file < 0) {
                printf("Open failure for file %s\n", source_file_name);
                perror("Error is");

                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");
                n = getString(name, sizeof name, stdin);

                if((name[0] == 'q') || (name[0] == 'Q')) {
                    return;
                } else {
                    source_file_name[0] = '\0';
                    printf("\n\n");
                }

            } else {

                good_filename_INT13 = TRUE;
                int13_fileopen      = TRUE;
                
                t = fstat(X86file, &stat);

                if (t < 0) {
                    printf("Couldn't get size of file %s\n", source_file_name);
                    perror("Error is");
                    int13_fileopen = FALSE;
                    close(X86file);
                } else {
                    X86len = stat.st_size;
                }
            } // ends if (X86file < 0)
        } // ends while (good_filename_INT13 == FALSE)


        

        /*
        **  Let's get the filename for the FCode
        */
        while (good_filename_FCode == FALSE || fcode_fileopen == FALSE) {

            if (good_filename_FCode == FALSE) {
                /*
                **  Are we in a manufacturing environment?
                */
                if (strcmp(flag_ptr->FileName1, "UNKNOWN") == 0 && flag_ptr->ManLogOpen == TRUE) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        strcpy(source_file_name_fcode, DEFAULT_FCODE_BIOS_SAS);
                    }

                /*
                **  Do we need to ask for the filename?
                */
                } else if (strcmp(flag_ptr->FileName1, "UNKNOWN") == 0) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        printf("\n\nEnter name of FCode (default: %s):  ", DEFAULT_FCODE_BIOS_SAS);
                        n = getString(source_file_name_fcode, sizeof source_file_name_fcode, stdin);
                    }

                    /*
                    **  Did they just hit return?
                    */
                    if(strlen(source_file_name_fcode) == 0) {
                        
                        if (HostRunIsSASFamily(flag_ptr)) {
                            strcpy(source_file_name_fcode, DEFAULT_FCODE_BIOS_SAS);
                        }
                    }

                /*
                **  Must be waiting on us
                */
                } else {

                    strcpy(source_file_name_fcode , flag_ptr->FileName1);
                    strcpy(flag_ptr->FileName1, "UNKNOWN");
                }
            } // ends if (good_filename_FCode == FALSE)

            /*
            **  Let's see if we can open it
            */
            Fcodefile = open(source_file_name_fcode, O_RDONLY | O_BINARY);

            if (Fcodefile < 0) {
                printf("Open failure for file %s\n", source_file_name_fcode);
                perror("Error is");

                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");
                n = getString(name, sizeof name, stdin);

                if((name[0] == 'q') || (name[0] == 'Q')) {
                    return;
                } else {
                    source_file_name_fcode[0] = '\0';
                    printf("\n\n");
                }

            } else {

                good_filename_FCode = TRUE;
                fcode_fileopen      = TRUE;
                
                t = fstat(Fcodefile, &stat);

                if (t < 0) {
                    printf("Couldn't get size of file %s\n", source_file_name_fcode);
                    perror("Error is");
                    fcode_fileopen = FALSE;
                    close(Fcodefile);
                } else {
                    Fcodelen = stat.st_size;
                }
            } // ends if (X86file < 0)
        } // ends while (good_filename_FCode == FALSE)


        
        /*
        **  Let's get the filename for the EFI
        */
        while (good_filename_EFI == FALSE || EFI_fileopen == FALSE) {

            if (good_filename_EFI == FALSE) {
                /*
                **  Are we in a manufacturing environment?
                */
                if (strcmp(flag_ptr->FileName2, "UNKNOWN") == 0 && flag_ptr->ManLogOpen == TRUE) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        strcpy(source_file_name_EFI, DEFAULT_EFI_BIOS_SAS);
                    }

                /*
                **  Do we need to ask for the filename?
                */
                } else if (strcmp(flag_ptr->FileName2, "UNKNOWN") == 0) {

                    if (HostRunIsSASFamily(flag_ptr)) {
                        printf("\n\nEnter name of EFI (default: %s):  ", DEFAULT_EFI_BIOS_SAS);
                        n = getString(source_file_name_EFI, sizeof source_file_name_EFI, stdin);
                    }

                    /*
                    **  Did they just hit return?
                    */
                    if(strlen(source_file_name_EFI) == 0) {
                        
                        if (HostRunIsSASFamily(flag_ptr)) {
                            strcpy(source_file_name_EFI, DEFAULT_EFI_BIOS_SAS);
                        }
                    }

                /*
                **  Must be waiting on us
                */
                } else {

                    strcpy(source_file_name_EFI , flag_ptr->FileName2);
                    strcpy(flag_ptr->FileName2, "UNKNOWN");
                }
            } // ends if (good_filename_FCode == FALSE)

            /*
            **  Let's see if we can open it
            */
            EFIfile = open(source_file_name_EFI, O_RDONLY | O_BINARY);

            if (EFIfile < 0) {
                printf("Open failure for file %s\n", source_file_name_EFI);
                perror("Error is");

                printf("\n\nVerify file is present and in local directory.");
                printf("\nPress any key to reenter file name, otherwise press q to quit");
                n = getString(name, sizeof name, stdin);

                if((name[0] == 'q') || (name[0] == 'Q')) {
                    return;
                } else {
                    source_file_name_EFI[0] = '\0';
                    printf("\n\n");
                }

            } else {

                good_filename_EFI = TRUE;
                EFI_fileopen      = TRUE;
                
                t = fstat(EFIfile, &stat);

                if (t < 0) {
                    printf("Couldn't get size of file %s\n", source_file_name_EFI);
                    perror("Error is");
                    EFI_fileopen = FALSE;
                    close(EFIfile);
                } else {
                    EFIlen = stat.st_size;
                }
            } // ends if (X86file < 0)
        } // ends while (good_filename_FCode == FALSE)


        
        image1Len = X86len;
        image2Len = Fcodelen;
        image3Len = EFIlen;

        logPrint("     source_file_name: ..... %s -- Size: 0x%08lx", source_file_name,       image1Len);
        logPrint("     source_file_name_fcode: %s -- Size: 0x%08lx", source_file_name_fcode, image2Len);
        logPrint("     source_file_name_EFI: . %s -- Size: 0x%08lx", source_file_name_EFI,   image3Len);

        /*
        **  Get some memory .....
        */
        image1Buf = (unsigned char *)malloc(image1Len);
        image2Buf = (unsigned char *)malloc(image2Len);
        image3Buf = (unsigned char *)malloc(image3Len);

        if (image1Buf == NULL || image2Buf == NULL || image3Buf == NULL) {
            logPrint("     Allocating Buffer Problems ......");
            return;
        }


        /*
        **  Copy the int13 bios information to memory .....
        */
        t = read(X86file, image1Buf, X86len);

        if (t != X86len) {
            printf("Read failed for file %s\n", source_file_name);
            perror("Error is");
            free(image1Buf);
            close(X86file);
            int13_fileopen = FALSE;
        }

        close(X86file);
        int13_fileopen = FALSE;

        /*
        **  Copy the fcode information to memory .....
        */
        t = read(Fcodefile, image2Buf, Fcodelen);

        if (t != Fcodelen) {
            printf("Read failed for file %s\n", source_file_name_fcode);
            perror("Error is");
            free(image2Buf);
            close(Fcodefile);
            fcode_fileopen = FALSE;
        }

        close(Fcodefile);
        fcode_fileopen = FALSE;


        /*
        **  Copy the EFI information to memory .....
        */
        t = read(EFIfile, image3Buf, EFIlen);

        if (t != EFIlen) {
            printf("Read failed for file %s\n", source_file_name_EFI);
            perror("Error is");
            free(image3Buf);
            close(EFIfile);
            EFI_fileopen = FALSE;
        }

        close(EFIfile);
        EFI_fileopen = FALSE;


        /*
        **  Valdiate them to ensure they are good images.
        */
        error = checkBiosValidity(port, (U32 *)image1Buf, image1Len);

        if (error) {

            /*
            **  Bad image, were going to need to get a new file 
            */
            good_file_int13     = FALSE;
            good_filename_INT13 = FALSE;

        } else {
            
            good_file_int13 = TRUE;

            error = checkBiosValidity(port, (U32 *)image2Buf, image2Len);

            if (error) {

                /*
                **  Bad image, were going to need to get a new file 
                */
                good_file_fcode     = FALSE;
                good_filename_FCode = FALSE;

            } else {

                good_file_fcode     = TRUE;
                error = checkBiosValidity(port, (U32 *)image3Buf, image3Len);

                if (error) {
                    
                    /*
                    **  Bad image, were going to need to get a new file 
                    */
                    good_file_EFI     = FALSE;
                    good_filename_EFI = FALSE;

                } else {

                    good_file_EFI     = TRUE;

                } // ends if (error)            
            } // ends if (error)            
        } // ends if (error)

        /*
        **  Close the file pointers
        */
        close(X86file);
        close(Fcodefile);
        close(EFIfile);

        /*
        **  This file could be really messed up, but the user may want to flash it anyway.
        */
        if (mptutil) {

            if (good_file_fcode == FALSE || good_file_int13 == FALSE || good_file_EFI == FALSE) {
                 
                /*
                **  Give the user one last chance to not flash this image.
                */
                if (good_file_fcode == FALSE) {
                    printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_fcode);
                } else if (good_file_int13 == FALSE) {
                    printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name);
                } else if (good_file_EFI == FALSE) {
                    printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_EFI);
                } else if (good_file_int13 == FALSE && good_file_fcode == FALSE && good_file_EFI == FALSE) {
                    printf("\nFlashing any of these files could make your card permanently non-functional.");
                }
                printf("\nWould you like flash this image or quit? [y/n/q]  ");
                n = getString(name, sizeof name, stdin);
                
                if ((name[0] == 'Y') || (name[0] == 'y')) {
                    good_file_int13 = TRUE;
                    good_file_fcode = TRUE;
                    good_file_EFI   = TRUE;
                } else if ((name[0] == 'Q') || (name[0] == 'q')) {
                    free(image1Buf);
                    free(image2Buf);
                    free(image3Buf);
                    return;
                }
            } // ends if (good_file_fcode == FALSE || good_file_int13)

        } else if (good_file_fcode == FALSE || good_file_int13 == FALSE || good_file_EFI == FALSE) {

            /*
            **  Tell the user about the problem and leave.
            */
            if (good_file_fcode == FALSE) {
                printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_fcode);
            } else if (good_file_int13 == FALSE) {
                printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name);
            } else if (good_file_EFI == FALSE) {
                printf("\nFlashing the file %s could make your card permanently non-functional.", source_file_name_EFI);
            } else if (good_file_int13 == FALSE && good_file_fcode == FALSE && good_file_EFI == FALSE) {
                printf("\nFlashing any of these files could make your card permanently non-functional.");
            }
            printf("\nPress Return to enter a new file name or 'q' to quit");
            n = getString(name, sizeof name, stdin);

            if ((name[0] == 'Q') || (name[0] == 'q')) {
                free(image1Buf);
                free(image2Buf);
                free(image3Buf);
                return;
            }
        } // ends if (FCUtil)

    } // ends while (good_file_int13 == FALSE || good_file_fcode == FALSE)


    /*
    **  Start combining the images ... x86 first
    */
    doSplitBiosImage (&image1Buf, &image1Len, &image4Buf, &image4Len);

    /*
    **  EFI next
    */
    doSplitBiosImage (&image3Buf, &image3Len, &image5Buf, &image5Len);


    logPrint("     Image1Len: 0x%04lx", image1Len);
    logPrint("     Image2Len: 0x%04lx", image2Len);
    logPrint("     Image3Len: 0x%04lx", image3Len);
    logPrint("     Image4Len: 0x%04lx", image4Len);
    logPrint("     Image5Len: 0x%04lx", image5Len);

    fixupBiosFcodeImage (port, image1Buf, image1Len, 0);
    fixupBiosFcodeImage (port, image2Buf, image2Len, 0);
    fixupBiosFcodeImage (port, image3Buf, image3Len, 1);


    /*
    **  Copy the memory over ....
    */	
    imageLen = image1Len + image2Len + image3Len + image4Len + image5Len;
    logPrint("      ImageLen: 0x%04lx", imageLen);
	
    if (imageLen == 0) {
        free(image1Buf);
        free(image2Buf);
        free(image3Buf);
        return;
    }

    WorkBuf = (unsigned char *)malloc(imageLen);

    filestart    = (U32 *)WorkBuf;
    filecurrent  = filestart;
    StartAddress = (U32)filecurrent;
    imageOff     = 0;
	
    /*
    **  Copy x86 core over
    */
    logPrint("     Copying x86");
    memcpy(filecurrent + (imageOff / 4), image1Buf, image1Len);
    imageOff += image1Len;
    free(image1Buf);
    logPrint("     Ending imageOff: 0x%08x", imageOff);

    /*
    **  Copy Fcode core over
    */
    logPrint("     Copying FCode");
    memcpy(filecurrent + (imageOff / 4), image2Buf, image2Len);
    imageOff += image2Len;
    free(image2Buf);
    logPrint("     Ending imageOff: 0x%08x", imageOff);

    /*
    **  Copy EFI core over
    */
    logPrint("     Copying EFI");
    memcpy(filecurrent + (imageOff / 4), image3Buf, image3Len);
    imageOff += image3Len;
    free(image3Buf);
    logPrint("     Ending imageOff: 0x%08x", imageOff);

    /*
    **  Copy x86 CU over
    */
    if (image4Buf != NULL) {
        logPrint("     Copying x86 Cu");
		memcpy(filecurrent + (imageOff / 4), image4Buf, image4Len);
		imageOff += image4Len;
		free(image4Buf);
        logPrint("     Ending imageOff: 0x%08x", imageOff);
	}

    /*
    **  Copy EFI CU over
    */
    if (image5Buf != NULL) {
        logPrint("     Copying EFI Cu");
		memcpy(filecurrent + (imageOff / 4), image5Buf, image5Len);
		imageOff += image5Len;
		free(image5Buf);
        logPrint("     Ending imageOff: 0x%08x", imageOff);
	}

    /*
    **  Reset
    */
    filecurrent = filestart;
    
	status = doFwDownload(port, MPI_FW_DOWNLOAD_ITYPE_BIOS, WorkBuf, imageLen, 0);
    
    if (status != MPI_IOCSTATUS_SUCCESS) {

        printf("\n\nERROR:  BIOS download failed with status: 0x%04x", status);
        printf("  \nPress <Enter> to continue");
        dogetch();
    }
    
    free(WorkBuf);
    logPrint("*Leaving doFlashBiosFcode()");
}





int doFwDownload(MPT_PORT *port, int type, unsigned char *buf, int len, int offset) {

	FWDownload_t		 req;
	FWDownloadReply_t	 rep;
	FWDownloadTCSGE_t	*tc;
	int					 size;

    logPrint ("*Entering doFwDownload()");     
    
    memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	tc                 = (FWDownloadTCSGE_t *)&req.SGL;
	req.Function       = MPI_FUNCTION_FW_DOWNLOAD;
	req.ImageType      = type;
	tc->ContextSize	   = 0;
	tc->DetailsLength  = 12;
	tc->Flags          = MPI_SGE_FLAGS_TRANSACTION_ELEMENT;

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }

    
	if (port->mptVersion < 0x0101 && type == MPI_FW_DOWNLOAD_ITYPE_BIOS) {

		int	  i;
		U32	  data_l;
		U32	  data_h;
		U32	 *p_data_l;
		U32	 *p_data_h;

		p_data_l = (U32 *)&buf[0];
		p_data_h = (U32 *)&buf[len] - 1;

		for (i = 0; i < len / 8; i++) {
			data_l      = *p_data_l;
			data_h      = *p_data_h;
			*p_data_l++ = data_h;
			*p_data_h-- = data_l;
		}

		offset += 0x100000;
		buf    += len;
	}

	printf("\nDownloading image...\n");

	while (len > 0) {

		if (port->mptVersion < 0x0101 && flag_ptr->doingFWDLB == FALSE) {

			int		 i;
			U32		 checksum;

			size = min(len, 0x10000);

			if (type == MPI_FW_DOWNLOAD_ITYPE_BIOS) {
				offset -= size;
				buf    -= size;
			}

			checksum = 0;
			for (i = 0; i < size / 4; i++)
				checksum -= get32(((U32 *)buf)[i]);

			tc->Reserved_0100_Checksum = set32(checksum);

		} else {

			size = min(len, 0x4000);
			//size = len;
			if (size == len) {
				req.MsgFlags = MPI_FW_DOWNLOAD_MSGFLGS_LAST_SEGMENT;
            }
		}

		tc->ImageSize   = set32(size);
		tc->ImageOffset	= set32(offset);

		if (doMptCommand(port, &req, sizeof req - sizeof req.SGL + sizeof *tc, &rep, sizeof rep, NULL, 0, buf, size, 60) != 1) {
			printf("Download failed\n");
			return 0;
		}

		len -= size;

		if (!(port->mptVersion < 0x0101 && type == MPI_FW_DOWNLOAD_ITYPE_BIOS)) {
			buf += size;
			offset += size;
		}

        if (HostRunIsSASFamily(flag_ptr)) {

            if (get16(rep.IOCStatus)  == MPI_IOCSTATUS_INTERNAL_ERROR &&
                get32(rep.IOCLogInfo) == 0x30010103                   ){

                /*
                **  Firmware A to B to C for SAS.
                */
                printf("\n\n To flash this version of firmware you will need to flash firmware");
                printf("  \n version 0.03.22 first.");
                printf("\n\n Press Return to Continue");
                dogetch();
                return (get16(rep.IOCStatus));

            } else {

                if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS) {
                    logPrint("     Firmware Download Failed with Status:  0x%04x", get16(rep.IOCStatus));

                    if (get16(rep.IOCStatus) & MPI_IOCSTATUS_FLAG_LOG_INFO_AVAILABLE) {
                        logPrint("                               IOCLogInfo:  0x%08x", get32(rep.IOCLogInfo));
                    }

                    return (get16(rep.IOCStatus));
                }
            }

        } else {

            if (get16(rep.IOCStatus) & MPI_IOCSTATUS_FLAG_LOG_INFO_AVAILABLE) {
                logPrint("                               IOCLogInfo:  0x%08x", get32(rep.IOCLogInfo));
            }

            return (get16(rep.IOCStatus));
        }
	} // ends while (len > 0)

    printf   ("Download succeeded\n");
    logPrint ("*Leaving doFwDownload()");     
	return (get16(rep.IOCStatus));
}




int doFirmwareUpload(MPT_PORT *port) {

	int				 file;
	unsigned char	*imageBuf = NULL;
	int				 imageLen;
	int				 actualImageLen;
	int				 offset;
	int				 n;
	int				 t;


    logPrint("*Entering doFirmwareUpload()");

    system("clear");
	printf("\n\nEnter firmware filename: ");
	n = getString(name, sizeof name, stdin);


	if (n > 0) {

		file = open(name, O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0644);

		if (file < 0) {
			printf("Open failure for file %s\n", name);
			perror("Error is");
			return 0;
		}
	
    } else {

		printf("Image won't be uploaded\n");
		return 1;
	}

    imageLen = 0x80000;
    //imageLen = 0x10000;
	//imageBuf = (unsigned char *)malloc(imageLen);

	offset = 0;
	while (TRUE) {

		if (doFwUpload(port, MPI_FW_UPLOAD_ITYPE_FW_FLASH, buffer1, imageLen, offset, &actualImageLen) != 1)
			break;

		if (offset + 0x80000 > actualImageLen)
			imageLen = actualImageLen - offset;

		t = write(file, buffer1, imageLen);
		
        if (t != imageLen) {
			printf("Write failed for file %s, t = %x\n", name, t);
			perror("Error is");
			break;
		}

		offset += imageLen;

		if (offset >= actualImageLen)
			break;
	}


	logPrint("     Wrote %d bytes to file %s\n", offset, name);

	close(file);

	free(imageBuf);

    logPrint("*Leaving doFirmwareUpload()");
	return 1;
}



int doFwUpload(MPT_PORT *port, int type, unsigned char *buf, int len, int offset, int *outLen) {

	FWUpload_t			 req;
	FWUploadReply_t		 rep;
	FWUploadTCSGE_t		*tc;
	int					 size;

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	tc                 = (FWUploadTCSGE_t *)&req.SGL;
	req.Function       = MPI_FUNCTION_FW_UPLOAD;
	req.ImageType      = type;
	tc->ContextSize    = 0;
	tc->DetailsLength  = 12;
	tc->Flags          = MPI_SGE_FLAGS_TRANSACTION_ELEMENT;

    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }

	while (len > 0) {

		size = len;
		//size = min(len, 0x4000);

		tc->ImageSize   = set32(size);
		tc->ImageOffset = set32(offset);

		if (doMptCommand(port, &req, sizeof req - sizeof req.SGL + sizeof *tc, &rep, sizeof rep, buf, size, NULL, 0, 60) != 1) {

			printf("Upload failed\n");
			return 0;
		}

		if (get16(rep.IOCStatus) != MPI_IOCSTATUS_SUCCESS) {

			if (get16(rep.IOCStatus) == MPI_IOCSTATUS_INVALID_FIELD) {

				if (offset + size > (int)get32(rep.ActualImageSize)) {

					len = get32(rep.ActualImageSize) - offset;
					continue;
				}
			}

			printf("Upload failed, IOCStatus = %04x\n", get16(rep.IOCStatus));
			return 0;
		}

		buf += size;
		len -= size;
		offset += size;
	}

	*outLen = get32(rep.ActualImageSize);

	return 1;
}


void dogetch (void) {
    
	int	 n;

    n = getString(name, sizeof name, stdin);
}



void doHelp( void ) {

    system("clear");
    
    /*
    ** Display the menu
    */
    printf("\nValid Options:");

    /*
    **  -a option
    */
    

    /*
    **  -b option
    */
    printf("\n\n-bx: Flash BIOS to an HBA where x is the name of the BIOS file");
    if (mptutil) {
        printf("\n       If x = null, will null the BIOS.");
    }

    /*
    **  -c option
    */
    printf("\n\n-cx: Change current adapter where x is the number of the adapter.");
    printf("  \n     *** Please read the user guide for more information on this option.");

    /*
    **  -d option
    */
    if (mptutil) {
        printf("\n\n-d x,y,z: Concatenate a SAS firmware and nvdata file where ");
        printf("  \n          x = firmware, y = nvdata file and z = output file.");
    }

    /*
    **  -e option
    */
#ifdef __KERNEL_2_4__
    if (mptutil) {
        printf("\n\n-ex: Erase Memory where x is the memory type to erase");
        printf("  \n     1:  NVSRAM");
        printf("  \n     2:  SEEPROM");
        printf("  \n     3:  NVSRAM & SEEPROM");
        printf("  \n     4:  Backup Firmware");
        printf("  \n     5:  Persistent Pages");
        printf("  \n     6:  Manufacturing Pages");
        printf("  \n     7:  Boot Services");
    }
#endif

    if (mptutil) {
        printf("\nPress Return To Continue ... ");
        dogetch();
    }


    /*
    **  -f option
    */
    printf("\n\n-fx: Flash firmware to an HBA where x is the name of the firmware file");


    /*
    **  -g option
    */
    if (mptutil) {
      printf("\n\n-g x y: Flash INT13 and FCode expansion roms to an HBA");
      printf("  \n        where x = INT13 bios and y = FCode.");
    }

    /*
    **  -h option
    */
    if (mptutil) {
      printf("\n\n-h x y z: Flash x86, FCode and EFI expansion roms to an HBA");
      printf("  \n          x = x86, y = FCode and z = EFI.");
    }
    

    /*
    **  -i option
    */
    

    /*
    **  -j option
    */

    /*
    **  -k option
    */

    /*
    **  -l option
    */

    /*
    **  -m option
    */
    if (mptutil) {
        printf("\n\n-m: Flag for manufacturing use.");
    }

    /*
    **  -n option
    */
    

    /*
    **  -o option
    */
    if (mptutil) {
        printf("\n\n-o: Used to open up more command line and menu options.");
    }

    /*
    **  -p option
    */
    

    /*
    **  -q option
    */

    /*
    **  -r option
    */

    /*
    **  -s option
    */
    if (mptutil) {
        printf("\n\n-sx: Used to program SEEPROM where x is the name of the data file.");
    }

    /*
    **  -t option
    */
    if (mptutil) {
        printf("\n\n-t: Used to program a SAS address only.");
    }



    printf("\n\nPress Return To Continue ... ");
    dogetch();

    /*
    **  -u option
    */

    /*
    **  -v option
    */
    if (mptutil) {
        printf("\n\n-vx: Used to disable(0)/enable(1) write cache to devices seen by a SAS HBA.");
    }

    /*
    **  -w option
    */
    if (mptutil) {
        printf("\n\n-wx: Used with -s option to hold the WWID(x) for a SAS HBA.");
    }

    /*
    **  -x option
    */
    if (mptutil) {
        printf("\n\n-x: Used as a flag to enable manufacturing logging.");
    }

    /*
    **  -y option
    */
    if (mptutil) {
        printf("\n\n-y: Used to diagnostically reset the card.");
    }

    /*
    **  -z option
    */
    if (mptutil) {
        printf("\n\n-z: Used to output debug information to /var/log/messages.");
    }

    printf("\n\n");
}



int doInquiry(MPT_PORT *port, int bus, int target, int lun) {

    int              status, index;
	SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;
    unsigned char    inq_data[36];

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function			= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus					= bus;
	req.TargetID			= target;
	req.CDBLength			= 6;
	req.LUN[1]				= lun;
	req.Control				= set32(MPI_SCSIIO_CONTROL_READ | MPI_SCSIIO_CONTROL_SIMPLEQ);
	req.CDB[0]				= 0x12;
	req.CDB[1]				= 0;
	req.CDB[2]				= 0;
	req.CDB[3]				= 0;
	req.CDB[4]				= sizeof(inq_data);
	req.CDB[5]				= 0;
	req.DataLength			= set32(sizeof(inq_data));
    

	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, inq_data, sizeof(inq_data), NULL, 0, 10);

    if (status == 1) {

        /*
        **  I need the Model type
        */ 
        for (index= 16; index < 32; index++) {
            ptrSasDev->Model[index - 16]   = inq_data[index];
        }

        for (index= 32; index < 36; index++) {
            ptrSasDev->Version[index - 32] = inq_data[index];
        }
        ptrSasDev->Model[16]  = '\0';
        ptrSasDev->Version[4] = '\0';

        logPrint("     ProductID: %s", ptrSasDev->Model);
        logPrint("      Revision: %s", ptrSasDev->Version);

    }

    return status;
}



int doIocInit(MPT_PORT *port, int WhoInit) {

	IOCInit_t		 req;
	IOCInitReply_t	 rep;
	IOCFactsReply_t	 IOCFacts;
    int              Status = 0xFF;

	if (getIocFacts(port, &IOCFacts) != 1) {
        logPrint("      getIocFacts() is returning 0");
		return 0;
    }

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

    logPrint("      Sending IOCInit()");
	req.Function			= MPI_FUNCTION_IOC_INIT;
	req.WhoInit				= WhoInit;
	req.Flags				= IOCFacts.Flags;
	req.MaxDevices			= IOCFacts.MaxDevices;
	req.MaxBuses			= IOCFacts.MaxBuses;
	req.ReplyFrameSize		= IOCFacts.CurReplyFrameSize;
	req.HostMfaHighAddr		= IOCFacts.CurrentHostMfaHighAddr;
	req.SenseBufferHighAddr	= IOCFacts.CurrentSenseBufferHighAddr;
	req.HostPageBufferSGE	= IOCFacts.HostPageBufferSGE;

/*
	req.Function			= MPI_FUNCTION_IOC_INIT;
	req.WhoInit				= WhoInit;
	req.Flags				= 0;
	req.MaxDevices			= 64;
	req.MaxBuses			= 1;
	req.ReplyFrameSize		= 128;
	req.HostMfaHighAddr		= 0;
	req.SenseBufferHighAddr	= 0;
	//req.HostPageBufferSGE	= 0;
    req.MsgVersion          = 0x0105;
*/
    if (flag_ptr->Handshake == TRUE) {
        req.MsgContext = 0x02012020;
    } else {
        req.MsgContext = 0xDEADBEEF;
    }

    Status = doMptCommand(port, &req, sizeof req, &rep, sizeof rep, NULL, 0, NULL, 0, 10);

    if (rep.IOCStatus != MPI_IOCSTATUS_SUCCESS) {
        logPrint("    IOCInit Failed with Status: 0x%04x", rep.IOCStatus);
        logPrint("                       LogInfo: 0x%08x", rep.IOCLogInfo);
    }

	return Status;
}



//int doIocInit(MPT_PORT *port, int WhoInit) {
//
//	IOCInit_t		 req;
//	IOCInitReply_t	 rep;
//	IOCFactsReply_t	 IOCFacts;
//
//	if (getIocFacts(port, &IOCFacts) != 1)
//		return 0;
//
//	memset(&req, 0, sizeof req);
//	memset(&rep, 0, sizeof rep);
//
//	req.Function			= MPI_FUNCTION_IOC_INIT;
//	req.WhoInit				= WhoInit;
//	req.Flags				= IOCFacts.Flags;
//	req.MaxDevices			= IOCFacts.MaxDevices;
//	req.MaxBuses			= IOCFacts.MaxBuses;
//	req.ReplyFrameSize		= IOCFacts.CurReplyFrameSize;
//	req.HostMfaHighAddr		= IOCFacts.CurrentHostMfaHighAddr;
//	req.SenseBufferHighAddr	= IOCFacts.CurrentSenseBufferHighAddr;
//	req.HostPageBufferSGE	= IOCFacts.HostPageBufferSGE;
//
//	return doMptCommand(port, &req, sizeof req, &rep, sizeof rep, NULL, 0, NULL, 0, 10);
//}




int doIOCPage0 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pIOCPage0_t           pbuf; // message data
    
    logPrint("*Entering doIOCPage0()");

    pbuf  = (pIOCPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_IOC,      // type
                            0,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_CURRENT,  // action
                                     MPI_CONFIG_PAGETYPE_IOC,            // type
                                     0,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOCPage0_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            system("clear");

            printf("\nIOC Page 0 \n");
            printf("\n\t Total NVStore ........ 0x%08x", pbuf->TotalNVStore);
            printf("\n\t Free NVStore ......... 0x%08x", pbuf->FreeNVStore);
            printf("\n\t Vendor ID ............ 0x%04x", pbuf->VendorID);
            printf("\n\t Device ID ............ 0x%02x", pbuf->DeviceID);
            printf("\n\t Revision ID .......... 0x%02x", pbuf->RevisionID);
            printf("\n\t Class Code ........... 0x%08x", pbuf->ClassCode);
            printf("\n\t Subsystem Vendor ID .. 0x%04x", pbuf->SubsystemVendorID);
            printf("\n\t Subsystem ID ......... 0x%04x", pbuf->SubsystemID);

            printf("\n\n\t Press Enter to Quit");
            dogetch();
            
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doIOCPage0()");
    return 0;
}



int doIOCPage1 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pIOCPage1_t           pbuf; // message data
    
    logPrint("*Entering doIOCPage1()");

    pbuf  = (pIOCPage1_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_IOC,      // type
                            1,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_IOC,            // type
                                     1,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOCPage1_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nIOC Page 1 \n");
                printf("\n\ta - Flags ............... 0x%08x", pbuf->Flags);
                printf("\n\tb - Coalescing Timeout .. 0x%08x", pbuf->CoalescingTimeout);
                printf("\n\td - Coalescing Depth .... 0x%02x", pbuf->CoalescingDepth);
                printf("\n\te - PCI Slot Number ..... 0x%02x", pbuf->PCISlotNum);
                
                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'e') {
                    printf("\n\t New Value:  0x");
                }


                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->CoalescingTimeout = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->CoalescingDepth = strtoul(name, NULL, 16);
                            break; }
                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->PCISlotNum = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_IOC,            // type
                                1,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(IOCPage1_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doIOCPage1()");
    return 0;
}



int doIOUnitPage1 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pIOUnitPage1_t pbuf; // message data
    
    logPrint("*Entering doIOUnitPage1()");

    pbuf  = (pIOUnitPage1_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                            1,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_IO_UNIT,       // type
                                     1,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOUnitPage1_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nIOUnit Page 1 \n");
                printf("\n\ta - Flags ......... 0x%08x", pbuf->Flags);
                
                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] == 'a') {
                    printf("\n\t New Value:  0x");
                }


                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                                1,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(IOUnitPage1_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doIOUnitPage1()");
    return 0;
}




int doIOUnitPage2 (MPT_PORT *port) {
    
    int                   status, i;
    char                  buf[1024];
    ConfigReply_t         rep;
    pIOUnitPage2_t pbuf; // message data
    
    logPrint("*Entering doIOUnitPage2()");

    pbuf  = (pIOUnitPage2_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                            2,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_IO_UNIT,       // type
                                     2,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOUnitPage2_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nIOUnit Page 2 \n");
                printf("\n\ta - Flags ......... 0x%08x", pbuf->Flags);
                printf("\n\tb - BIOS Version .. 0x%08x", pbuf->BiosVersion);
                for (i = 0; i < 4; i++) {
                    printf("\n\t    Adapter(%d) .... 0x%02x%02x%04x", i, pbuf->AdapterOrder[i].PciBusNumber, 
                                                                         pbuf->AdapterOrder[i].PciDeviceAndFunctionNumber,
                                                                         pbuf->AdapterOrder[i].AdapterFlags);
                }
                
                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'b') {
                    printf("\n\t New Value:  0x");
                }


                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->BiosVersion = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                                2,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(IOUnitPage2_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doIOUnitPage2()");
    return 0;
}



int doIOUnitPage3 (MPT_PORT *port) {
    
    int                   status, i;
    char                  buf[1024];
    ConfigReply_t         rep;
    pIOUnitPage3_t pbuf; // message data
    
    logPrint("*Entering doIOUnitPage3()");

    pbuf  = (pIOUnitPage3_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                         // adapter
                            MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                            3,                            // page number
                            0,                            // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_IO_UNIT,       // type
                                     3,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOUnitPage3_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nIOUnit Page 3 \n");
                printf("\n\ta - GPIO Count .. 0x%02x", pbuf->GPIOCount);
                
                for (i = 0; i < pbuf->GPIOCount; i++) {

                    if (pbuf->GPIOVal[i] & 0x0001) {
                        printf("\n\t%c - GPIO Value .. 0x%02x (ON)", i+100, pbuf->GPIOVal[i]);
                    } else {
                        printf("\n\t%c - GPIO Value .. 0x%02x (OFF)", i+100, pbuf->GPIOVal[i]);
                    }
                }

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'd' + pbuf->GPIOCount)  {
                    printf("\n\t New Value:  0x");
                }


                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->GPIOCount = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_IO_UNIT,  // type
                                3,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(IOUnitPage3_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }

                default:  { if (name[0] >= 'd' && name[0] <= 'd' + pbuf->GPIOCount) {
                                i = name[0] - 'd';
                                logPrint("      Char: %c", name[0]);
                                logPrint("     Value: %d", i);
                                getString(name, sizeof(name), stdin);  
                                pbuf->GPIOVal[i] = strtoul(name, NULL, 16);
                            }
                            break; }

                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doIOUnitPage3()");
    return 0;
}






int doManufacturingPage0 (MPT_PORT *port) {

    int                    status;
    char                   buf[256];
    ConfigReply_t		   rep;
	pManufacturingPage0_t  pbuf;


    logPrint("*Entering doManufacturingPage0()");
    pbuf = (pManufacturingPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            0,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     0,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(ManufacturingPage0_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nManufacturing Page 0 \n");
                printf("\n\ta - Chip Name ....... %s", pbuf->ChipName);
                printf("\n\tb - Chip Rev ........ %s", pbuf->ChipRevision);
                printf("\n\td - Board Name ...... %s", pbuf->BoardName);
                printf("\n\te - Board Assembly .. %s", pbuf->BoardAssembly);
                printf("\n\tf - Board Tracer .... %s", pbuf->BoardTracerNumber);

                printf("\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, 256, stdin);

                switch (name[0]) {
                
                case 'a': { printf("\n\nName: "    ); getString(pbuf->ChipName,          16, stdin);  break; }
                case 'b': { printf("\n\nRevision: "); getString(pbuf->ChipRevision,       8, stdin);  break; }
                case 'd': { printf("\n\nName: "    ); getString(pbuf->BoardName,         16, stdin);  break; }
                case 'e': { printf("\n\nAssembly: "); getString(pbuf->BoardAssembly,     16, stdin);  break; }
                case 'f': { printf("\n\nTracer: "  ); getString(pbuf->BoardTracerNumber, 16, stdin);  break; }
                      
                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                0,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage0_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)

            } // ends while (name != 'q')

        } // ends if (getConfigPageAction(port,

    } // ends if (getConfigPageHeader(port, 
    
    logPrint("*Leaving doManufacturingPage0()");

	return 1;
}




int doManufacturingPage1 (MPT_PORT *port) {

    int                    status;
    char                   buf[1024];
    char                   choice_offset[15];
    U8                    *p;
    U32                    i, j, mini_offset, counter, offset, index, new_num, *start, *current;
    ConfigReply_t		   rep;
	pManufacturingPage1_t  pbuf;

    logPrint("*Entering doManufacturingPage1()");

    pbuf  = (pManufacturingPage1_t)buf;
    start = current = (U32 *)buf;
    p     = (U8 *)current;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            1,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     1,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(ManufacturingPage1_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {
                
                counter     = 1;
                offset      = 0;
                mini_offset = 0;

                system("clear");
                printf("\nManufacturing Page 1 \n");

                /*
                **  We are going to start displaying at offset 0x4 to skip mpi configuration headers.
                */
                for (i = 1; i < sizeof(ManufacturingPage1_t) / 4; i++) {

                    if (counter == 1) {

                        printf("\n  0x%02x: 0x%08x ", offset, current[i]);
                        counter++;
                        offset += 16;

                    } else if (counter == 4) {
                        counter = 1;
                        printf("0x%08x -- ", current[i]);

                        for (j = 0; j < 16; j++) {

                            printf("%c", p[mini_offset + 4]);
                            mini_offset++;
                        }

                    } else {
                        counter++;
                        printf("0x%08x ", current[i]);

                    } // ends if (coutner == 1)
                } // ends for (i = 0; i < sizeof(ManufacturingPage1_t) / 4; i++) 


                printf("\n\n\ta - Change value at offset x");
                printf("\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);

                switch (name[0]) {
                
                case 'a': { printf("\n\nEnter the dword offset you wish to change:  0x"    ); 
                            getString(choice_offset, sizeof(choice_offset), stdin);
                            index = strtoul(choice_offset, NULL, 16);

                            if (index % 4 != 0) {
                                printf("\nOffset 0x%02x incorrect.\n\nPress Return to Continue", index);
                                dogetch();

                            } else {

                                /*
                                **  Index is coming in on a byte boundary ... change to word.
                                */
                                index = index / 4;
                                printf("  \n               Please enter the new value:  0x");
                                getString(choice_offset, sizeof(choice_offset), stdin);
                                new_num = strtoul(choice_offset, NULL, 16);
                                current[index + 1] = new_num;
                                logPrint("         New Num: 0x%08lx at Offset: 0x%08lx", new_num, index);
                                logPrint("     Value now at Offset 0x%08lx is: 0x%08lx", index, current[index + 1]);
                            }
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                1,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage1_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)

            } // ends while (name != 'q')

        } // ends if (getConfigPageAction(port,

    } // ends if (getConfigPageHeader(port, 
    
    logPrint("*Leaving doManufacturingPage1()");

	return 1;
}




int doManufacturingPage2 ( MPT_PORT *port ) {
    
    int                       status;
    char                      buf[1024];
    ConfigReply_t             rep;
    pManufacturingPage2_SAS_t pbuf; // message data
    
    logPrint("*Entering doManufacturingPage2()");

    pbuf  = (pManufacturingPage2_SAS_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            2,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     2,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(ManufacturingPage2_SAS_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nManufacturing Page 2 \n");
                printf("\n\ta - Sub System ID Function 0 ........ 0x%04x", pbuf->SubSystemIDFunc0);
                printf("\n\tb - Sub System VendorID Function 0 .. 0x%04x", pbuf->SubSystemVendorIDFunc0);
                printf("\n\td - PCI Memory Diagnostic Size ...... 0x%02x", pbuf->PCIMemDiagSize);
                printf("\n\te - Sub System ID Function 1 ........ 0x%04x", pbuf->SubSystemIDFunc1);
                printf("\n\tf - Sub System VendorID Function 1 .. 0x%04x", pbuf->SubSystemVendorIDFunc1);
                printf("\n\tg - Auto Download Checksum .......... 0x%02x", pbuf->AutoDownloadChecksum);
                printf("\n\th - VendorID DeviceID Lock .......... 0x%02x", pbuf->VendorIDDeviceIDLock);
                printf("\n\ti - VendorID 0 ...................... 0x%04x", pbuf->VendorID0);
                printf("\n\tj - DeviceID 0 ...................... 0x%04x", pbuf->DeviceID0);
                printf("\n\tk - VendorID 1 ...................... 0x%04x", pbuf->VendorID1);
                printf("\n\tl - DeviceID 1 ...................... 0x%04x", pbuf->DeviceID1);
                printf("\n\t    ClassCode 0 ..................... 0x%02x%02x%02x", pbuf->ClassCode0[2], pbuf->ClassCode0[1], pbuf->ClassCode0[0]);
                printf("\n\t    ClassCode 1 ..................... 0x%02x%02x%02x", pbuf->ClassCode1[2], pbuf->ClassCode1[1], pbuf->ClassCode1[0]);
                printf("\n\tm - Hardward Configuration .......... 0x%04x", pbuf->HardwareConfig);
                printf("\n\tn - Option rom Offset 0 ............. 0x%08x", pbuf->OptionRomOffset0);
                printf("\n\to - Option rom Offset 1 ............. 0x%08x", pbuf->OptionRomOffset1);

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'o') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->SubSystemIDFunc0 = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->SubSystemVendorIDFunc0 = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->PCIMemDiagSize = strtoul(name, NULL, 16);
                            break; }
                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->SubSystemIDFunc1 = strtoul(name, NULL, 16);
                            break; }
                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->SubSystemVendorIDFunc1 = strtoul(name, NULL, 16);
                            break; }
                case 'g': { getString(name, sizeof(name), stdin);  
                            pbuf->AutoDownloadChecksum = strtoul(name, NULL, 16);
                            break; }
                case 'h': { getString(name, sizeof(name), stdin);  
                            pbuf->VendorIDDeviceIDLock = strtoul(name, NULL, 16);
                            break; }
                case 'i': { getString(name, sizeof(name), stdin);  
                            pbuf->VendorID0 = strtoul(name, NULL, 16);
                            break; }
                case 'j': { getString(name, sizeof(name), stdin);  
                            pbuf->DeviceID0 = strtoul(name, NULL, 16);
                            break; }
                //case 'k': { getString(name, sizeof(name), stdin);  
                //            pbuf->VendorID1 = strtoul(name, NULL, 16);
                //            break; }
                //case 'l': { getString(name, sizeof(name), stdin);  
                //            pbuf->DeviceID1 = strtoul(name, NULL, 16);
                //            break; }
                case 'm': { getString(name, sizeof(name), stdin);  
                            pbuf->HardwareConfig = strtoul(name, NULL, 16);
                            break; }
                case 'n': { getString(name, sizeof(name), stdin);  
                            pbuf->OptionRomOffset0 = strtoul(name, NULL, 16);
                            break; }
                case 'o': { getString(name, sizeof(name), stdin);  
                            pbuf->OptionRomOffset1 = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                               //(MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING),  // type
                                2,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage2_SAS_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doManufacturingPage2()");
    return 0;
}




int doManufacturingPage3 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    PTR_IOC_CONFIG_PAGE_MFG_PAGE_3 pbuf; // message data
    
    logPrint("*Entering doManufacturingPage3()");

    pbuf  = (PTR_IOC_CONFIG_PAGE_MFG_PAGE_3)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            3,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     3,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nManufacturing Page 3 \n");
                printf("\n\ta - Flash Time ...... 0x%02x", pbuf->FlashTime);
                printf("\n\tb - NVTime .......... 0x%02x", pbuf->NVTime);
                printf("\n\td - Flag ............ 0x%02x", pbuf->Flag);
                printf("\n\te - Runtime Config .. 0x%02x", pbuf->RuntimeConfig);
                printf("\n\tf - SGPIO Type ...... 0x%02x", pbuf->SGPIOType);
                printf("\n\tg - SGPIO Flags ..... 0x%02x", pbuf->SGPIOFlags);
                printf("\n\n\th - View/Edit GPIO Definitions");
                printf("\n\ti - View/Edit Quad Configurations");

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'g') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->FlashTime = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->NVTime = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->Flag = strtoul(name, NULL, 16);
                            break; }
                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->RuntimeConfig = strtoul(name, NULL, 16);
                            break; }
                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->SGPIOType = strtoul(name, NULL, 16);
                            break; }
                case 'g': { getString(name, sizeof(name), stdin);  
                            pbuf->SGPIOFlags = strtoul(name, NULL, 16);
                            break; }
                
                case 'h': { while (name[0] != 'q' && name[0] != 'Q') {

                                system("clear");
                                printf("\nManufacturing Page 3 -- GPIO Definitions\n");

                                printf("\n\ta - GPIO Offset 0x00 ... 0x%04x", pbuf->GPIODefinition[0]);
                                printf("\n\tb - GPIO Offset 0x01 ... 0x%04x", pbuf->GPIODefinition[1]);
                                printf("\n\td - GPIO Offset 0x02 ... 0x%04x", pbuf->GPIODefinition[2]);
                                printf("\n\te - GPIO Offset 0x03 ... 0x%04x", pbuf->GPIODefinition[3]);

                                if (HostRunIs1068Family(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
                                    printf("\n\tf - GPIO Offset 0x04 ... 0x%04x", pbuf->GPIODefinition[4]);
                                    printf("\n\tg - GPIO Offset 0x05 ... 0x%04x", pbuf->GPIODefinition[5]);
                                    printf("\n\th - GPIO Offset 0x06 ... 0x%04x", pbuf->GPIODefinition[6]);
                                    printf("\n\ti - GPIO Offset 0x07 ... 0x%04x", pbuf->GPIODefinition[7]);
                                }

                                printf("\n\tq - Quit");
                                printf("\n\n\t Selection:  ");

                                getString(name, sizeof(name), stdin);
                                if (name[0] != 'c' && name[0] <= 'i') {
                                    printf("\n\t New Value:  0x");
                                }

                                switch (name[0]) {
                                case 'a': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[0] = strtoul(name, NULL, 16);
                                            break; }
                                case 'b': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[1] = strtoul(name, NULL, 16);
                                            break; }
                                case 'd': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[2] = strtoul(name, NULL, 16);
                                            break; }
                                case 'e': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[3] = strtoul(name, NULL, 16);
                                            break; }
                                case 'f': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[4] = strtoul(name, NULL, 16);
                                            break; }
                                case 'g': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[5] = strtoul(name, NULL, 16);
                                            break; }
                                case 'h': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[6] = strtoul(name, NULL, 16);
                                            break; }
                                case 'i': { getString(name, sizeof(name), stdin);  
                                            pbuf->GPIODefinition[7] = strtoul(name, NULL, 16);
                                            break; }
                                } // ends switch (name[0])

                            } // ends while (name[0] != 'q' && name[0] != 'Q') 

                            name[0] = '?';
                            break; }
                case 'i': { while (name[0] != 'q' && name[0] != 'Q') {

                                system("clear");
                                
                                printf("\nManufacturing Page 3 -- Quad Configurations\n");

                                printf("\nQuad Configuration 0");
                                printf("\n\t a) Hot Plug Timeout ............ 0x%02x", pbuf->QuadConfig[0].HotPlugTimeout);
                                printf("\n\t b) Max Command Frames .......... 0x%02x", pbuf->QuadConfig[0].MaxCmdFrames);
                                printf("\n\t d) Gigablze Configuraiton [0] .. 0x%08x", pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[0]);
                                printf("\n\t e) Gigablze Configuraiton [1] .. 0x%08x", pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[1]);
                                printf("\n\t f) Gigablze Configuraiton [2] .. 0x%08x", pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[2]);
                                printf("\n\t g) Gigablze Configuraiton [3] .. 0x%08x", pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[3]);

                                printf("\n\nQuad Configuration 1");
                                printf("\n\t h) Hot Plug Timeout ............ 0x%02x", pbuf->QuadConfig[1].HotPlugTimeout);
                                printf("\n\t i) Max Command Frames .......... 0x%02x", pbuf->QuadConfig[1].MaxCmdFrames);
                                printf("\n\t j) Gigablze Configuraiton [0] .. 0x%08x", pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[0]);
                                printf("\n\t k) Gigablze Configuraiton [1] .. 0x%08x", pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[1]);
                                printf("\n\t l) Gigablze Configuraiton [2] .. 0x%08x", pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[2]);
                                printf("\n\t m) Gigablze Configuraiton [3] .. 0x%08x", pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[3]);

                                printf("\n\t q - Quit");
                                printf("\n\n\t Selection:  ");

                                getString(name, sizeof(name), stdin);
                                if (name[0] != 'c' && name[0] <= 'm') {
                                    printf("\n\t New Value:  0x");
                                }

                                switch (name[0]) {
                                case 'a': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].HotPlugTimeout = strtoul(name, NULL, 16);
                                            break; }
                                case 'b': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].MaxCmdFrames = strtoul(name, NULL, 16);
                                            break; }
                                case 'd': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[0] = strtoul(name, NULL, 16);
                                            break; }
                                case 'e': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[1] = strtoul(name, NULL, 16);
                                            break; }
                                case 'f': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[2] = strtoul(name, NULL, 16);
                                            break; }
                                case 'g': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[0].PhyConfig->GigablazeConfig[3] = strtoul(name, NULL, 16);
                                            break; }
                                case 'h': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].HotPlugTimeout = strtoul(name, NULL, 16);
                                            break; }
                                case 'i': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].MaxCmdFrames = strtoul(name, NULL, 16);
                                            break; }
                                case 'j': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[0] = strtoul(name, NULL, 16);
                                            break; }
                                case 'k': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[1] = strtoul(name, NULL, 16);
                                            break; }
                                case 'l': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[2] = strtoul(name, NULL, 16);
                                            break; }
                                case 'm': { getString(name, sizeof(name), stdin);  
                                            pbuf->QuadConfig[1].PhyConfig->GigablazeConfig[3] = strtoul(name, NULL, 16);
                                            break; }
                                } // ends switch (name[0])

                            } // ends while (name[0] != 'q' && name[0] != 'Q') 

                            name[0] = '?';
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                3,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doManufacturingPage3()");
    return 0;
}


int doManufacturingPage4 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pManufacturingPage4_t pbuf; // message data
    
    logPrint("*Entering doManufacturingPage4()");

    pbuf  = (pManufacturingPage4_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            4,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     4,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(ManufacturingPage4_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");
                printf("\nManufacturing Page 4 \n");
                printf("\n\ta - Info Offset 0 ........ 0x%02x", pbuf->InfoOffset0);
                printf("\n\tb - Info Size 0 .......... 0x%02x", pbuf->InfoSize0);
                printf("\n\td - Info Offset 1 ........ 0x%02x", pbuf->InfoOffset1);
                printf("\n\te - Info Size 1 .......... 0x%02x", pbuf->InfoSize1);
                printf("\n\tf - Inquiry Size ......... 0x%02x", pbuf->InquirySize);
                printf("\n\tg - Flags ................ 0x%02x", pbuf->Flags);
                printf("\n\th - IS Volume Settings ... 0x%08x", pbuf->ISVolumeSettings);
                printf("\n\ti - IM Volume Settings ... 0x%08x", pbuf->IMVolumeSettings);
                printf("\n\tj - IME Volume Settings .. 0x%08x", pbuf->IMEVolumeSettings);
                printf("\n\tk - IS Data Scrub Rate ... 0x%02x", pbuf->ISDataScrubRate);
                printf("\n\tl - IS Resync Rage ....... 0x%02x", pbuf->ISResyncRate);
                printf("\n\tm - IM Data Scrub Rate ... 0x%02x", pbuf->IMDataScrubRate);
                printf("\n\tn - IM Resync Rage ....... 0x%02x", pbuf->IMResyncRate);
                printf("\n\to - IME Data Scrub Rate .. 0x%02x", pbuf->IMEDataScrubRate);
                printf("\n\tp - IME Resync Rage ...... 0x%02x", pbuf->IMEResyncRate);
                
                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'p') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->InfoOffset0 = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->InfoSize0 = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->InfoOffset1 = strtoul(name, NULL, 16);
                            break; }
                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->InfoSize1 = strtoul(name, NULL, 16);
                            break; }
                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->InquirySize = strtoul(name, NULL, 16);
                            break; }
                case 'g': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }
                case 'h': { getString(name, sizeof(name), stdin);  
                            pbuf->ISVolumeSettings = strtoul(name, NULL, 16);
                            break; }
                case 'i': { getString(name, sizeof(name), stdin);  
                            pbuf->IMVolumeSettings = strtoul(name, NULL, 16);
                            break; }
                case 'j': { getString(name, sizeof(name), stdin);  
                            pbuf->IMEVolumeSettings = strtoul(name, NULL, 16);
                            break; }
                case 'k': { getString(name, sizeof(name), stdin);  
                            pbuf->ISDataScrubRate = strtoul(name, NULL, 16);
                            break; }
                case 'l': { getString(name, sizeof(name), stdin);  
                            pbuf->ISResyncRate = strtoul(name, NULL, 16);
                            break; }
                case 'm': { getString(name, sizeof(name), stdin);  
                            pbuf->IMDataScrubRate = strtoul(name, NULL, 16);
                            break; }
                case 'n': { getString(name, sizeof(name), stdin);  
                            pbuf->IMResyncRate = strtoul(name, NULL, 16);
                            break; }
                case 'o': { getString(name, sizeof(name), stdin);  
                            pbuf->IMEDataScrubRate = strtoul(name, NULL, 16);
                            break; }
                case 'p': { getString(name, sizeof(name), stdin);  
                            pbuf->IMEResyncRate = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                4,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage4_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doManufacturingPage4()");
    return 0;
}



int doManufacturingPage5 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pManufacturingPage5_t pbuf; // message data
    
    logPrint("*Entering doManufacturingPage5()");

    pbuf  = (pManufacturingPage5_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            5,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                     5,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(ManufacturingPage5_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nManufacturing Page 5 \n");
                printf("\n\ta - Base WWID (High) .. 0x%08x", pbuf->BaseWWID.High);
                printf("\n\tb - Base WWID (Low) ... 0x%08x", pbuf->BaseWWID.Low);
                printf("\n\td - Flags ............. 0x%02x", pbuf->Flags);
                
                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'd') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->BaseWWID.High = strtoul(name, NULL, 16);
                            break; }
                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->BaseWWID.Low = strtoul(name, NULL, 16);
                            break; }
                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                5,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage5_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doManufacturingPage5()");
    return 0;
}




int doModeSelect (MPT_PORT *port, PTR_SAS_DEVICE ptrSasDev, U32 Buffer_Size) {

    int              status;
    SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;


    logPrint("*Entering doModeSelect()");

    /*
    **  Make sure not asking for too much data
    */
    if (Buffer_Size > 0xFF) {
        Buffer_Size = 0xFF;
    }

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function	= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus			= ptrSasDev->BusNumber;
	req.TargetID	= ptrSasDev->TargetId;
	req.CDBLength	= 6;
	req.LUN[1]		= ptrSasDev->Lun;
	req.Control		= set32(MPI_SCSIIO_CONTROL_WRITE | MPI_SCSIIO_CONTROL_SIMPLEQ);
	req.CDB[0]		= 0x15;               // Mode Select(6) cmd op code
	req.CDB[1]		= 0x11;               // SP - Save Pages, PF - Use structured output
	req.CDB[2]		= 0;
	req.CDB[3]		= 0;
	req.CDB[4]		= Buffer_Size;
	req.CDB[5]		= 0;
	req.DataLength	= set32(Buffer_Size);

	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, NULL, 0, buffer3, Buffer_Size, 10);
    return status;
}



                        
int doModeSense (MPT_PORT *port, PTR_SAS_DEVICE ptrSasDev, U8 PCF, U8 Page, U8 Clear_Data, U32 Buffer_Size, U8 DBD) {

    int              status;
    SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;


    logPrint("*Entering doModeSense()");

    /*
    **  Make sure not asking for too much data
    */
    if (Buffer_Size > 0xFF) {
        Buffer_Size = 0xFF;
    }

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function	= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus			= ptrSasDev->BusNumber;
	req.TargetID	= ptrSasDev->TargetId;
	req.CDBLength	= 6;
	req.LUN[1]		= ptrSasDev->Lun;
	req.Control		= set32(MPI_SCSIIO_CONTROL_READ | MPI_SCSIIO_CONTROL_SIMPLEQ);
	req.CDB[0]		= 0x1A;               // Mode Sense(10) cmd op code
	req.CDB[1]		= DBD;                // DBD - Do not return block desriptors;
	req.CDB[2]		= (PCF << 6) | Page;  // Page Code and Page Control (PCF);
	req.CDB[3]		= 0;
	req.CDB[4]		= Buffer_Size;
	req.CDB[5]		= 0;
	req.DataLength	= set32(Buffer_Size);

	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, buffer3, Buffer_Size, NULL, 0, 10);
    return status;
}



                        
int doMptCommand(MPT_PORT *port, void *req, int reqSize, void *rep, int repSize, void *payIn, int payInSize, void *payOut, int payOutSize, int timeOut) {

	int	status;
	int extra;

	struct mpt_ioctl_command *command;
                                                                           
    //logPrint ("*Entering doMptCommand()");

	extra   = max(0, reqSize - sizeof command->MF);
	command = (struct mpt_ioctl_command *)malloc(sizeof *command + extra);

	memset(command, 0, sizeof *command);

	command->hdr.iocnum       = port->portNumber;
	command->hdr.port         = (reqSize+sizeof(SGE_SIMPLE_UNION)) << 16;
	command->timeout          = timeOut;
	command->replyFrameBufPtr = rep;
	command->dataInBufPtr     = payIn;
	command->dataOutBufPtr    = payOut;
	command->maxReplyBytes    = repSize;                            
	command->dataInSize       = payInSize;
	command->dataOutSize      = payOutSize;
	command->dataSgeOffset    = reqSize / 4;

	memcpy(command->MF, req, reqSize);

	status = ioctl(port->fileHandle, MPTCOMMAND, command);

	free(command);

    //logPrint ("*Leaving doMptCommand(%d)", status == 0);
	return status == 0;
}





int doNvdataFunctions(MPT_PORT *port) {

	int  option = -1;

    logPrint("*Entering doNvdataFunctions()");

	
	while (TRUE) {
                      
        system("clear");
        
		if (option < 0 ) {

            printf("\n*****************************************************************");
            printf("\n                     NVDATA Functions");
            printf("\n*****************************************************************");
            
            printf("\n\n\ta - Upload/Display Raw NVData image");
            printf("  \n\tb - Upload/Save NVData image - binary file");

            printf("\n\n\tq - Quit to previous menu");
            printf("\n\n\n    Selection:  ");
            
            getString( name, 256, stdin );
        
            switch (name[0]) {
            case 'a': {doDisplayNvdata(port, 0);  break;}
            case 'b': {doDisplayNvdata(port, 1);  break;} 
            case 'Q': 
            case 'q': {return 0; break;}
            }

            option = -1;
        }
    } // ends while (TRUE)

	return 0;
}





void doNvdataImage( void ) {

    unsigned int   totalBytes     = 0;
    unsigned int   nextProdId     = sizeof(CONFIG_DIR_HEADER);
    unsigned int   nextDirEntry   = sizeof(CONFIG_DIR_HEADER) + sizeof(CONFIG_PROD_ID);
    unsigned int   nextConfigPage = sizeof(CONFIG_DIR_HEADER) + sizeof(CONFIG_PROD_ID) + (sizeof(CONFIG_DIR_ENTRY)*NUM_CONFIG_PAGES);
    //unsigned int   nextDirEntry   = sizeof(CONFIG_DIR_HEADER);
    //unsigned int   nextConfigPage = sizeof(CONFIG_DIR_HEADER) + (sizeof(CONFIG_DIR_ENTRY)*NUM_CONFIG_PAGES);

    unsigned char *p, image_file_name[20];

    CONFIG_DIR_HEADER       configDirHdr;
    CONFIG_DIR_ENTRY        configDirEntry;
    PERSISTENT_PAGE_HEADER  persistPageHdr;
    CONFIG_PROD_ID          configProductionID;

    
    logPrint ("*Entering doNvdataImage()");
    
    image_file_name[0] = '\0';

    /* 
    **  get a buffer to build the nvdata image in 
    */
    ptrSasNvdataImage = (U8 *) malloc(BUFFER_SIZE);
    p                 = (unsigned char *) ptrSasNvdataImage;
    memset(p, 0, BUFFER_SIZE);

    /* 
    **  build the CONFIG_DIR_HEADER 
    */
    memset(&configDirHdr, 0, sizeof(CONFIG_DIR_HEADER));

    configDirHdr.Signature            = CONFIG_DIR_HEADER_SIGNATURE;
    configDirHdr.State                = CONFIG_DIR_HEADER_STATE_VALID;
    configDirHdr.NbrDirEntries        = NUM_CONFIG_PAGES;
    configDirHdr.NbrPersistDirEntries = NUM_PERSIST_CONFIG_PAGES;
    configDirHdr.SeepromVersion       = SasSeepromVersion;
    configDirHdr.CdhSize              = sizeof(CONFIG_DIR_HEADER) / 4;
    configDirHdr.CdeSize              = sizeof(CONFIG_DIR_ENTRY) / 4;
    configDirHdr.PphSize              = sizeof(PERSISTENT_PAGE_HEADER) / 4;      
    configDirHdr.ProdIdSize           = sizeof(CONFIG_PROD_ID) / 4;

    memcpy((void *)p, (const void *)&configDirHdr, sizeof(CONFIG_DIR_HEADER));
    totalBytes += sizeof(CONFIG_DIR_HEADER);




    /*
    **  Copy and Build the Config_Production_ID
    */
    memset(&configProductionID, 0, sizeof(CONFIG_PROD_ID));
    strcpy(configProductionID.ProductId,       CustomNvdataPtr->ProductId);
    strcpy(configProductionID.ProductRevision, CustomNvdataPtr->ProductRevision);
    strcpy(configProductionID.VendorId,        CustomNvdataPtr->VendorId);
    configProductionID.Signature =             CONFIG_PROD_ID_SIGNATURE;

    memcpy(&p[nextProdId], &configProductionID, sizeof(CONFIG_PROD_ID));
    totalBytes += sizeof(CONFIG_PROD_ID);

    

    /* 
    **
    **  Build each of the Config Pages 
    **
    */


    /*
    **  Manuf. 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_MANUFACTURING_0) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    /* 
    **  write the CONFIG_DIR_ENTRY to the buffer 
    */
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State       = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset = 0x7FFF;
    persistPageHdr.Checksum    = checksum((unsigned char *)&ptrIocConfigData->MfgPage0, sizeof(CONFIG_PAGE_MANUFACTURING_0), MPI_HEADER);

    /* 
    **  write the PERISTENT_PAGE_HEADER to the buffer 
    */
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    /* 
    **  write the Config Page (minus the MPI header to the buffer 
    */
    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage0.ChipName[0], sizeof(CONFIG_PAGE_MANUFACTURING_0)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_MANUFACTURING_0)-MPI_HEADER;

    /* 
    **  advance the offset values 
    */
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_MANUFACTURING_0)-MPI_HEADER;




    /*
    ** Manuf. 1
    */

    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State            = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits       = (sizeof(CONFIG_PAGE_MANUFACTURING_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType         = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum          = 1;
    configDirEntry.PageAddress      = 0;
    configDirEntry.IocNum           = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage1;
    configDirEntry.DwordOffset      = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->MfgPage1, sizeof(CONFIG_PAGE_MANUFACTURING_1), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage1.VPD[0], sizeof(CONFIG_PAGE_MANUFACTURING_1)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_MANUFACTURING_1)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_MANUFACTURING_1)-MPI_HEADER;




    /*
    ** Manuf. 2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->MfgPage2, sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2), MPI_HEADER);
    
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);
    
    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage2.ChipId, sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2)-MPI_HEADER);
    totalBytes += sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(IOC_CONFIG_PAGE_MFG_PAGE_2)-MPI_HEADER;




    /*
    **  Manuf. 3
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum           = 3;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage3;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);
    
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->MfgPage3, sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3), MPI_HEADER);
    
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);
    
    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage3.ChipId, sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3)-MPI_HEADER);
    totalBytes += sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3)-MPI_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(IOC_CONFIG_PAGE_MFG_PAGE_3)-MPI_HEADER;


    
    
    /*
    ** Manuf. 4
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_MANUFACTURING_4) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum           = 4;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage4;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->MfgPage4, sizeof(CONFIG_PAGE_MANUFACTURING_4), MPI_HEADER);
    
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage4.Reserved1, sizeof(CONFIG_PAGE_MANUFACTURING_4)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_MANUFACTURING_4)-MPI_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_MANUFACTURING_4)-MPI_HEADER;




    /*
    ** Manuf. 5
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_MANUFACTURING_5) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_MANUFACTURING;
    configDirEntry.PageNum           = 5;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->ManufacturingPage5;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->MfgPage5, sizeof(CONFIG_PAGE_MANUFACTURING_5), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->MfgPage5.BaseWWID, sizeof(CONFIG_PAGE_MANUFACTURING_5)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_MANUFACTURING_5)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_MANUFACTURING_5)-MPI_HEADER;




    /*
    ** IO Unit Page 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IO_UNIT_0) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IO_UNIT;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOUnitPage0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);
    
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IoUnitPage0, sizeof(CONFIG_PAGE_IO_UNIT_0), MPI_HEADER);
    
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IoUnitPage0.UniqueValue, sizeof(CONFIG_PAGE_IO_UNIT_0)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IO_UNIT_0)-MPI_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IO_UNIT_0)-MPI_HEADER;




    /*
    ** IO Unit Page 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IO_UNIT_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IO_UNIT;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOUnitPage1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("\n\n\tPage Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("\n\t\tAllocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("\n\t\t    Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("\n\t\t    DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("\n\t\t    Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IoUnitPage1, sizeof(CONFIG_PAGE_IO_UNIT_1), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IoUnitPage1.Flags, sizeof(CONFIG_PAGE_IO_UNIT_1)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IO_UNIT_1)-MPI_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IO_UNIT_1)-MPI_HEADER;




    /*
    ** IO Unit Page 2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IO_UNIT_2) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IO_UNIT;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOUnitPage2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IoUnitPage2, sizeof(CONFIG_PAGE_IO_UNIT_2), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IoUnitPage2.Flags, sizeof(CONFIG_PAGE_IO_UNIT_2)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IO_UNIT_2)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IO_UNIT_2)-MPI_HEADER;




    /*
    ** IO Unit Page 3
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IO_UNIT_3) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IO_UNIT;
    configDirEntry.PageNum           = 3;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOUnitPage3;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IoUnitPage3, sizeof(CONFIG_PAGE_IO_UNIT_3), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IoUnitPage3.GPIOCount, sizeof(CONFIG_PAGE_IO_UNIT_3)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IO_UNIT_3)-MPI_HEADER;
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IO_UNIT_3)-MPI_HEADER;




    /*
    ** IO Unit Page 4
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IO_UNIT_4) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IO_UNIT;
    configDirEntry.PageNum           = 4;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOUnitPage4;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IoUnitPage4, sizeof(CONFIG_PAGE_IO_UNIT_4), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IoUnitPage4.Reserved1, sizeof(CONFIG_PAGE_IO_UNIT_4)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IO_UNIT_4)-MPI_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IO_UNIT_4)-MPI_HEADER;




    /*
    ** IOC Page 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IOC_0) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage0, sizeof(CONFIG_PAGE_IOC_0), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage0[0].TotalNVStore, sizeof(CONFIG_PAGE_IOC_0)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_0)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_0)-MPI_HEADER;




    /*
    ** IOC Page 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IOC_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY)); 
    totalBytes += sizeof(CONFIG_DIR_ENTRY);
    
    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage1, sizeof(CONFIG_PAGE_IOC_1), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage1[0].Flags, sizeof(CONFIG_PAGE_IOC_1)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_1)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_1)-MPI_HEADER;




    /*
    * IOC Page 2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IOC_2) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage2, sizeof(CONFIG_PAGE_IOC_2), MPI_HEADER);
    
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage2[0].CapabilitiesFlags, sizeof(CONFIG_PAGE_IOC_2)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_2)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_2)-MPI_HEADER;




    /*
    * IOC Page 3
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State            = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits       = (sizeof(CONFIG_PAGE_IOC_3) - MPI_HEADER) >> 2;
    configDirEntry.PageType         = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum          = 3;
    configDirEntry.PageAddress      = 0;
    configDirEntry.IocNum           = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage3;
    configDirEntry.DwordOffset      = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage3, sizeof(CONFIG_PAGE_IOC_3), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage3[0].NumPhysDisks, sizeof(CONFIG_PAGE_IOC_3)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_3)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_3)-MPI_HEADER;




    /*
    ** IOC Page 4
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IOC_4) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum           = 4;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage4;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage4, sizeof(CONFIG_PAGE_IOC_4), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage4[0].ActiveSEP, sizeof(CONFIG_PAGE_IOC_4)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_4)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_4)-MPI_HEADER;




    /*
    * IOC Page 5
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_IOC_5) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_IOC;
    configDirEntry.PageNum           = 5;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->IOCPage5;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->IocPage5, sizeof(CONFIG_PAGE_IOC_5), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->IocPage5[0].Reserved1, sizeof(CONFIG_PAGE_IOC_5)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_IOC_5)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_IOC_5)-MPI_HEADER;


    
    
    /********************************************************
    **
    ** For the SAS pages, only create a CONFIG_DIR_ENTRY
    **
    ********************************************************/


    /*
    ** SAS IO Unit 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_IO_UNIT_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASIOUnit0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);
    logPrint("        DForce Update: 0x%02lx",force_update_ptr->SASIOUnit0);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasIoUnit0, sizeof(CONFIG_PAGE_SAS_IO_UNIT_0), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasIoUnit0.Reserved1, sizeof(CONFIG_PAGE_SAS_IO_UNIT_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_IO_UNIT_0)-MPI_EXTENDED_HEADER;
    
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_IO_UNIT_0)-MPI_EXTENDED_HEADER;




    /*
    ** SAS IO Unit 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_IO_UNIT_1) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASIOUnit1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasIoUnit1, sizeof(CONFIG_PAGE_SAS_IO_UNIT_1), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasIoUnit1.ControlFlags, sizeof(CONFIG_PAGE_SAS_IO_UNIT_1)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_IO_UNIT_1)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_IO_UNIT_1)-MPI_EXTENDED_HEADER;




    /*
    ** SAS IO Unit 2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_IO_UNIT_2) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASIOUnit2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasIoUnit2, sizeof(CONFIG_PAGE_SAS_IO_UNIT_2), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasIoUnit2.Reserved1, sizeof(CONFIG_PAGE_SAS_IO_UNIT_2)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_IO_UNIT_2)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_IO_UNIT_2)-MPI_EXTENDED_HEADER;




    /*
    ** SAS IO Unit 3
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_IO_UNIT_3) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT;
    configDirEntry.PageNum           = 3;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASIOUnit3;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasIoUnit3, sizeof(CONFIG_PAGE_SAS_IO_UNIT_3), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasIoUnit3.Reserved1, sizeof(CONFIG_PAGE_SAS_IO_UNIT_3)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_IO_UNIT_3)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_IO_UNIT_3)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Expander 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_EXPANDER_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_EXPANDER;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASExpnader0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasExpander0, 
                                           sizeof(CONFIG_PAGE_SAS_EXPANDER_0), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasExpander0.PhysicalPort, 
           sizeof(CONFIG_PAGE_SAS_EXPANDER_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_EXPANDER_0)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_EXPANDER_0)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Expander 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_EXPANDER_1) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_EXPANDER;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASExpnader1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasExpander1, 
                                           sizeof(CONFIG_PAGE_SAS_EXPANDER_1), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasExpander1.PhysicalPort, 
           sizeof(CONFIG_PAGE_SAS_EXPANDER_1)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_EXPANDER_1)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_EXPANDER_1)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Device 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_DEVICE_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASDevice0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasDevice0, sizeof(CONFIG_PAGE_SAS_DEVICE_0), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasDevice0.Slot, sizeof(CONFIG_PAGE_SAS_DEVICE_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_DEVICE_0)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_DEVICE_0)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Device 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_DEVICE_1) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASDevice1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasDevice1, sizeof(CONFIG_PAGE_SAS_DEVICE_1), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasDevice1.Reserved1, sizeof(CONFIG_PAGE_SAS_DEVICE_1)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_DEVICE_1)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_DEVICE_1)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Device 2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_DEVICE_2) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_DEVICE;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASDevice2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasDevice2, sizeof(CONFIG_PAGE_SAS_DEVICE_2), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasDevice2.PhysicalIdentifier.Low, sizeof(CONFIG_PAGE_SAS_DEVICE_2)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_DEVICE_2)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_DEVICE_2)-MPI_EXTENDED_HEADER;



    /*
     * SAS Phy 0
     */

    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State            = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits       = (sizeof(CONFIG_PAGE_SAS_PHY_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType         = MPI_CONFIG_EXTPAGETYPE_SAS_PHY;
    configDirEntry.PageNum          = 0;
    configDirEntry.PageAddress      = 0;
    configDirEntry.IocNum           = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASPhy0;
    configDirEntry.DwordOffset      = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasPhy0, sizeof(CONFIG_PAGE_SAS_PHY_0), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasPhy0.Reserved1, sizeof(CONFIG_PAGE_SAS_PHY_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_PHY_0)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_PHY_0)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Phy 1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_SAS_PHY_1) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_EXTPAGETYPE_SAS_PHY;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASPhy1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasPhy1, sizeof(CONFIG_PAGE_SAS_PHY_1), MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasPhy1.Reserved1, sizeof(CONFIG_PAGE_SAS_PHY_1)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_PHY_1)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_PHY_1)-MPI_EXTENDED_HEADER;




    /*
    ** SAS Enclosure 0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State            = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits       = (sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType         = MPI_CONFIG_EXTPAGETYPE_ENCLOSURE;
    configDirEntry.PageNum          = 0;
    configDirEntry.PageAddress      = 0;
    configDirEntry.IocNum           = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASEnclosure0;
    configDirEntry.DwordOffset      = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->SasEnclosure0, sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0),MPI_EXTENDED_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->SasEnclosure0.Reserved1, sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0)-MPI_EXTENDED_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_SAS_ENCLOSURE_0)-MPI_EXTENDED_HEADER;




    /*
    ** IOC_CONFIG_PAGE_PERSISTENT_ID
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(IOC_CONFIG_PAGE_PERSISTENT_ID) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType          = IOC_MPI_CONFIG_PAGETYPE_PERSIST_ID;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->SASPersistentID;
    configDirEntry.DwordOffset       = 0x7FFF;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    /* 
    **  write the CONFIG_DIR_ENTRY to the buffer 
    */
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    /* 
    **  advance the offset values 
    */
    nextDirEntry   += sizeof(CONFIG_DIR_ENTRY);




    /*
    ** CONFIG_PAGE_RAID_VOL_0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_RAID_VOL_0) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_RAID_VOLUME;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->RAIDVol0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->RaidVolPage0, sizeof(CONFIG_PAGE_RAID_VOL_0), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->RaidVolPage0.VolumeID, sizeof(CONFIG_PAGE_RAID_VOL_0)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_RAID_VOL_0)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_RAID_VOL_0)-MPI_HEADER;




    /*
    ** CONFIG_PAGE_RAID_VOL_1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_RAID_VOL_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_RAID_VOLUME;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->RAIDVol1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes                 += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->RaidVolPage1,  sizeof(CONFIG_PAGE_RAID_VOL_1), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->RaidVolPage1.VolumeID, sizeof(CONFIG_PAGE_RAID_VOL_1)-MPI_HEADER); totalBytes += sizeof(CONFIG_PAGE_RAID_VOL_1)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_RAID_VOL_1)-MPI_HEADER;




    /*
    ** CONFIG_PAGE_RAID_PHYS_DISK_0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_RAID_PHYSDISK;
    configDirEntry.PageNum           = 0;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->RAIDPhysDisk0;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->RaidPhysDiskPage0, sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->RaidPhysDiskPage0.PhysDiskID, sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_RAID_PHYS_DISK_0)-MPI_HEADER;




    /*
    ** CONFIG_PAGE_RAID_PHYS_DISK_1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_RAID_PHYS_DISK_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_RAID_PHYSDISK;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->RAIDPhysDisk1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->RaidPhysDiskPage1, sizeof(CONFIG_PAGE_RAID_PHYS_DISK_1),  MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->RaidPhysDiskPage1.NumPhysDiskPaths, sizeof(CONFIG_PAGE_RAID_PHYS_DISK_1)-MPI_HEADER);  totalBytes += sizeof(CONFIG_PAGE_RAID_PHYS_DISK_1)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_RAID_PHYS_DISK_1)-MPI_HEADER;




    /*
    ** CONFIG_PAGE_BIOS_1
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_BIOS_1) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_BIOS;
    configDirEntry.PageNum           = 1;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->BIOS1;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->Bios1, sizeof(CONFIG_PAGE_BIOS_1), MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->Bios1.BiosOptions, sizeof(CONFIG_PAGE_BIOS_1)-MPI_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_BIOS_1)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_BIOS_1)-MPI_HEADER;




    /*
    ** CONFIG_PAGE_BIOS_2
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State             = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits        = (sizeof(CONFIG_PAGE_BIOS_2) - MPI_HEADER) >> 2;
    configDirEntry.PageType          = MPI_CONFIG_PAGETYPE_BIOS;
    configDirEntry.PageNum           = 2;
    configDirEntry.PageAddress       = 0;
    configDirEntry.IocNum            = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->BIOS2;
    configDirEntry.DwordOffset       = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->Bios2,  sizeof(CONFIG_PAGE_BIOS_2),  MPI_HEADER);

    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->Bios2.Reserved1, sizeof(CONFIG_PAGE_BIOS_2)-MPI_HEADER); totalBytes += sizeof(CONFIG_PAGE_BIOS_2)-MPI_HEADER;

    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_BIOS_2)-MPI_HEADER;



    /*
    ** CONFIG_PAGE_LOG_0
    */
    memset(&configDirEntry, 0, sizeof(CONFIG_DIR_ENTRY));

    configDirEntry.State            = CONFIG_DIR_ENTRY_STATE_IN_USE;
    configDirEntry.AllocUnits       = (sizeof(CONFIG_PAGE_LOG_0) - MPI_EXTENDED_HEADER) >> 2;
    configDirEntry.PageType         = MPI_CONFIG_EXTPAGETYPE_LOG;
    configDirEntry.PageNum          = 0;
    configDirEntry.PageAddress      = 0;
    configDirEntry.IocNum           = 0;
    configDirEntry.ForceNvdataUpdate = force_update_ptr->LOG0;
    configDirEntry.DwordOffset      = nextConfigPage >> 2;

    logPrint("     Page Type: 0x%x ... Page Number: 0x%x",configDirEntry.PageType,configDirEntry.PageNum);
    logPrint("     Allocation Units: 0x%08lx",configDirEntry.AllocUnits);
    logPrint("         Page Address: 0x%08lx",configDirEntry.PageAddress);
    logPrint("         DWord Offset: 0x%08lx",configDirEntry.DwordOffset);
    logPrint("         Force Update: 0x%08lx",configDirEntry.ForceNvdataUpdate);

    /* write the CONFIG_DIR_ENTRY to the buffer */
    memcpy(&p[nextDirEntry], &configDirEntry, sizeof(CONFIG_DIR_ENTRY));
    totalBytes += sizeof(CONFIG_DIR_ENTRY);

    persistPageHdr.State        = CONFIG_PERSISTENT_HEADER_STATE_UPDATE_COMPLETE;
    persistPageHdr.DwordOffset  = 0x7FFF;
    persistPageHdr.Checksum     = checksum((unsigned char *)&ptrIocConfigData->Log0,
                                           sizeof(CONFIG_PAGE_LOG_0),
                                           MPI_EXTENDED_HEADER);

    /* write the PERISTENT_PAGE_HEADER to the buffer */
    memcpy(&p[nextConfigPage], &persistPageHdr, sizeof(PERSISTENT_PAGE_HEADER));
    totalBytes += sizeof(PERSISTENT_PAGE_HEADER);

    /* write the Config Page (minus the MPI header to the buffer */
    memcpy(&p[nextConfigPage]+sizeof(PERSISTENT_PAGE_HEADER), &ptrIocConfigData->Log0.Reserved1, 
               sizeof(CONFIG_PAGE_LOG_0)-MPI_EXTENDED_HEADER);
    totalBytes += sizeof(CONFIG_PAGE_LOG_0)-MPI_EXTENDED_HEADER;


    /* advance the offset values */
    nextDirEntry += sizeof(CONFIG_DIR_ENTRY);
    nextConfigPage += sizeof(PERSISTENT_PAGE_HEADER) + sizeof(CONFIG_PAGE_LOG_0)-MPI_EXTENDED_HEADER;


















    /*
    ** Fill in the length of the NVDATA in the CONFIG_DIR_HEADER
    */
    configDirHdr.TotalBytes = totalBytes;
    NvDataImageLen = totalBytes;

    /* 
    ** Now, rewrite at the beginning, again, the CONFIG_DIR_HEADER
    */
    memcpy((void *)p, (const void *)&configDirHdr, sizeof(CONFIG_DIR_HEADER));


    /*
    **  I want to save this to possibly use in the future .... comment off for now.
    */
#if dsf
    if (flag_ptr->SaveDefaults == TRUE) {
        /*
        **  Get the filename
        */
        while (image_file_name[0] == '\0') {

            if (strcmp(flag_ptr->FileName, "UNKNOWN") == 0) {

                printf("\n\nEnter name of output file:  ");

                gets(image_file_name);

                if(strlen(image_file_name) == 0) {
                    continue;
                }

                strcpy(flag_ptr->FileName, image_file_name);

            } else {
                strcpy(image_file_name, flag_ptr->FileName);
            }

        }  // end while loop

        /* open the output file, BINARY format */

        fPtr = fopen(image_file_name,"wb");

        for (i=0; i<totalBytes; i++)
        {
                fprintf(fPtr, "%c", p[i] );
        }

        fclose(fPtr);
    }
#endif
}




int doPHYPage0 (MPT_PORT *port) {
    
    int                   status, i, loop;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasPhyPage0_t pbuf; // message data
    
    logPrint("*Entering doPHYPage0()");

    pbuf  = (pSasPhyPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_PHY,  // type
                            0,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        if (HostRunIs1064Family(flag_ptr) || HostRunIs1064EFamily(flag_ptr)) {
            loop = 4;
        } else if (HostRunIs1068Family(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
            loop = 8;
        }


        for (i = 0; i < loop; i++) {

            /*
            **  Okay ... let's read the page ....
            */
            status = getConfigPageAction(port,                               // adapter
                                         MPI_CONFIG_ACTION_PAGE_READ_CURRENT,  // action
                                         MPI_CONFIG_EXTPAGETYPE_SAS_PHY, // type
                                         0,                                  // page number
                                         i,                                  // address
                                         buf, 
                                         sizeof(SasPhyPage0_t));

            if (status == MPI_IOCSTATUS_SUCCESS) {

                /*
                **  Let's display the data
                */
                if (i == 0 || i == 2 || i == 4 || i == 6) {
                    system("clear");
                    printf("\nSAS PHY Page 0");
                }

                printf("\n\n PHY %d", i);
                printf("\n\t SAS Address (High) ....... 0x%08x", pbuf->SASAddress.High);
                printf("\n\t SAS Address (Low) ........ 0x%08x", pbuf->SASAddress.Low);
                printf("\n\t Attached Dev Handle ...... 0x%04x", pbuf->AttachedDevHandle);
                printf("\n\t Attached PHY Identifier .. 0x%02x", pbuf->AttachedPhyIdentifier);
                printf("\n\t Attached Device Info ..... 0x%08x", pbuf->AttachedDeviceInfo);
                printf("\n\t Programmed Link Rate ..... 0x%02x", pbuf->ProgrammedLinkRate);
                printf("\n\t Hardward Link Rate ....... 0x%02x", pbuf->HwLinkRate);
                printf("\n\t Change Count ............. 0x%02x", pbuf->ChangeCount);
                printf("\n\t PHY Information .......... 0x%08x", pbuf->PhyInfo);

                if (i == 1 || i == 3 || i == 5 || i == 7) {
                    printf("\n\nPress Return to Continue");
                    dogetch();
                }
            } // ends for (i = 0; i < pbuf->NumPhys; i++)
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doPHYPage0()");
    return 0;
}




int doPHYPage1 (MPT_PORT *port) {
    
    int                   status, i, loop;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasPhyPage1_t pbuf; // message data
    
    logPrint("*Entering doPHYPage1()");

    pbuf  = (pSasPhyPage1_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_PHY,  // type
                            1,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        if (HostRunIs1064Family(flag_ptr) || HostRunIs1064EFamily(flag_ptr)) {
            loop = 4;
        } else if (HostRunIs1068Family(flag_ptr) || HostRunIs1068EFamily(flag_ptr)) {
            loop = 8;
        }

        for (i = 0; i < loop; i++) {

            /*
            **  Okay ... let's read the page ....
            */
            status = getConfigPageAction(port,                               // adapter
                                         MPI_CONFIG_ACTION_PAGE_READ_CURRENT,  // action
                                         MPI_CONFIG_EXTPAGETYPE_SAS_PHY, // type
                                         1,                                  // page number
                                         i,                                  // address
                                         buf, 
                                         sizeof(SasPhyPage1_t));

            if (status == MPI_IOCSTATUS_SUCCESS) {

                /*
                **  Let's display the data
                */
                if (i == 0 || i == 2 || i == 4 || i == 6) {
                    system("clear");
                    printf("\nSAS PHY Page 0");
                }

                printf("\n\n PHY %d", i);
                printf("\n\t Invalid DWord Count ............ 0x%04x", pbuf->InvalidDwordCount);
                printf("\n\t Running Disparity Error Count .. 0x%02x", pbuf->RunningDisparityErrorCount);
                printf("\n\t Loss DWord Synch Count ......... 0x%08x", pbuf->LossDwordSynchCount);
                printf("\n\t PHY Reset Problem Count ........ 0x%02x", pbuf->PhyResetProblemCount);


                if (i == 1 || i == 3 || i == 5 || i == 7) {
                    printf("\n\nPress Return to Continue");
                    dogetch();
                }
            } // ends for (i = 0; i < pbuf->NumPhys; i++)
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doPHYPage0()");
    return 0;
}




int doPort(MPT_PORT *port) {

	int  option = -1;

    logPrint("*Entering doPort()");

	
	while (TRUE) {
                      
        system("clear");

        getWhatFromFirmware(port);

        if (option < 0) {

            /*
            **  Legacy refered to as customer version
            */
            printf("\nLSI Logic Corp. SAS Serial EEPROM / Flash Utility");
            //printf("\nMPTUtil -- Version: %s (%s) ** FOR TEST PURPOSES ONLY **", mptutil_version, mptutil_build);
            printf("\nMPTUtil -- Version: %s (%s)", mptutil_version, mptutil_build);
            printf("\nCopyright (C) 2005 LSI Logic Corporation.  All rights reserved. ");
            printf("\n*****************************************************************");

            //if (port->fwVersion != -1) {
            //    printf("\nCurrent Firmware: 0x%05x", port->fwVersion);
            //} else {
            //    printf("\nCurrent Firmware: %02x.%02x.%02x.%02x (Hex)", 
            //           port->fwVersion_new.Struct.Major,
            //           port->fwVersion_new.Struct.Minor, 
            //           port->fwVersion_new.Struct.Unit,
            //           port->fwVersion_new.Struct.Dev);
            //}                                          
            printf("\nCurrent Firmware: %s", flag_ptr->FirmwareWhat);

            if (HostRunIs1064Family(flag_ptr)) {
                printf(" -- SAS 1064");
            } else if (HostRunIs1068Family(flag_ptr)) {
                printf(" -- SAS 1068");
            } else if (HostRunIs1064EFamily(flag_ptr)) {
                printf(" -- SAS 1064E");
            } else if (HostRunIs1068EFamily(flag_ptr)) {
                printf(" -- SAS 1068E");
            } else {
                printf(" -- Unknown");
            }

            printf("\nCurrent x86 BIOS: %s", flag_ptr->x86BIOSWhat);

            printf("\n*****************************************************************");

            if (mptutil == FALSE ) {

                printf("\n\nFLASH");
                printf("\n\ta - Update Firmware");
                printf("\n\tb - Update BIOS\n");
                printf("\n\tc - Upload current firmware to a file");
                printf("\n\td - Upload current BIOS to a file");

                printf("\n\nCONFIGURATION");
                printf("\n\tl - Manage configuration settings");

                printf("\n\nMISC");
                printf("\n\tz - Change adapters");
                printf("\n\tq - Quit");

                printf("\n\nSelection:  ");

                getString( name, 256, stdin );

                switch (name[0]) {
                case 'a': {doFirmwareDownload(port);               break;}
                case 'b': {doBiosFcodeDownload(port);              break;}                         
                case 'c': {doFirmwareUpload(port);                 break;}
                case 'd': {doBiosUpload(port);                     break;}
                //case 'd': {doBiosFcodeUpload(port, NULL, NULL, 0); break;}
                case 'l': {doConfigurationPage(port);              break;}
                //case 'y': {doFirmwareDownloadBoot(port);           break;}
                case 'z': {return 1; break;}
                case 'Q': 
                case 'q': {return 0; break;}
                }

                option = -1;

            } else {

                printf("\n\ta - Update Firmware");
                printf("\n\tb - Update BIOS\n");
                printf("\n\tc - Upload current firmware to a file");
                printf("\n\td - Upload current BIOS to a file\n");

                printf("\n\tk - Write/Read Buffer Test\n");
                printf("\n\tl - Manage configuration settings");
                printf("\n\tm - Manage NVDATA functions\n");

#ifdef __KERNEL_2_4__
                printf("\n\tx - Toolbox");
#endif
                printf("\n\tz - Change adapters");
                printf("\n\tq - Quit");

                printf("\n\nSelection:  ");
                getString( name, 256, stdin );

                switch (name[0]) {
                case 'a': {doFirmwareDownload(port);               break;}
                case 'b': {doBiosFcodeDownload(port);              break;}                         
                case 'c': {doFirmwareUpload(port);                 break;}
                case 'd': {doBiosUpload(port);                     break;}
                case 'k': {doWriteReadBufferTest(port);            break;}
                case 'l': {doConfigurationPage(port);              break;}
                case 'm': {doNvdataFunctions(port);                break;}

#ifdef __KERNEL_2_4__
                case 'x': {doToolBox(port);                        break;}
#endif 
                
                case 'z': {return 1; break;} 
                case 'Q': 
                case 'q': {return 0; break;}
                }

                option = -1;


            } // ends if (mptutil == FALSE )
        } // ends if (option < 0)
    } // ends while (TRUE)

	return 0;
}




int doReadBuffer (MPT_PORT *port, int bus, int target, int lun, int mode, U32 size) {

    int              status;
	SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function			= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus					= bus;
    req.TargetID			= target;
	req.CDBLength			= 10;
	req.LUN[1]				= lun;
	req.Control				= set32(MPI_SCSIIO_CONTROL_READ | MPI_SCSIIO_CONTROL_UNTAGGED);
	req.CDB[0]				= 0x3C;  // Read Bufffer cmd op code
	req.CDB[1]				= mode;  // Read Bufffer MODE field
    req.CDB[6]				= size >> 16;   // Read Bufffer cmd op code
    req.CDB[7]				= size >> 8;    // Read Bufffer cmd op code
    req.CDB[8]				= size & 0xFF;  // Read Bufffer cmd op code

	req.DataLength			= set32(size);

	//status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, inq_data, sizeof(inq_data), NULL, 0, 10);
	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, buffer3, size, NULL, 0, 10);

    if (status == 1 && mode == 0x3) {

        /*
        **  I need to get the read buffer capacity
        */ 
        logPrint("     Raw Buffer:  0x%02x 0x%02x 0x%02x 0x%02x", buffer3[0], buffer3[1], buffer3[2], buffer3[3]);
        ptrSasDev->BufferSize = (U32) ( (buffer3[1] << 16)  | (buffer3[2] << 8) | buffer3[3]);
        ptrSasDev->BufferSize = ptrSasDev->BufferSize & 0xFFFF00;

        /*
        **  See if the buffer is larger than our buffer
        */
        if (ptrSasDev->BufferSize > GLOBAL_MEMORY_BYTES) {
            ptrSasDev->BufferSize = GLOBAL_MEMORY_BYTES;
        }

        logPrint("     tBuffer capacity:  0x%06x", ptrSasDev->BufferSize);

    }

    return status;
}






int doReadCapacity(MPT_PORT *port, int bus, int target, int lun) {

    int              status;
	unsigned char	 cap[8];
    U32              MaxLBA, BlockLength;
	SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;


    logPrint("*Entering doReadCapacity()");

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function	= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus			= bus;
	req.TargetID	= target;
	req.CDBLength	= 10;
	req.LUN[1]		= lun;
	req.Control		= set32(MPI_SCSIIO_CONTROL_READ | MPI_SCSIIO_CONTROL_SIMPLEQ);
	req.CDB[0]		= 0x25;
	req.CDB[1]		= 0;
	req.CDB[2]		= 0;
	req.CDB[3]		= 0;
	req.CDB[4]		= 0;
	req.CDB[5]		= 0;
	req.CDB[6]		= 0;
	req.CDB[7]		= 0;
	req.CDB[8]		= 0;
	req.CDB[9]		= 0;
	req.DataLength	= set32(sizeof(cap));

	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, cap, sizeof(cap), NULL, 0, 10);
                                
    if (status == 1) {

        BlockLength = ((cap[4] << 24) | (cap[5] << 16) | (cap[6] << 8) | cap[7]);
        MaxLBA      = ((cap[0] << 24) | (cap[1] << 16) | (cap[2] << 8) | cap[3]);
        MaxLBA      = MaxLBA + 1;

        ptrSasDev->Capacity = ((MaxLBA / 1048576) * BlockLength / 1024);  // move it to GB
        
        logPrint("     Block Length: %u", BlockLength);
        logPrint("          Max LBA: %u", MaxLBA);
        logPrint("         Capacity: %.2f", ptrSasDev->Capacity);
    }

    return status;

}






int doResetPort(MPT_PORT *port, U32 type) {

    int                           status;
	struct mpt_ioctl_diag_reset  *diag_reset;

    logPrint("*Entering doResetPort()");

    diag_reset = (struct mpt_ioctl_diag_reset *)malloc(sizeof *diag_reset);

	memset(diag_reset, 0, sizeof *diag_reset);

	diag_reset->hdr.iocnum = port->portNumber;

	printf("Resetting port...\n");

	status = ioctl(port->fileHandle, type, diag_reset);
    //printf("\n\n\tDiag Reset Status: %d", status);

	free(diag_reset);

	return status == 0;
}



void doSASAddress ( MPT_PORT *port ) {

    int                            status, i;
    char                           buf[1024], SasAdrstag[20], tracertag[16], assemblytag[16];
    U32                            SasAdrstmp[2];
    ConfigReply_t		           rep;
	pManufacturingPage0_t          pMan0;
	pManufacturingPage2_SAS_t      pMan2;
    pManufacturingPage4_t          pMan4;
    pManufacturingPage5_t          pMan5;
    

    system("clear");

    logPrint("*Entering doSASAddress()");
    printf("\n\nProcessing Cfg. Pages to be written with persistency...");


    /*
    **  Let's scan the SAS address
    */
    Scan(SasAdrstag, tracertag, assemblytag, 1);

    /*
    **  Update SAS Adrs areas
    */
    sscanf(SasAdrstag + 8, "%x", &(SasAdrstmp[1]));
    SasAdrstag[8] = 0;
    sscanf(SasAdrstag,     "%x", &(SasAdrstmp[0]));

    /*
    **  Let's write the address out to the configuration page.
    */
    pMan5 = (pManufacturingPage5_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            5,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     5,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage5_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            pMan5->Header.PageLength       = (sizeof(ManufacturingPage5_t) / 4);
            pMan5->Header.PageNumber       = 5;
            pMan5->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan5->Header.PageVersion      = MPI_MANUFACTURING5_PAGEVERSION;

            pMan5->BaseWWID.High = SasAdrstmp[0];
            pMan5->BaseWWID.Low  = SasAdrstmp[1];

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                5,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage5_t)); 
        }
    } // Finishes Manufacturing Page 5

    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }

    /*
    **  Lets set Tracer and Assembly information in Man0.
    */
    
    pMan0 = (pManufacturingPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            0,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     0,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage0_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {
            
            pMan0->Header.PageLength       = (sizeof(ManufacturingPage0_t) / 4);
            pMan0->Header.PageNumber       = 0;
            pMan0->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan0->Header.PageVersion      = MPI_MANUFACTURING0_PAGEVERSION;

            strcpy(pMan0->BoardAssembly,     "Unspecified");
            strcpy(pMan0->BoardTracerNumber, "Unspecified");

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                0,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage0_t)); 
        }
    } // Finishes Manufacturing Page 0


    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }


    /*
    **  On to manufacturing page 2.
    */
    pMan2 = (pManufacturingPage2_SAS_t)buf;


    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            2,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     2,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage2_SAS_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {
            
            pMan2->ChipId.DeviceID      = port->deviceId;
            pMan2->ChipId.PCIRevisionID = port->revisionId;
            pMan2->Header.PageLength    = (sizeof(ManufacturingPage2_SAS_t) / 4);
            pMan2->Header.PageNumber    = 2;
            pMan2->Header.PageType      = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan2->Header.PageVersion   = MPI_MANUFACTURING2_PAGEVERSION;

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                2,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage2_SAS_t)); 
        }
    } // Finishes Manufacturing Page 2

    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }

    /*
    **  On to manufacturing page 4.
    */
    
    pMan4 = (pManufacturingPage4_t)buf;


    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            4,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     4,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage4_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            pMan4->Header.PageLength       = (sizeof(ManufacturingPage4_t) / 4);
            pMan4->Header.PageNumber       = 4;
            pMan4->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan4->Header.PageVersion      = MPI_MANUFACTURING4_PAGEVERSION;

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                4,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage4_t)); 
        }
    } // Finishes Manufacturing Page 4


    logPrint("*Leaving doSASAddress()");
}









int doSASIOUnitPage0 (MPT_PORT *port) {
    
    int                   status, i;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasIOUnitPage0_t pbuf; // message data
    
    logPrint("*Entering doSASIOUnitPage0()");

    pbuf  = (pSasIOUnitPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT,  // type
                            0,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_CURRENT,  // action
                                     MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                     0,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(SasIOUnitPage0_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            
            for (i = 0; i < pbuf->NumPhys; i++) {

                if (i == 0 || i == 2 || i == 4 || i == 6) {
                    system("clear");
                    printf("\nSAS IOUnit Page 0");
                }

                if (i == 0) {
                    printf("\n\tNumber of PHY's ............. 0x%02x", pbuf->NumPhys);
                }

                printf("\n\n PHY %d", i);
                printf("\n\t Port ........................ 0x%02x", pbuf->PhyData[i].Port);
                printf("\n\t Port Flags .................. 0x%02x", pbuf->PhyData[i].PortFlags);
                printf("\n\t PHY Flags ................... 0x%02x", pbuf->PhyData[i].PhyFlags);
                printf("\n\t Negotiated Link Rate ........ 0x%02x", pbuf->PhyData[i].NegotiatedLinkRate);
                printf("\n\t Controller PHY Device Info .. 0x%08x", pbuf->PhyData[i].ControllerPhyDeviceInfo);
                printf("\n\t Attached Device Handle ...... 0x%04x", pbuf->PhyData[i].AttachedDeviceHandle);
                printf("\n\t Controller Dev Handle ....... 0x%04x", pbuf->PhyData[i].ControllerDevHandle);
                printf("\n\t Discovery Status ............ 0x%08x", pbuf->PhyData[i].DiscoveryStatus);

                if (i == 1 || i == 3 || i == 5 || i == 7) {
                    printf("\n\nPress Return to Continue");
                    dogetch();
                }
            } // ends for (i = 0; i < pbuf->NumPhys; i++)
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doSASIOUnitPage0()");
    return 0;
}




int doSASIOUnitPage1 (MPT_PORT *port) {
    
    int                   status, i;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasIOUnitPage1_t pbuf; // message data
    
    logPrint("*Entering doSASIOUnitPage1()");

    pbuf  = (pSasIOUnitPage1_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT,  // type
                            1,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                     1,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(SasIOUnitPage1_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nSAS IOUnit Page 1 \n");
                printf("\n\ta - Control Flags ............... 0x%04x", pbuf->ControlFlags);
                printf("\n\tb - Max Number of SATA Targets .. 0x%04x", pbuf->MaxNumSATATargets);
                printf("\n\td - Number of PHY's ............. 0x%02x", pbuf->NumPhys);
                printf("\n\te - SATA Max QDepth ............. 0x%02x", pbuf->SATAMaxQDepth);
                printf("\n\tf - Display all (%d) PHY entries", pbuf->NumPhys);
                printf("\n\n\tg - %c: PHY entry to change (0 - %d)", pbuf->NumPhys+'g', pbuf->NumPhys); 

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] !=  'c' && name[0] <= 'e') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->ControlFlags = strtoul(name, NULL, 16);
                            break; }

                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxNumSATATargets = strtoul(name, NULL, 16);
                            break; }

                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->NumPhys = strtoul(name, NULL, 16);
                            break; }

                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->SATAMaxQDepth = strtoul(name, NULL, 16);
                            break; }

                case 'f': { for (i = 0; i < pbuf->NumPhys; i++) {

                                if (i == 0 || i == 3 || i == 6) {
                                    system("clear");
                                }

                                printf("\n\n\t Port ........................ 0x%02x", pbuf->PhyData[i].Port);
                                printf("\n\t Port Flags .................. 0x%02x", pbuf->PhyData[i].PortFlags);
                                printf("\n\t PHY Flags ................... 0x%02x", pbuf->PhyData[i].PhyFlags);
                                printf("\n\t Max/Min Link Rate ........... 0x%02x", pbuf->PhyData[i].MaxMinLinkRate);
                                printf("\n\t Controller PHY Device Info .. 0x%08x", pbuf->PhyData[i].ControllerPhyDeviceInfo);

                                if (i == 2 || i == 5 || i == 8) {
                                    printf("\n\nPress Return to Continue");
                                    dogetch();
                                }
                            }
                            printf("\nPress Return to Continue");
                            dogetch();
                            break; }

                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                1,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(SasIOUnitPage1_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }

                default:  { if (name[0] >= 'g' && name[0] <= 'g' + pbuf->NumPhys) {
                                i = name[0] - 'g';
                                logPrint("      Char: %c", name[0]);
                                logPrint("     Value: %d", i);

                                while (name[0] != 'q' && name[0] != 'Q') {
                                    system("clear");
                                    printf("\n\nSettings for PHY %d", i);
                                    printf("\n\t a - Port ........................ 0x%02x", pbuf->PhyData[i].Port);
                                    printf("\n\t b - Port Flags .................. 0x%02x", pbuf->PhyData[i].PortFlags);
                                    printf("\n\t d - PHY Flags ................... 0x%02x", pbuf->PhyData[i].PhyFlags);
                                    printf("\n\t e - Max/Min Link Rate ........... 0x%02x", pbuf->PhyData[i].MaxMinLinkRate);
                                    printf("\n\t f - Controller PHY Device Info .. 0x%08x", pbuf->PhyData[i].ControllerPhyDeviceInfo);
                                    printf("\n\n\t q - Quit");
                                    
                                    printf("\n\n\t Selection:  ");

                                    getString(name, sizeof(name), stdin);
                                    printf("\n\t New Value:  0x");

                                    switch (name[0]) {
                                    
                                    case 'a': { getString(name, sizeof(name), stdin);  
                                                pbuf->PhyData[i].Port = strtoul(name, NULL, 16);
                                                break; }

                                    case 'b': { getString(name, sizeof(name), stdin);  
                                                pbuf->PhyData[i].PortFlags = strtoul(name, NULL, 16);
                                                break; }

                                    case 'd': { getString(name, sizeof(name), stdin);  
                                                pbuf->PhyData[i].PhyFlags = strtoul(name, NULL, 16);
                                                break; }

                                    case 'e': { getString(name, sizeof(name), stdin);  
                                                pbuf->PhyData[i].MaxMinLinkRate = strtoul(name, NULL, 16);
                                                break; }

                                    case 'f': { getString(name, sizeof(name), stdin);  
                                                pbuf->PhyData[i].ControllerPhyDeviceInfo = strtoul(name, NULL, 16);
                                                break; }

                                    case 'Q': 
                                    case 'q': { break; }

                                    } // ends switch (name[0]) 
                                } // ends while (name[0] != 'q' && name[0] != 'Q')
                                name[0] = '?';
                            }
                            break;}

                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doSASIOUnitPage1()");
    return 0;
}




int doSASIOUnitPage2 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasIOUnitPage2_t pbuf; // message data
    
    logPrint("*Entering doSASIOUnitPage2()");

    pbuf  = (pSasIOUnitPage2_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT,  // type
                            2,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                     2,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(SasIOUnitPage2_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nSAS IOUnit Page 2 \n");
                printf("\n\ta - Max Persistent IDs ............... 0x%04x", pbuf->MaxPersistentIDs);
                printf("\n\tb - Number of Persistent IDs Used .... 0x%04x", pbuf->NumPersistentIDsUsed);
                printf("\n\td - Status ........................... 0x%02x", pbuf->Status);
                printf("\n\te - Flags ............................ 0x%02x", pbuf->Flags);
                printf("\n\tf - Max Number Physical Mapped ID's .. 0x%04x", pbuf->MaxNumPhysicalMappedIDs);

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'f') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxPersistentIDs = strtoul(name, NULL, 16);
                            break; }

                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->NumPersistentIDsUsed = strtoul(name, NULL, 16);
                            break; }

                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->Status = strtoul(name, NULL, 16);
                            break; }

                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->Flags = strtoul(name, NULL, 16);
                            break; }

                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxNumPhysicalMappedIDs = strtoul(name, NULL, 16);
                            break; }


                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                2,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(SasIOUnitPage2_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doSASIOUnitPage2()");
    return 0;
}




int doSASIOUnitPage3 (MPT_PORT *port) {
    
    int                   status;
    char                  buf[1024];
    ConfigReply_t         rep;
    pSasIOUnitPage3_t pbuf; // message data
    
    logPrint("*Entering doSASIOUnitPage3()");

    pbuf  = (pSasIOUnitPage3_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                                // adapter
                            MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT,  // type
                            3,                                   // page number
                            0,                                   // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        logPrint("     Failed to read page header -- that page might not exist\n\n");
        return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                               // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_NVRAM,  // action
                                     MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                     3,                                  // page number
                                     0,                                  // address
                                     buf, 
                                     sizeof(SasIOUnitPage3_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            /*
            **  Let's display the data
            */
            while (name[0] != 'q' && name[0] != 'Q') {

                system("clear");

                printf("\nSAS IOUnit Page 3 \n");
                printf("\n\ta - Max Invalid DWord Count ............ 0x%08x", pbuf->MaxInvalidDwordCount);
                printf("\n\tb - Invalid DWord Count Time ........... 0x%08x", pbuf->InvalidDwordCountTime);
                printf("\n\td - Max Running Disparity Error Count .. 0x%08x", pbuf->MaxRunningDisparityErrorCount);
                printf("\n\te - Running Disparity Error Count ...... 0x%08x", pbuf->RunningDisparityErrorTime);
                printf("\n\tf - Max Loss DWord Synch Count ......... 0x%08x", pbuf->MaxLossDwordSynchCount);
                printf("\n\tg - Loss DWord Synch Count Time ........ 0x%08x", pbuf->LossDwordSynchCountTime);
                printf("\n\th - Max PHY Reset Problem Count ........ 0x%08x", pbuf->MaxPhyResetProblemCount);
                printf("\n\ti - PHY Reset Problem Time ............. 0x%08x", pbuf->PhyResetProblemTime);

                printf("\n\n\tc - Commit Changes");
                printf("\n\tq - Quit");
                printf("\n\n\t Selection:  ");

                getString(name, sizeof(name), stdin);
                if (name[0] != 'c' && name[0] <= 'i') {
                    printf("\n\t New Value:  0x");
                }

                switch (name[0]) {
                
                case 'a': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxInvalidDwordCount = strtoul(name, NULL, 16);
                            break; }

                case 'b': { getString(name, sizeof(name), stdin);  
                            pbuf->InvalidDwordCountTime = strtoul(name, NULL, 16);
                            break; }

                case 'd': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxRunningDisparityErrorCount = strtoul(name, NULL, 16);
                            break; }

                case 'e': { getString(name, sizeof(name), stdin);  
                            pbuf->RunningDisparityErrorTime = strtoul(name, NULL, 16);
                            break; }

                case 'f': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxLossDwordSynchCount = strtoul(name, NULL, 16);
                            break; }

                case 'g': { getString(name, sizeof(name), stdin);  
                            pbuf->LossDwordSynchCountTime = strtoul(name, NULL, 16);
                            break; }

                case 'h': { getString(name, sizeof(name), stdin);  
                            pbuf->MaxPhyResetProblemCount = strtoul(name, NULL, 16);
                            break; }

                case 'i': { getString(name, sizeof(name), stdin);  
                            pbuf->PhyResetProblemTime = strtoul(name, NULL, 16);
                            break; }


                case 'c': { setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_EXTPAGETYPE_SAS_IO_UNIT, // type
                                3,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(SasIOUnitPage3_t)); 
                            break; }
                      
                case 'Q': 
                case 'q': { break; }
                } // ends switch (name)
            } // ends while (name[0] != 'q' && name[0] != 'Q')
        } // ends if (status == MPI_IOCSTATUS_SUCCESS) {
    } // ends if (getConfigPageHeader(port,                               // adapter

    logPrint("*Leaving doSASIOUnitPage3()");
    return 0;
}




void doSASManufacturing_Info ( MPT_PORT *port ) {

    int                            status;
    char                           buf[1024], SasAdrstag[20], tracertag[16], assemblytag[16];
    U32                            SasAdrstmp[2], i;
    ConfigReply_t		           rep;
	pManufacturingPage0_t          pMan0;
	pManufacturingPage2_SAS_t      pMan2;
    pManufacturingPage4_t          pMan4;
    pManufacturingPage5_t          pMan5;
    

    system("clear");

    logPrint("*Entering doSASManufacturing_Info()");
    printf("\n\nProcessing Cfg. Pages to be written with persistency...");


    /*
    **  Let's walk the pages that need to be written stating with manufacturing page 0.
    */
    
    pMan0 = (pManufacturingPage0_t)buf;

    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            0,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     0,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage0_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {
            
            pMan0->Header.PageLength       = (sizeof(ManufacturingPage0_t) / 4);
            pMan0->Header.PageNumber       = 0;
            pMan0->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan0->Header.PageVersion      = MPI_MANUFACTURING0_PAGEVERSION;

            /*
            **  scan info from board into the program
            */
            Scan(SasAdrstag, tracertag, assemblytag, 0);
            
            /*
            **  Update SAS Adrs areas
            */
            sscanf(SasAdrstag + 8, "%x", &(SasAdrstmp[1]));
            SasAdrstag[8] = 0;
            sscanf(SasAdrstag, "%x", &(SasAdrstmp[0]));

            strcpy(pMan0->BoardAssembly,     assemblytag);
            strcpy(pMan0->BoardTracerNumber, tracertag  );

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                0,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage0_t)); 
        }
    } // Finishes Manufacturing Page 0

    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }


    /*
    **  On to manufacturing page 2.
    */
    pMan2 = (pManufacturingPage2_SAS_t)buf;


    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            2,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     2,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage2_SAS_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {
            
            pMan2->ChipId.DeviceID      = port->deviceId;
            pMan2->ChipId.PCIRevisionID = port->revisionId;
            pMan2->Header.PageLength    = (sizeof(ManufacturingPage2_SAS_t) / 4);
            pMan2->Header.PageNumber    = 2;
            pMan2->Header.PageType      = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan2->Header.PageVersion   = MPI_MANUFACTURING2_PAGEVERSION;

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                2,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage2_SAS_t)); 
        }
    } // Finishes Manufacturing Page 2

    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }

    /*
    **  On to manufacturing page 4.
    */
    
    pMan4 = (pManufacturingPage4_t)buf;


    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            4,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     4,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage4_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            pMan4->Header.PageLength       = (sizeof(ManufacturingPage4_t) / 4);
            pMan4->Header.PageNumber       = 4;
            pMan4->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan4->Header.PageVersion      = MPI_MANUFACTURING4_PAGEVERSION;

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                4,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage4_t)); 
        }
    } // Finishes Manufacturing Page 4


    for (i=0; i < 1024; i++) {
        buf[i] = 0;
    }

    /*
    **  On to manufacturing page 5.
    */
    
    pMan5 = (pManufacturingPage5_t)buf;


    /*
    **  Let's get header information 
    */
    if (getConfigPageHeader(port,                               // adapter
                            MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                            5,                                  // page number
                            0,                                  // address
                            &rep) != 1) {
        printf("\nFailed to read page header -- that page might not exist\n\n");
        //return 0;

    } else {

        /*
        **  Okay ... let's read the page ....
        */
        status = getConfigPageAction(port,                                // adapter
                                     MPI_CONFIG_ACTION_PAGE_READ_DEFAULT, // action
                                     MPI_CONFIG_PAGETYPE_MANUFACTURING,   // type
                                     5,                                   // page number
                                     0,                                   // address
                                     buf, 
                                     sizeof(ManufacturingPage5_t));

        if (status == MPI_IOCSTATUS_SUCCESS) {

            pMan5->Header.PageLength       = (sizeof(ManufacturingPage5_t) / 4);
            pMan5->Header.PageNumber       = 5;
            pMan5->Header.PageType         = (MPI_CONFIG_PAGEATTR_PERSISTENT | MPI_CONFIG_PAGETYPE_MANUFACTURING);
            pMan5->Header.PageVersion      = MPI_MANUFACTURING5_PAGEVERSION;

            pMan5->BaseWWID.High = SasAdrstmp[0];
            pMan5->BaseWWID.Low  = SasAdrstmp[1];

            /*
            **  Write the information back.
            */
            setConfigPageAction(port,               // adapter
                                MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM, // action
                                MPI_CONFIG_PAGETYPE_MANUFACTURING,  // type
                                5,                                  // page number
                                0,                                  // address
                                buf, 
                                sizeof(ManufacturingPage5_t)); 
        }
    } // Finishes Manufacturing Page 5


    /*
    **  I need to let the Linux Driver know that they can now issue a Port Enable.
    **  To do this, I'm sending an IOCInit with a Who Init of No One.
    */
    //doIocInit(port, MPI_WHOINIT_NO_ONE);

    logPrint("*Leaving doSASManufacturing_Info()");
}








void doSASPagesStructure(PTR_IOC_CONFIG_PAGES ptrIocConfigData, PTR_INQUIRY_DATA ptrInquiry, int Index, U32 Value, char *PtrString, int Counter) {

    int         done = FALSE;
    static char tracertag[16], assemblytag[16];
    U8          ChkSum;
    static U32  SasAdrstmp[2];
    
    GENERAL_DATA_ENUM dataPos;

    switch(Index) {
        case SECTION_GENERAL_DATA: {
             dataPos = (GENERAL_DATA_ENUM)Counter;

             switch(dataPos) {
                case SAS_ADRS_PREFIX: {
                     SasAdrstmp[0] = SasAdrstmp[1]  = 0x00;
                     tracertag[0]  = assemblytag[0] = 0;
                     break;
                     }
                case USER_VERSION: {
                     SasSeepromVersion = SasSeepromVersion | (U16)Value;
                     break;
                     }
                case NVDATA_VENDORID:
                     strcpy((char *)CustomNvdataPtr->VendorId, PtrString);
                     break;
                case NVDATA_PRODUCTID:
                     strcpy((char *)CustomNvdataPtr->ProductId, PtrString);
                     break;
                case NVDATA_PRODUCT_REVISION:
                     strcpy((char *)CustomNvdataPtr->ProductRevision, PtrString);
                     break;
                default: {
                    break;
                    }
             } // ends switch(dataPos)

             break;
        } // ends case SECTION_GENERAL_DATA: 

        case SECTION_MANUFACTURING_PAGE_0:
            done = manufacturingPage0Data(ptrIocConfigData, Value, PtrString, Counter);
            break;
        case SECTION_MANUFACTURING_PAGE_1:
            done = manufacturingPage1Data(ptrIocConfigData, Value, PtrString, Counter);
            break;
        case SECTION_IOC_MFG_PAGE_2:
            done = manufacturingPage2Data(ptrIocConfigData, Value, Counter);
            
            if (done == TRUE) {
                ptrIocConfigData->MfgPage2.AutoDownloadChecksum = 0x00;
                ChkSum = doAutoDLChecksum(ptrIocConfigData, 30);
                logPrint("     CheckSum: 0x%08lx", ChkSum);
                ptrIocConfigData->MfgPage2.AutoDownloadChecksum = ChkSum;
            }
            break;
             

        case SECTION_IOC_MFG_PAGE_3:
            done = manufacturingPage3Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_MANUFACTURING_PAGE_4:
            done = manufacturingPage4Data(ptrIocConfigData, ptrInquiry, PtrString, Value, Counter);
            memcpy(ptrIocConfigData->MfgPage4.InquiryData, ptrInquiry, sizeof(INQUIRY_DATA));
            break;
        case SECTION_MANUFACTURING_PAGE_5:
            done = manufacturingPage5Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IO_UNIT_PAGE_0:
            done = ioUnitPage0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IO_UNIT_PAGE_1:
            done = ioUnitPage1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IO_UNIT_PAGE_2:
            done = ioUnitPage2Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IO_UNIT_PAGE_3:
            done = ioUnitPage3Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IO_UNIT_PAGE_4:
            done = ioUnitPage4Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_IOC_PAGE_0:
            done = iocPage0Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_IOC_PAGE_1:
            done = iocPage1Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_IOC_PAGE_2:
            done = iocPage2Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_IOC_PAGE_3:
            done = iocPage3Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_IOC_PAGE_4:
            done = iocPage4Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_IOC_PAGE_5:
            done = iocPage5Data(ptrIocConfigData, Value, Counter, 0);
            break;
        case SECTION_SAS_IO_UNIT_0:
            done = SasIoUnitPage0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_IO_UNIT_1:
            done = SasIoUnitPage1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_IO_UNIT_2:
            done = SasIoUnitPage2Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_IO_UNIT_3:
            done = SasIoUnitPage3Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_EXPANDER_0:
            done = SasExpander0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_EXPANDER_1:
            done = SasExpander1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_DEVICE_0:
            done = SasDevice0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_DEVICE_1:
            done = SasDevice1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_DEVICE_2:
            done = SasDevice2Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_PHY_0:
            done = SasPhy0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_SAS_PHY_1:
            done = SasPhy1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_PERSISTENT_ID:
            done = SasPersistIdData(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_RAID_VOL_PAGE_0:
            done = RaidVolume0Data(ptrIocConfigData, Value, Counter);
            break;
       case SECTION_RAID_VOL_PAGE_1:
            done = RaidVolume1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_RAID_PHYS_DISK_PAGE_0:
            done = RaidPhysDsk0Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_RAID_PHYS_DISK_PAGE_1:
            done = RaidPhysDsk1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_BIOS_1:
            done = BiosPage1Data(ptrIocConfigData, Value, Counter);
            break;
        case SECTION_BIOS_2:
            done = BiosPage2Data(ptrIocConfigData, Value, Counter);
            break;
        default:
            break;
    } // ends switch(Index) 
}





int doScsiIo(MPT_PORT *port, SCSIIORequest_t *req, int reqSize, SCSI_REPLY *rep, int repSize, void *payIn, int payInSize, void *payOut, int payOutSize, int timeOut) {

	if (doMptCommand(port, req, reqSize, rep, repSize, payIn, payInSize, payOut, payOutSize, timeOut) != 1)
		return 0;

    logPrint("    doScsiIo IOCStatus: 0x%04x", get16(rep->reply.IOCStatus));
    logPrint("   doScsiIo SCSIStatus: 0x%02x", rep->reply.SCSIStatus);

	if (get16(rep->reply.IOCStatus) == MPI_IOCSTATUS_SCSI_DEVICE_NOT_THERE)
		return 0;

	if (get16(rep->reply.IOCStatus) == MPI_IOCSTATUS_BUSY                ||
		get16(rep->reply.IOCStatus) == MPI_IOCSTATUS_SCSI_IOC_TERMINATED ||
		rep->reply.SCSIStatus       == MPI_SCSI_STATUS_CHECK_CONDITION   ||
		rep->reply.SCSIStatus       == MPI_SCSI_STATUS_BUSY              ||
		rep->reply.SCSIStatus       == MPI_SCSI_STATUS_TASK_SET_FULL     ) {

		if (doMptCommand(port, req, reqSize, rep, repSize, payIn, payInSize, payOut, payOutSize, timeOut) != 1)
			return 0;
	}

	if (get16(rep->reply.IOCStatus) != MPI_IOCSTATUS_SUCCESS &&
		get16(rep->reply.IOCStatus) != MPI_IOCSTATUS_SCSI_DATA_UNDERRUN &&
		get16(rep->reply.IOCStatus) != MPI_IOCSTATUS_SCSI_RESIDUAL_MISMATCH) {
		printf("ScsiIo failed, IOCStatus = %04x\n", get16(rep->reply.IOCStatus));
		return 0;
	}
        

    if (req->CDB[0] == 0x1A && get16(rep->reply.IOCStatus) == MPI_IOCSTATUS_SCSI_DATA_UNDERRUN) {
        logPrint("    Mode Sense:  Data Underrun Error");
        return 1;
    }


	if (rep->reply.SCSIStatus != MPI_SCSI_STATUS_SUCCESS) {

		if (rep->reply.SCSIStatus == MPI_SCSI_STATUS_CHECK_CONDITION) {

			if (rep->sense[2] == 5 && rep->sense[12] == 0x20 && rep->sense[13] == 0x00 && payInSize == 36)
				return 0;

			if (rep->sense[2] == 5 && rep->sense[12] == 0x24 && rep->sense[13] == 0x00 && payInSize == 36)
				return 0;

			if (rep->sense[2] == 5 && rep->sense[12] == 0x25 && rep->sense[13] == 0x00 && payInSize == 36)
				return 0;

			if (rep->sense[2] == 0 && rep->sense[12] == 0x00 && rep->sense[13] == 0x00)
				return 0;

			printf("ScsiIo failed, Check Condition, Key = %d, ASC/ASCQ = %02x/%02x\n", rep->sense[2], rep->sense[12], rep->sense[13]);

		} else {

			printf("ScsiIo failed, SCSIStatus = %02x\n", rep->reply.SCSIStatus);
		}
		return 0;
	}

	return 1;
}


int doSplitBiosImage(unsigned char **buf1, int *len1, unsigned char **buf2, int *len2) {

	int	   n;
	PCIR  *pcir;

    logPrint("*Entering splitBiosImage()");
	
    n = ((*buf1)[0x19]<<8) + (*buf1)[0x18];
    logPrint("     Buffer Length 0x%04lx ..    N Length: 0x%04lx", len1, n);

	if (n + (int)sizeof *pcir < *len1) {

		pcir = (PCIR *)(*buf1 + n);

		if (pcir->signature[0] == 'P' &&
			pcir->signature[1] == 'C' &&
			pcir->signature[2] == 'I' &&
			pcir->signature[3] == 'R')   {

            //n = get16(pcir->imageLength) * 512;
			n = pcir->imageLength * 512;
                          
            logPrint("     Buffer Length 0x%04lx .. PCIR Length: 0x%04lx", len1, n);
			if (n < *len1) {
				*buf2 = (unsigned char *)malloc(*len1 - n);
				*len2 = *len1 - n;
				memcpy(*buf2, *buf1 + n, *len1 - n);
				*buf1 = (unsigned char *)realloc(*buf1, n);
				*len1 = n;
			}
		} // ends if (pcir->signature[0] == 'P' &&
	}  // ends if (n + (int)sizeof *pcir < *len1)

    logPrint("*Leaving splitBiosImage()");
	return 1;
}




#ifdef __KERNEL_2_4__
void doTBoxClean (MPT_PORT *port, U32 value) {

    int                   status = 0, failed = FALSE;
    ToolboxCleanRequest_t req;
	ToolboxReply_t        rep;


    logPrint("*Entering doTBoxClean()");

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

    system("clear");
    
    /*
    **  Fill in the message
    */
    req.Function   = MPI_FUNCTION_TOOLBOX;
    req.Tool       = MPI_TOOLBOX_CLEAN_TOOL;

    //if (flag_ptr->Handshake == TRUE) {
    //    req.MsgContext = 0x02012020;
    //} else {
    //    req.MsgContext = 0xA0ED0000 | value;
    //}
    
    req.MsgContext = 0x02012020;

    if ( HostRunIsSASFamily(flag_ptr) ) {

        switch (value) {
           case   1:  { req.Flags = MPI_TOOLBOX_CLEAN_NVSRAM;
                       printf("\n\nThere will be a slight pause while NVSRAM is being erased\n");
                       break; }
           case   2:  { req.Flags = MPI_TOOLBOX_CLEAN_SEEPROM;    
                       printf("\n\nThere will be a slight pause while SEEPROM is being erased\n");
                       break; }
           case   3:  { req.Flags = (MPI_TOOLBOX_CLEAN_NVSRAM  | MPI_TOOLBOX_CLEAN_SEEPROM);          
                       printf("\n\nThere will be a slight pause while NVSRAM and SEEPROM are being erased\n");
                       break; }
           case   4:  { req.Flags = MPI_TOOLBOX_CLEAN_FW_BACKUP;
                       printf("\n\nThere will be a slight pause while Firmware Backup is being erased\n");
                       break; }
           case   5:  { req.Flags = MPI_TOOLBOX_CLEAN_OTHER_PERSIST_PAGES;    
                       printf("\n\nThere will be a slight pause while Persistent Pages are being erased\n");
                       break; }
           case   6:  { req.Flags = MPI_TOOLBOX_CLEAN_PERSIST_MANUFACT_PAGES; 
                       printf("\n\nThere will be a slight pause while Maunfacturing Pages are being erased\n");
                       break; }
           case   7:  { req.Flags = MPI_TOOLBOX_CLEAN_BOOT_SERVICES;          
                       printf("\n\nThere will be a slight pause while Boot Services is being erased\n");
                       break; }
           case 714:  { req.Flags = MPI_TOOLBOX_CLEAN_FLASH;                  
                       printf("\n\nA FWDLB is required to erase SAS Flash\n");

                       /*
                       **  SAS IR firmware cannot run the erase command wihtout a bootstrap, so I will run a bootstrap on 
                       **  any SAS card.
                       */
                       if (HostRunIsSASFamily(flag_ptr)) {

                           status = doFirmwareDownloadBoot(port, 0);
                       }

                       if (status == 0) {
                           printf("\n\nThere will be a slight pause while Flash is being erased\n");
                       }

                       break; }
            default: { printf("\n\nInvalid erase option: %d\n\n", value);  
                       exit(1);                         
                       break; }
        }
    }  // ends if ( HostRunIsSASFamily(host_run_ptr) )


    if (status == 0) {

        /*
        **  Send the message ....
        */
        if (doMptCommand(port, &req, sizeof req, &rep, sizeof rep, NULL, 0, NULL, 0, 60) != 1) {

            printf("\n\nERROR: Clean Tool message failed");
            failed = TRUE;
        }

        
        if (failed == FALSE) {

            if (rep.IOCStatus != 0x00) {
               printf("\n\nErasing Problem: 0x%04x", rep.IOCStatus);
               printf("  \n                 0x%08x", rep.IOCLogInfo);
               printf("\n\n Press ENTER to Continue\n");
               dogetch();

           } else if ( (req.Flags & MPI_TOOLBOX_CLEAN_FLASH) == MPI_TOOLBOX_CLEAN_FLASH ) {
               printf("\n\n You have choosen to erase FLASH content.  \n You will need to power cycle the machine now.");
               printf("\n\n Press ENTER to Continue\n");
               dogetch();
               flag_ptr->DidErase = TRUE;

           } else {
               flag_ptr->DidErase = TRUE;
           }
        }
    }

    logPrint("*Leaving doTBoxClean()");
}
#endif



#ifdef __KERNEL_2_4__
int doToolBox (MPT_PORT *port) {

	int  option = -1;

    logPrint("*Entering doToolBox()");

	
	while (TRUE) {
                      
        system("clear");

        
		if (option < 0 ) {

            printf("\n*****************************************************************");
            printf("\n                      Erase Functions");
            printf("\n*****************************************************************");

            printf("\n\n\ta - Erase NVSRAM");
            printf("  \n\tb - Erase SEEPROM");
            printf("  \n\tc - Erase NVSRAM and SEEPROM");
            printf("  \n\td - Erase FW Backup Image");
            printf("  \n\te - Erase Mfg. Persistent Pages");
            printf("  \n\tf - Erase Other Persistent Pages");
            printf("  \n\tg - Erase BIOS/Boot Services Image");
                    
            printf("\n\n\tq - Quit to previous menu");
            printf("\n\n\n    Selection:  ");

            getString( name, 256, stdin );
        
            switch (name[0]) {
            case 'a': {doTBoxClean(port, 1);  break;}
            case 'b': {doTBoxClean(port, 2);  break;}                         
            case 'c': {doTBoxClean(port, 3);  break;}                         
            case 'd': {doTBoxClean(port, 4);  break;}                         
            case 'e': {doTBoxClean(port, 5);  break;}                         
            case 'f': {doTBoxClean(port, 6);  break;}                         
            case 'g': {doTBoxClean(port, 7);  break;}                         
            case 'Q': 
            case 'q': {return 0; break;}
            }

            option = -1;
        }
    } // ends while (TRUE)

	return 0;
}
#endif



int doTUR(MPT_PORT *port, int bus, int target, int lun) {

    int              status;
	SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;


    logPrint("*Entering doTUR()");

    memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function			= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus					= bus;
	req.TargetID			= target;
	req.CDBLength			= 6;
	req.LUN[1]				= lun;
	req.Control				= set32(MPI_SCSIIO_CONTROL_READ | MPI_SCSIIO_CONTROL_SIMPLEQ);
	req.CDB[0]				= 0;
	req.CDB[1]				= 0;
	req.CDB[2]				= 0;
	req.CDB[3]				= 0;
	req.CDB[4]				= 0;
	req.CDB[5]				= 0;
	req.DataLength			= 0;

	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, NULL, 0, NULL, 0, 10);
    return status;
}




int doWriteBuffer (MPT_PORT *port, int bus, int target, int lun, int mode) {

    int              status;
	SCSIIORequest_t	 req;
	SCSI_REPLY		 rep;

	memset(&req, 0, sizeof req);
	memset(&rep, 0, sizeof rep);

	req.Function			= MPI_FUNCTION_SCSI_IO_REQUEST;
	req.Bus					= bus;
    req.TargetID			= target;
	req.CDBLength			= 10;
	req.LUN[1]				= lun;
	req.Control				= set32(MPI_SCSIIO_CONTROL_WRITE | MPI_SCSIIO_CONTROL_UNTAGGED);
	req.CDB[0]				= 0x3B;  // Write Bufffer cmd op code
	req.CDB[1]				= mode;  // Write Bufffer MODE field
	req.CDB[6]				= ptrSasDev->BufferSize >> 16;    // Device's Data buffer size - MSB.
	req.CDB[7]				= ptrSasDev->BufferSize >> 8;
	req.CDB[8]				= ptrSasDev->BufferSize & 0xFF;   // Device's data buffer size - LSB.
	req.DataLength			= set32(ptrSasDev->BufferSize);

    /*
    **  For this test ... I am going to assume that the user has setup global buffer3 to send their data in.
    */
	status = doScsiIo(port, &req, sizeof req - sizeof req.SGL, &rep, sizeof rep, NULL, 0, buffer3, ptrSasDev->BufferSize, 10);

    return status;
}





void doWriteReadBufferTest(MPT_PORT *port) {

    U8            status = 0;
    U32           i;


    logPrint("*Entering doWriteReadBufferTest()");

    system("clear");
    printf("\n ---  Read/Write Buffer Test with Target Devices  ---\n");

    /*
    **
    **
    **  May need to move the card to different states .... don't know
    **
    **
    */



    /*
    **  Let's start off by finding all the devices connected.
    */
    status = getDeviceList(port);

    if (status == 0) {
        
        /*
        **  Found devices to issue commands to.  Do Inquiry and Read Buffer
        **  to finish filling each device's struct...
        */
        ptrSasDev = ptrAllSasDevs;

        printf("\n");
        printf("\n\n      Address             Model       Version   Size    Pass/Fail");
        printf("\n-----------------------------------------------------------------");

        while (ptrSasDev != NULL) {

            logPrint("     Port ................. 0x%02x",  ptrSasDev->PhyPort);
            logPrint("     Dev SAS Adrs Lo ...... 0x%08lx", ptrSasDev->DevSasAdrsLo);
            logPrint("     Dev SAS Adrs Hi ...... 0x%08lx", ptrSasDev->DevSasAdrsHi);
            logPrint("     Target ID ............ 0x%02x",  ptrSasDev->TargetId);
            logPrint("     Bus Number ........... 0x%02x",  ptrSasDev->BusNumber);

            /*
            **  Let's start by sending an Inquiry Command to the drive
            */
            status = doInquiry(port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun);

            if (status == 1) {
                
                /*
                **  Starting put output to the screen ....
                */
                printf("\n0x%08x%08x  %s    %s    ", ptrSasDev->DevSasAdrsHi, ptrSasDev->DevSasAdrsLo, ptrSasDev->Model, ptrSasDev->Version);

                /*
                **  Let's get one more piece of information about the drive
                */
                status = doReadCapacity (port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun);

                if (status == 1) {
                    
                    printf("%3.2fGB   ", ptrSasDev->Capacity);    


                    status = doReadBuffer (port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun, 0x3, 0x4);

                    if (status == 1) {

                        /*
                        **  Let's fill in a pattern into the buffer.
                        */
                        for (i = 0; i < ptrSasDev->BufferSize; i++ ) {
                            buffer3[i] = 0xA5;
                        }

                        /*
                        **  Let's send the write of this data
                        */
                        status = doWriteBuffer (port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun, 0x2);

                        if (status == 1) {

                            /*
                            **  Change the data
                            */
                            for (i = 0; i <= ptrSasDev->BufferSize; i++ ) {
                                buffer3[i] = 0xFF;
                            }


                            /*
                            **  Let's do the read and compare.
                            */
                            status = doReadBuffer (port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun, 0x2, ptrSasDev->BufferSize);

                            if (status == 1) {

                                status = 0;

                                /*
                                **  Do the compare
                                */
                                for (i = 0; i < ptrSasDev->BufferSize; i++ ) {

                                    if (buffer3[i] != 0xA5 && status < 20) {
                                        logPrint("     ERROR: Data miscompare at %d:  0x%08lx", i, buffer3[i]);
                                        status++;
                                    } else if (status >= 20) {
                                        break;
                                    }
                                }

                                if (status != 0) {

                                    printf("FAIL: Data miscompare");

                                } else {

                                    printf("PASS");

                                }

                            } else {

                                printf("FAILED (Read Buffer Data)");

                            }

                        } else {

                            printf("FAILED (Write Buffer)");

                        } //ends if (status == 1) write buffer

                    } else {

                        printf("FAILED (Read Buffer Size)");

                    } //ends if (status == 1) read buffer

                } else {

                    printf("        FAILED (Read Capacity)"); 

                } // ends if (status == 1) read capacity

            }  else {
                
                printf("\n0x%08x%08x                                         FAIL (Inquiry)", ptrSasDev->DevSasAdrsHi, ptrSasDev->DevSasAdrsLo);

            }// ends if (status == 1) from Inquiry
            

            ptrSasDev = ptrSasDev->PtrNext;

        } // ends while (ptrSasDev != NULL) {
    } // ends if (status == 0) {

    printf("\n\nPress Return to Exit");
    dogetch();
    
    logPrint("*Leaving doWriteReadBufferTest()");
}





void doWriteReadCache (MPT_PORT *port, char option) {

    U8  status;
    U8 *data;
    U32 cache_page_length = 0, loop = 0, changeable;

    logPrint("*Entering doWriteReadCache(%c)", option);


    /*
    **  Is our option correct?
    */
    if (option != '0' && option != '1') {
        system("clear");
        printf("\nEnable / Disable Write Cache to Attached Devices\n");
        printf("\n\nWould you like to disable cache to all devices attached [y/n]: ");
        getString(name, sizeof name, stdin);

        if (name[0] == 'y' || name[0] == 'Y') {
            option = '0';
        } else if (name[0] == 'n' || name[0] == 'N') {
            printf("\nWould you like to enable cache to all devices attached [y/n]: ");
            getString(name, sizeof name, stdin);

            if (name[0] == 'y' || name[0] == 'Y') {
                option = '1';
            } else {

                /*
                **  Guess they got this command line option by mistake
                */
                return;
            }
        }
    }

    
    system("clear");
    if (option == '0') {
        printf("\nDisable Write Cache to Attached Devices\n");
    } else {
        printf("\nEnable Write Cache to Attached Devices\n");
    }

    if (option == '1') {

        printf("\n\nWARNING: This setting enables write caching to improve disk performance,");
        printf("  \n         a power outage or equipment failure may result in data loss");
        printf("  \n         or corruption.");
        printf("\n\n         Would you like to Exit [y]:  ");

        getString( name, 256, stdin );

        if (strcmp(name, "y") == 0 || strcmp(name, "Y") == 0) {
            return;
        }          
    }


    /*
    **  Let's get a list of devices
    */ 
    status = getDeviceList(port);

    /*
    **  Found devices to issue commands to.  Do Inquiry and Read Buffer
    **  to finish filling each device's struct...
    */
    ptrSasDev = ptrAllSasDevs;

    printf("\n\n");
    while (ptrSasDev != NULL) {

        if (option == '0') {
            printf("\nDisabling Write Cache to: 0x%08x%08x", ptrSasDev->DevSasAdrsHi, ptrSasDev->DevSasAdrsLo);
        } else {
            printf("\nEnabling Write Cache to: 0x%08x%08x", ptrSasDev->DevSasAdrsHi, ptrSasDev->DevSasAdrsLo);
        }

        logPrint("  *********************************");
        logPrint("     Dev SAS Adrs ...... 0x%08x%08x", ptrSasDev->DevSasAdrsHi, ptrSasDev->DevSasAdrsLo);
        logPrint("     Target ID ......... 0x%02x",  ptrSasDev->TargetId);
        logPrint("     Bus Number ........ 0x%02x",  ptrSasDev->BusNumber);
        logPrint("     Buffer Size ....... 0x%08x",  ptrSasDev->BufferSize);

        /*
        **  Issue a TUR and see if the devices is ready.
        */
        status = doTUR(port, ptrSasDev->BusNumber, ptrSasDev->TargetId, ptrSasDev->Lun);
 
        if (status) {

            /*
            **  We need to find out if this devices supports the Caching Page
            **  PCF, Page, Clear_Data, BufferSize
            **
            **  We are using Buffer3 to store data
            */ 
            status = doModeSense(port, ptrSasDev, 0, 0x3F, 1, 0xFF, 8);

            if (status) {

                data = (U8 *) buffer3;

                /*
                **  Let's skip all the header information .... 
                */
                loop = data[3] + 4;

                /*
                **  Okay ... we should have data on all supported mode pages.  
                **  Let's look for the caching page
                */
                while (data[loop] != 0x00 && loop <= 0xFF) {

                    if ( (data[loop] & 0x3F) == 0x8 ) {
                        cache_page_length = data[loop+1] + 6;  // 4 byte header + 2 byte Page Code
                        loop = 0x100;

                        logPrint("     Cache Page Length: 0x%08x", cache_page_length);

                    } else {

                        /*
                        **  go to the next word and that should be the length of the page
                        */
                        loop++;
                        loop = data[loop] + loop + 1;

                        logPrint("     Data: 0x%02x 0x%02x AND data: 0x%02x", data[loop], data[loop+1], (data[loop] & 0x3F));
                    }
                } // ends while (data[loop] != 0x00 && loop <= 0xFF)
                
                if (cache_page_length == 0) {

                    /*
                    **  We didn't not find the page
                    */
                    printf(" ... FAILED (not supported)");
                    logPrint("     Cache Mode Page Not Supported");

                } else {

                    /*
                    **  Okay ... now we have the length of the Cache page ... let's read in the changeable
                    **  settings.  PCF, Page, Clear_Data, BufferSize
                    */
                    status = doModeSense(port, ptrSasDev, 1, 0x08, 1, cache_page_length, 8);

                    data = (U8 *) buffer3;
                    loop = data[3] + 6;

                    if ((data[loop] & 0x04) != 0x4) {

                        /*
                        **  We can't change this field ... which is what we are trying to do.
                        */
                        printf(" ... FAILED (not able to change)");
                        logPrint("     ERROR: Write Cache Enable Not changable.");

                    } else {

                        /*
                        **  Okay, finally ... read current values.
                        **  PCF, Page, Clear_Data, BufferSize
                        */
                        status = doModeSense(port, ptrSasDev, 0, 0x08, 1, cache_page_length, 8);

                        /*
                        **  How is this device currently setup?
                        */
                        data       = (U8 *) buffer3;
                        changeable = data[loop] & 0x04;

                        if ( (changeable == 4 && option == '1') || (changeable == 0 && option == '0') ) {

                            printf(" ... PASSED (already set)");
                            logPrint("     Already set correctly.");

                        } else {

                            logPrint("     Data Before: 0x%02x", data[loop]);

                            /*
                            **  Enable or Disable
                            */
                            if (option == '0') {
                                data[loop] = data[loop] & 0xFB;
                            } else {
                                data[loop] = data[loop] | 0x04;
                            }

                            logPrint("      Data After: 0x%02x", data[loop]);

                            /*
                            **  Setting up the data for a Mode Select
                            */
                            //LogPrintf("\n\t");
                            //for (loop = 0; loop < cache_page_length; loop++) {
                            //    LogPrintf("%02x, ", data[loop]);
                            //    loop2++;
                            //
                            //    if (loop2 == 0x10) {
                            //        LogPrintf("\n\t");
                            //        loop2 = 0;
                            //    }
                            //}

                            /*
                            **  Okay ... let's send the message.
                            */
                            status = doModeSelect(port, ptrSasDev, cache_page_length);

                            if (status) {

                                /*
                                **  Let's verify the data
                                **  PCF, Page, Clear_Data, BufferSize
                                */
                                status = doModeSense(port, ptrSasDev, 0, 0x08, 1, cache_page_length, 8);

                                /*
                                **  One more quick check ... did we get valid data?
                                */                                                 
                                data = (U8 *) buffer3;
                                loop = data[3] + 4;

                                if (data[loop] == 0x88) {

                                    loop = data[3] + 6;
                                    changeable = data[loop] & 0x04;

                                    if ( (changeable == 4 && option == '1') || (changeable == 0 && option == '0') ) {
                                        printf(" ... PASSED");
                                        logPrint("     Data Changed Correctly.");
                                    } else {
                                        printf(" ... FAILED (Bit Didn't Change)");
                                        logPrint("     FAIL: Bit didn't change");
                                    }

                                } else {

                                    printf(" ... FAILED (Data Read Invalid)");
                                    logPrint("     FAIL: Data Read Invalid."); 

                                }  // ends if (data[12] == 0x88)

                            } else {
                                printf(" ... FAILED (ModeSelect Error)");
                                logPrint("     FAIL: ModeSelect Error."); 
                            } // neds if (status == 0) ModeSelect
                        } // ends if (changeable == 0x1 && direction == 1  || changeable == 0x0 && direction == 0
                    } // ends if ((data[loop] & 0x04) != 0x4)
                } // ends if (cache_page_length == 0)
            } else { 
                printf(" ... FAILED (Failed Mode Sense)");
            } // ends status from ModeSense 0, 3F
        } // ends status from TUR

        ptrSasDev = ptrSasDev->PtrNext;

    } // ends while (ptrSasDev != NULL) 

    printf("\n\n");
    logPrint("*Leaving doWriteReadCache()");
    return;
}
