/* drivers/message/fusion/linux_compat.h */

#ifndef FUSION_LINUX_COMPAT_H
#define FUSION_LINUX_COMPAT_H

#include <linux/version.h>
#include <linux/utsname.h>
#include <linux/sched.h>
#include <scsi/scsi_device.h>
#include <scsi/scsi_cmnd.h>

/* scsi_print_command() came in lk 2.6.8 kernel,
 * prior kernels it was called print_Scsi_Cmnd()
 */
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8))
extern void print_Scsi_Cmnd(struct scsi_cmnd *cmd);
#else
extern void scsi_print_command(struct scsi_cmnd *cmd);
#endif
static void inline mptscsih_scsi_print_command(struct scsi_cmnd *cmd){
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8))
	print_Scsi_Cmnd(cmd);
#else
	scsi_print_command(cmd);
#endif
}

/* define msleep, msleep_interruptible which came in lk 2.6.8
 * to be backward compatible to older variants of lk 2.6
 *
 * NEW:  SLES9 SP2 has been backported for the msleep api,
 * so the following check condition for SUSE_KERNEL was added
 */
#if (defined(CONFIG_SUSE_KERNEL) && LINUX_VERSION_CODE == KERNEL_VERSION(2,6,5)) || LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8)
static inline unsigned long msecs_to_jiffies_compat(const unsigned int m)
{
#if HZ <= 1000 && !(1000 % HZ)
	return (m + (1000 / HZ) - 1) / (1000 / HZ);
#elif HZ > 1000 && !(HZ % 1000)
	return m * (HZ / 1000);
#else
	return (m * HZ + 999) / 1000;
#endif
}
static inline unsigned int jiffies_to_msecs_compat(const unsigned long j)
{
#if HZ <= 1000 && !(1000 % HZ)
	return (1000 / HZ) * j;
#elif HZ > 1000 && !(HZ % 1000)
	return (j + (HZ / 1000) - 1)/(HZ / 1000);
#else
	return (j * 1000) / HZ;
#endif
}
static void inline msleep_compat(unsigned long msecs)
{
	unsigned long timeout = msecs_to_jiffies_compat(msecs) + 1;
	while (timeout) {
		set_current_state(TASK_UNINTERRUPTIBLE);
		timeout = schedule_timeout(timeout);
	}
}
static long inline msleep_interruptible_compat(unsigned long msecs)
{
	unsigned long timeout = msecs_to_jiffies_compat(msecs) + 1;
	while (timeout && !signal_pending(current)) {
		set_current_state(TASK_INTERRUPTIBLE);
		timeout = schedule_timeout(timeout);
	}
	return jiffies_to_msecs_compat(timeout);
}
#else
static void inline msleep_compat(unsigned long msecs) {msleep(msecs);}
static void inline msleep_interruptible_compat(unsigned long msecs) {msleep_interruptible(msecs);}
#endif

/* define __iomem which came in lk 2.6.9
 * to be backward compatible to older variants of lk 2.6
 */
#ifndef __iomem
#define __iomem
#endif

/* define pm_message_t which came in lk 2.6.11
 * to be backward compatible to older variants of lk 2.6
 */
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,11))
typedef u32 pm_message_t;
#endif

/* exporting of pci_disable_msi which came in lk 2.6.8
 * to be backward compatible to older variants of lk 2.6
 */
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8))
static inline void pci_disable_msi(struct pci_dev* dev) {}
#endif

/* defines for SAS controlers, to be eventually added to inlcude/linux/pci_ids.h
 */
#ifndef PCI_DEVICE_ID_LSI_SAS1064
#define PCI_DEVICE_ID_LSI_SAS1064	(0x0050)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1066
#define PCI_DEVICE_ID_LSI_SAS1066	(0x005E)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1068
#define PCI_DEVICE_ID_LSI_SAS1068	(0x0054)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1064A
#define PCI_DEVICE_ID_LSI_SAS1064A	(0x005C)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1064E
#define PCI_DEVICE_ID_LSI_SAS1064E	(0x0056)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1066E
#define PCI_DEVICE_ID_LSI_SAS1066E	(0x005A)
#endif

#ifndef PCI_DEVICE_ID_LSI_SAS1068E
#define PCI_DEVICE_ID_LSI_SAS1068E	(0x0058)
#endif

#ifndef PCI_DEVICE_ID_LSI_FC939X
#define PCI_DEVICE_ID_LSI_FC939X	(0x0642)
#endif

#ifndef PCI_DEVICE_ID_LSI_FC949X
#define PCI_DEVICE_ID_LSI_FC949X	(0x0640)
#endif

#ifndef PCI_DEVICE_ID_LSI_FC949ES
#define PCI_DEVICE_ID_LSI_FC949ES	(0x0646)
#endif
/*}-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
#endif /* _LINUX_COMPAT_H */
