/* System Include Files
 */
#include "apps.h"

char *mptreset_name_ver = WHAT_MAGIC_STRING "mptreset - " MPT_LINUX_VERSION_COMMON;

static char *ctlname	= MPT_MISCDEV_PATHNAME;

int main (int argc, char *argv[])
{
	unsigned long ctlnum = MPTHARDRESET;
	struct mpt_ioctl_diag_reset rinfo;
	int ctlfd, eval = 0;

	if (argc != 2) {
		printf ("Usage: mptreset [ioc number].\n");
		exit (1);
	}

	if ((rinfo.hdr.iocnum = atoi(argv[1])) < 0) {
		fprintf (stderr, "ERROR: ioc number = %d is invalid. ioc "
			 "numbers must be greater than 0.\n", rinfo.hdr.iocnum);
		exit (1);
	}
	
	if ((ctlfd = open(ctlname, O_RDWR)) < 0) {
		fprintf(stderr, "ERROR: open(\"%s\") FAILED: %s\n", ctlname, 
			strerror(errno));
		return -EPERM;
	}

	if ((eval = ioctl(ctlfd, ctlnum, (char *) &rinfo)) < 0)
		fprintf(stderr, "ERROR - reset failed because: %s.\n",
			strerror(eval));
	else
		printf ("Reset completed.\n");

	return (0);
}
