
/* Include Files
 */
#include "apps.h"

/* Product Information
 */
#define BUILD_DATE "date"

static char *ToolTitle ="LSI Logic Linux Fusion-MPT Ioctl Test Tool";
static char *IdString= "Build with Driver " DRIVER_VERSION " Header Files on " BUILD_DATE;
static char *LsiCopyright="Copyright 2002 LSI Logic";

/* mainMenuList functions
 */
void NullFunction (void);
void IoIoctlCommands(void);
void PassthroughIoIoctlCommands(void);
void MptIoctlCommands(void);
void OtherIoctlCommands(void);
void DiagIoctlCommands(void);
void CompaqIoctlCommands(void);
void ShowHelp(void);
void ShowAbout(void);

void MainMenuCommands(void);
uchar OptionsMenuHandler (CmdOptions *menuPtr);

/* External Function Prototypes
 */
extern void GetOldIocInfo(void);
extern void GetIocInfo(void);
extern void GetTargetInfo(void);
extern void TestIoctl(void);
extern void EventQuery(void);
extern void EventEnable(void);
extern void EventReport(void);
extern void ReplaceFW(void);
extern void DiagnosticReset(void);

extern void DiagRegisterIoctl(void);
extern void DiagReleaseIoctl(void);
extern void DiagUnregisterIoctl(void);
extern void DiagQueryIoctl(void);
extern void DiagReadBufferIoctl(void);

extern void HP_HostInfo(void);
extern void HP_HostInfo_rev0(void);
extern void HP_TargetInfo(void);

extern void InquiryCmd(void);
extern void TurCmd(void);
extern void ReadCapacityCmd(void);
extern void ModeSenseCmd(void);
extern void ModeSelectCmd(void);
extern void Read10Cmd(void);

extern void BusResetIoctl(void);
extern void FactsIoctl(void);
extern void PortFactsIoctl(void);
extern void ConfigIoctl(void);
extern void PortEnableIoctl(void);
extern void InitIoctl(void);
extern void EventNotificationIoctl(void);
extern void EventAckIoctl(void);
extern void FirmWareUploadIoctl(void);
extern void FirmWareDownloadIoctl(void);
extern void RaidVolumeIoctl(void);
extern void EnclosureProcessor(void);

CmdStrings mainMenuList[] =
{
	{"Select Ioctl Command Type:  ",NullFunction},
	{"SCSI I/O Command", IoIoctlCommands},
	{"SCSI I/O RAID Passthrough Command", PassthroughIoIoctlCommands},
	{"Non SCSI-I/O MPT Command", MptIoctlCommands},
	{"Data Gathering Commands", OtherIoctlCommands},
	{"Diagnostic Buffer Commands", DiagIoctlCommands},
	{"Compaq Commands", CompaqIoctlCommands},
	{"Help", ShowHelp},
	{"About", ShowAbout},
	{"Quit", DoExit},
	{"NULL", NullFunction}
};

CmdStrings OtherIoctls[] =
{
	{"Linux Data Gathering Ioctls: ", NullFunction},
	{"Test Ioctl", TestIoctl},
	{"IOC Information", GetIocInfo},
	{"IOC Information (rev0)", GetOldIocInfo},
	{"Target Information", GetTargetInfo},
	{"Event Query", EventQuery},
	{"Event Enable", EventEnable},
	{"Event Report", EventReport},
	{"Replace Cached F/W", ReplaceFW},
	{"Diagnostic Reset", DiagnosticReset},
	{"Return to main menu", MainMenuCommands},
	{"Quit",DoExit},
	{"NULL", NullFunction}
};

CmdStrings DiagIoctls[] =
{
	{"Linux Diagnostic Buffer Ioctls: ", NullFunction},
	{"Register Diag Buffer", DiagRegisterIoctl},
	{"Release Diag Buffer", DiagReleaseIoctl},
	{"Unregister Diag Buffer", DiagUnregisterIoctl},
	{"Query Diag Buffer", DiagQueryIoctl},
	{"Read Diag Buffer", DiagReadBufferIoctl},
	{"Return to main menu", MainMenuCommands},
	{"Quit", DoExit},
	{"NULL", NullFunction}
};

CmdStrings CompaqIoctls[] =
{
	{"Compaq Linux Data Gathering Ioctls: ", NullFunction},
	{"HP_GETHOSTINFO", HP_HostInfo},
	{"HP_GETHOSTINFO (rev0)", HP_HostInfo_rev0},
	{"HP_GETTARGETINFO", HP_TargetInfo},
	{"Return to main menu", MainMenuCommands},
	{"Quit",DoExit},
	{"NULL", NullFunction}
};


CmdStrings IoIoctls[] =
{
	{"I/O Ioctls: ", NullFunction},
	{"INQUIRY", InquiryCmd},
	{"TEST UNIT READY",TurCmd},
	{"READ CAPACITY",ReadCapacityCmd},
	{"MODE SENSE",ModeSenseCmd},
	{"MODE SELECT",ModeSelectCmd},
	{"Read 10",Read10Cmd},
	{"Return to main menu", MainMenuCommands},
	{"Quit",DoExit},
	{"NULL", NullFunction}
};

CmdStrings NonIoMptIoctls[] =
{
	{"Non-I/O MPT Ioctls: ", NullFunction},
	{"MPI_FUNCTION_SCSI_IO_REQUEST: ", IoIoctlCommands},
	{"MPI_FUNCTION_SCSI_TASK_MGMT: ", BusResetIoctl},
	{"MPI_FUNCTION_IOC_FACTS: ", FactsIoctl},
	{"MPI_FUNCTION_PORT_FACTS: ", PortFactsIoctl},
	{"MPI_FUNCTION_CONFIG: ", ConfigIoctl},
	{"MPI_FUNCTION_PORT_ENABLE: ", PortEnableIoctl},
	{"MPI_FUNCTION_IOC_INIT: ", InitIoctl},
	{"MPI_FUNCTION_EVENT_NOTIFICATION: ", EventNotificationIoctl},
	{"MPI_FUNCTION_EVENT_ACK: ", EventAckIoctl},
	{"MPI_FUNCTION_FW_UPLOAD: ", FirmWareUploadIoctl},
	{"MPI_FUNCTION_FW_DOWNLOAD: ", FirmWareDownloadIoctl},
	{"MPI_FUNCTION_RAID_VOLUME: ", RaidVolumeIoctl},
	{"MPI_FUNCTION_SCSI_ENCLOSURE_PROCESSOR: ", EnclosureProcessor},
	{"Return to main menu", MainMenuCommands},
	{"Quit",DoExit},
	{"NULL", NullFunction}
};


/*
 * Options Menus for Config Ioctls
 */
CmdOptions configAction[] =
{
	{"Select Action:  ", 0xFF},
	{"Get Page Header", MPI_CONFIG_ACTION_PAGE_HEADER},
	{"Read Current Page", MPI_CONFIG_ACTION_PAGE_READ_CURRENT},
	{"Write Current Page", MPI_CONFIG_ACTION_PAGE_WRITE_CURRENT},
	{"Read Page Default", MPI_CONFIG_ACTION_PAGE_READ_DEFAULT},
	{"Write Page Default", MPI_CONFIG_ACTION_PAGE_DEFAULT},
	{"Read Page NVRAM", MPI_CONFIG_ACTION_PAGE_READ_NVRAM},
	{"Write Page NVRAM", MPI_CONFIG_ACTION_PAGE_WRITE_NVRAM},
	{"NULL", 0xFF}
};


CmdOptions configPageType[] =
{
	{"Select Page:  ", 0xFF},
	{"IO Unit Page", MPI_CONFIG_PAGETYPE_IO_UNIT},
	{"IOC Page", MPI_CONFIG_PAGETYPE_IOC},
//    {"BIOS Page", MPI_CONFIG_PAGETYPE_BIOS},
	{"SCSI-SPI Port Page", MPI_CONFIG_PAGETYPE_SCSI_PORT},
	{"SCSI-SPI Device Page", MPI_CONFIG_PAGETYPE_SCSI_DEVICE},
	{"FC Port Device Page", MPI_CONFIG_PAGETYPE_FC_PORT},
	{"FC Device Page", MPI_CONFIG_PAGETYPE_FC_DEVICE},
	{"LAN Page", MPI_CONFIG_PAGETYPE_LAN},
	{"RAID VOLUME Page", MPI_CONFIG_PAGETYPE_RAID_VOLUME},
	{"MANUFACTURING Page", MPI_CONFIG_PAGETYPE_MANUFACTURING},
	{"RAID Physical Disk Page", MPI_CONFIG_PAGETYPE_RAID_PHYSDISK},
	{"NULL", 0xFF}
};

char g_NumPages[] =
{
	4,          /* MPI_CONFIG_PAGETYPE_IO_UNIT */
	6,          /* MPI_CONFIG_PAGETYPE_IOC */
	0,          /* MPI_CONFIG_PAGETYPE_BIOS */
	3,          /* MPI_CONFIG_PAGETYPE_SCSI_PORT */
	4,          /* MPI_CONFIG_PAGETYPE_SCSI_DEVICE */
	11,         /* MPI_CONFIG_PAGETYPE_FC_PORT */
	1,          /* MPI_CONFIG_PAGETYPE_FC_DEVICE */
	2,          /* MPI_CONFIG_PAGETYPE_LAN */
	1,          /* MPI_CONFIG_PAGETYPE_RAID_VOLUME */
	5,          /* MPI_CONFIG_PAGETYPE_MANUFACTURING */
	1,          /* MPI_CONFIG_PAGETYPE_RAID_PHYSDISK */
};

/*
 * Options Menus for RAID Volume Ioctls
 */
CmdOptions raidVolumeAction[] =
{
	{"Select Action:  ", 0xFF},
	{"Get Volume Status", MPI_RAID_ACTION_STATUS},
	{"Get Indicator Structure", MPI_RAID_ACTION_INDICATOR_STRUCT},
	{"Create Raid Volume", MPI_RAID_ACTION_CREATE_VOLUME},
	{"Delete Raid Volume", MPI_RAID_ACTION_DELETE_VOLUME},
	{"Disable Raid Volume", MPI_RAID_ACTION_DISABLE_VOLUME},
	{"Enable Raid Volume", MPI_RAID_ACTION_ENABLE_VOLUME},
	{"Quiesce Internal I/Os", MPI_RAID_ACTION_QUIESCE_PHYS_IO},
	{"Enable Internal I/Os", MPI_RAID_ACTION_ENABLE_PHYS_IO},
	{"Change Volume Settings", MPI_RAID_ACTION_CHANGE_VOLUME_SETTINGS},
	{"Take Phsical Disk Offline", MPI_RAID_ACTION_PHYSDISK_OFFLINE},
	{"Make Physical Disk Online", MPI_RAID_ACTION_PHYSDISK_ONLINE},
	{"Change Device Settings", MPI_RAID_ACTION_CHANGE_PHYSDISK_SETTINGS},
	{"Create Physical Disk", MPI_RAID_ACTION_CREATE_PHYSDISK},
	{"Delete Physical Disk", MPI_RAID_ACTION_DELETE_PHYSDISK},
	{"Fail Physical Disk", MPI_RAID_ACTION_FAIL_PHYSDISK},
	{"Replace Physical Disk", MPI_RAID_ACTION_REPLACE_PHYSDISK},
	{"NULL", 0xFF}
};

/*
 * Options for selecting which events to save.
 */
CmdOptions eventTypes[] =
{
	{"Add Event Types: ", 0xFF},
	{"Log Nothing ", MPI_EVENT_NONE},
	{"Log Data ", MPI_EVENT_LOG_DATA},
	{"IOC-State Change ", MPI_EVENT_STATE_CHANGE},
	{"Unit Attention ", MPI_EVENT_UNIT_ATTENTION},
	{"Bus Reset ", MPI_EVENT_IOC_BUS_RESET},
	{"External Bus Reset ", MPI_EVENT_EXT_BUS_RESET},
	{"Rescan Required ", MPI_EVENT_RESCAN},
	{"Link Status Change ", MPI_EVENT_LINK_STATUS_CHANGE},
	{"Loop State Change ", MPI_EVENT_LOOP_STATE_CHANGE},
	{"Logout ", MPI_EVENT_LOGOUT},
	{"Event-State Change ", MPI_EVENT_EVENT_CHANGE},
	{"RAID Event ", MPI_EVENT_INTEGRATED_RAID},
	{"SCSI Device Change ", MPI_EVENT_SCSI_DEVICE_STATUS_CHANGE},
	{"On-Bus-Timer Expired ", MPI_EVENT_ON_BUS_TIMER_EXPIRED},
	{"Done  ", 0xFF},
	{"NULL", 0xFF}
};


/* Internal Utility Functions
 */
void MenuHandler(CmdStrings *menuPtr);

/* Global Variables
 */
extern int 	g_iocnum;
int   		g_passthrough = 0;
extern int	g_bigEndian;

#ifdef APP_MEM_TEST
int	g_target;
#endif


/*****************************************************************
 *                                                               *
 *                                                               *
 *  MAIN                                                         *
 *                                                               *
 *                                                               *
 *****************************************************************/
int main (int argc, char *argv[])
{
	FILE *pfile;
	char *name = "mptctl";
	char dataIn[PROC_READ_LINE];
	int  c;
	test_endianess_t test;

	/* Initialize (force a buffer flush)
	 */
	setvbuf(stdout,NULL,_IONBF,0);

	/* Get the system endianness....MPI request frames must have
	 * Little Endianness. If bigEndian, byte swap on data coming from FW
	 * and all request frame fields.
	 */
	test.u.foo = 0x01020304;
	g_bigEndian = 0;
	if (test.u.bar[0] != (test.u.foo & 0xFF))
			g_bigEndian = 1;

	/* Show the tool name, version number and build date
	 */
	ShowAbout();

	/* Open /proc/modules to determine if
	 * driver loaded.
	 */
	snprintf(dataIn, PROC_READ_LINE, "/proc/modules");
	if ((pfile = fopen(dataIn, "r")) == NULL ) {
		printf("Open of /proc/modules failed!\n");
		DoExit();
	}

	c = 0;
	while (1) {
		if (fgets(dataIn, PROC_READ_LINE, pfile) == NULL)
			break;

		if (strstr(dataIn, name) != NULL) {
			c = 1;
			break;
		}
	}
	fclose(pfile);

	if (c == 0) {
		system("insmod mptctl");
	}

	/* Verify 2 arguments
	 * Print Usage if necessary.
	 */
#ifndef APP_MEM_TEST
	if (argc != 2){
		fprintf (stderr, "usage: %s iocnum \n", argv[0]);
		return (0);
	}
#else
	if (argc != 3){
		fprintf (stderr, "usage: %s iocnum target\n", argv[0]);
		return (0);
	}
#endif

	/* Get and open scsi node.
	 */
	if (OpenDevice(argv[1]))
		DoExit();

	/* Main Menu - set mode to script/individual or exit
	 */
#ifndef APP_MEM_TEST
	MenuHandler(mainMenuList);
#else
	if (CheckNumericalInput(argv[2]) != APP_TRUE) {
		printf("not a digit\n");
	} else {
		int kk;
		g_target = atoi(argv[2]);
		if ((g_target >= 0) && (g_target <= 255)) {
			kk=1;
			while (kk) {
				for (c=0; c < 10000; c++) {
					GetIocInfo();
					GetTargetInfo();
					InquiryCmd();
					ReadCapacityCmd();
					ModeSenseCmd();
					Read10Cmd();
				}
				printf("Iteration %d\n", kk);
				kk++;
				sleep (1);
			}
		}
	}
#endif

	return 0;
}

/*****************************************************************
 *  void MenuHandler(CmdStrings *menuPtr)
 *
 *  input:  menuPtr - pointer to a menu of type CmdStrings
 *              the last entry must be NULL
 *  Purpose:  Will display the supplied menu and check for the
 *            validity of the user input agains the menu choices
 *            On a successful input, will invoke the specified
 *            menu function.
 *****************************************************************/
void MenuHandler(CmdStrings *menuPtr)
{
	char dataIn[DATAIN_LENGTH];
	int input;
	char counter;
	uchar notDone = APP_TRUE;
	uchar menuNotDone;

	while (notDone) {
		input = 0;
		counter = 0;
		menuNotDone = APP_TRUE;
		printf("\n");
		while (menuNotDone) {
			if (strcmp(menuPtr[(int)counter].cmdString,"NULL") != 0) {
				if (counter == 0)
					printf("\n%s", menuPtr[(int)counter].cmdString);
				else
					printf("\n%d - %s", counter, menuPtr[(int)counter].cmdString);
				counter++;
			} else {
				/* Completed showing menu? Decrement counter.
				 * Valid values [1, counter]
				 */
				menuNotDone = APP_FALSE;
				counter--;
			}
		}
		printf("\nPlease enter your selection:  ");
		fgets (dataIn, DATAIN_LENGTH, stdin);

		printf("Entered value %s\n", dataIn); /* REMOVE */
		if (CheckNumericalInput(dataIn) == APP_FALSE)
			continue;

		sscanf(dataIn, "%d", &input);

		/* If Legal, invoke the specified funcion
		 */
		if ((input < 1)||(input > counter))
			printf("\nInvalid entry, please try again.\n");
		else
			menuPtr[input].cmdFunction();
	}

	return;
}

/*****************************************************************
 * OptionsMenuHandler
 *
 * Return an integer (MPI DEFINE) when a specific option is selected.
 * Used only for config page requests.
 *
 *****************************************************************/
uchar OptionsMenuHandler (CmdOptions *menuPtr)
{
	char dataIn[DATAIN_LENGTH];
	int input;
	char counter;
	uchar notDone = APP_TRUE;
	uchar menuNotDone;

	while (notDone) {
		counter = 0;
		menuNotDone = APP_TRUE;
		printf("\n");
		while (menuNotDone) {
			if (strcmp(menuPtr[(int) counter].optionString,"NULL") != 0) {
				if (counter == 0)
					printf("\n%s", menuPtr[(int) counter].optionString);
				else
					printf("\n%d - %s", counter, menuPtr[(int)counter].optionString);

				counter++;
			} else {
				menuNotDone = APP_FALSE;
				counter--;
			}
		}
		printf("\nPlease enter your selection:  ");
		fgets(dataIn, DATAIN_LENGTH, stdin);

		/* Verify that a numeric value was entered
		 */
		if (CheckNumericalInput(dataIn) == APP_FALSE)
			continue;

		/* Input string consists only of digits, convert to a number.
		 */
		sscanf(dataIn, "%d", &input);

		/* Check input to make sure that entered value is legal
		 */
		if ((input < 1)||(input > counter))
			printf("\nInvalid entry, please try again.\n");
		else
			notDone = APP_FALSE;
	}

	return (menuPtr[input].value);

}


/*****************************************************************
 *                                                               *
 * Primary Menu Functions.                                       *
 *                                                               *
 *                                                               *
 *****************************************************************/
/*****************************************************************
 * NullFunction
 *
 * A generic routine used as a place holder.
 *
 *****************************************************************/
void NullFunction (void)
{
	return;
}

/*****************************************************************
 * OtherIoctlCommands
 *
 * MenuDisplay callback for the Other specific ioctl commands.
 * Linux OS only.
 *****************************************************************/
void OtherIoctlCommands(void)
{
	MenuHandler(OtherIoctls);
	return;
}

/*****************************************************************
 * DIagIoctlCommands
 *
 * MenuDisplay callback for the Other specific ioctl commands.
 * Linux OS only.
 *****************************************************************/
void DiagIoctlCommands(void)
{
	MenuHandler(DiagIoctls);
	return;
}

/*****************************************************************
 * CompaqIoctlCommands
 *
 * MenuDisplay callback for the Compaqr specific ioctl commands.
 * Linux OS only.
 *****************************************************************/
void CompaqIoctlCommands(void)
{
	MenuHandler(CompaqIoctls);
	return;
}

/*****************************************************************
 * IoIoctlCommands
 *
 * MenuDisplay callback for the SCSI IO ioctl commands.
 *****************************************************************/
void IoIoctlCommands(void)
{
	g_passthrough = 0;
	MenuHandler(IoIoctls);
	return;
}

/*****************************************************************
 * PassthroughIoIoctlCommands
 *
 * MenuDisplay callback for the SCSI IO RAID Passthrough ioctl
 * commands.
 *****************************************************************/
void PassthroughIoIoctlCommands(void)
{
	g_passthrough = 1;
	MenuHandler(IoIoctls);
	return;
}


/*****************************************************************
 * MptIoctlCommands
 *
 * MenuDisplay callback for non-SCSI I/O MPT commands.
 *****************************************************************/
void MptIoctlCommands(void)
{
	MenuHandler(NonIoMptIoctls);
	return;
}

/*****************************************************************
 * MainMenuCommands
 *
 * MenuDisplay callback for the main menu commands.
 *****************************************************************/
void MainMenuCommands(void)
{
	MenuHandler(mainMenuList);
	return;
}


/*****************************************************************
 * void ShowHelp(void)
 * Purpose:  Displays the user help information.
 *****************************************************************/
void ShowHelp(void)
{
	printf("\n\nThis is a menu-driven application intended \n");
	printf("primarily for test purposes.  The application will \n");
	printf("allow generation and execution of: \n");
	printf("\t SCSI IO IOCTLs - issue standard SCSI IO commands through\n");
	printf("\t\t the MPT interface;\n");
	printf("\t MPT IOCTLs - get config pages, port and IOC facts,\n");
	printf("\t\t firmware download. The application will generate;\n");
	printf("\t\t the MPT request and pass that to host driver.\n");
	printf("\t\t Only passive (read) commands are currently implemented.\n");
	printf("\t Other Specific IOCTLs - get the driver type, version, \n");
	printf("\t\t bus type, bus reset;\n");
	printf("\n\n Press enter to return to the main menu...\n");
	getchar();

	return;
}

/*****************************************************************
 * void ShowAbout(void)
 * Purpose:  Displays the tool ID string
 *****************************************************************/
void ShowAbout(void)
{
	printf("\n\n%s\n",ToolTitle);
	printf("%s\n",IdString);
	printf("%s\n",LsiCopyright);

	return;
}
