/*****************************************************************
 *                                                               *
 * Copyright 2000-2002 LSI Logic. All rights reserved.           *
 *                                                               *
 * This fiel is confidential and a trade secret of LSI Logic.    *
 * The receipt of or possession of this file does not convey any *
 * rights to reproduce or disclose its contents or to            *
 * manufacture, use, or sell anything it may describe, in whole, *
 * or in part, without the specific written consent of LSI Logic.*
 *                                                               *
 *****************************************************************/

/* System Include Files
 */
#include "apps.h"

/* Function Prototypes
 */
void ConfigIoctl (int min_idx, int max_idx);

/* Globals
 */
extern int mptio_GetIocInfo(void);
extern void mptio_GetTargetInfo(void);

extern mpiIoctlBlk_t    *mpiBlkPtr;
extern int              g_iocnum;
extern int              g_bigEndian;

/*****************************************************************
 *
 *
 *  MAIN
 *
 *
 *****************************************************************/
int main (int argc, char *argv[])
{
	FILE *pfile;
	char *name = "mptctl";
	char dataIn[PROC_READ_LINE];
	int  c;
	test_endianess_t test;

	/* Initialize (force a buffer flush)
	 */
	setvbuf(stdout,NULL,_IONBF,0);

	/* Get the system endianness....MPI request frames must have
	 * Little Endianness. If bigEndian, byte swap on data coming from FW
	 * and all request frame fields.
	 */
	test.u.foo = 0x01020304;
	g_bigEndian = 0;
	if (test.u.bar[0] != (test.u.foo & 0xFF))
		g_bigEndian = 1;

	/* Open /proc/modules to determine if
	 * driver loaded.
	 */
	snprintf(dataIn, PROC_READ_LINE, "/proc/modules");
	if ((pfile = fopen(dataIn, "r")) == NULL ) {
		printf("Open of /proc/modules failed!\n");
		DoExit();
	}

	c = 0;
	while (1) {
		if (fgets(dataIn, PROC_READ_LINE, pfile) == NULL)
			break;

		if (strstr(dataIn, name) != NULL) {
			c = 1;
			break;
		}
	}
	fclose(pfile);

	if (c == 0) {
		system("insmod mptctl");
	}

	/* Usage
	 */
	if (argc < 2){
		fprintf (stderr, "usage: %s iocnum\n", argv[0]);
		return (0);
	}

	/* Get and open scsi node.
	 */
	if (OpenDevice(argv[1]))
		DoExit();

	if ( mptio_GetIocInfo() )
	{
		mptio_GetTargetInfo();
	}
	else
	{
		printf ("No mpt Host Adapter available at ha=%d\n", g_iocnum);
	}

	DoExit();
	return 0;
}

/*****************************************************************
 * ConfigIoctl
 *
 *****************************************************************/
void ConfigIoctl (int min_idx, int max_idx)
{
	Config_t *ConfigRequest;
	ConfigReply_t *pReply = NULL;
	char *speed;
	SCSIDevicePage0_t *pSDP0;
	uint tmp;
	uint numBytes;
	uint negoParms;
	int  id, status;
	uchar bus = 0;

	numBytes = (sizeof(Config_t) - sizeof(SGE_IO_UNION)) + sizeof (SGESimple64_t);
	if ((mpiBlkPtr = allocIoctlBlk(numBytes)) == NULL)
		return;

	ConfigRequest = (Config_t *) mpiBlkPtr->MF;
	mpiBlkPtr->dataInSize = mpiBlkPtr->dataOutSize = 0;
	mpiBlkPtr->dataInBufPtr = mpiBlkPtr->dataOutBufPtr = NULL;
	mpiBlkPtr->dataSgeOffset = (sizeof (Config_t) - sizeof(SGE_IO_UNION))/4;

	pReply = (ConfigReply_t *)mpiBlkPtr->replyFrameBufPtr;

	/* Populate the Config Request
	 */
	ConfigRequest->Action       = MPI_CONFIG_ACTION_PAGE_HEADER;
	ConfigRequest->Function     = MPI_FUNCTION_CONFIG;
	ConfigRequest->MsgContext   = -1;
	ConfigRequest->Header.PageType = MPI_CONFIG_PAGETYPE_SCSI_DEVICE;
	ConfigRequest->PageAddress = cpu_to_le32((bus << 8) | min_idx);

	status = IssueMptCommand(MPT_FLAGS_KEEP_MEM);

	if ((status != 0) || (pReply->Header.PageLength == 0)) {
		freeAllocMem ();
		return;
	}

	mpiBlkPtr->dataInSize = pReply->Header.PageLength * 4;
	if (allocDataFrame(DATA_DIR_IN)) {
		printf ("Config: Unable to allocate data buffer.");
		freeAllocMem ();
		return;
	}

	ConfigRequest->Action = MPI_CONFIG_ACTION_PAGE_READ_CURRENT;
	ConfigRequest->Header.PageVersion = pReply->Header.PageVersion;
	ConfigRequest->Header.PageLength = pReply->Header.PageLength;
	pSDP0 = (SCSIDevicePage0_t *) mpiBlkPtr->dataInBufPtr;

	for (id = min_idx; id <= max_idx; id++) {
		ConfigRequest->PageAddress = cpu_to_le32((bus << 8) | id);
		status = IssueMptCommand(MPT_FLAGS_KEEP_MEM);
		if (status == 0) {
			printf("Id 0x%x: ", id);

			negoParms = le32_to_cpu(pSDP0->NegotiatedParameters);
			printf("%s, ", negoParms & MPI_SCSIDEVPAGE0_NP_WIDE ? "Wide" : "Narrow");

			if (negoParms & MPI_SCSIDEVPAGE0_NP_NEG_SYNC_OFFSET_MASK) {
				 tmp = (negoParms & MPI_SCSIDEVPAGE0_NP_NEG_SYNC_OFFSET_MASK) >> 16;
				printf("Synchronous: Offset=0x%x, ", tmp);
				tmp = (negoParms & MPI_SCSIDEVPAGE0_NP_NEG_SYNC_PERIOD_MASK) >> 8;
				if (tmp == 0x08)
					speed = "Ultra320";
				else if (tmp <= 0x09)
					speed = "Ultra160";
				else if (tmp <= 0x0A)
					speed = "Ultra2";
				else if (tmp <= 0x0C)
					speed = "Ultra";
				else
					speed = "Fast or Slower";
		
				printf("Factor=0x%x (%s)\n", tmp, speed);
				printf("\tSpecial Features Enabled: ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_IU)
					printf("IU ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_DT)
					printf("DT ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_QAS)
					printf("QAS ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_HOLD_MCS)
					printf("HOLD_MCS ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_WR_FLOW)
					printf("WR_FLOW ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_RD_STRM)
					printf("RD_STRM ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_RTI)
					printf("RTI ");
				if (negoParms & MPI_SCSIDEVPAGE0_NP_PCOMP_EN)
					printf("PCOMP_EN");
				printf("\n");
			} else
				printf("Asynchronous.\n");
		}
	}

	freeAllocMem();
	return;
}
