
/* System Include Files
 */
#include "apps.h"


/* Global Variables
 */
extern int	g_fd;   
extern int	g_iocnum;   

char *bus_width[] =
{
	"",
	"Unknown",
	"Narrow",
	"Wide",
	"Double Wide"
};

char *bus_speed[] =
{
	"",
	"",
	"Async",
	"Fast",
	"Ultra",
	"Ultra2",
	"Ultra160",
	"SCSI 1",
	"Ultra320"
};

char *hp_status[] =
{
	"",
	"Unknown",
	"Ok",
	"Failed"
};
/*****************************************************************
 *
 *      COMPAQ Support IOCTLS
 *
 *****************************************************************/
/*****************************************************************
 * HP_HostInfo
 *
 * The driver will fill in the contents of the structure:
 *
 * Most data returned in this structure is stored statically
 * within the driver.
 *****************************************************************/
void HP_HostInfo(void)
{
	hp_host_info_t thisBuf;
	int sz = sizeof(hp_host_info_t);

	memset (&thisBuf, 0, sz);

	thisBuf.hdr.iocnum = g_iocnum;

	ShowBuf ("HP_GETHOSTINFO Start:", &thisBuf, sz, 0);
	if (ioctl(g_fd, (unsigned long) HP_GETHOSTINFO, (char *) &thisBuf) != 0)
		perror ("HP_GETHOSTINFO ioctl failed");
	else {
		ShowBuf ("HP_GETHOSTINFO Data:", &thisBuf, sz, 0);
		printf ("Get Host Information:\n");
		printf ("================================\n");
		printf ("Vendor           = 0x%04x\n", thisBuf.vendor);
		printf ("Device           = 0x%04x\n", thisBuf.device);
		printf ("Subsystem Vendor = 0x%04x\n", thisBuf.subsystem_vendor);
		printf ("Subsystem Device = 0x%04x\n", thisBuf.subsystem_id);
		printf ("PCI device_fn    = 0x%x\n", thisBuf.devfn);
		printf ("PCI bus          = %d\n", thisBuf.bus);
		printf ("SCSI Host Number = %d\n", thisBuf.host_no);
		printf ("FW Version       = %s\n", thisBuf.fw_version);
		printf ("Serial Number    = %s\n", thisBuf.serial_number);
		printf ("IOC Status       = %d (%s)\n", thisBuf.ioc_status,
						hp_status[thisBuf.ioc_status]);
		printf ("Bus Phys Width   = %d\n", thisBuf.bus_phys_width);
		printf ("Base IO Addr     = 0x%08x\n", thisBuf.base_io_addr);
		printf ("Hard Resets      = %d\n", thisBuf.hard_resets);
		printf ("Soft Resets      = %d\n", thisBuf.soft_resets);
		printf ("Timeouts         = %d\n", thisBuf.timeouts);
	}

	return;
}

/*****************************************************************
 * HP_HostInfo_rev0
 *
 * The driver will fill in the contents of the structure:
 *
 * Most data returned in this structure is stored statically
 * within the driver.
 *****************************************************************/
void HP_HostInfo_rev0(void)
{
	hp_host_info_rev0_t thisBuf;
	int sz = sizeof(hp_host_info_rev0_t);

	memset (&thisBuf, 0, sz);

	thisBuf.hdr.iocnum = g_iocnum;

	ShowBuf ("HP_GETHOSTINFO Start:", &thisBuf, sz, 0);
	if (ioctl(g_fd, (unsigned long) HP_GETHOSTINFO1, (char *) &thisBuf) != 0)
		perror ("HP_GETHOSTINFO1 ioctl failed");
	else {
		ShowBuf ("HP_GETHOSTINFO1 Data:", &thisBuf, sz, 0);
		printf ("Get Host Information (rev 0):\n");
		printf ("================================\n");
		printf ("Vendor           = 0x%04x\n", thisBuf.vendor);
		printf ("Device           = 0x%04x\n", thisBuf.device);
		printf ("Subsystem Vendor = 0x%04x\n", thisBuf.subsystem_vendor);
		printf ("Subsystem Device = 0x%04x\n", thisBuf.subsystem_id);
		printf ("PCI device_fn    = 0x%x\n", thisBuf.devfn);
		printf ("PCI bus          = %d\n", thisBuf.bus);
		printf ("SCSI Host Number = %d\n", thisBuf.host_no);
		printf ("FW Version       = %s\n", thisBuf.fw_version);
		printf ("Serial Number    = %s\n", thisBuf.serial_number);
		printf ("IOC Status       = %d (%s)\n", thisBuf.ioc_status,
						hp_status[thisBuf.ioc_status]);
		printf ("Bus Phys Width   = %d\n", thisBuf.bus_phys_width);
		printf ("Base IO Addr     = 0x%08x\n", thisBuf.base_io_addr);
		printf ("Hard Resets      = %ld\n", thisBuf.hard_resets);
		printf ("Soft Resets      = %ld\n", thisBuf.soft_resets);
		printf ("Timeouts         = %ld\n", thisBuf.timeouts);
	}

	return;
}

/*****************************************************************
 * HP_TargetInfo
 *
 * The driver will fill in the contents of the structure:
 *
 * Most data returned in this structure is stored statically
 * within the driver.
 *****************************************************************/
void HP_TargetInfo(void)
{
	hp_target_info_t	thisBuf;
	int sz = sizeof(hp_target_info_t);

	memset (&thisBuf, 0, sz);

	thisBuf.hdr.iocnum = g_iocnum;
	thisBuf.hdr.host = AskValue(0, 32, "Enter the SCSI Host number:");
	thisBuf.hdr.channel = 0;
	thisBuf.hdr.id = AskValue(0, MAX_FC_ID, "Enter the SCSI ID number:");
	thisBuf.hdr.lun = 0;

	ShowBuf ("HP_GETTARGETINFO Start:", (char *) &thisBuf, sz, 0);
	if (ioctl(g_fd, (unsigned long) HP_GETTARGETINFO, (char *) &thisBuf) != 0)
		perror ("HP_GETTARGETINFO ioctl failed");
	else {
		ShowBuf ("HP_GETTARGETINFO Data:", &thisBuf, sz, 0);
		printf ("Get Target Information (rev 0):\n");
		printf ("================================\n");
		printf ("Host:\n");
		printf ("\tIOC           = %d\n", g_iocnum);
		printf ("\tSCSI          = %d\n", thisBuf.hdr.host);
		printf ("\tBus           = %d\n", thisBuf.hdr.channel);
		printf ("\tID            = %d\n", thisBuf.hdr.id);
		printf ("\tLUN           = %d\n", thisBuf.hdr.lun);
		printf ("Data Transfer:\n" );
		printf ("\tWidth         = %d (%s)\n", thisBuf.negotiated_width, 
					bus_width[thisBuf.negotiated_width]);
		printf ("\tSpeed         = %d (%s)\n", thisBuf.negotiated_speed,
					bus_speed[thisBuf.negotiated_speed]);
		printf ("Errors:\n");
		printf ("\tParity        = %d\n", thisBuf.parity_errors);
		printf ("\tPhase         = %d\n", thisBuf.phase_errors);
		printf ("\tMsg Rejects   = %d\n", thisBuf.message_rejects);
		printf ("\tSel Timeouts  = %d\n", thisBuf.select_timeouts);
	}

	return;
}
