/*****************************************************************
 *                                                               *
 * Copyright 2000-2002 LSI Logic. All rights reserved.           *
 *                                                               *
 * This file is confidential and a trade secret of LSI Logic.    *
 * The receipt of or possession of this file does not convey any *
 * rights to reproduce or disclose its contents or to            *
 * manufacture, use, or sell anything it may describe, in whole, *
 * or in part, without the specific written consent of LSI Logic.*
 *                                                               *
 *****************************************************************/

/* Include Files
 */
#include "apps.h"

/* Globals
 */
static char      *specialFile = MPT_MISCDEV_PATHNAME;
mpiIoctlBlk_t	 *scsiBlkPtr=NULL;
mpiIoctlBlk_t	 *configBlkPtr=NULL;
int              g_fd;
int              errno;
int              g_iocnum;
int              g_bigEndian = 0;

/* Defines
 */

/*****************************************************************
 * Byte swapping functions. MPI is LittleEndian.
 *****************************************************************/
u32 swap32(u32 x) {
	if (g_bigEndian) {
		u32 y;
		y = (x & 0xFF00) << 8;
		y |= (x & 0xFF) << 24;
		y |= (x & 0xFF0000) >> 8;
		y |= (x & 0xFF000000) >> 24; 
		return y;
	} else
		return x;
}

u16 swap16(u16 x) {
	if (g_bigEndian) {
		u16 y = (((x & 0xFF00) >> 8) | ((x & 0xFF) << 8)); 
		return y;
	} else
		return x;
}

/*****************************************************************
 * Given the ioc number, verify acceptable and open
 * the specialFile. The iocnum (global) is set.
 *
 * Return the device number to the calling program.
 *
 * Return 0: success   non-zero: fail
 *****************************************************************/
int OpenDevice ( char *inputDevice)
{
	int rc = 0;

	if (!isdigit (*inputDevice)) {
		fprintf (stderr, "usage: %s iocnum \n", inputDevice);
		rc = 1;
	} else {
		g_iocnum = atoi(inputDevice);
		if (g_iocnum < 0 || g_iocnum > MPT_MAX_ADAPTERS) {
			fprintf (stderr, "usage: %s iocnum \n", inputDevice);
			fprintf (stderr, "0 <= iocnum <= %d\n", MPT_MAX_ADAPTERS);
			rc = 2;
		} else {
			unsigned int major = 10;
			unsigned int minor = 220;
			dev_t device = (dev_t) ((major << 8) | minor);

			/* Valid ioc number, open the special file.
			 */
			if ((g_fd = open(specialFile, O_RDWR)) < 0) {
				switch(errno)
				{
				case ENOENT:
				case ENXIO:
				case ENODEV:
					/* See man 2 mknod: 
					 * S_IFCHR - a character special file.
					 * Permissions: 0644: rwx user; r og
					 *
					 * makedev(10, 200) creates dev_t type
					 * of variable. system macro in
					 * (sys/sysmacros.h) Depending on 
					 * platform, dev_t is either an 
					 * unsigned int or an unsigned short.
					 */

					mknod(specialFile, 0644 | S_IFCHR, device);

					/* See man 2 chmod or 
					 * linux/include/stat.h for defines
					 * Set perms. to 0644: rwx user; r og
					 */
					chmod(specialFile, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
					if ((g_fd = open(specialFile, O_RDWR)) >= 0) {
						printf("Created and opened %si\n", specialFile);
						break;
					}

					/* Fall through to the default error case 
					 * when open fails.
					 */
				default:
					printf("Can't open %s.", specialFile);
					rc = g_fd;
					break;
				}
			}
		}
	}

	return rc;
}

/***************************************************************** 
 * DoExit
 * Purpose:  If a file pointer is open, close the file pointer
 *           and exit the program.  Remove the special file
 *           "scsinode" from the working directory.
 *****************************************************************/
void DoExit(void)
{
	if (g_fd != -1)
		close(g_fd);

	exit(0);
}

/*****************************************************************
 * uchar CheckHexInput (char *dataString)
 *
 * Input:  string pointer
 * Return:  False if dataString contains non-hex characters
 *          True otherwise
 * Purpose:  To ensure that the entered data is hex
 *****************************************************************/
uchar CheckHexInput(char *dataString)
{
	uint ii;
	uchar isHex = APP_TRUE;
	char *newLine = NULL;

	/* Replace new line character if it exists.
	 */
	if ( (newLine = strchr(dataString, '\n')) != NULL )
		*newLine = 0;

	for (ii=0; ii < strlen(dataString); ii++) {
		if (isxdigit(dataString[ii]) == 0){
			isHex = APP_FALSE;
			break;
		}
	}

	return isHex;
}

/*****************************************************************
 * uchar CheckNumericalInput (char *dataString)
 *
 * Input:  string pointer
 * Return:  False if dataString contains non-digit characters
 *          True otherwise
 * Purpose:  To ensure that the entered data is numerical
 *****************************************************************/
uchar CheckNumericalInput(char *dataString)
{
	uint ii;
	uchar isDecimal = APP_TRUE;
	char *newLine = NULL;

	/* Replace new line character if it exists.
	 */
	if ( (newLine = strchr(dataString, '\n')) != NULL )
		*newLine = 0;


	for (ii=0; ii < strlen(dataString); ii++) {
		if (isdigit(dataString[ii]) == 0) { // Not a digit, continue
			isDecimal = APP_FALSE;
			break;
		}
	}

	return isDecimal;
}

/*****************************************************************
 * uchar AskBits( uchar noBits, char *dataString)
 *
 * inputs: noBits - number of bits that can be modified. Valid
 *                  values are 1 through 8
 *         dataString - querry specific string
 * returns: value set by user or 0 in case of an error (this is
 *          also a legal value
 * Purpose: Generic subroutine to get up to 1 byte of data for
 *          populating the CDB and/or buffer
 *****************************************************************/
uchar AskBits( uchar noBits, char *dataString)
{
	char dataIn[DATAIN_LENGTH];
	uchar input;
	uchar inputMax;

	if ((noBits == 0) || (noBits >8)) {
		printf("\nERROR! AskBits called with the number of bits");
		printf("\nequal to 0 or larger than 8.");
		return 0;
	}

	inputMax = (1<<noBits) - 1;

	while (1) {
		printf("\nEnter value for the %s  [0x00, 0x%02X] = 0x", 
							dataString, inputMax);
		fgets (dataIn, DATAIN_LENGTH, stdin);

		if (CheckHexInput(dataIn) == APP_FALSE)
			continue;

		input = (uchar) strtoul(dataIn, (char**)NULL, 16); 

		if (input <= inputMax)
			break;
	}
	return input;
}


/*****************************************************************
 * uint AskBytes( uchar noBytes, char *dataString)
 *
 * inputs: noBytes - number of bits that can be modified. Valid
 *                  values are 1 through 4
 *         dataString - querry specific string
 * returns: value set by user or 0 in case of an error (this is
 *          also a legal value
 * Purpose: Generic subroutine to get up to 1 byte of data for
 *          populating the CDB and/or buffer
 *****************************************************************/
uint AskBytes( uchar noBytes, char *dataString)
{
	char  dataIn[DATAIN_LENGTH];
	uint input;
	uint inputMax;

	if ((noBytes == 0) || (noBytes > 4)) {
		printf("\nERROR! AskBytes called with the number of bytes");
		printf("\nequal to 0 or larger than 4.");
		return 0;
	}

	inputMax = (((uint) 1) <<(noBytes*8)) - 1;

	while (1) {
		printf("\nEnter value for the %s  [0x00, 0x%0X] = 0x", 
							dataString, inputMax);
		fgets(dataIn, DATAIN_LENGTH, stdin);

		if (CheckHexInput(dataIn) == APP_FALSE)
			continue;

		input = (uint) strtoul(dataIn, (char**)NULL, 16); 

		if (input <= inputMax)
			break;
	}
	return input;
}

/*****************************************************************
 * uint AskValue(uint minValue, uint maxValue,
 *                      char *dataString)
 *
 * Inputs:  minValue - minimum legal value
 *          maxValue - maximum legal value
 *          dataString - string to print
 *
 * Purpose: return a value between the specified minimum and
 *          maximum values
 *****************************************************************/
uint AskValue(uint minValue, uint maxValue, char *dataString)
{
	char  dataIn[DATAIN_LENGTH];
	uint input;

	if (minValue > maxValue) {
		printf("\nMinimum exceed maximum. Return 0");
		return 0;
	}

	while (1) {
		printf("\n%s [0x%X, 0x%X] = 0x", dataString, minValue, maxValue);
		fgets (dataIn, DATAIN_LENGTH, stdin);

		if (CheckHexInput(dataIn) == APP_FALSE)
			continue;

		input = (uint) strtoul(dataIn, (char**)NULL, 16); 

		if ((input >= minValue) && (input <= maxValue))
			break;
		else
			printf("\nEnter a value in the range [0x%0X, 0x%0X]", 
						minValue, maxValue);
	}

	return input;
}


/*****************************************************************
 *
 * ShowBuf - dump the buffer contents w/ header and ascii conversion.
 *
 *****************************************************************/
void ShowBuf(char *titleP, void *dataBufP, int count, int always)
{
	int done;
	int lineDone = 0;
	int i;
	unsigned char *bufP = (unsigned char *) dataBufP;
	unsigned char textBuf [BYTES_PER_LINE + 1];
	unsigned char nextByte;
	unsigned char sepChar;

#ifdef DEBUG_APP
	always = 1;
#endif
	if (always == 0) 
		return;

	printf ("%s\n", titleP);

	if (count > 96)
		count = 96;

	done = 0;
	while (done < count) {
		if (lineDone == 0)
			printf(" %.4X: ", done);

		if (lineDone == (BYTES_PER_LINE/2))
			sepChar = '-';
		else
			sepChar = ' ';

		nextByte = bufP[done];

		printf ("%c%.2X", sepChar, nextByte);
		if ( (nextByte >= 0x20) && (nextByte <= 0x7F))
			textBuf[lineDone] = nextByte;
		else
			textBuf[lineDone] = '.';

		lineDone++;
		done++;

		if ((lineDone == BYTES_PER_LINE) || (done == count)) {
			for (i=lineDone; i<BYTES_PER_LINE; i++)
				printf("   ");

			textBuf[lineDone]='\0';
			printf("  %s\n", textBuf);
			lineDone =0;
		}
	}
	return;
}
