/* Include Files
 */
#include "apps.h"

/* Globals
 */
mpiIoctlBlk_t	*mpiBlkPtr = NULL;
extern int	g_iocnum;
extern int	g_fd;

#ifndef	APP_MEM_TEST
char  g_data[4*1024];
uchar g_command[1024];
char  g_reply[1024];
char  g_sense[256];
#endif

/* Defines
 */
u8	g_buffer[GBL_BUF_SIZE];

/*****************************************************************
 * IssueMptIoctl
 *
 * Generic command to issue the MPT command using the special
 * SDI_IOC | 0x01 Ioctl Function.
 *****************************************************************/
int IssueMptCommand (uint flags)
{
	MPIDefaultReply_t *pReply = NULL;
	int CmdBlkSize;
	int status = -1;
	int dumpData = 1;

	CmdBlkSize = sizeof(mpiIoctlBlk_t) + ((mpiBlkPtr->dataSgeOffset)*4) + 8;

	ShowBuf("Command Block Before: ", mpiBlkPtr, CmdBlkSize, 0);
#ifdef DEBUG_APP_BIG
	printf("reply %p  max (%d) \n",
		    mpiBlkPtr->replyFrameBufPtr, mpiBlkPtr->maxReplyBytes);
	printf("data in %p size (%d) \n",
			    mpiBlkPtr->dataInBufPtr, mpiBlkPtr->dataInSize);
	printf("data out %p size (%d) \n",
			    mpiBlkPtr->dataOutBufPtr, mpiBlkPtr->dataOutSize);
	printf("sense %p size (%d) \n",
			    mpiBlkPtr->senseDataPtr, mpiBlkPtr->maxSenseBytes);
	printf("Timeout %d, \n", mpiBlkPtr->timeout);

	printf("CmdBlkSize %d  mpiBlkPtr %p\n", CmdBlkSize, mpiBlkPtr);

	printf(" dataSgeOffset*4 0x%x, size of SGESimple64 0x%x\n",
		    mpiBlkPtr->dataSgeOffset*4, (uint) sizeof(SGESimple64_t));
	printf("Press enter to continue..");
	getchar();
#endif

	/* Set the IOC number prior to issuing this command.
	 */
	mpiBlkPtr->hdr.iocnum = g_iocnum;
	mpiBlkPtr->hdr.port = 0;

	if (ioctl(g_fd, (unsigned long) MPTCOMMAND, (char *) mpiBlkPtr) != 0)
		perror("IOCTL failed");
	else {
		/* Be smarter about dumping and using data.
		 * If SCSI IO, reply may be null and data xfer
		 * will be good. If a non-SCSI IO, if reply is
		 * NULL data is definately garbage.
		 *
		 */
		pReply = (MPIDefaultReply_t *) mpiBlkPtr->replyFrameBufPtr;
		if ((pReply) && (pReply->MsgLength > 0)) {
			u8 funct = pReply->Function;
			u8 state = mpiBlkPtr->replyFrameBufPtr[0x0D];

			pReply->IOCStatus = le16_to_cpu(pReply->IOCStatus);

			ShowBuf("Reply Frame : ", pReply, pReply->MsgLength * 4, 0);

			status = pReply->IOCStatus & MPI_IOCSTATUS_MASK;
			if (flags & MPT_FLAGS_DUMP_REPLY)
				ShowBuf("Reply Frame : ", pReply, pReply->MsgLength * 4, 1);

			if ((funct == MPI_FUNCTION_SCSI_IO_REQUEST) ||
					(funct == MPI_FUNCTION_RAID_SCSI_IO_PASSTHROUGH)) {
				if (state & MPI_SCSI_STATE_AUTOSENSE_VALID) {
					/* non-NULL only for SCSI IO commands */
					if (mpiBlkPtr->senseDataPtr) {
						dumpData = 0;
						ShowBuf("Sense : ", mpiBlkPtr->senseDataPtr,
									mpiBlkPtr->maxSenseBytes, 1);
					}
				} else if (state & (MPI_SCSI_STATE_TERMINATED |
						MPI_SCSI_STATE_AUTOSENSE_FAILED |
						MPI_SCSI_STATE_NO_SCSI_STATUS)) {
					dumpData = 0;
				}
			}
		} else
			status = 0;

#ifndef APP_MEM_TEST
		if (status != 0)
			printf("ERROR");
#else
		if (!status && dumpData && (flags & MPT_FLAGS_DUMP_DATA)) {
			if (mpiBlkPtr->dataInBufPtr)
				ShowBuf("Data In: ", mpiBlkPtr->dataInBufPtr,
								mpiBlkPtr->dataInSize, 1);
			if (mpiBlkPtr->dataOutBufPtr)
				ShowBuf("Data Out: ", mpiBlkPtr->dataOutBufPtr,
								mpiBlkPtr->dataOutSize, 1);
		}

		if (!status && dumpData && mpiBlkPtr->dataInBufPtr) {
			memcpy(g_buffer, mpiBlkPtr->dataInBufPtr,
				mpiBlkPtr->dataInSize < GBL_BUF_SIZE ?  mpiBlkPtr->dataInSize : GBL_BUF_SIZE);
		}
#endif
	}

	if ((flags & MPT_FLAGS_KEEP_MEM) == 0)
		freeAllocMem();

	return status;
}

/*****************************************************************
 * allocIocltBlk
 *
 * Utility to allocate an mpiIoctlBlk_t structure that is large
 * enough to handle the entire MF + ioctl overhead.
 *
 * If successful, allocate the reply frame for this block.
 *
 * Return:  Null if either alloc fails
 *          mptBlkPtr if successful.
 *
 *****************************************************************/
mpiIoctlBlk_t *allocIoctlBlk (uint numBytes)
{
	int blksize = sizeof(mpiIoctlBlk_t) + numBytes;
#ifndef	APP_MEM_TEST
	if (blksize >= 1024)
		return NULL;

	mpiBlkPtr = (mpiIoctlBlk_t *) &g_command;
#else
	printf ("allocIoctlBlk: calling malloc blksize=%d numBytes=%d\n", blksize, numBytes);
	if ((mpiBlkPtr = (mpiIoctlBlk_t *) malloc(blksize)) == NULL) {
	    printf("allocIoctlBlk: No memory.\n");
		return (NULL);
	}
	printf ("allocIoctlBlk: mpiBlkPtr=%p for blksize=%d\n", mpiBlkPtr, blksize);
#endif
	memset(mpiBlkPtr, 0, blksize);

	if (allocReplyFrame()) {
		printf ("allocReplyFrame call failed\n");
		freeAllocMem();
		return (NULL);
	}
	else
		return (mpiBlkPtr);
}
/*****************************************************************
 * Utility to allocate a reply frame (MPI SIZE)
 * and save the address in the incomping mpiBlkPtr
 *
 * Return 0: success   1: fail
 *****************************************************************/
int allocReplyFrame (void)
{
#ifndef	APP_MEM_TEST
	mpiBlkPtr->replyFrameBufPtr = (char *) &g_reply;
#else
	printf ("allocReplyFrame: calling malloc for %d bytes\n", REPLY_SIZE);
	if ((mpiBlkPtr->replyFrameBufPtr = (char *) malloc(REPLY_SIZE)) == NULL) {
		printf ("allocReplyFrame malloc for %d bytes failed\n", REPLY_SIZE);
		return (1);
	}
	printf ("allocReplyFrame: %p for %d bytes\n", mpiBlkPtr->replyFrameBufPtr, REPLY_SIZE);
#endif
	memset (mpiBlkPtr->replyFrameBufPtr, 0, REPLY_SIZE);
	mpiBlkPtr->maxReplyBytes = REPLY_SIZE;
	return (0);
}

/*****************************************************************
 * Utility to allocate a data frame (mpiBlkPtr->DataInSize)
 * or mpiBlkPtr->DataOutSize
 * and save the address in the incomping mpiBlkPtr
 * Inputs:  DATA_DIR_IN (1) or DATA_DIR_OUT (2) or DATA_DIR_NONE (0)
 * Return 0: success   1: fail
 *****************************************************************/
int allocDataFrame (int dir)
{

	if (dir == DATA_DIR_OUT) {
#ifndef	APP_MEM_TEST
		if (mpiBlkPtr->dataOutSize > (4*1024))
			return 1;
		mpiBlkPtr->dataOutBufPtr =  (char *)&g_data;
#else
		if ((mpiBlkPtr->dataOutBufPtr = (char *) malloc(
						mpiBlkPtr->dataOutSize)) == NULL) {
			fprintf(stderr, "Can't allocate memory");
			perror("Reason");
			return (1);
		}
		printf ("allocated %d DATA_OUT bytes of data space\n", mpiBlkPtr->dataInSize);
#endif
		memset(mpiBlkPtr->dataOutBufPtr, 0, mpiBlkPtr->dataOutSize);

	} else if (dir == DATA_DIR_IN) {
#ifndef	APP_MEM_TEST
		if (mpiBlkPtr->dataInSize > (4*1024))
			return 1;
		mpiBlkPtr->dataInBufPtr = (char *)&g_data;
#else
		if ((mpiBlkPtr->dataInBufPtr = (char *) malloc(
						mpiBlkPtr->dataInSize)) == NULL) {
			printf ("Unable to allocate %d DATA_IN bytes of data space\n", mpiBlkPtr->dataInSize);
			fprintf(stderr, "Can't allocate memory");
			perror("Reason");
			return (1);
		}
		printf ("allocated %d DATA_IN bytes of data space\n", mpiBlkPtr->dataInSize);
#endif
		memset(mpiBlkPtr->dataInBufPtr, 0, mpiBlkPtr->dataInSize);
	}
	return (0);
}

/*****************************************************************
 * Utility to allocate a sense buffer
 * and save the address and size in
 * mpiBlkPtr->senseDataPtr and mpiBlkPtr->maxSenseBytes.
 * Return 0: success   1: fail
 *****************************************************************/
int   allocSenseBuffer (void)
{
	mpiBlkPtr->maxSenseBytes = SENSE_BUF_SIZE;

#ifndef	APP_MEM_TEST
	mpiBlkPtr->senseDataPtr =  (char *)&g_sense;
#else
	if ((mpiBlkPtr->senseDataPtr = (char *) malloc (
					mpiBlkPtr->maxSenseBytes)) == NULL) {
		printf ("Unable to allocate %d sense bytes\n", mpiBlkPtr->maxSenseBytes);
		mpiBlkPtr->maxSenseBytes = 0;
		return (1);
	}
	printf ("allocated %d sense bytes\n", mpiBlkPtr->maxSenseBytes);
#endif
	memset (mpiBlkPtr->senseDataPtr, 0, mpiBlkPtr->maxSenseBytes);
	return (0);
}

void freeAllocMem (void)
{
#ifndef	APP_MEM_TEST
	if (mpiBlkPtr->replyFrameBufPtr)
		mpiBlkPtr->replyFrameBufPtr = NULL;

	if (mpiBlkPtr->dataOutBufPtr)
		mpiBlkPtr->dataOutBufPtr = NULL;

	if (mpiBlkPtr->dataInBufPtr)
		mpiBlkPtr->dataInBufPtr = NULL;

	mpiBlkPtr = NULL;
#else
	if (mpiBlkPtr->replyFrameBufPtr) {
		free(mpiBlkPtr->replyFrameBufPtr);
		mpiBlkPtr->replyFrameBufPtr = NULL;
	}

	if (mpiBlkPtr->dataOutBufPtr) {
		free(mpiBlkPtr->dataOutBufPtr);
		mpiBlkPtr->dataOutBufPtr = NULL;
	}

	if (mpiBlkPtr->dataInBufPtr) {
		free(mpiBlkPtr->dataInBufPtr);
		mpiBlkPtr->dataInBufPtr = NULL;
	}

	if (mpiBlkPtr->senseDataPtr) {
		free(mpiBlkPtr->senseDataPtr);
		mpiBlkPtr->senseDataPtr = NULL;
	}
	
	free(mpiBlkPtr);
	mpiBlkPtr = NULL;
#endif
	return;
}
