/***************************************************************************
 *                                                                         *
 *  Copyright 2000-2002 LSI  Logic.  All rights reserved.                  *
 *                                                                         *
 *  This file is confidential and a trade secret of LSI Logic.  The        *
 *  receipt of or possession of this file does not convey any rights to    *
 *  reproduce or disclose its contents or to manufacture, use, or sell     *
 *  anything it may describe, in whole, or in part, without the specific   *
 *  written consent of LSI Logic Incorporated.                             *
 *                                                                         *
 ***************************************************************************/

/*           Name:  apps.h
 *          Title:  Module Main defines
 *     Programmer:  Pam A. Delaney
 *  Creation Date:  April 9, 2001
 *
 *  Version History
 *  ---------------
 *
 *    Date    Who?  Description
 *  --------  ----  -------------------------------------------------------
#BeginRevision
 *
#EndRevision
 *
 *-------------------------------------------------------------------------
 *
 *
 */

/* If this header file has not been included yet. */
#if !defined __apps_H
#define __apps_H

/* System Include Files
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
//#include <curses.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/compiler.h>
#include <string.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <malloc.h>

#include "../mptbase.h"

/* Typedefs
 */
#ifndef uchar
typedef unsigned char uchar;
#endif

#ifndef u8
typedef unsigned char u8;
#endif

#ifndef u16
typedef unsigned short u16;
#endif

#ifndef u32
typedef unsigned int u32;
#endif

#ifndef u64
typedef unsigned long long u64;
#endif

/* Driver Includes
 */
#include "../mptctl.h"
#include "../lsi/mpi_type.h"
#include "../lsi/mpi.h"
#include "../lsi/mpi_ioc.h"
#include "../lsi/mpi_cnfg.h"
#include "../lsi/mpi_init.h"
#include "../lsi/mpi_raid.h"
#include "../lsi/mpi_tool.h"

/* Structure typedefs
 */

/* The following strucure is used to link the user selection
 * with a specific function.  Selection of the cmdString results
 * in execution fo the function cmdFunction.  The structures
 * are populated in the dot-c modules.
 */
typedef struct _CmdStrings
{
	char *cmdString;        // Pointer to a String
	void (*cmdFunction)();  // Pointer to a CommandFunction - invoked
                                // if string is selected.
} CmdStrings;

typedef struct _CmdOptions
{
	char *optionString;
	uchar  value;

} CmdOptions;

/* Used to test the system Endianness.
 */
typedef struct _test_endianness {
	union {
		u32	foo;
		u8	bar[4];
	} u;
} test_endianess_t;

typedef struct mpt_ioctl_command mpiIoctlBlk_t;

#define DRIVER_VERSION	MPT_LINUX_VERSION_COMMON

/* Marcos
 */
#define MIN(a,b)  (((a) < (b)) ? (a) : (b))

/* Defines
 */
#define APP_TRUE	1
#define APP_FALSE	0
#define REPLY_SIZE      128

#define MAX_SCSI_ID     15
#define MAX_FC_ID       255

#define REPLY_FRAME_DISPLAY     0x30
#define BYTES_PER_LINE  	16
#define SENSE_BUF_SIZE		36

#define DATA_DIR_NONE           0
#define DATA_DIR_IN             1
#define DATA_DIR_OUT            2

#define DATAIN_LENGTH           20
#define MAX_FILE_NAME_LENGTH	32

#define PROC_READ_LINE		64

#define MPT_FLAGS_FREE_MEM	0x00
#define MPT_FLAGS_KEEP_MEM	0x01
#define MPT_FLAGS_DUMP_REPLY	0x02
#define MPT_FLAGS_DUMP_DATA	0x04

#define MPT_FLAGS_STANDARD	(MPT_FLAGS_FREE_MEM | MPT_FLAGS_DUMP_REPLY | MPT_FLAGS_DUMP_DATA)

#define CMD_LENGTH_6		6
#define CMD_LENGTH_10		10
#define INQ_SIZE		36	/* SCSI_STD_INQUIRY_BYTES */

#define GBL_BUF_SIZE		512

/* Byte-swapping
 */
#define cpu_to_le32 swap32
#define le32_to_cpu swap32
#define cpu_to_le16 swap16
#define le16_to_cpu swap16


/* Function Prototypes
 */
extern int   IssueMptCommand (uint flags);
extern void  ShowBuf (char *titleP, void *dataBufP, int count, int always);
extern uchar CheckNumericalInput(char *dataString);
extern void  freeAllocMem ( void );
extern mpiIoctlBlk_t *allocIoctlBlk (uint numBytes);
extern int   allocReplyFrame (void);
extern int   allocDataFrame (int dir);
extern int   allocSenseBuffer (void);
extern int   OpenDevice (char *inputDevice);
extern void  DoExit(void);
extern u32   swap32(u32 x);
extern u16   swap16(u16 x);
extern uint  AskValue(uint minValue, uint maxValue, char *dataString);
extern uchar AskBits( uchar noBits, char *dataString);


#endif /* End of apps_H */
