/****************************************************************************
 * testTLS.c - TLS/DES example for SEC2
 ****************************************************************************
 * Copyright (c) 2005 Freescale Semiconductor
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 ***************************************************************************/

/* Revision History:
 * 1.3 Aug 11,2005 sec - new for support of 8548
 */

#include "sec2drvTest.h"
#include "Sec2.h"


static unsigned char packetIn[] =
{
    0x84, 0x64, 0x42, 0x22,   /* auth only portion, 13 bytes */
    0x91, 0xD5, 0x87, 0xD8,
    0x82, 0x65, 0x2B, 0x03,
    0xD5,
    
    0xF9, 0xE8, 0x37, 0x60,   /* cipher in , 235 bytes */
    0x50, 0x94, 0xB0, 0xDA,
    0x7C, 0xD6, 0xC6, 0x06,
    0xC7, 0xB0, 0xB0, 0x3A,
    0xD7, 0x0E, 0x4C, 0xA6,
    0x9C, 0xC3, 0x82, 0xF4,
    0x1E, 0x00, 0x58, 0xC4,
    0x8A, 0xFF, 0xA6, 0xED,
    0xF5, 0x62, 0xCB, 0x3A,
    0x73, 0x7A, 0x4C, 0xDF,
    0x5A, 0xC7, 0xE5, 0xBA,
    0x97, 0x0D, 0xD4, 0xFA,
    0x13, 0xA3, 0xE8, 0xA3,
    0x83, 0x8E, 0x04, 0xF8,
    0xB3, 0x00, 0xDB, 0x3E,
    0xC7, 0xDC, 0xB8, 0x0D,
    0xBD, 0x43, 0x20, 0xA1,
    0x56, 0xD1, 0x6E, 0xC4,
    0x49, 0x4A, 0xA5, 0x0A,
    0x9A, 0xF6, 0xB9, 0x99,
    0xCE, 0xBF, 0x9A, 0x50,
    0x3D, 0xE8, 0x0F, 0x1F,
    0x6E, 0xF2, 0x50, 0x1B,
    0x4B, 0x93, 0x24, 0x9B,
    0xE0, 0x51, 0x3A, 0x4D,
    0xAE, 0x80, 0x67, 0xC3,
    0x8C, 0xD6, 0xED, 0x28,
    0xDB, 0x12, 0x61, 0xCD,
    0x0F, 0xBD, 0x26, 0x43,
    0x12, 0x24, 0x1B, 0xDC,
    0x13, 0x0D, 0xF2, 0x85,
    0xF5, 0x85, 0x3D, 0xF1,
    0x03, 0xE8, 0x51, 0x71,
    0xE7, 0xA4, 0xAA, 0x22,
    0x78, 0x37, 0x74, 0x2A,
    0xF6, 0xC8, 0x5D, 0x40,
    0x9B, 0x6D, 0x0E, 0x82,
    0x99, 0xBF, 0xC8, 0x87,
    0x40, 0xBD, 0xB1, 0x56,
    0x3A, 0xD0, 0x68, 0x14,
    0x7C, 0x3C, 0xCD, 0x3E,
    0xD6, 0x2D, 0x2D, 0xC7,
    0x84, 0x8A, 0x3D, 0x00,
    0x53, 0xF8, 0xF7, 0x93,
    0xAE, 0x43, 0x98, 0x78,
    0x47, 0x62, 0xCC, 0x6D,
    0x16, 0xD0, 0xC1, 0x72,
    0x68, 0x3E, 0xC0, 0x2E,
    0xD9, 0x81, 0x40, 0x76,
    0x0F, 0xEC, 0x8F, 0x3A,
    0x3D, 0x60, 0xB4, 0xB9,
    0xC4, 0xD4, 0x86, 0x14,
    0x97, 0x99, 0x67, 0x59,
    0x4A, 0x24, 0xBB, 0x50,
    0x86, 0x95, 0x37, 0x7A,
    0x50, 0x8B, 0x64, 0xA2,
    0x1E, 0xC8, 0x18, 0xEB,
    0xDF, 0x7C, 0x76, 0xBF,
    0x68, 0x71, 0xA6,
                             /* 248 bytes to this point */

    0x00, 0x00, 0x00, 0x00,  /* 20-byte space for MAC */
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
                             /* 268 bytes to this point */
                             
    0x00, 0x00, 0x00, 0x00,  /* pad and length */
    0x00, 0x00, 0x00, 0x00,
                             /* 284 bytes to here */
};

/* encrypt key - 8 bytes */
static const unsigned char EncKey[] = {
    0xCA, 0x36, 0xEC, 0x46,
    0xFA, 0x36, 0x61, 0x75
};

/* auth key - 20 bytes */
static const unsigned char authKey[] = {
    0xF1, 0xC2, 0x9A, 0x3D,
    0x89, 0x2E, 0x49, 0x73,
    0xCE, 0xA5, 0x74, 0xE9,
    0x3A, 0x46, 0x68, 0x09,
    0x63, 0x0B, 0x52, 0x31
};

/* IV - 8 bytes */
static unsigned char in_iv[]  = {
    0xF9, 0x43, 0xB2, 0x3F,
    0x64, 0xBE, 0x3C, 0xA4
}; 

static unsigned char outivdata[8];
static unsigned char packetOut[284];

/* Expected results */
static const unsigned char exp_cipher_out [] = {
        0xE9,0xD6,0x7F,0x16,0x04,0xD3,0xC5,0xF5,
        0x8B,0xF2,0x87,0xCB,0x7B,0x58,0xAE,0x9E,
        0xB4,0x07,0xCD,0x10,0x28,0x55,0x4D,0xC8,
        0xDA,0x40,0x2D,0x04,0x67,0x4B,0x95,0xA8,
        0x80,0x2C,0xF6,0x0C,0xFA,0x8A,0xCE,0xAC,
        0xAD,0x20,0xED,0x37,0x36,0xCF,0x47,0x38,
        0x95,0x46,0x5F,0xF9,0x03,0x9C,0x94,0x97,
        0x34,0x11,0x41,0xEC,0x13,0xC6,0x43,0xE3,
        0x24,0xAB,0xFF,0x3F,0x62,0x92,0x44,0x70,
        0xC1,0x2C,0xF5,0x8C,0x55,0x21,0x82,0x2C,
        0x5A,0x01,0xD7,0x8D,0x94,0x38,0x06,0x4D,
        0x39,0x9E,0x41,0xB9,0xE3,0x88,0x87,0x96,
        0x95,0x2E,0xFF,0xC8,0xDD,0x93,0xE7,0xE4,
        0xB3,0xBA,0xEB,0x17,0x18,0x88,0x82,0x09,
        0x35,0xC2,0x39,0xD5,0x98,0xD3,0x6B,0x92,
        0x82,0x89,0xB8,0xB9,0x7B,0xC3,0x60,0x56,
        0xE9,0x47,0x6C,0x40,0xA2,0x0E,0x8F,0x76,
        0x28,0x06,0xE6,0x80,0x91,0x90,0x53,0xD7,
        0xF5,0x3B,0xE2,0x94,0x26,0x12,0xC6,0x09,
        0x7F,0x9F,0xD8,0x8A,0x28,0x45,0x02,0xF3,
        0xEE,0x24,0xBF,0x6B,0x5C,0xAF,0xEA,0xCF,
        0xE9,0x86,0xD3,0x05,0xDA,0x5C,0x37,0x32,
        0x06,0x26,0x55,0x7A,0x94,0xBF,0x8F,0xB5,
        0x7D,0xAD,0xF0,0x25,0xB8,0x46,0x74,0x7D,
        0x0A,0xEF,0x1A,0x80,0xBC,0xAC,0xCA,0xD7,
        0x3F,0x21,0x3B,0x96,0xFC,0x8C,0x24,0xF0,
        0x9E,0x83,0x9D,0x4C,0x3C,0x42,0xE2,0xEB,
        0x3E,0xE2,0x9E,0x6F,0x3B,0x11,0xB1,0x3D,
        0x27,0x06,0x97,0x53,0xE1,0x65,0x39,0x7F,
        0xA6,0xDA,0x32,0x46,0x60,0xA1,0xAA,0x8F,
        0xA5,0xAA,0x8D,0xEF,0x35,0xA6,0x53,0x27,
        0x97,0x4C,0x0E,0x3C,0x48,0x0A,0x93,0xE6
};

static unsigned char exp_iv_out [] = {
        0x97,0x4C,0x0E,0x3C,0x48,0x0A,0x93,0xE6
};





int testTLS(int fd)
{
    TLS_BLOCK_OUTBOUND_REQ tlsRq;
    int                    status, fail;

    printf("*** Test TLS Block Outbound  ***\n");
    
    /* clear request block */
    memset(&tlsRq,    0, sizeof(tlsRq));
    memset(packetOut, 0, 256);
    

    /* set up request */
    tlsRq.opId            = DPD_TLS_BLOCK_OUTBOUND_SDES_SHA1;
    
    tlsRq.hashKeyBytes    = 20;
    tlsRq.hashKeyData     = (unsigned char *)authKey;

    tlsRq.ivBytes         = 8;
    tlsRq.ivData          = in_iv;

    tlsRq.cipherKeyBytes  = 8;
    tlsRq.cipherKeyData   = (unsigned char *)EncKey;
    
    tlsRq.ivOutBytes      = 8;
    tlsRq.ivOutData       = outivdata;

    tlsRq.outBytes        = 256;
    tlsRq.outData         = packetOut;

    tlsRq.hashOnlyBytes   = 13;
    tlsRq.mainDataBytes   = 235;
    tlsRq.MACbytes        = 20;
    tlsRq.cipherOnlyBytes = 1;
    tlsRq.hashOnlyData	  = packetIn;


    status = putKmem(fd, (void *)authKey, (void **)&tlsRq.hashKeyData, tlsRq.hashKeyBytes);
    if (status)
        return status;

    status = putKmem(fd, (void *)in_iv, (void **)&tlsRq.ivData, tlsRq.ivBytes);
    if (status) {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        return status;
    }
    
    status = putKmem(fd, (void *)EncKey, (void **)&tlsRq.cipherKeyData, tlsRq.cipherKeyBytes);
    if (status) {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        freeKmem(fd, (void **)&tlsRq.ivData);
        return status;
    }
    
    status = putKmem(fd, NULL, (void **)&tlsRq.ivOutData, tlsRq.ivOutBytes);
    if (status) {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        freeKmem(fd, (void **)&tlsRq.ivData);
        freeKmem(fd, (void **)&tlsRq.cipherKeyData);
        return status;
    }

    status = putKmem(fd, NULL, (void **)&tlsRq.outData, tlsRq.outBytes);
    if (status) {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        freeKmem(fd, (void **)&tlsRq.ivData);
        freeKmem(fd, (void **)&tlsRq.cipherKeyData);
        freeKmem(fd, (void **)&tlsRq.ivOutData);
        return status;
    }
    
    status = putKmem(fd, (void *)packetIn, (void **)&tlsRq.hashOnlyData, 284);
    if (status) {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        freeKmem(fd, (void **)&tlsRq.ivData);
        freeKmem(fd, (void **)&tlsRq.cipherKeyData);
        freeKmem(fd, (void **)&tlsRq.ivOutData);
        freeKmem(fd, (void **)&tlsRq.outData);
        return status;
    }
    
    tlsRq.cipherOnlyData = &tlsRq.hashOnlyData[268];
    
    armCompletion(&tlsRq);
    status = ioctl(fd, IOCTL_PROC_REQ, (int)&tlsRq);
    
    if ((status = waitCompletion("testTLS(): outbound block test", status, &tlsRq)))
    {
        freeKmem(fd, (void **)&tlsRq.hashKeyData);
        freeKmem(fd, (void **)&tlsRq.ivData);
        freeKmem(fd, (void **)&tlsRq.cipherKeyData);
        freeKmem(fd, (void **)&tlsRq.ivOutData);
        freeKmem(fd, (void **)&tlsRq.outData);
        freeKmem(fd, (void **)&tlsRq.hashOnlyData);
        return status;
    }
        
    getKmem(fd, outivdata, (void **)&tlsRq.ivOutData, tlsRq.ivOutBytes);
    getKmem(fd, packetOut, (void **)&tlsRq.outData, tlsRq.outBytes);
    
    freeKmem(fd, (void **)&tlsRq.hashKeyData);
    freeKmem(fd, (void **)&tlsRq.ivData);
    freeKmem(fd, (void **)&tlsRq.cipherKeyData);
    freeKmem(fd, (void **)&tlsRq.ivOutData);
    freeKmem(fd, (void **)&tlsRq.outData);
    freeKmem(fd, (void **)&tlsRq.hashOnlyData);

    /* run results comparisons */

    fail = 0;

    if ((memcmp(outivdata, exp_iv_out, 8)) != 0)
    {
        printf("cipher context out miscompare\n");
        printf("expected result:\n");
        dumpm((unsigned char *)exp_iv_out, 8);
        printf("actual result:\n");
        dumpm(outivdata, 8);
        fail++;
    }

    if ((memcmp(packetOut, exp_cipher_out, 256)) != 0)
    {
        printf("packet out miscompare\n");
        printf("expected result:\n");
        dumpm((unsigned char *)exp_cipher_out, 256);
        printf("actual result:\n");
        dumpm(packetOut, 256);
        fail++;
    }


    printf("*** Test TLS Block Outbound - ");
    if (fail)
    {
        printf("failed ***\n");
        return(-1);
    }
    else
    {
        printf("passed ***\n");
        return(0);
    }
    
    return 0;
} 

