
/****************************************************************************
 * testICV.c - HMAC ICV comparison test for SEC2 device driver
 ****************************************************************************
 * Copyright (c) 2005 Freescale Semiconductor
 * All Rights Reserved. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 ***************************************************************************/

/* Revision History:
 * 1.3   01-Aug-2005 sec - new for 8548
 */



#include "sec2drvTest.h"
#include "Sec2.h"



/* HMAC Key, 18 bytes */
static const unsigned char hmac_key[] =
{
    0x9D, 0x55, 0x4A, 0x75,
    0x5E, 0xBB, 0x51, 0x2A,
    0xBE, 0x8B, 0xAC, 0xC8,
    0x2E, 0x95, 0xB6, 0x28,
    0x3C, 0x8C
};


/* Message in, 810 bytes */
static const unsigned char msg_in[] =
{
    0x30, 0x58, 0x6F, 0x99,
    0xA6, 0x7D, 0xC8, 0x43,
    0xD5, 0x24, 0xE9, 0xF8,
    0x31, 0x37, 0xCC, 0x4A,
    0xB8, 0x7D, 0xE8, 0x9D,
    0x15, 0x09, 0x26, 0x79,
    0xDF, 0xDA, 0x07, 0x6A,
    0xC9, 0xBE, 0x47, 0xF6,
    0x55, 0xA6, 0xFF, 0x14,
    0x48, 0x47, 0xE2, 0x4A,
    0x59, 0x43, 0x9F, 0xA9,
    0x90, 0xF8, 0x92, 0xB9,
    0xF1, 0xAA, 0x58, 0xAE,
    0x17, 0x3A, 0x99, 0xF8,
    0x75, 0xA1, 0xB5, 0xB5,
    0xCD, 0x07, 0x1C, 0x35,
    0x9E, 0x65, 0xDF, 0x77,
    0xA2, 0xA9, 0x60, 0xC6,
    0x9C, 0x62, 0x45, 0x26,
    0xF8, 0x58, 0xEA, 0xEE,
    0x10, 0xF2, 0x10, 0xEA,
    0x72, 0xA4, 0xAF, 0xA1,
    0x7A, 0xBD, 0xE3, 0xA5,
    0x19, 0xA9, 0xDC, 0xA0,
    0xE4, 0xA5, 0x16, 0xE5,
    0x7F, 0xF5, 0x91, 0xC0,
    0xF6, 0x67, 0xF4, 0x3A,
    0xC0, 0x22, 0x07, 0xE8,
    0x3D, 0x96, 0xAF, 0x0C,
    0xFA, 0xE0, 0x8B, 0x4C,
    0xF7, 0x10, 0xE2, 0x40,
    0x57, 0x0C, 0x3D, 0x0F,
    0x68, 0x7E, 0x7B, 0x56,
    0xD5, 0x32, 0x19, 0x55,
    0xAB, 0x80, 0x0B, 0x3C,
    0x08, 0xD3, 0x1B, 0x06,
    0x43, 0x34, 0x8C, 0x8C,
    0x4D, 0x6B, 0xBD, 0x6B,
    0xC8, 0x85, 0x58, 0x10,
    0x30, 0xCA, 0x91, 0x2B,
    0xCB, 0x87, 0x84, 0x7E,
    0xB9, 0xA2, 0x32, 0x04,
    0x9D, 0xB8, 0x4A, 0xE5,
    0x05, 0xB0, 0xC4, 0x7D,
    0x04, 0xD2, 0x11, 0xE7,
    0xF4, 0xCC, 0xFD, 0xE5,
    0xB1, 0x4B, 0xFD, 0x64,
    0x28, 0x9B, 0xC7, 0x83,
    0x2E, 0xE1, 0xE1, 0xBF,
    0x0F, 0x73, 0x56, 0x22,
    0x61, 0x31, 0xE4, 0x83,
    0xEE, 0x4C, 0xEE, 0x73,
    0x40, 0xE9, 0x6F, 0x76,
    0xDE, 0x48, 0x22, 0xAE,
    0x28, 0x92, 0x3B, 0x9B,
    0x7F, 0xA8, 0xFD, 0x7D,
    0xAE, 0x20, 0xD1, 0xA8,
    0x4E, 0xAF, 0x97, 0xE0,
    0x7A, 0x98, 0x12, 0xB5,
    0x5F, 0x56, 0xC8, 0x0D,
    0x6F, 0x23, 0x7E, 0x6B,
    0x12, 0x0E, 0xD1, 0x3E,
    0xDD, 0x24, 0x89, 0x52,
    0x33, 0xCA, 0x07, 0x22,
    0xB0, 0x82, 0x2B, 0xB9,
    0x4E, 0x67, 0xE2, 0x45,
    0x48, 0xCE, 0x5D, 0x2A,
    0xA2, 0xC0, 0x2A, 0xB9,
    0xF2, 0x52, 0x9B, 0x1C,
    0x5B, 0x5C, 0xED, 0x6E,
    0xEC, 0xB6, 0x20, 0x60,
    0x7D, 0x4C, 0x99, 0x68,
    0x70, 0xC0, 0x35, 0x30,
    0x0A, 0x63, 0x31, 0x5C,
    0x85, 0x6A, 0xF6, 0x37,
    0x33, 0xEC, 0xF1, 0xBA,
    0xF2, 0xA4, 0x34, 0x50,
    0xB1, 0x5D, 0x41, 0x58,
    0x44, 0x24, 0x0B, 0x32,
    0x87, 0xB1, 0x05, 0x18,
    0x38, 0x9C, 0x48, 0xF8,
    0x56, 0xBD, 0xE6, 0xD6,
    0x82, 0x78, 0x5C, 0x07,
    0x25, 0x3C, 0x06, 0x50,
    0xCC, 0x2E, 0xD8, 0xBB,
    0x67, 0xA6, 0x01, 0x79,
    0x18, 0xE8, 0x6C, 0x2A,
    0x24, 0x27, 0x2F, 0x7F,
    0x78, 0x2A, 0xFE, 0x95,
    0x07, 0xA6, 0xAE, 0xF0,
    0xCA, 0x41, 0x3C, 0x7B,
    0xE1, 0xB0, 0x4C, 0x8B,
    0x09, 0x30, 0x2C, 0xE4,
    0x22, 0xED, 0xD5, 0x1E,
    0xB0, 0x22, 0x0D, 0xB7,
    0xEE, 0x9D, 0xB5, 0xFA,
    0xF6, 0xF4, 0x7D, 0x2F,
    0xE3, 0x17, 0x5D, 0x50,
    0x16, 0x76, 0x89, 0xF7,
    0x8D, 0x64, 0xBB, 0xC9,
    0xFB, 0xB4, 0x76, 0x8E,
    0x4D, 0x7D, 0x9A, 0xEC,
    0xA7, 0xD3, 0xEF, 0x4C,
    0xE1, 0x9C, 0x54, 0x41,
    0xF7, 0xDF, 0x03, 0xC8,
    0xBC, 0xC3, 0x46, 0x8F,
    0xB9, 0x8D, 0xFA, 0xA5,
    0x06, 0x65, 0x5C, 0x24,
    0x94, 0x38, 0x87, 0x40,
    0xB5, 0xBB, 0x28, 0x52,
    0xC0, 0x80, 0x82, 0xCB,
    0xC7, 0x13, 0xBE, 0x7C,
    0x2D, 0x44, 0xCF, 0x6F,
    0x50, 0x4B, 0x9B, 0x6F,
    0xBB, 0x37, 0xAB, 0x1E,
    0xD1, 0x63, 0xBB, 0xD6,
    0x1B, 0x39, 0x71, 0xE9,
    0xAC, 0x57, 0x7E, 0x0E,
    0x1E, 0xD5, 0x11, 0xEC,
    0x19, 0xA7, 0xF7, 0x73,
    0x4B, 0x0F, 0x0B, 0x9B,
    0x86, 0xAA, 0x33, 0x0F,
    0xA0, 0xB2, 0xCC, 0xAD,
    0xC7, 0x73, 0xFD, 0x90,
    0x15, 0x11, 0xE7, 0x41,
    0xB5, 0xC2, 0x0B, 0x02,
    0x6E, 0x9D, 0xBC, 0x46,
    0x63, 0x0A, 0x60, 0xEB,
    0x32, 0x00, 0x50, 0x88,
    0x97, 0x13, 0xAE, 0x96,
    0xB6, 0x65, 0x12, 0xBA,
    0xF4, 0x37, 0x43, 0x94,
    0x78, 0xCF, 0x4A, 0x63,
    0x85, 0x55, 0x55, 0xB5,
    0x78, 0x10, 0x9D, 0x49,
    0x5D, 0x96, 0x6B, 0x12,
    0x93, 0x2D, 0x40, 0xA8,
    0x37, 0x0F, 0x25, 0xE1,
    0x69, 0xB1, 0xF8, 0xB1,
    0x6A, 0x0A, 0x3B, 0xC8,
    0x69, 0x36, 0xE3, 0x25,
    0x34, 0x1A, 0x09, 0x71,
    0x33, 0x84, 0xDF, 0x97,
    0x64, 0x24, 0x84, 0x13,
    0x34, 0xF4, 0xE9, 0x1B,
    0x2E, 0xFB, 0x76, 0xB6,
    0xB6, 0x40, 0x2A, 0xB0,
    0x75, 0x79, 0xB2, 0xC3,
    0x79, 0x94, 0xB7, 0x0C,
    0x36, 0x43, 0x9C, 0x24,
    0x6F, 0xCE, 0xB3, 0x96,
    0x31, 0x92, 0x18, 0x75,
    0x08, 0xBD, 0x74, 0xC7,
    0x51, 0x8B, 0x68, 0xDA,
    0x17, 0x1F, 0xD1, 0x0F,
    0xA9, 0x5F, 0x15, 0x3C,
    0x88, 0x36, 0x59, 0x1C,
    0xC7, 0xF6, 0x0E, 0x40,
    0x4A, 0x9F, 0x37, 0x59,
    0xE6, 0xC7, 0x84, 0xCB,
    0x2C, 0xD7, 0x0D, 0x77,
    0xF0, 0xA9, 0xC5, 0xDA,
    0xEF, 0x95, 0x8F, 0x50,
    0xCB, 0x55, 0x1A, 0xBD,
    0xFD, 0x44, 0xC8, 0x65,
    0x18, 0xCC, 0x59, 0xCE,
    0xCA, 0x5D, 0xBC, 0x72,
    0x0C, 0x79, 0xBE, 0xBC,
    0x59, 0x74, 0xA2, 0xFB,
    0x55, 0x0B, 0xB4, 0x9B,
    0x40, 0x03, 0x8C, 0xB0,
    0x39, 0xA0, 0xCF, 0xCB,
    0xE1, 0x15, 0x15, 0x08,
    0xE6, 0x18, 0x59, 0xE7,
    0xC8, 0x45, 0x1B, 0xE3,
    0x6D, 0x21, 0xD0, 0x6B,
    0xA8, 0x09, 0xBD, 0x3E,
    0x5D, 0xB4, 0x08, 0xBD,
    0xDB, 0x18, 0xA3, 0x11,
    0xBC, 0x81, 0x2A, 0x90,
    0xBA, 0xBB, 0x0D, 0xCC,
    0xBB, 0x69, 0xD2, 0x82,
    0xCD, 0x81, 0x1F, 0xDE,
    0x24, 0x52, 0xFF, 0x91,
    0x1B, 0xB9, 0x6A, 0xB5,
    0x9D, 0x73, 0x26, 0x7D,
    0xED, 0xA4, 0xF8, 0x00,
    0xD8, 0xB3, 0x3C, 0x2D,
    0x04, 0x50, 0xA6, 0x20,
    0x73, 0xBE, 0x22, 0x5F,
    0x6B, 0xAC, 0x73, 0x3A,
    0x82, 0xB8, 0x8F, 0xC3,
    0xF9, 0x66, 0xBD, 0xF2,
    0xA5, 0x8B, 0xF9, 0x93,
    0x0F, 0x39, 0x20, 0xC9,
    0x91, 0xCA, 0x4B, 0x89,
    0xD3, 0x80, 0x9B, 0x61,
    0x71, 0xC0, 0x4E, 0xB2,
    0xC0, 0x75, 0x36, 0x5A,
    0x78, 0x0B, 0x9F, 0xE8,
    0x20, 0x67, 0x3F, 0xD2,
    0xFA, 0x6D, 0x03, 0xF2,
    0xC4, 0xFF
};


/* expected MD5 digest, 16 bytes */
static const unsigned char exp_digest[] =
{
    0x12, 0xB8, 0x45, 0x7E,
    0xD6, 0xC0, 0xE7, 0x24,
    0x09, 0x7F, 0xAE, 0x9F,
    0xE3, 0x19, 0xE0, 0x97,
};

/* dummy mismatched digest, 16 bytes */
static const unsigned char bad_digest[] =
{
    0x12, 0xB8, 0x45, 0x7E,
    0xD6, 0xC0, 0x7e, 0x24,
    0x09, 0x7F, 0xAE, 0x9F,
    0xE3, 0x19, 0xE0, 0x97,
};



static unsigned char digest[16];


int testICV(int fd)
{
    HMAC_PAD_REQ hmacRQ;
    int          status, testfail;
    
    testfail = 0;
    
    
    printf("*** HMAC MD-5 ICV Match Test ***\n");
        
    memset(digest, 0, 16);
    memset(&hmacRQ, 0, sizeof(hmacRQ));
        
        
    hmacRQ.opId     = DPD_MD5_LDCTX_HMAC_PAD_ULCTX_CMP;
    
    hmacRQ.keyBytes = 18;
    hmacRQ.keyData  = (unsigned char *)hmac_key;
    
    hmacRQ.inBytes  = 810;
    hmacRQ.inData   = (unsigned char *)msg_in;

    hmacRQ.outBytes = 16;
    hmacRQ.outData  = digest;
        
    hmacRQ.cmpData  = (unsigned char *)exp_digest;
        


    status = putKmem(fd, (unsigned char *)hmac_key, (void **)&hmacRQ.keyData, hmacRQ.keyBytes);
    if (status)
        return status;
        
    status = putKmem(fd, (unsigned char *)msg_in, (void **)&hmacRQ.inData, hmacRQ.inBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        return status;
    }
        
    status = putKmem(fd, NULL, (void **)&hmacRQ.outData, hmacRQ.outBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        freeKmem(fd, (void **)&hmacRQ.inData);
        return status;
    }
        
    status = putKmem(fd, (unsigned char *)exp_digest, (void **)&hmacRQ.cmpData, hmacRQ.outBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        freeKmem(fd, (void **)&hmacRQ.inData);
        freeKmem(fd, (void **)&hmacRQ.outData);
        return status;
    }
        
        
    armCompletion(&hmacRQ);
    status = ioctl(fd, IOCTL_PROC_REQ, (int)&hmacRQ);
        
    if ((status = waitCompletion("testICV(): message compare test", status, &hmacRQ)))
    {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        freeKmem(fd, (void **)&hmacRQ.inData);
        freeKmem(fd, (void **)&hmacRQ.outData);
        freeKmem(fd, (void **)&hmacRQ.cmpData);
        return status;
    }
        
    getKmem(fd, digest, (void **)&hmacRQ.outData, hmacRQ.outBytes);
        
    freeKmem(fd, (void **)&hmacRQ.keyData);
    freeKmem(fd, (void **)&hmacRQ.inData);
    freeKmem(fd, (void **)&hmacRQ.outData);
    freeKmem(fd, (void **)&hmacRQ.cmpData);
        
        
    /* compare result */
    if (memcmp(exp_digest, digest, hmacRQ.outBytes) == 0) 
        printf("*** HMAC MD-5 ICV Match Test Passed ***\n");
    else 
    {
        printf("*** HMAC MD-5 ICV Match Test Failed ***\n");
        printf("expected digest:\n");
        dumpm((unsigned char *)exp_digest, hmacRQ.outBytes);
        printf("actual digest:\n");
        dumpm(digest, hmacRQ.outBytes);
        testfail++;
    }



    printf("*** HMAC MD-5 ICV Mismatch Test ***\n");
    

    /* just point the compare data to a digest that's not quite right */
    hmacRQ.cmpData  = (unsigned char *)bad_digest;
        
    status = putKmem(fd, (unsigned char *)hmac_key, (void **)&hmacRQ.keyData, hmacRQ.keyBytes);
    if (status)
        return status;
        
    status = putKmem(fd, (unsigned char *)msg_in, (void **)&hmacRQ.inData, hmacRQ.inBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        return status;
    }
        
    status = putKmem(fd, NULL, (void **)&hmacRQ.outData, hmacRQ.outBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        freeKmem(fd, (void **)&hmacRQ.inData);
        return status;
    }
        
    status = putKmem(fd, (unsigned char *)bad_digest, (void **)&hmacRQ.cmpData, hmacRQ.outBytes);
    if (status) {
        freeKmem(fd, (void **)&hmacRQ.keyData);
        freeKmem(fd, (void **)&hmacRQ.inData);
        freeKmem(fd, (void **)&hmacRQ.outData);
        return status;
    }
        
        
    armCompletion(&hmacRQ);
    status = ioctl(fd, IOCTL_PROC_REQ, (int)&hmacRQ);
        
    status = waitCompletion("testICV(): message miscompare test SHOULD RETURN ERROR!: ", status, &hmacRQ);
    if (status == SEC2_CHA_ERROR)
        printf("*** HMAC MD-5 ICV Match Test Passed ***\n");
    else
    {
        printf("*** HMAC MD-5 ICV Match Test Failed ***\n");
        testfail++;
    }
    
        
    getKmem(fd, digest, (void **)&hmacRQ.outData, hmacRQ.outBytes);
        
    freeKmem(fd, (void **)&hmacRQ.keyData);
    freeKmem(fd, (void **)&hmacRQ.inData);
    freeKmem(fd, (void **)&hmacRQ.outData);
    freeKmem(fd, (void **)&hmacRQ.cmpData);
        
        

    if (testfail)
        return -1;
        
    return 0;
}
