
/****************************************************************************
 * testDES.c - DES known-answer test for SEC2 device driver
 ****************************************************************************
 * Copyright (c) 2004-2005 Freescale Semiconductor
 * All Rights Reserved. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 ***************************************************************************/

/* Revision History:
 * 1.1.0 Dec 05,2004 sec - prep for linux-compatible driver release
 * 1.2   02-Feb-2005 sec - clean up test data types
 * 1.3   Aug 11,2005
 */


#include "Sec2.h"
#include "sec2drvTest.h"

#define DES_KEYSIZE     (24)
#define DES_CTXSIZE     (8)
#define DES_MAXTESTSIZE (4096)


static const unsigned char desData[] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde,
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0,
    0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01,
    0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12,
    0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23,
    0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34,
    0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45,
    0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56,
    0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
    0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78,
    0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89,
    0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
    0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab,
    0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc,
    0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd,
    0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde
};

static const unsigned char desKey[] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
    0xfe, 0xdc, 0xba, 0x98, 0x76, 0x54, 0x32, 0x10, 
    0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88 
};

static const unsigned char iv_in[] = "abcedf01";

static unsigned char desDecResult[DES_MAXTESTSIZE];
static unsigned char desEncResult[DES_MAXTESTSIZE];
static unsigned char desCtxOut[DES_CTXSIZE];


int testDes(int fd, int len, int times)
{
    DES_LOADCTX_CRYPT_REQ desencReq;
    DES_LOADCTX_CRYPT_REQ desdecReq;
    int status;
    int a, b;
    unsigned long encryptopId, decryptopId, keyBytes;
        
    status = 0;
    
    if (len > 4096)
    {
        printf("testDes(): test data size limit is %d\n", DES_MAXTESTSIZE);
        return(-1);
    }
    
    for (b=0; b < 2; b++) 
    {
        if (b == 0) 
        {
            printf("\n*** Test TDES CBC *** %d size %d times\n", len, times);
            encryptopId = DPD_TDES_CBC_CTX_ENCRYPT;
            decryptopId = DPD_TDES_CBC_CTX_DECRYPT;
            keyBytes = 24;
        }
        else
        {
            printf("\n*** Test SDES CBC *** %d size %d times\n", len, times);
            encryptopId = DPD_SDES_CBC_CTX_ENCRYPT;
            decryptopId = DPD_SDES_CBC_CTX_DECRYPT;
            keyBytes = 8;
        }
        
        for (a = 0; a < times; a++)
        {    
            memset(&desencReq, 0, sizeof(desencReq));
            memset(&desdecReq, 0, sizeof(desdecReq));
        
            memset(desDecResult, 0, len);
            memset(desEncResult, 0, len);
            memset(desCtxOut,    0, DES_CTXSIZE);
        
            desencReq.opId       = encryptopId;
            desencReq.inIvBytes  = DES_CTXSIZE;
            desencReq.keyBytes   = keyBytes;
            desencReq.outIvBytes = DES_CTXSIZE;
            desencReq.inBytes    = len;
            desencReq.inIvData   = (unsigned char *)iv_in;
            desencReq.keyData    = (unsigned char *)desKey;
            desencReq.inData     = (unsigned char *)desData;
            desencReq.outIvData  = desCtxOut;
            desencReq.outData    = desEncResult;
        
            status = putKmem(fd, (void *)desKey, (void **)&desencReq.keyData, desencReq.keyBytes);
            if (status)
                return status;
        
            status = putKmem(fd, (void *)desData, (void **)&desencReq.inData, desencReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                return status;
            }
        
            status = putKmem(fd, (void *)iv_in, (void **)&desencReq.inIvData, desencReq.outIvBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
                return status;
            }
        
            status = putKmem(fd, NULL, (void **)&desencReq.outIvData, desencReq.outIvBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
                freeKmem(fd, (void **)&desencReq.inIvData);
            }
        
            status = putKmem(fd, NULL, (void **)&desencReq.outData, desencReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
                freeKmem(fd, (void **)&desencReq.inIvData);
                freeKmem(fd, (void **)&desencReq.outIvData);
            }
            
            armCompletion(&desencReq);
            status = ioctl(fd, IOCTL_PROC_REQ, (int)&desencReq);
        
            if ((status = waitCompletion("testDes(): CBC encryption test", status, &desencReq)))
            {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
                freeKmem(fd, (void **)&desencReq.inIvData);
                freeKmem(fd, (void **)&desencReq.outIvData);
                freeKmem(fd, (void **)&desencReq.outData);
                return status;
            }
        
            getKmem(fd, desEncResult, (void **)&desencReq.outData, desencReq.inBytes);
            getKmem(fd, desCtxOut,    (void **)&desencReq.outIvData, desencReq.outIvBytes);
        
            freeKmem(fd, (void **)&desencReq.keyData);
            freeKmem(fd, (void **)&desencReq.inData);
            freeKmem(fd, (void **)&desencReq.inIvData);
            freeKmem(fd, (void **)&desencReq.outIvData);
            freeKmem(fd, (void **)&desencReq.outData);
        
        
            desdecReq.opId       = decryptopId;
            desdecReq.inIvBytes  = DES_CTXSIZE;
            desdecReq.outIvBytes = DES_CTXSIZE;
            desdecReq.keyBytes   = keyBytes;
            desdecReq.inBytes    = len;
            desdecReq.inIvData   = (unsigned char *)iv_in;
            desdecReq.keyData    = (unsigned char *)desKey;
            desdecReq.inData     = desEncResult;
            desdecReq.outData    = desDecResult;
            desdecReq.outIvData  = desCtxOut;
        
        
            status = putKmem(fd, (void *)desKey, (void **)&desdecReq.keyData, desdecReq.keyBytes);
            if (status)
                return status;
        
            status = putKmem(fd, desEncResult, (void **)&desdecReq.inData, desdecReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                return status;
            }
        
            status = putKmem(fd, (void *)iv_in, (void **)&desdecReq.inIvData, desdecReq.inIvBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
                return status;
            }
        
            status = putKmem(fd, NULL, (void **)&desdecReq.outIvData, desdecReq.inIvBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
                freeKmem(fd, (void **)&desdecReq.inIvData);
            }
        
            status = putKmem(fd, NULL, (void **)&desdecReq.outData, desdecReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
                freeKmem(fd, (void **)&desdecReq.inIvData);
                freeKmem(fd, (void **)&desdecReq.outIvData);
            }
        
        
            armCompletion(&desdecReq);
            status = ioctl(fd, IOCTL_PROC_REQ, (int)&desdecReq);
        
            if ((status = waitCompletion("testDes(): CBC decryption test", status, &desdecReq)))
            {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
                freeKmem(fd, (void **)&desdecReq.inIvData);
                freeKmem(fd, (void **)&desdecReq.outIvData);
                freeKmem(fd, (void **)&desdecReq.outData);
                return status;
            }
        
            getKmem(fd, desDecResult, (void **)&desdecReq.outData,   desdecReq.inBytes);
            getKmem(fd, desCtxOut,    (void **)&desdecReq.outIvData, desdecReq.inIvBytes);
        
            freeKmem(fd, (void **)&desdecReq.keyData);
            freeKmem(fd, (void **)&desdecReq.inData);
            freeKmem(fd, (void **)&desdecReq.inIvData);
            freeKmem(fd, (void **)&desdecReq.outIvData);
            freeKmem(fd, (void **)&desdecReq.outData);
        
        
            if ((memcmp(desData, desDecResult, len)) == 0) {
                printf("*** Test DES CBC Passed ***\n");
                status = 0;
            } else {
                printf("*** Test DES CBC Failed ***\n");
                status = -1;
            }
        } /* for a */
    
        printf("*** Test DES CBC Done ***\n");
    } /* for b */
    return status;
}



int testDesECB(int fd, int len, int times)
{
    DES_CRYPT_REQ desencReq;
    DES_CRYPT_REQ desdecReq;
    int           status;
    int           a, b;
    unsigned long encryptopId, decryptopId, keyBytes;
    

    status = 0;
    
    for (b=0; b < 2; b++) 
    {
        if (b == 0) 
        {
            printf("\n*** Test TDES ECB Mode *** %d size %d times\n", len, times);
            encryptopId = DPD_TDES_ECB_ENCRYPT;
            decryptopId = DPD_TDES_ECB_DECRYPT;
            keyBytes = 24;
        }
        else
        {
            printf("\n*** Test SDES ECB Mode *** %d size %d times\n", len, times);
            encryptopId = DPD_SDES_ECB_ENCRYPT;
            decryptopId = DPD_SDES_ECB_DECRYPT;
            keyBytes = 8;
        }
        

        for (a = 0; a < times; a++)
        {
            memset(&desencReq,   0, sizeof(desencReq));
            memset(&desdecReq,   0, sizeof(desdecReq));
            memset(desDecResult, 0, len);
            memset(desEncResult, 0, len);
        
            desencReq.opId     = encryptopId;
            desencReq.keyBytes = keyBytes;
            desencReq.inBytes  = len;
            desencReq.keyData  = (unsigned char *)desKey;
            desencReq.inData   = (unsigned char *)desData;
            desencReq.outData  = desEncResult;
        
        
            status = putKmem(fd, (void *)desKey, (void **)&desencReq.keyData, desencReq.keyBytes);
            if (status)
                return status;
        
            status = putKmem(fd, (void *)desData, (void **)&desencReq.inData, desencReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                return status;
            }
        
            status = putKmem(fd, NULL, (void **)&desencReq.outData, desencReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
            }
        
        
            armCompletion(&desencReq);
            status = ioctl(fd, IOCTL_PROC_REQ, (int)&desencReq);
        
            if ((status = waitCompletion("testDes(): CBC encryption test", status, &desencReq)))
            {
                freeKmem(fd, (void **)&desencReq.keyData);
                freeKmem(fd, (void **)&desencReq.inData);
                freeKmem(fd, (void **)&desencReq.outData);
                return status;
            }
        
            getKmem(fd, desEncResult, (void **)&desencReq.outData, desencReq.inBytes);
        
            freeKmem(fd, (void **)&desencReq.keyData);
            freeKmem(fd, (void **)&desencReq.inData);
            freeKmem(fd, (void **)&desencReq.outData);
        
            desdecReq.opId     = decryptopId;
            desdecReq.keyBytes = keyBytes;
            desdecReq.inBytes  = len;
            desdecReq.keyData  = (unsigned char *)desKey;
            desdecReq.inData   = desEncResult;
            desdecReq.outData  = desDecResult;
        
        
            status = putKmem(fd, (void *)desKey, (void **)&desdecReq.keyData, desdecReq.keyBytes);
            if (status)
                return status;
        
            status = putKmem(fd, desEncResult, (void **)&desdecReq.inData, desdecReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                return status;
            }
        
            status = putKmem(fd, NULL, (void **)&desdecReq.outData, desdecReq.inBytes);
            if (status) {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
            }
        
        
       
            armCompletion(&desdecReq);
            status = ioctl(fd, IOCTL_PROC_REQ, (int)&desdecReq);
        
            if ((status = waitCompletion("testDes(): CBC decryption test", status, &desdecReq)))
            {
                freeKmem(fd, (void **)&desdecReq.keyData);
                freeKmem(fd, (void **)&desdecReq.inData);
                freeKmem(fd, (void **)&desdecReq.outData);
                return status;
            }
        
            getKmem(fd, desDecResult, (void **)&desdecReq.outData, desdecReq.inBytes);
        
            freeKmem(fd, (void **)&desdecReq.keyData);
            freeKmem(fd, (void **)&desdecReq.inData);
            freeKmem(fd, (void **)&desdecReq.outData);
        
        
        
            if ((memcmp(desData, desDecResult, len)) == 0) {
                printf("*** Test DES ECB Passed ***\n");
                status = 0;
            } else {
                printf("*** Test DES ECB Failed ***\n");
                status = -1;
            }
        }
        printf("*** Test DES ECB Done ***\n");
    }
    
    return status;
}





