
/****************************************************************************
 * testAFHActx.c - ARC4 (with context I/O) known-answer test for SEC2 driver
 ****************************************************************************
 * Copyright (c) 2004-2005 Freescale Semiconductor
 * All Rights Reserved. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 ***************************************************************************/

/* Revision History:
 * 1.1.0 Dec 05,2004 sec - prep for linux-compatible driver release
 * 1.2   02-Feb-2005 sec - fix some type warnings, convert test data to const
 * 1.3   Aug 11,2005
 */


#include "sec2drvTest.h"
#include "Sec2.h"



/* test AFHA with full context */
/*
begin_descriptor:
    10700050             // Talitos2.0 Header (type: Common-A)
    0                            // Writeback value / Reserved

    0                                    // NIL (MDHA context-in size)
    0                                    // Extent0 field
    0                                    // NIL Pointer to MDHA context-in

    103                                  // 259dec (0x103) bytes (AFHA context-in size)
    0                                    // Extent1 field
    @q1                                  // Pointer to AFHA context-in

    0                                    // NIL (AFHA key size)
    0                                    // Extent2 field
    0                                    // NIL Pointer to AFHA key

    800                                  // 2048dec (0x800) bytes (AFHA data-in size)
    0                                    // Extent3 field
    @p3                                  // Pointer to AFHA data-in

    800                                  // 2048dec (0x800) bytes (AFHA data-out size)
    0                                    // Extent4 field
    @p4                                  // Pointer to AFHA data-out

    103                                  // 259dec (0x103) Bytes (AFHA context-out size)
    0                                    // Extent5 field
    @q5                                  // Pointer to AFHA context-out

    0                                    // NIL (sha256 hash data-out size)
    0                                    // Extent6 field
    0                                    // NIL pointer to sha256 hash data-out
*/

/* AFHA input context for a context-in/hash/context-out operation */
static const unsigned char inctx[] =
{
    0xb6, 0x4e, 0xb0, 0xb7, 0x6c, 0xf9, 0x9a, 0xbb,
    0x60, 0xf5, 0xd4, 0xe3, 0x8b, 0xbc, 0x26, 0xb1,
    0x12, 0x14, 0x57, 0x94, 0x20, 0x33, 0xf1, 0x32,
    0x1f, 0x29, 0x7b, 0x38, 0x16, 0x49, 0xa5, 0x05,
    0x2d, 0xa8, 0xa1, 0xf8, 0xd3, 0xff, 0x5a, 0xe1,
    0xfd, 0x75, 0x39, 0x7e, 0x15, 0x56, 0x96, 0x1a,
    0x84, 0x9b, 0x81, 0x0f, 0x19, 0x3b, 0xc5, 0x5c,
    0xee, 0x6b, 0xc1, 0x40, 0x4d, 0x5b, 0x65, 0xa7,
    0x9e, 0x54, 0xf7, 0x6a, 0x0e, 0x8e, 0x80, 0x2f,
    0x71, 0xbf, 0x59, 0x0c, 0x45, 0xa9, 0x03, 0xe2,
    0xec, 0x3c, 0x86, 0x85, 0x4b, 0x0d, 0x62, 0xb9,
    0x73, 0x1d, 0x63, 0x30, 0x92, 0xfb, 0x83, 0x95,
    0xd5, 0x93, 0xcb, 0x76, 0x67, 0xa2, 0x52, 0x5d,
    0x78, 0xb2, 0x31, 0x41, 0x7a, 0x70, 0x09, 0x8f,
    0xab, 0x69, 0x1c, 0x00, 0x3d, 0xa4, 0xe4, 0x22,
    0x02, 0x51, 0xbd, 0x8d, 0x99, 0xa0, 0x9f, 0x18,
    0x8a, 0xda, 0x7f, 0x7d, 0xc0, 0xf4, 0x9d, 0x8c,
    0xe9, 0x13, 0x88, 0x6f, 0xc2, 0x27, 0x55, 0xe8,
    0x17, 0xce, 0x2a, 0x0b, 0x25, 0xc3, 0x5e, 0xc9,
    0x28, 0xb5, 0x66, 0x5f, 0x90, 0xea, 0x36, 0x87,
    0x44, 0xd7, 0x43, 0xfc, 0x11, 0x2e, 0x1b, 0xca,
    0xd8, 0xaf, 0xb4, 0xe6, 0x46, 0x4c, 0xa3, 0x58,
    0xae, 0xf0, 0xd2, 0xbe, 0x77, 0xdd, 0xcc, 0xde,
    0xdc, 0x97, 0x9c, 0xe0, 0x91, 0x48, 0xd6, 0xd1,
    0x61, 0xef, 0xfa, 0x6d, 0xcf, 0xf3, 0xdb, 0x68,
    0x64, 0xfe, 0xf6, 0x79, 0x01, 0x23, 0x04, 0x82,
    0x2c, 0xba, 0x3e, 0x21, 0xb8, 0xa6, 0xdf, 0x2b,
    0x50, 0xd9, 0x98, 0x7c, 0x10, 0x3a, 0x4a, 0xed,
    0x34, 0x37, 0xc7, 0xc8, 0x89, 0xd0, 0xeb, 0x3f,
    0x53, 0x42, 0xe7, 0x06, 0xe5, 0x35, 0xb3, 0xcd,
    0xc4, 0x6e, 0x47, 0x4f, 0x1e, 0xac, 0x0a, 0x08,
    0xc6, 0x07, 0x74, 0x72, 0xf2, 0x24, 0xaa, 0xad,
    0x09, 0x03, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00
};       /* 0x103 Bytes */


static const unsigned char indata[] =
{
    0x9e, 0x93, 0xcd, 0xaa, 0x10, 0x18, 0xe1, 0xb2,
    0xf9, 0x93, 0x01, 0x97, 0x92, 0xb1, 0x55, 0xd6,
    0xb3, 0xfb, 0x02, 0x5d, 0x3d, 0xc2, 0x9b, 0x11,
    0xc8, 0x67, 0xb6, 0xbf, 0x98, 0x0e, 0x1b, 0x46,
    0xf9, 0x1f, 0xba, 0x14, 0x15, 0x9a, 0x04, 0xc9,
    0x65, 0xb5, 0xa3, 0x31, 0xc9, 0xb3, 0x50, 0x39,
    0x73, 0x7a, 0xb4, 0x3c, 0x97, 0xd3, 0x1c, 0x3c,
    0x2f, 0xd4, 0xe2, 0x57, 0xae, 0x69, 0x5f, 0x25,
    0xf6, 0x74, 0x41, 0x35, 0x6f, 0x7f, 0x0d, 0x6f,
    0x8d, 0x71, 0xce, 0x81, 0xae, 0x45, 0x8a, 0x1c,
    0x91, 0x3a, 0x9e, 0x33, 0x56, 0x71, 0x8c, 0xf5,
    0x4c, 0x71, 0x64, 0xbe, 0x6d, 0x8c, 0x50, 0xab,
    0xe6, 0x9f, 0x60, 0x1e, 0x74, 0x19, 0x37, 0xd0,
    0xfb, 0xcf, 0xa4, 0xc5, 0x2d, 0x96, 0xc4, 0xbc,
    0x8d, 0x02, 0xc8, 0x70, 0xbc, 0x69, 0xf3, 0x4a,
    0x54, 0x82, 0xed, 0xce, 0x2e, 0xa5, 0xf8, 0x74,
    0x74, 0x24, 0x2e, 0x18, 0x52, 0xb1, 0x54, 0xd7,
    0x91, 0x54, 0x63, 0x76, 0x0b, 0xcf, 0x55, 0x12,
    0x3f, 0x12, 0x56, 0x58, 0xe4, 0x82, 0xf0, 0xfc,
    0xd5, 0xc6, 0x47, 0x9c, 0x20, 0xd7, 0xfc, 0xd0,
    0xa4, 0xfc, 0xd9, 0xa4, 0x11, 0x8b, 0xcc, 0x25,
    0x87, 0xf5, 0x5f, 0x43, 0xe3, 0x12, 0x2c, 0xc8,
    0xd4, 0x20, 0x82, 0x87, 0xbf, 0x7b, 0xb6, 0x89,
    0xb4, 0x72, 0x51, 0x71, 0x4b, 0x40, 0x98, 0xcb,
    0xd1, 0x9d, 0xaa, 0x7c, 0x8b, 0xe1, 0xa4, 0x0e,
    0x6f, 0x27, 0x05, 0x11, 0x2b, 0x75, 0xd1, 0x47,
    0xd5, 0x5e, 0x9e, 0xd3, 0x19, 0x0b, 0x15, 0x24,
    0x2f, 0x34, 0x04, 0xd0, 0x91, 0xf2, 0x9f, 0x26,
    0xaf, 0xf1, 0xfd, 0x8f, 0x7b, 0xe5, 0x73, 0xa4,
    0x31, 0xd1, 0xd9, 0x00, 0x2d, 0x0a, 0x64, 0xab,
    0x22, 0x71, 0x17, 0x48, 0x91, 0xde, 0x71, 0xb8,
    0xd8, 0x30, 0x71, 0x75, 0xa9, 0xfc, 0x7c, 0x5a,
    0x48, 0x5d, 0x4b, 0x08, 0x6c, 0xc2, 0x6b, 0xb0,
    0x0f, 0x56, 0x79, 0x67, 0x0f, 0xd9, 0x9d, 0xcb,
    0xef, 0x7b, 0x6d, 0x2c, 0xa4, 0x9d, 0xc7, 0xea,
    0xa1, 0x04, 0xc0, 0x52, 0x24, 0x61, 0x34, 0x99,
    0xfe, 0xba, 0x21, 0x46, 0xc5, 0x9a, 0x56, 0xb0,
    0xa2, 0x8f, 0x98, 0xd5, 0xcb, 0xe2, 0xca, 0x36,
    0xcf, 0x11, 0x3c, 0xfb, 0xa3, 0xe4, 0xaf, 0x17,
    0xcb, 0xc5, 0x34, 0x92, 0x68, 0x1e, 0x62, 0xce,
    0x90, 0x5d, 0x26, 0xe3, 0xc4, 0x87, 0x96, 0xdd,
    0xdb, 0xcd, 0x05, 0x11, 0x38, 0x20, 0xd5, 0x2f,
    0xa7, 0x44, 0x37, 0x6a, 0xb9, 0x4d, 0x56, 0x51,
    0xf6, 0x03, 0x23, 0x99, 0xb7, 0x27, 0x3a, 0x9b,
    0x0e, 0x12, 0x19, 0xb0, 0x81, 0x9d, 0x25, 0x28,
    0x05, 0xd9, 0xa2, 0x1a, 0x01, 0x80, 0x3d, 0xb5,
    0xb6, 0x9a, 0x28, 0x67, 0xe7, 0x63, 0x81, 0x65,
    0x16, 0xbf, 0xfe, 0x02, 0x2a, 0x68, 0x87, 0x5a,
    0xe4, 0x1b, 0xd0, 0xb5, 0xe7, 0xe5, 0x93, 0x37,
    0xbe, 0xf6, 0x6e, 0x26, 0xa9, 0xeb, 0x19, 0x80,
    0x94, 0x15, 0xf2, 0x16, 0x09, 0xad, 0x8e, 0xd7,
    0x78, 0x7b, 0x4f, 0x9d, 0xb0, 0xc6, 0xad, 0x1c,
    0xd5, 0x33, 0x3c, 0x35, 0xbf, 0x62, 0x0c, 0x6b,
    0x02, 0xdd, 0x7d, 0xa4, 0x8e, 0x44, 0x19, 0xfb,
    0x30, 0x29, 0x90, 0xd3, 0xce, 0xab, 0x73, 0xe2,
    0xc1, 0x2a, 0xb6, 0x78, 0x11, 0x1f, 0xa8, 0xab,
    0xfd, 0x8f, 0x61, 0xa6, 0xa6, 0x0f, 0x50, 0xda,
    0x21, 0xbf, 0xfa, 0x3d, 0xe2, 0x61, 0x84, 0x4f,
    0xd0, 0xc8, 0x14, 0x35, 0xc3, 0xd2, 0xbc, 0x7b,
    0xef, 0x39, 0xec, 0xd5, 0xed, 0x44, 0x0c, 0x89,
    0xcf, 0xdb, 0x5f, 0xbb, 0x12, 0xdc, 0xb9, 0x58,
    0xc3, 0x46, 0x2d, 0xcd, 0xb4, 0x13, 0x3b, 0x58,
    0x16, 0x59, 0xa9, 0x08, 0x4a, 0x92, 0x91, 0x4e,
    0x57, 0x8f, 0xc1, 0x30, 0xbd, 0x05, 0x04, 0xf1,
    0x16, 0x39, 0x6c, 0x5d, 0x52, 0xb7, 0x3a, 0x69,
    0xeb, 0x92, 0x70, 0x6d, 0xe7, 0x23, 0xb4, 0xab,
    0xf6, 0xba, 0x92, 0x51, 0x9c, 0x50, 0xaf, 0xbe,
    0xa6, 0x88, 0x1f, 0x3a, 0xd0, 0x24, 0x54, 0xd4,
    0xf3, 0x44, 0xd7, 0xac, 0x8b, 0x80, 0x5a, 0x4f,
    0xf2, 0x3e, 0x38, 0x6c, 0x37, 0x50, 0x02, 0x98,
    0xc1, 0x45, 0x29, 0x4c, 0xcb, 0x6b, 0x6b, 0xe7,
    0xe1, 0xfa, 0x06, 0xde, 0x51, 0x5e, 0x57, 0xdc,
    0xe5, 0x11, 0x07, 0x02, 0xbb, 0x13, 0x3d, 0x01,
    0x89, 0x5b, 0x13, 0x50, 0x37, 0x54, 0xc8, 0x24,
    0x1f, 0xc6, 0xe1, 0x70, 0xc3, 0x39, 0xb3, 0x9e,
    0x66, 0x34, 0x8d, 0x41, 0x3d, 0x68, 0x02, 0x6c,
    0xbe, 0x2b, 0x7a, 0xed, 0xba, 0x40, 0x9c, 0x2f,
    0xb8, 0x72, 0xa4, 0xd7, 0x55, 0xdf, 0x4a, 0x0d,
    0x0d, 0x88, 0x46, 0x68, 0x46, 0x09, 0x0e, 0x6e,
    0xe8, 0xf8, 0xe7, 0xbc, 0x6d, 0xed, 0xdf, 0x9c,
    0xa7, 0x94, 0xc7, 0x3b, 0x36, 0xd3, 0xc8, 0x42,
    0xe2, 0x84, 0xa8, 0xfa, 0xd4, 0x99, 0x5d, 0xc8,
    0xe2, 0x49, 0xf7, 0x1a, 0xeb, 0x21, 0x97, 0x9b,
    0x77, 0x87, 0x5c, 0xe3, 0x92, 0x95, 0x14, 0x3f,
    0x27, 0xc8, 0x9e, 0xe8, 0xb3, 0x90, 0xac, 0x58,
    0xbf, 0x0d, 0xf5, 0xe8, 0xd1, 0x24, 0x71, 0x85,
    0x51, 0x3f, 0xb3, 0xa1, 0x28, 0xbf, 0x06, 0x22,
    0x77, 0x95, 0x4d, 0x81, 0x35, 0xf8, 0x5b, 0xdf,
    0x15, 0xbd, 0xc4, 0x31, 0x92, 0x2f, 0xc9, 0x4b,
    0x61, 0xfa, 0x78, 0x07, 0x40, 0x16, 0x8f, 0x2a,
    0x5d, 0x1c, 0x4b, 0x55, 0x46, 0x1b, 0xa7, 0xb4,
    0xa5, 0x4f, 0x31, 0x98, 0xb3, 0xad, 0x08, 0xbe,
    0xa7, 0xdb, 0x18, 0x83, 0x07, 0x63, 0x39, 0xaa,
    0x31, 0xb9, 0x34, 0xf5, 0xec, 0x01, 0x56, 0x52,
    0x67, 0x05, 0xa9, 0xc1, 0x66, 0x62, 0x61, 0xc1,
    0x17, 0x5a, 0x9b, 0x63, 0x47, 0x41, 0x06, 0xd5,
    0x67, 0x08, 0x90, 0x8a, 0x21, 0xd6, 0xad, 0xbc,
    0xee, 0x29, 0x45, 0x8a, 0x7c, 0x6d, 0xfc, 0x55,
    0x26, 0x9b, 0xd0, 0xab, 0x83, 0xbb, 0xb1, 0x6b,
    0x38, 0xd4, 0x32, 0x56, 0x01, 0x36, 0xd9, 0xd7,
    0x39, 0x9d, 0x3d, 0x26, 0xc5, 0x2d, 0x6f, 0x83,
    0xb5, 0xa3, 0xe2, 0xd5, 0x6a, 0xda, 0x54, 0x41,
    0xa9, 0xf4, 0xdb, 0x0f, 0x6f, 0x45, 0xae, 0x8d,
    0xcf, 0x54, 0xb7, 0x1b, 0xc7, 0x0a, 0x9e, 0x2f,
    0x57, 0x70, 0x44, 0x6f, 0xb4, 0x00, 0x61, 0xb6,
    0xf5, 0xfa, 0x57, 0x1e, 0x0a, 0xc1, 0xc3, 0xdb,
    0x58, 0xa2, 0xfd, 0x23, 0xd5, 0x16, 0x04, 0xbc,
    0xf9, 0xe5, 0x05, 0x95, 0x5c, 0x31, 0x09, 0xfc,
    0x56, 0xca, 0xe3, 0xb7, 0x82, 0xe1, 0xfc, 0xc4,
    0x77, 0x78, 0x08, 0xe1, 0x89, 0x94, 0x4b, 0xa2,
    0xf0, 0xab, 0x80, 0x52, 0x37, 0x3b, 0xf8, 0x44,
    0x2d, 0x0e, 0x09, 0xe0, 0x57, 0x18, 0x62, 0x1a,
    0x1f, 0x70, 0x72, 0x87, 0x9d, 0x5c, 0x53, 0xd7,
    0x5d, 0xdb, 0x71, 0xd7, 0xeb, 0xb8, 0x81, 0xcb,
    0x8c, 0x8d, 0xc7, 0x43, 0xee, 0xbc, 0x6b, 0x29,
    0x34, 0xcb, 0xcd, 0x4e, 0x28, 0x23, 0x91, 0x1b,
    0xf6, 0x9d, 0x60, 0xa0, 0x4d, 0xf3, 0x0e, 0xcc,
    0x20, 0x61, 0x29, 0xef, 0x0d, 0x90, 0x96, 0x46,
    0x97, 0x42, 0x4d, 0xd1, 0x2e, 0x98, 0xd0, 0x26,
    0x36, 0x94, 0x73, 0x6a, 0x17, 0xad, 0x0f, 0x47,
    0x78, 0x05, 0x33, 0xfa, 0xae, 0x21, 0x70, 0x3f,
    0x91, 0xb7, 0xdb, 0x50, 0xa1, 0x74, 0x52, 0xb5,
    0xdb, 0x38, 0xa4, 0x13, 0xfe, 0xc4, 0x35, 0xaf,
    0xb0, 0x54, 0x33, 0xf6, 0x44, 0x0e, 0xf0, 0xa2,
    0x96, 0xd2, 0x88, 0xc6, 0xb8, 0x57, 0x52, 0x7b,
    0xd8, 0x0a, 0x4d, 0x58, 0x35, 0xb4, 0x15, 0x7a,
    0x76, 0x56, 0x77, 0x55, 0x45, 0x2f, 0x41, 0xf1,
    0x76, 0x71, 0x5d, 0xef, 0xa8, 0x90, 0xe1, 0xe5,
    0x9c, 0xa9, 0x19, 0x6f, 0x39, 0x01, 0x26, 0x8c,
    0x79, 0xf9, 0x59, 0x9e, 0x2d, 0x99, 0xd5, 0xa9,
    0xdf, 0xfc, 0x89, 0x1c, 0xb9, 0xbf, 0x30, 0xd0,
    0xb7, 0xc9, 0x5a, 0x87, 0x13, 0x77, 0x26, 0x83,
    0x2d, 0xa5, 0xb2, 0x93, 0xd6, 0x80, 0xf5, 0x30,
    0x4b, 0x9f, 0xf6, 0xf1, 0xc5, 0x62, 0x23, 0x10,
    0xe6, 0x03, 0xb4, 0x24, 0xee, 0x54, 0xd7, 0xe7,
    0xf6, 0xb1, 0xab, 0x29, 0x2d, 0x01, 0x98, 0xa5,
    0x45, 0x59, 0x3c, 0x0d, 0x0e, 0x2f, 0x62, 0xdf,
    0x80, 0x8d, 0x32, 0x5a, 0x12, 0x49, 0x27, 0x35,
    0xb3, 0xb7, 0xeb, 0x63, 0x4e, 0xc3, 0xa7, 0x8b,
    0x13, 0xf6, 0xe8, 0x77, 0x76, 0x61, 0xac, 0x2d,
    0x35, 0xd1, 0xb3, 0xec, 0x37, 0x61, 0xa5, 0xca,
    0xa1, 0xcb, 0x2e, 0x15, 0xfd, 0x7e, 0x9f, 0x56,
    0xc3, 0xe2, 0x39, 0x06, 0x1c, 0xda, 0xa3, 0xc6,
    0x41, 0xdf, 0xc3, 0x4d, 0x47, 0xc4, 0x6f, 0xb4,
    0xaa, 0x90, 0x31, 0x7c, 0x7f, 0x60, 0x92, 0xd7,
    0x8f, 0xdd, 0x29, 0x9a, 0x4f, 0x29, 0xe5, 0x69,
    0xee, 0xc3, 0xc0, 0x71, 0x70, 0x61, 0x6a, 0x5f,
    0x0e, 0x29, 0x04, 0xbd, 0xcf, 0x50, 0x84, 0x8e,
    0xa7, 0x91, 0xe1, 0x3c, 0xec, 0x6e, 0x90, 0xa9,
    0x83, 0xbb, 0x77, 0x99, 0xa0, 0x6b, 0xe7, 0x1c,
    0x64, 0x12, 0xbc, 0x43, 0x3e, 0x16, 0x31, 0xce,
    0x5e, 0x08, 0x8a, 0x14, 0x17, 0x1f, 0x26, 0xc3,
    0x87, 0x48, 0x0d, 0xe3, 0x5d, 0xc6, 0xa3, 0x95,
    0x0f, 0xd6, 0x85, 0xf7, 0x66, 0x5c, 0x2e, 0xd4,
    0xab, 0xfc, 0x7e, 0x4e, 0x50, 0xad, 0xc6, 0x4b,
    0x6f, 0x2a, 0x51, 0xd2, 0xfe, 0x46, 0x28, 0x18,
    0xfd, 0xa1, 0x11, 0x66, 0x88, 0x9a, 0x64, 0xac,
    0x1c, 0x19, 0xd8, 0xd5, 0xed, 0x0e, 0xd7, 0xb1,
    0xa3, 0x2c, 0x72, 0xa1, 0x47, 0xd8, 0x8e, 0xbf,
    0xd7, 0xb4, 0x67, 0xb4, 0x3f, 0xd2, 0xf7, 0x03,
    0x16, 0xfe, 0x65, 0xeb, 0xfa, 0x16, 0x04, 0xb6,
    0xea, 0xe3, 0x0c, 0x88, 0x5b, 0x86, 0x9d, 0x87,
    0x83, 0xbf, 0x1b, 0x81, 0x9e, 0x3d, 0x88, 0xcf,
    0x83, 0x46, 0xf6, 0xad, 0x68, 0xc8, 0x97, 0xb7,
    0x32, 0x3d, 0x97, 0xd4, 0x1c, 0x59, 0x4c, 0x34,
    0x14, 0x11, 0xd6, 0xa0, 0xa9, 0xc7, 0xce, 0xe5,
    0xda, 0x4d, 0x12, 0x6a, 0xa8, 0x77, 0x49, 0xd7,
    0xb7, 0xf2, 0x3f, 0xe6, 0xe0, 0x24, 0xa3, 0x20,
    0x0e, 0xae, 0x50, 0xba, 0x29, 0x81, 0xa0, 0x5c,
    0x8a, 0xf0, 0x03, 0xe4, 0xad, 0xca, 0x52, 0x11,
    0x90, 0xe5, 0x0b, 0x12, 0x8f, 0x21, 0xfd, 0xeb,
    0x11, 0x48, 0x99, 0xc4, 0xea, 0xd9, 0x4f, 0xdd,
    0xbc, 0x1f, 0x4c, 0x6e, 0x39, 0x9f, 0xf7, 0x1f,
    0x95, 0x4e, 0x77, 0x54, 0x13, 0x7e, 0xa8, 0x08,
    0xe3, 0x10, 0xcf, 0x64, 0x54, 0xc5, 0x6d, 0xd7,
    0x86, 0x4d, 0x76, 0xe2, 0x9d, 0xd5, 0x66, 0x4b,
    0xa9, 0xd2, 0x62, 0xf8, 0x39, 0xbd, 0xe6, 0x24,
    0xd7, 0x69, 0x2f, 0x24, 0x5e, 0xcb, 0xe9, 0x80,
    0x6b, 0xca, 0x43, 0x86, 0xd1, 0xed, 0xf4, 0x1f,
    0x63, 0x7d, 0x5e, 0x12, 0xe8, 0xfc, 0x4d, 0x7a,
    0x98, 0x83, 0x82, 0x9a, 0xf0, 0xde, 0x94, 0xcc,
    0x4a, 0xfb, 0x40, 0xc5, 0xec, 0x93, 0xc4, 0xe8,
    0x17, 0x8f, 0x61, 0xd5, 0xb9, 0x17, 0x8a, 0xfd,
    0x4e, 0xce, 0xf2, 0x5e, 0x96, 0x2b, 0xfd, 0x35,
    0xa2, 0x66, 0xb2, 0xcd, 0xfc, 0xfd, 0xc3, 0x2f,
    0x3d, 0x37, 0xd6, 0xdd, 0xf0, 0xae, 0x81, 0x65,
    0x2e, 0x4b, 0x3b, 0xe7, 0x97, 0xb7, 0xba, 0x68,
    0x44, 0xaf, 0xeb, 0x0b, 0x44, 0x36, 0x0e, 0xfc,
    0x3d, 0x26, 0x11, 0x41, 0xd4, 0x0c, 0xce, 0x1c,
    0x5a, 0xc5, 0x36, 0x4d, 0x77, 0xeb, 0xfe, 0xd5,
    0x4e, 0x67, 0xfb, 0x88, 0xcc, 0x3e, 0xab, 0x0a,
    0x99, 0x04, 0x1b, 0x92, 0x6c, 0xe8, 0xa7, 0x0b,
    0x33, 0xe6, 0xd4, 0xdf, 0xc6, 0xf4, 0xa6, 0x1c,
    0xa2, 0xc8, 0xbd, 0x2a, 0x65, 0x15, 0xb5, 0xcf,
    0x71, 0xc2, 0xe6, 0xbc, 0x93, 0x12, 0x1c, 0x48,
    0xfb, 0x2a, 0x67, 0xa7, 0x5e, 0x09, 0x8f, 0x53,
    0xa6, 0x43, 0x4c, 0xc9, 0xf6, 0x99, 0xd4, 0x6e,
    0x6f, 0xd7, 0xe0, 0xc2, 0x75, 0xea, 0xb5, 0xa0,
    0xe4, 0xb4, 0x55, 0xc2, 0xfd, 0x8f, 0x61, 0x3d,
    0x70, 0xf7, 0xd2, 0x36, 0x43, 0x52, 0x21, 0x7e,
    0x13, 0x4e, 0xdf, 0x57, 0x65, 0xd5, 0x7b, 0x0b,
    0x73, 0x07, 0x2b, 0x9e, 0x3d, 0x24, 0xa5, 0x4f,
    0x4f, 0x0c, 0xbb, 0x0e, 0xf6, 0x0f, 0x67, 0xbd,
    0x54, 0xb9, 0x76, 0x5f, 0x19, 0x78, 0x50, 0xee,
    0x4c, 0x93, 0x0c, 0x1b, 0xe8, 0x7c, 0x53, 0xa2,
    0xb4, 0xdd, 0x43, 0x7d, 0x28, 0x73, 0xc5, 0x98,
    0xb1, 0x11, 0xa3, 0x4b, 0x3f, 0xdd, 0xb6, 0x55,
    0x5c, 0x36, 0x81, 0x80, 0xb9, 0x29, 0xa7, 0xbe,
    0x7c, 0x18, 0x68, 0xdc, 0x2d, 0x56, 0xaf, 0x9b,
    0x97, 0x5e, 0xe3, 0x55, 0x7a, 0x7f, 0xed, 0xf1,
    0x61, 0x83, 0xaf, 0x61, 0x72, 0x43, 0x6a, 0x47,
    0x96, 0xa9, 0x3d, 0x2b, 0xd4, 0x09, 0x4c, 0xbe,
    0x28, 0x55, 0xa2, 0x9d, 0xba, 0x26, 0x79, 0x17,
    0xd2, 0x02, 0xe2, 0x54, 0x51, 0xe8, 0x8d, 0x8b,
    0x0f, 0x99, 0x9b, 0x6b, 0x01, 0x7d, 0x39, 0x91,
    0x68, 0xc9, 0x0b, 0x29, 0xf2, 0xb3, 0xf8, 0x79,
    0x2a, 0x40, 0x83, 0x96, 0xee, 0xa7, 0x32, 0xeb,
    0x78, 0xba, 0x2d, 0xe3, 0x9e, 0x49, 0xac, 0x49,
    0xc1, 0x03, 0x38, 0xbe, 0x37, 0xc2, 0x71, 0xe6,
    0x8d, 0xc4, 0x63, 0x7f, 0x74, 0xbc, 0x02, 0x32,
    0xb4, 0x43, 0xe7, 0x38, 0xfe, 0x8b, 0xf2, 0xab,
    0xf2, 0xf0, 0xc7, 0xa0, 0x31, 0x30, 0xe9, 0xc9,
    0xd7, 0xe7, 0x72, 0xe8, 0x36, 0x41, 0xf7, 0xb2,
    0x1c, 0x3f, 0xd6, 0x68, 0x90, 0xb2, 0x52, 0xe0,
    0x53, 0x41, 0xc7, 0x2b, 0xfa, 0x7e, 0x6e, 0x9d,
    0x01, 0x86, 0xcd, 0x61, 0xab, 0x26, 0x7e, 0x62,
    0x09, 0xe6, 0x4b, 0xae, 0xf7, 0x1f, 0x4b, 0x19,
    0x81, 0x56, 0x0d, 0x57, 0x58, 0x19, 0x6e, 0x38,
    0xea, 0x97, 0x31, 0x52, 0xc7, 0x20, 0xed, 0xc0,
    0xbe, 0xd5, 0x74, 0x37, 0x8a, 0xaa, 0x39, 0x23,
    0x63, 0x19, 0xde, 0x0c, 0x4f, 0x7c, 0x7f, 0xf6,
    0x81, 0xa0, 0xc7, 0xf4, 0xb3, 0x6b, 0x71, 0xa1,
    0xb3, 0x18, 0x4a, 0xc4, 0x23, 0x0d, 0x53, 0xcd,
    0x9a, 0xae, 0x0a, 0x67, 0x22, 0x38, 0x81, 0xce,
    0x50, 0x0c, 0x5e, 0x37, 0xe5, 0x6d, 0x44, 0xdf,
    0x3c, 0x2b, 0xdf, 0x27, 0x62, 0x1f, 0x0f, 0x40,
    0x43, 0x10, 0x53, 0xd3, 0xa5, 0xd6, 0x18, 0x35,
    0x5f, 0x5b, 0xf0, 0x71, 0x9d, 0x3e, 0x57, 0xe5,
    0x8d, 0xc7, 0x15, 0x9c, 0x3e, 0x03, 0xdd, 0x1f,
    0x23, 0x7b, 0x45, 0x07, 0xfc, 0xa0, 0x93, 0xed,
    0x83, 0x40, 0xa0, 0x08, 0xba, 0x09, 0x4e, 0x1e,
    0x2d, 0x9d, 0xa6, 0x0c, 0x03, 0x24, 0x53, 0x9d,
    0x32, 0xcb, 0x65, 0xe0, 0xb1, 0x41, 0x2b, 0xb9,
    0x07, 0x8d, 0x01, 0xe7, 0xf3, 0x54, 0xe1, 0x3b,
    0xb8, 0xe5, 0xa2, 0x24, 0xa9, 0x24, 0x9e, 0x68,
    0x7e, 0xae, 0xc0, 0x26, 0x2d, 0x4c, 0xa3, 0xe3,
    0xad, 0x10, 0xca, 0xe1, 0x74, 0x28, 0xa0, 0x6a,
    0x0a, 0xd8, 0x34, 0x55, 0x8e, 0x96, 0x75, 0x73,
    0x7c, 0xb3, 0xdf, 0x1f, 0x90, 0xa3, 0x4c, 0xac,
    0x24, 0x3f, 0xeb, 0xe6, 0xd1, 0x0e, 0x10, 0x5e,
    0xc6, 0x03, 0xd7, 0xb3, 0x8e, 0xad, 0x4c, 0xa5,
    0xab, 0x4a, 0x17, 0x12, 0xed, 0xbb, 0x63, 0x97,
    0xc3, 0xd5, 0xf6, 0x2a, 0x66, 0xf9, 0x30, 0x3a,
    0x46, 0x79, 0xea, 0xad, 0x7a, 0xb9, 0xf9, 0x6a,
    0x9e, 0x8c, 0x36, 0xa2, 0xe2, 0xbf, 0xd3, 0x97,
    0xbf, 0x46, 0xfa, 0x18, 0x0b, 0x10, 0x56, 0x61
};     /* 2048 dec Bytes (0x800) */

static const unsigned char outdata[] =
{ 
    0x7e, 0x35, 0x8d, 0xef, 0xcb, 0x55, 0x59, 0x1f,
    0x8f, 0x3d, 0x95, 0x61, 0x96, 0x9b, 0xf5, 0xd3,
    0x24, 0x20, 0x49, 0xab, 0x38, 0x20, 0x3b, 0xd5,
    0x7f, 0xeb, 0x30, 0x27, 0x86, 0x9f, 0x44, 0x08,
    0xeb, 0x21, 0xfd, 0xfa, 0xea, 0x1f, 0xf7, 0x8a,
    0x50, 0xa8, 0x96, 0xbf, 0xc2, 0x27, 0x48, 0x52,
    0xe6, 0x78, 0xe8, 0x1f, 0x8e, 0x43, 0xd4, 0x7d,
    0xd1, 0x5d, 0x4d, 0x74, 0x4f, 0x51, 0x0a, 0x75,
    0x66, 0xde, 0xee, 0x7c, 0x84, 0x8a, 0xef, 0xfb,
    0x74, 0xe8, 0x5c, 0x56, 0xdb, 0x7b, 0xff, 0xd5,
    0xaa, 0x8d, 0xa7, 0xce, 0x11, 0x34, 0x78, 0x95,
    0xe7, 0x68, 0xd0, 0x7b, 0xed, 0x46, 0xd5, 0x75,
    0x1d, 0x82, 0xf2, 0xca, 0x16, 0x7f, 0x6b, 0xe1,
    0xae, 0x78, 0x74, 0x48, 0xc9, 0xa3, 0x7c, 0xea,
    0xe8, 0x10, 0x92, 0xf9, 0x9b, 0x87, 0x14, 0xae,
    0x55, 0xfe, 0x92, 0xb5, 0x26, 0x7c, 0xcb, 0x65,
    0x42, 0x5a, 0xbd, 0x14, 0x0e, 0xa0, 0x46, 0x95,
    0x71, 0x7a, 0xf4, 0x33, 0x31, 0xc8, 0x5e, 0x42,
    0x59, 0xc1, 0xd6, 0x0b, 0x8c, 0x75, 0x7e, 0xd5,
    0xac, 0xa9, 0xf8, 0xde, 0x6a, 0x13, 0x69, 0xff,
    0x29, 0x3f, 0x3b, 0xa3, 0x98, 0xc2, 0x39, 0x96,
    0x59, 0xbe, 0xfe, 0x44, 0x78, 0x77, 0x87, 0xcd,
    0x9f, 0x59, 0xa7, 0x15, 0xc2, 0x58, 0x24, 0x9e,
    0x00, 0x38, 0x97, 0x4e, 0x59, 0xeb, 0x0e, 0xe4,
    0x30, 0x6c, 0x47, 0x30, 0xf0, 0x8c, 0x3b, 0x27,
    0xbf, 0x72, 0x2a, 0x16, 0x93, 0x79, 0xb1, 0xad,
    0xcf, 0x19, 0xaf, 0x07, 0x80, 0x2d, 0xca, 0x95,
    0x92, 0x36, 0xa3, 0x4a, 0xd2, 0xea, 0xf7, 0x82,
    0xc5, 0xe8, 0x13, 0x3b, 0xf5, 0x84, 0x1b, 0xc7,
    0xff, 0xb1, 0x4f, 0xcd, 0x96, 0xa2, 0x0b, 0x34,
    0x99, 0x2c, 0xd7, 0x5f, 0x5d, 0xc3, 0x49, 0x1d,
    0x2f, 0x8c, 0x46, 0x7e, 0x63, 0xdf, 0x51, 0xe5,
    0x3e, 0x46, 0x35, 0x55, 0x27, 0x78, 0xca, 0xfc,
    0x46, 0xd9, 0x80, 0xcb, 0xfc, 0x65, 0x73, 0x3b,
    0x0b, 0xfe, 0xb5, 0x2d, 0xd2, 0xd0, 0x04, 0xcd,
    0xdd, 0x2f, 0x4d, 0x93, 0xc4, 0x12, 0x2d, 0x8f,
    0x27, 0x32, 0x50, 0x9b, 0x5d, 0x49, 0xd2, 0x2d,
    0x8c, 0xc7, 0xc3, 0xa1, 0xcf, 0xf7, 0xdf, 0x24,
    0x7c, 0xe3, 0x0c, 0xc0, 0x5c, 0x17, 0x9e, 0xe8,
    0x61, 0x73, 0xaf, 0xe3, 0x27, 0x18, 0xd8, 0x2e,
    0x5e, 0xc7, 0xe0, 0xd5, 0x74, 0x4c, 0x1d, 0x4e,
    0x4d, 0xe3, 0xc6, 0x01, 0x27, 0xf9, 0xf7, 0x9a,
    0xdf, 0x48, 0x65, 0xcb, 0x69, 0x18, 0xb8, 0x9d,
    0x88, 0xd7, 0x06, 0xb4, 0x3d, 0xea, 0xc3, 0xec,
    0x4a, 0x58, 0x01, 0x37, 0x09, 0x3a, 0xc9, 0xb0,
    0x76, 0x62, 0xd7, 0x6f, 0x30, 0x96, 0xda, 0xfe,
    0xc0, 0x80, 0xa6, 0x68, 0xfd, 0xbb, 0x21, 0xc1,
    0x01, 0x1f, 0x98, 0xcb, 0x8a, 0x97, 0x0f, 0x78,
    0xca, 0xda, 0x61, 0x7d, 0xe6, 0x5f, 0xa1, 0x5a,
    0x0a, 0xc6, 0x40, 0x86, 0x91, 0x6f, 0x51, 0x0d,
    0x50, 0x01, 0xda, 0x5f, 0x16, 0xa1, 0x3c, 0x9b,
    0xb7, 0xef, 0xd2, 0x00, 0x5b, 0x4a, 0x33, 0x38,
    0xdb, 0x3a, 0x25, 0x2d, 0xd0, 0xbc, 0x44, 0xe4,
    0x64, 0xb0, 0x1b, 0x3f, 0x4c, 0xcd, 0x26, 0x50,
    0xa4, 0xcd, 0x20, 0x2d, 0xe0, 0x44, 0x81, 0xcc,
    0x0e, 0xed, 0x36, 0x7e, 0xeb, 0x6f, 0x77, 0x56,
    0x11, 0xcf, 0x2e, 0x70, 0xa6, 0x86, 0x09, 0xff,
    0xc4, 0x60, 0x95, 0x1b, 0x9f, 0xad, 0x77, 0x1d,
    0x85, 0x97, 0xfd, 0x48, 0xd9, 0x88, 0x5e, 0xe8,
    0x25, 0x4f, 0x60, 0x22, 0x88, 0x44, 0x1f, 0x26,
    0xe8, 0xbd, 0x12, 0x33, 0x41, 0xf3, 0xb5, 0x29,
    0x28, 0x73, 0x16, 0x04, 0xb3, 0x94, 0x79, 0xbb,
    0xc2, 0xea, 0xf3, 0x4b, 0x4d, 0x02, 0xe6, 0x28,
    0x6e, 0xe7, 0xd7, 0x30, 0x58, 0xa9, 0xd9, 0x79,
    0x35, 0x9e, 0xe8, 0xae, 0xf3, 0xba, 0xa2, 0xac,
    0xe8, 0x95, 0xa9, 0xc6, 0x4a, 0x0d, 0x3c, 0x1a,
    0xd5, 0x4c, 0x30, 0x4e, 0x2f, 0xf1, 0xd7, 0x1b,
    0xd4, 0x69, 0xda, 0xae, 0x45, 0xa6, 0x83, 0xa5,
    0x41, 0x12, 0xce, 0x15, 0x33, 0x8d, 0x44, 0x19,
    0x5d, 0x71, 0x96, 0x2f, 0x80, 0x06, 0x8c, 0x2e,
    0x9f, 0xf4, 0xdb, 0xb7, 0x38, 0x93, 0x96, 0xee,
    0x12, 0x52, 0x62, 0x43, 0x34, 0x1e, 0x27, 0x43,
    0x34, 0x4e, 0x23, 0x92, 0x32, 0x0a, 0x7e, 0xdb,
    0x6a, 0xae, 0x83, 0x71, 0x8b, 0x8e, 0x85, 0x62,
    0x53, 0xf2, 0xc7, 0xc4, 0xde, 0x40, 0xde, 0x77,
    0x0a, 0x6a, 0x4b, 0x72, 0x12, 0x24, 0x76, 0xad,
    0x8d, 0x45, 0x2c, 0x49, 0xbc, 0xb5, 0xf9, 0x11,
    0x50, 0x70, 0xa2, 0xc4, 0x46, 0xcd, 0xef, 0x10,
    0x8c, 0xe6, 0x7f, 0xbf, 0x4a, 0xd6, 0xdc, 0x5c,
    0xaf, 0x3b, 0xfc, 0x46, 0xf9, 0x34, 0xfc, 0x89,
    0x8d, 0xf2, 0x32, 0xdb, 0x53, 0x63, 0x1e, 0x5b,
    0xb6, 0xb3, 0x22, 0x79, 0xb1, 0x71, 0x70, 0xd7,
    0xc1, 0x53, 0xd4, 0xf8, 0xdb, 0xd0, 0xcd, 0x46,
    0x39, 0x14, 0x3d, 0x85, 0x0c, 0x0d, 0x69, 0xe7,
    0x4c, 0x73, 0x8a, 0xc2, 0xd1, 0xaf, 0x3c, 0x0b,
    0xa8, 0x9f, 0x67, 0x8c, 0x56, 0xc6, 0x0c, 0xea,
    0xb8, 0x0b, 0x2e, 0x4e, 0x40, 0x37, 0x42, 0x19,
    0xf3, 0x96, 0x3a, 0xd5, 0x31, 0x2e, 0x6d, 0x4a,
    0x3e, 0x17, 0x0e, 0xd1, 0xdc, 0x09, 0xa4, 0x9c,
    0xae, 0x51, 0x12, 0xc1, 0x09, 0x21, 0xdf, 0x0b,
    0x2e, 0x77, 0xf1, 0xdc, 0xc5, 0x02, 0xdf, 0x9a,
    0x06, 0xcb, 0x32, 0xb4, 0xc6, 0xb3, 0x2f, 0x7c,
    0x6b, 0xab, 0xf0, 0x81, 0xd0, 0xd1, 0x37, 0xf7,
    0x11, 0xfa, 0x5c, 0xd8, 0xbc, 0xc4, 0x7b, 0xee,
    0x5c, 0x11, 0x58, 0xae, 0xad, 0x94, 0x6f, 0xcb,
    0x03, 0xe1, 0x61, 0x6f, 0xce, 0x38, 0xb2, 0xed,
    0x7a, 0x97, 0xcc, 0xe9, 0x48, 0x4b, 0xf5, 0x7b,
    0xfb, 0xe7, 0x47, 0x29, 0xbb, 0xd7, 0x7a, 0x5b,
    0xca, 0x41, 0xd2, 0x0f, 0x63, 0x56, 0x15, 0x77,
    0x71, 0x92, 0x75, 0x7a, 0xff, 0x12, 0xe7, 0xe0,
    0x82, 0x51, 0xa2, 0x8e, 0x97, 0xb3, 0x4f, 0x18,
    0x43, 0xa2, 0x1b, 0xbf, 0x86, 0xa9, 0x5e, 0x4b,
    0x64, 0xb4, 0xd3, 0x95, 0xdd, 0xe5, 0x35, 0x4c,
    0xb1, 0xc9, 0x76, 0xcc, 0x6e, 0x3f, 0xef, 0x4b,
    0xaa, 0xa7, 0x45, 0x55, 0xb3, 0x1a, 0x1c, 0x15,
    0x1a, 0x36, 0xae, 0x9e, 0x6c, 0x58, 0x00, 0xd3,
    0xff, 0x5a, 0x47, 0x6c, 0xc8, 0xe0, 0xa3, 0xb9,
    0x4a, 0xe3, 0x8d, 0x80, 0x04, 0x7b, 0x86, 0xb9,
    0xc3, 0xce, 0x83, 0x5e, 0x4e, 0x7b, 0x5b, 0xf5,
    0x8c, 0x5a, 0x18, 0x17, 0x27, 0x63, 0x85, 0xba,
    0x72, 0x58, 0x65, 0xe6, 0x49, 0x20, 0x49, 0xe8,
    0xcc, 0xa9, 0x37, 0xe9, 0x65, 0xc3, 0xfc, 0x1f,
    0xa7, 0x43, 0x8e, 0xb2, 0x58, 0x70, 0x3d, 0xcb,
    0x7b, 0x2f, 0x84, 0x14, 0x7d, 0x2f, 0x7e, 0x0e,
    0x96, 0x15, 0xb4, 0xd0, 0x90, 0x4e, 0xb7, 0x4e,
    0xf9, 0x56, 0xc9, 0x86, 0xc9, 0x42, 0xce, 0xc0,
    0x83, 0x0e, 0x44, 0x14, 0x93, 0x8e, 0xfc, 0x34,
    0x76, 0xe4, 0x91, 0xd2, 0xcf, 0x18, 0xff, 0xc8,
    0x40, 0x7e, 0x85, 0x92, 0x58, 0x99, 0x14, 0xb9,
    0x70, 0xfa, 0xcb, 0x6a, 0x21, 0x02, 0x6b, 0x34,
    0x72, 0x34, 0xd7, 0xff, 0x02, 0xc5, 0x24, 0xc2,
    0x36, 0x2e, 0xdb, 0x0a, 0x66, 0x8d, 0x9d, 0xd4,
    0x61, 0x54, 0x70, 0xd3, 0x5b, 0xf1, 0x71, 0xcd,
    0xc6, 0xa3, 0x71, 0xc7, 0x81, 0x99, 0xac, 0x93,
    0xca, 0x1e, 0xa4, 0x79, 0xf6, 0xef, 0xbe, 0x1c,
    0xf6, 0xc6, 0x58, 0x92, 0x94, 0x1e, 0x34, 0x45,
    0x57, 0xd9, 0x93, 0x1e, 0x64, 0xeb, 0x10, 0xd3,
    0x4e, 0xef, 0xa8, 0xef, 0x98, 0xcb, 0xae, 0xf8,
    0x1d, 0xb7, 0x70, 0xe5, 0xc2, 0x07, 0xb1, 0x08,
    0x30, 0x8f, 0x56, 0xb7, 0x8a, 0xce, 0x06, 0x6e,
    0xce, 0x84, 0x29, 0xb6, 0x9b, 0xf8, 0xad, 0x06,
    0x39, 0xe8, 0xb7, 0x0c, 0xc5, 0xe7, 0x42, 0x52,
    0xdf, 0xbc, 0xe9, 0xa4, 0x58, 0xea, 0x3c, 0x7a,
    0xd7, 0xc7, 0x21, 0x1d, 0xd2, 0x3d, 0x28, 0x67,
    0xf2, 0x0e, 0x3f, 0x6b, 0x26, 0xea, 0x42, 0xda,
    0xc3, 0xab, 0x7f, 0x95, 0x35, 0xcd, 0x0b, 0xe8,
    0xbe, 0x79, 0x0a, 0x29, 0x1c, 0x4e, 0x78, 0xac,
    0x01, 0x4d, 0x9e, 0x1e, 0x3f, 0xd7, 0xb4, 0xef,
    0x76, 0xb9, 0xe7, 0x2b, 0x18, 0x48, 0xfb, 0x1d,
    0xcf, 0xee, 0x02, 0x23, 0x7c, 0xb1, 0xbc, 0xdd,
    0xd2, 0xff, 0xd8, 0xa1, 0x4f, 0xd3, 0x9d, 0x09,
    0x27, 0x7f, 0x24, 0x92, 0x60, 0xbf, 0x2f, 0xb0,
    0xd2, 0x56, 0x1c, 0xc1, 0xa8, 0x07, 0xcd, 0x95,
    0x6d, 0xaa, 0xe9, 0x01, 0xae, 0x9b, 0xc1, 0xbb,
    0x2a, 0x66, 0xa5, 0xb7, 0x9a, 0xc3, 0xea, 0x49,
    0x4e, 0x6a, 0x34, 0x3f, 0xe4, 0x5f, 0x4c, 0x9e,
    0x21, 0x7d, 0xd2, 0xff, 0xcd, 0x3b, 0x82, 0xd1,
    0xae, 0xe2, 0x17, 0x39, 0x5b, 0x81, 0xb5, 0x17,
    0x33, 0xda, 0x1e, 0x10, 0x9f, 0x49, 0x66, 0x4f,
    0x9f, 0x0a, 0x9f, 0x92, 0x4a, 0xcd, 0x0e, 0x8c,
    0x68, 0x69, 0x74, 0xc1, 0xb3, 0x88, 0x4d, 0x22,
    0xbc, 0x59, 0xc1, 0xf0, 0xdb, 0x01, 0xa3, 0x6b,
    0x5c, 0x5f, 0x53, 0x60, 0xcf, 0x4f, 0x9d, 0xd5,
    0x18, 0x73, 0xab, 0x1e, 0xc8, 0x4d, 0x18, 0x7f,
    0xe1, 0x5f, 0x63, 0xd0, 0xf6, 0x57, 0xb9, 0x55,
    0x7a, 0x4e, 0xd7, 0x6b, 0x50, 0x47, 0xdd, 0xf5,
    0xe3, 0xee, 0x30, 0xda, 0x0d, 0x07, 0x58, 0x7b,
    0x2e, 0xab, 0x1c, 0x3f, 0x12, 0x40, 0x95, 0x7c,
    0x5c, 0xe1, 0xe5, 0x9a, 0xc1, 0xa5, 0x71, 0x6e,
    0xf3, 0x77, 0x1b, 0x7c, 0x45, 0x63, 0x2c, 0x7c,
    0xde, 0xb9, 0x20, 0xda, 0xb2, 0x56, 0xf4, 0x92,
    0xa3, 0xb8, 0x3f, 0x4a, 0x73, 0x67, 0xee, 0xb6,
    0x88, 0x70, 0x40, 0xee, 0x3e, 0xae, 0xe5, 0x68,
    0x53, 0x21, 0xbc, 0x59, 0x6b, 0x69, 0xa6, 0xdf,
    0x6b, 0x8a, 0x04, 0x26, 0x30, 0x9e, 0xe9, 0x24,
    0x2f, 0x0a, 0x1d, 0xa0, 0x42, 0xc9, 0x2c, 0x0a,
    0x49, 0xec, 0xa9, 0x5a, 0xab, 0x32, 0x27, 0x6f,
    0xb1, 0x1d, 0x6e, 0x28, 0xf7, 0x0e, 0x55, 0x85,
    0x37, 0xca, 0xda, 0x15, 0x6d, 0x42, 0x1d, 0xab,
    0xc6, 0x36, 0x6f, 0xb1, 0xa4, 0x79, 0x82, 0x33,
    0xf0, 0x22, 0x9b, 0x4c, 0xb7, 0xe9, 0x6a, 0xb1,
    0xa4, 0x09, 0x20, 0xc7, 0x53, 0x4b, 0xa2, 0x7b,
    0x0d, 0x5c, 0x02, 0xc0, 0x76, 0x86, 0xcb, 0xa2,
    0xe9, 0x5b, 0xe0, 0xca, 0x7a, 0xd4, 0xd2, 0x84,
    0x74, 0x13, 0x48, 0xe4, 0x8a, 0x18, 0xb4, 0x73,
    0x05, 0xd0, 0x90, 0xc1, 0x79, 0x97, 0x67, 0xb2,
    0xb0, 0xff, 0x14, 0x42, 0xb9, 0xd6, 0x13, 0x3c,
    0xf3, 0x44, 0x70, 0x50, 0xf6, 0x7c, 0x8c, 0xcb,
    0xbe, 0xd5, 0x2f, 0xa4, 0x71, 0x09, 0xe2, 0xde,
    0x6f, 0x08, 0x89, 0x42, 0x58, 0xfd, 0x58, 0xf7,
    0xf1, 0x9b, 0x55, 0x12, 0x56, 0x12, 0xae, 0x08,
    0x59, 0x00, 0x59, 0x9f, 0xfc, 0x13, 0x18, 0x31,
    0x81, 0xb1, 0x29, 0x62, 0x5d, 0x31, 0x6d, 0xfd,
    0xc4, 0xdb, 0x9e, 0x19, 0x1f, 0x1a, 0x39, 0x76,
    0x60, 0x43, 0xa3, 0x19, 0x1a, 0x09, 0x59, 0x96,
    0x3c, 0x0d, 0x54, 0x8a, 0x0d, 0xbd, 0xf9, 0xf6,
    0x08, 0x69, 0x56, 0x17, 0xcd, 0x9e, 0x29, 0x8c,
    0x86, 0x7a, 0x63, 0x19, 0x87, 0xe6, 0xf6, 0xac,
    0xaf, 0x72, 0x1c, 0x49, 0x55, 0x7f, 0x94, 0x79,
    0xc1, 0xc6, 0x43, 0xa4, 0x7f, 0xa7, 0x96, 0xb9,
    0x1a, 0xc5, 0x46, 0x78, 0xcf, 0x95, 0x88, 0xbb,
    0x04, 0x64, 0xfd, 0xb1, 0x59, 0xa8, 0xf8, 0x3a,
    0x0c, 0x0d, 0xff, 0xb5, 0x61, 0x3a, 0x67, 0x72,
    0xad, 0xe7, 0x1a, 0x1b, 0xe8, 0xd7, 0x12, 0x3b,
    0xbd, 0xf6, 0xd9, 0x89, 0x24, 0x7e, 0x57, 0x69,
    0x24, 0xf8, 0xbd, 0xe2, 0x75, 0x98, 0x77, 0x45,
    0x9d, 0x16, 0xe3, 0x07, 0xf8, 0xec, 0x8d, 0xb8,
    0x7b, 0x13, 0x1c, 0xca, 0xfc, 0x0e, 0x9d, 0x95,
    0x7e, 0xe8, 0x6f, 0x9e, 0xf3, 0x71, 0xa2, 0x7b,
    0xb7, 0x56, 0xff, 0xfa, 0x66, 0x98, 0xa8, 0x57,
    0x6d, 0xef, 0xff, 0x77, 0xa7, 0xfa, 0xde, 0x53,
    0x56, 0xef, 0x45, 0xaa, 0x36, 0x95, 0xf0, 0x96,
    0x25, 0x9d, 0xb2, 0x83, 0x80, 0xed, 0x04, 0xcf,
    0x8e, 0xcd, 0x60, 0xb4, 0x48, 0x60, 0xeb, 0x14,
    0xba, 0x5b, 0x3c, 0x2e, 0x87, 0x03, 0x22, 0x1b,
    0xab, 0x4a, 0x8f, 0x9b, 0xa1, 0x7d, 0xa0, 0xdd,
    0xf3, 0xea, 0x06, 0x07, 0x0d, 0xa6, 0x0a, 0x99,
    0xf5, 0x3a, 0x7a, 0x7d, 0x40, 0x6c, 0x2b, 0xcd,
    0xf3, 0x54, 0x96, 0x45, 0x6c, 0x23, 0x0c, 0x40,
    0xde, 0xb2, 0x52, 0x59, 0xf8, 0xe7, 0x53, 0xdc,
    0xf4, 0x90, 0x2d, 0xe7, 0x2e, 0x34, 0xf8, 0x7e,
    0x81, 0xc7, 0x82, 0x83, 0x10, 0xf7, 0x98, 0x4a,
    0x7b, 0x68, 0x5f, 0xb4, 0xc4, 0xe7, 0x47, 0x33,
    0xed, 0xf9, 0xb6, 0x9c, 0x69, 0x9f, 0x40, 0xc8,
    0x4b, 0xa6, 0x8b, 0x4d, 0xea, 0x73, 0x3b, 0x02,
    0xf0, 0x3a, 0x1d, 0x6e, 0xfd, 0x76, 0xbf, 0x66,
    0xe6, 0x86, 0x45, 0x0c, 0xae, 0x60, 0x42, 0xde,
    0xeb, 0xc0, 0x9e, 0x02, 0x92, 0x38, 0x39, 0xeb,
    0x40, 0x5e, 0xac, 0x2b, 0xbd, 0xe9, 0xa0, 0x2c,
    0x70, 0xcf, 0xe8, 0x37, 0x45, 0x3f, 0xb1, 0xfa,
    0x7e, 0xd8, 0x6d, 0x6f, 0xec, 0xcf, 0x8e, 0x4d,
    0xad, 0x29, 0x3c, 0x15, 0xcc, 0xa6, 0x30, 0x17,
    0xe0, 0x29, 0x4c, 0xe0, 0x82, 0x6e, 0x05, 0xb5,
    0x09, 0x37, 0x1a, 0xb1, 0xbc, 0x94, 0xf3, 0xbf,
    0x90, 0x38, 0xae, 0xb5, 0xca, 0xbe, 0xd8, 0x86,
    0x3a, 0xd5, 0x06, 0x95, 0xae, 0x2c, 0xc4, 0x0b,
    0x1a, 0x40, 0x02, 0xfc, 0x16, 0x08, 0x43, 0xe8,
    0x8d, 0x00, 0x85, 0xf5, 0xae, 0x5a, 0xee, 0x4d,
    0xd8, 0x61, 0xbd, 0x69, 0x06, 0x90, 0x68, 0xbc,
    0xd2, 0x9b, 0x40, 0x9e, 0xf2, 0x5f, 0x25, 0xdf,
    0x14, 0xd5, 0xc7, 0x9e, 0xef, 0xce, 0x2f, 0x35,
    0xed, 0xbc, 0x4a, 0x75, 0x5f, 0xcb, 0x54, 0xd7,
    0xce, 0xcc, 0x95, 0x42, 0x75, 0xa1, 0x92, 0x33,
    0xa8, 0xa7, 0x08, 0xb8, 0xbe, 0x21, 0x1f, 0xcf,
    0x34, 0x82, 0x1e, 0x36, 0xca, 0x27, 0xca, 0xde,
    0x0e, 0xff, 0x29, 0xc1, 0x25, 0x7b, 0x58, 0xd4,
    0x51, 0xcc, 0xf0, 0x77, 0x08, 0xb4, 0x83, 0xf6,
    0xe7, 0xe8, 0xde, 0x37, 0xb4, 0xc5, 0x3f, 0x93,
    0xd5, 0xdf, 0xf5, 0x22, 0xe1, 0xad, 0x8e, 0x79,
    0x10, 0xbc, 0xd4, 0xe3, 0x9f, 0x54, 0xd6, 0x5e,
    0xab, 0x02, 0xde, 0x0f, 0x50, 0xab, 0xf2, 0x35,
    0xa8, 0xc0, 0x01, 0x89, 0xd6, 0xcd, 0x46, 0xd9,
    0x14, 0xa7, 0x8c, 0x86, 0x15, 0xf8, 0x9c, 0xd6,
    0xac, 0x90, 0x81, 0xdd, 0x29, 0x81, 0x8d, 0x1f,
    0xce, 0xe9, 0xbe, 0x8e, 0xff, 0xf3, 0x52, 0x64,
    0x10, 0xa0, 0x94, 0x02, 0xd5, 0xa9, 0x8b, 0xc0,
    0xb1, 0xc4, 0x28, 0x01, 0x81, 0xd5, 0xe1, 0xd6,
    0x96, 0x19, 0x5f, 0xb0, 0x5b, 0xfd, 0x02, 0x7e,
    0x00, 0xe3, 0xb6, 0xb0, 0x7e, 0xe4, 0xee, 0xae,
    0x82, 0x16, 0x89, 0xd8, 0x33, 0xa2, 0x9c, 0x03,
    0xcb, 0x00, 0x08, 0x42, 0xc5, 0x18, 0xa1, 0xb0,
    0x8c, 0x60, 0x13, 0xcf, 0xbf, 0x8d, 0x15, 0xb2,
    0xa2, 0x00, 0xdc, 0x65, 0xec, 0xd4, 0x22, 0x34,
    0x53, 0x8b, 0x58, 0xaa, 0xb9, 0x18, 0xd4, 0x85,
    0x7e, 0x8c, 0x32, 0x63, 0xa4, 0x74, 0x0e, 0xec,
    0x05, 0x41, 0x7d, 0xa8, 0xc4, 0xe2, 0x9d, 0x40
};     /* 2048 dec Bytes (0x800) */

static const unsigned char outctx[] =
{
    0x9a, 0xf7, 0x5c, 0xfd, 0x64, 0x8e, 0x78, 0xac,
    0x42, 0x1f, 0x2a, 0xda, 0xd9, 0x6d, 0xb1, 0x59,
    0x33, 0xa9, 0x53, 0x00, 0xe9, 0xff, 0xdc, 0xcd,
    0x5d, 0xd8, 0x09, 0xca, 0x65, 0xe6, 0xc2, 0xf8,
    0x82, 0x73, 0x68, 0xee, 0x55, 0x51, 0x93, 0x9d,
    0x7c, 0xb0, 0x67, 0x1e, 0x6b, 0xf3, 0xb9, 0xe3,
    0xe0, 0x45, 0xd5, 0xb8, 0x58, 0x8c, 0x3b, 0x50,
    0x06, 0xaf, 0x8f, 0xba, 0xea, 0x8b, 0x54, 0xdb,
    0x0f, 0xbf, 0xa4, 0x0b, 0x08, 0xe8, 0xf1, 0x5b,
    0x89, 0x1c, 0x56, 0x90, 0x23, 0x04, 0x35, 0x38,
    0x46, 0xa5, 0x76, 0xd0, 0x20, 0xd3, 0xcf, 0xc9,
    0x77, 0xc7, 0x26, 0x8d, 0xdd, 0x48, 0x39, 0x74,
    0x79, 0xdf, 0xae, 0x91, 0x0e, 0x27, 0x1b, 0x5e,
    0xaa, 0x2d, 0x62, 0x37, 0xed, 0xc3, 0xb6, 0x30,
    0xd1, 0x0d, 0xd6, 0x75, 0xe1, 0xb3, 0x34, 0x71,
    0x36, 0x7f, 0x9e, 0x3f, 0x84, 0xf9, 0x6a, 0xc6,
    0x40, 0x70, 0x7d, 0x2b, 0xd7, 0xa3, 0x0c, 0x96,
    0xde, 0x3a, 0xec, 0x85, 0xab, 0xb4, 0xb2, 0x4f,
    0x25, 0xa1, 0x21, 0x98, 0x86, 0x7a, 0x0a, 0x2e,
    0x94, 0x49, 0x4b, 0xb5, 0xef, 0x1a, 0x07, 0x7b,
    0x7e, 0xc1, 0xcb, 0x03, 0xd2, 0x18, 0xc4, 0x99,
    0xce, 0x43, 0xc8, 0x95, 0x02, 0x11, 0x8a, 0x80,
    0x6c, 0x05, 0xbc, 0xc0, 0xf0, 0x01, 0xbb, 0x41,
    0xa6, 0x81, 0x2f, 0x3d, 0x57, 0x1d, 0x72, 0xf2,
    0xbd, 0x52, 0x22, 0xe7, 0x31, 0x28, 0x9f, 0xe2,
    0x17, 0x83, 0x3e, 0x16, 0x92, 0xe4, 0x4e, 0x2c,
    0x15, 0xfc, 0x13, 0xa2, 0x4d, 0xf4, 0xa8, 0xa0,
    0x12, 0xfa, 0xe5, 0xcc, 0x4c, 0xbe, 0x9c, 0x24,
    0x61, 0x5f, 0xc5, 0x87, 0xfb, 0x97, 0x32, 0xf6,
    0x9b, 0x4a, 0x63, 0x66, 0x10, 0xfe, 0xd4, 0xf5,
    0xb7, 0x47, 0x88, 0x69, 0xad, 0x44, 0xa7, 0x3c,
    0x6e, 0x29, 0x6f, 0x19, 0x60, 0xeb, 0x14, 0x5a,
    0x09, 0x37, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00
};


#define RC4_TESTSIZE (2048)
#define RC4_CTXSIZE  (259)

static unsigned char cmpdata[RC4_TESTSIZE], cmpctx[RC4_CTXSIZE];

int testAFHActx(int fd)
{
    int teststat, status;
    ARC4_LOADCTX_CRYPT_REQ rc4RQ;    
    
    
    status   = 0;
    teststat = 0;
    
    
    printf("\n*** AFHA context in/out test ***\n");

    /* Set up request block */
    memset(&rc4RQ, 0, sizeof(rc4RQ));

    rc4RQ.opId            = DPD_RC4_LDCTX_CRYPT_ULCTX;
    rc4RQ.inCtxBytes      = RC4_CTXSIZE;
    rc4RQ.inCtxData       = (unsigned char *)inctx;
    rc4RQ.inBytes         = RC4_TESTSIZE;
    rc4RQ.inData          = (unsigned char *)indata;
    rc4RQ.outData         = cmpdata;
    rc4RQ.outCtxBytes     = RC4_CTXSIZE;
    rc4RQ.outCtxData      = cmpctx;

    status = putKmem(fd, (void *)inctx, (void **)&rc4RQ.inCtxData, RC4_CTXSIZE);
    if (status)
        return status;
    
    status = putKmem(fd, (void *)indata, (void **)&rc4RQ.inData,  RC4_TESTSIZE);
    if (status) {
        freeKmem(fd, (void **)&rc4RQ.inCtxData);
        return status;
    }
    
    status = putKmem(fd, NULL, (void **)&rc4RQ.outData, RC4_TESTSIZE);
    if (status) {
        freeKmem(fd, (void **)&rc4RQ.inCtxData);
        freeKmem(fd, (void **)&rc4RQ.inData);
        return status;
    }

    status = putKmem(fd, NULL, (void **)&rc4RQ.outCtxData, RC4_CTXSIZE);
    if (status) {
        freeKmem(fd, (void **)&rc4RQ.inCtxData);
        freeKmem(fd, (void **)&rc4RQ.inData);
        freeKmem(fd, (void **)&rc4RQ.outData);
        return status;
    }

    
    armCompletion(&rc4RQ);
    status = ioctl(fd, IOCTL_PROC_REQ, (int)&rc4RQ);

    if ((status = waitCompletion("testAFHActx(): encryption test", status, &rc4RQ)))
    {
        freeKmem(fd, (void **)&rc4RQ.inCtxData);
        freeKmem(fd, (void **)&rc4RQ.inData);
        freeKmem(fd, (void **)&rc4RQ.outData);
        freeKmem(fd, (void **)&rc4RQ.outCtxData);
        return status;
    }
    
    getKmem(fd, cmpdata, (void **)&rc4RQ.outData,    RC4_TESTSIZE);
    getKmem(fd, cmpctx,  (void **)&rc4RQ.outCtxData, RC4_CTXSIZE);

    freeKmem(fd, (void **)&rc4RQ.inCtxData);
    freeKmem(fd, (void **)&rc4RQ.inData);
    freeKmem(fd, (void **)&rc4RQ.outData);
    freeKmem(fd, (void **)&rc4RQ.outCtxData);




    /* compare data */
    if (memcmp(cmpdata, outdata, RC4_TESTSIZE))
    {
        printf("AFHA context in/out output data compare failed\n");
        teststat = -1;
    }

    if (memcmp(cmpctx, outctx, RC4_CTXSIZE))
    {
        printf("AFHA context in/out output context compare failed\n");
        teststat = -1;
    }

    if (!teststat)
        printf("*** AFHA context in/out test passed ***\n");
    else
        printf("*** AFHA context in/out test failed ***\n");
        
    return(teststat);
}

