#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/skbuff.h>

#include <linux/cn_memmon.h>

static struct cb_id cn_memmon_id = { CN_IDX_MEMMON, CN_VAL_MEMMON };
static char cn_memmon_name[] = "cn_memmon";

#define CN_MEMMON_MSG_SIZE (sizeof(struct cn_msg))

void cn_memmon_callback(void *data)
{
	struct cn_msg *msg = (struct cn_msg *)data;
	struct memmon_info *args = NULL;
	struct mm_struct *mm;
	struct cn_msg *reply;
	__u8 buffer[CN_MEMMON_MSG_SIZE];
	int ret;
	struct task_struct *p;

	memset(buffer, 0, sizeof(buffer));

	args = (struct memmon_info *)msg->data;
#ifdef DEBUG
printk("cn_memmon_callback:\n");
printk("\tpid: %d\n", args->pid);
	switch (args->cmd) {
		case MONITOR_SET:
printk("\tcmd: MONITOR_SET\n");
			break;
		case MONITOR_CLR:
printk("\tcmd: MONITOR_CLR\n");
			break;
		case MONITOR_COLLECT:
printk("\tcmd: MONITOR_COLLECT\n");
			break;
		default:
printk("\tcmd: UNKNOWN\n");
	}
printk("\tflags: %c\n", args->flags);
printk("\tbufsize: %d\n", args->bufsize);
printk("\tbuf: %d\n", args->buf);
printk("\tstart: %d\n", args->start);
printk("\tend: %d\n", args->end);
printk("\toptions: %d\n", args->options);
if (args->options & CHECK_DIRTY_STATE) { printk("\t\tCHECK_DIRTY_STATE\n"); }
if (args->options & CHECK_FLAGS) { printk("\t\tCHECK_FLAGS\n"); }
if (args->options & STORE_MATCHING_PAGES) { printk("\t\tSTORE_MATCHING_PAGES\n"); }
if (args->options & CLEAN_STORED_PAGES) { printk("\t\tCLEAN_STORED_PAGES\n"); }
if (args->options & CLEAN_MATCHING_PAGES) { printk("\t\tCLEAN_MATCHING_PAGES\n"); }
if (args->options & STOP_WHEN_BUF_FULL) { printk("\t\tSTOP_WHEN_BUF_FULL\n"); }
if (args->options & CHECK_SWAPPED_STATE) { printk("\t\tCHECK_SWAPPED_STATE\n"); }
if (args->options & VALID_PAGES_ONLY) { printk("\t\tVALID_PAGES_ONLY\n"); }
#endif

	ret = -EINVAL;
	if (args->start > args->end)
		goto out;

	p = find_task_by_pid(args->pid);
	if (!p) {
		printk(KERN_ERR "memmon: invalid pid %d\n", args->pid);
		goto out;
	}
	mm = get_task_mm(p);
	if (!mm) {
		printk(KERN_ERR "memmon: no mm context\n");
		ret = -EFAULT;
		goto out;
	}

	switch (args->cmd) {
		case MONITOR_SET:
			ret = memmon_set_address_flags(mm, args);
			break;
		case MONITOR_CLR:
			ret = 0;
			memmon_clr_address_flags(mm, args);
			break;
		case MONITOR_COLLECT:
			ret = memmon_collect_data(mm, args);
			break;
	}
	mmput(mm);
out:
#ifdef DEBUG
printk("\tretval: %d\n", ret);
#endif
	reply = (struct cn_msg *)buffer;
        memcpy(&reply->id, &cn_memmon_id, sizeof(reply->id));
	reply->ack = ret;
	reply->len = 0;
	reply->seq = msg->seq;
	cn_netlink_send(reply, CN_IDX_MEMMON, GFP_KERNEL);
	return;
}

static int cn_memmon_init(void)
{
	int err;

	if ((err = cn_add_callback(&cn_memmon_id, cn_memmon_name, cn_memmon_callback))) {
		printk(KERN_WARNING "cn_memmon failed to register\n");
		return err;
	}
	return 0;
}

static void cn_memmon_exit(void)
{
	cn_del_callback(&cn_memmon_id);
}

module_init(cn_memmon_init);
module_exit(cn_memmon_exit);
