/*
 * (C) Copyright Nissin Systems 2008
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __MIFAXADP_RTC_H__
#define __MIFAXADP_RTC_H__

#undef CMOS_READ
#undef CMOS_WRITE
#undef RTC_SECONDS
#undef RTC_MINUTES
#undef RTC_HOURS
#undef RTC_DAY_OF_WEEK
#undef RTC_DAY_OF_MONTH
#undef RTC_MONTH
#undef RTC_YEAR
#undef RTC_FREQ_SELECT
#undef RTC_CONTROL
#undef RTC_INTR_FLAGS
#undef RTC_VALID
#undef RTC_SECONDS_ALARM
#undef RTC_MINUTES_ALARM
#undef RTC_HOURS_ALARM

#define CMOS_READ(addr) mifaxadp_rtc_read(addr)
#define CMOS_WRITE(val, addr) mifaxadp_rtc_write(val, addr)

#define RTC_SECONDS       0x00
#define RTC_MINUTES       0x01
#define RTC_HOURS         0x02
#define RTC_DAY_OF_WEEK   0x03
#define RTC_DAY_OF_MONTH  0x04
#define RTC_MONTH         0x05
#define RTC_YEAR          0x06
#define RTC_CONTROLREG    0x07
#define RTC_FREQ_SELECT   0x10
#define RTC_CONTROL       0x11
#define RTC_INTR_FLAGS    0x12
#define RTC_VALID         0x13
#define RTC_SECONDS_ALARM 0x14
#define RTC_MINUTES_ALARM 0x15
#define RTC_HOURS_ALARM	  0x16

#endif /* __MIFAXAD_RTC_H__ */
