#!/bin/sh
#
# zebra is the head of the quagga routing beast
#
# PROVIDE: zebra
# REQUIRE: NETWORKING
##

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/sbin:/usr/bin
export PATH

if [ -f /etc/rc.subr ]
then
	. /etc/rc.subr
fi

name="zebra"
rcvar=$name
required_files="/etc/${name}.conf"
command="/usr/sbin/${name}"
command_args="-d"

start_precmd="zebra_precmd"
stop_postcmd="zebra_postcmd"
socket_dir=/var
pidfile="${socket_dir}/${name}.pid"

zebra_precmd()
{
    mkdir -p "${socket_dir}"
    chown quagga.quagga "${socket_dir}"
    chmod 750 "${socket_dir}"
    rc_flags="$(
	set -- $rc_flags
	while [ $# -ne 0 ]; do
	    if [ X"$1" = X-P -o X"$1" = X-A ]; then
		break
	    fi
	    shift
	done
	if [ $# -eq 0 ]; then
	    echo "-P 0"
	fi
	) $rc_flags"
}

zebra_postcmd()
{
    if [ -d "${socketdir}" ]; then
        rmdir ${socketdir}
    fi
}

load_rc_config $name
run_rc_command "$1"
