#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "mifaxadp-dsphpi.h"

#define DSP_STARTADDR 0x0080
#define DSP_STARTOFF 0x00ff
#define DSP_ST1OFF 0x0021
#define WAIT_TIME 10

static int write_dspstartaddr(int fd)
{
	DSPHPI_REGS reg;

	reg.offset = DSP_STARTOFF;
	reg.value = DSP_STARTADDR;

	return ioctl(fd, DSPHPI_REG_SET, (unsigned int)&reg); 
}

static int dsp_start_waiting(int fd)
{
	int ret = 0;
	int retry = WAIT_TIME;
	DSPHPI_REGS reg;

	reg.offset = DSP_ST1OFF;

	do {
		ret = ioctl(fd, DSPHPI_REG_GET, (unsigned int)&reg);
		if (ret) {
			printf("dsphpi register read errror\n");
			break;
		}
		sleep(1);
	} while (reg.value != 1 && retry--);

	ret = -1;
	switch(reg.value) {
	case 0:
		printf("start waiting did timeout\n");
		break;
	case 1:
		ret = 0;
		break;
	case 2:
		printf("RAM check error\n");
		break;
	case 3:
		printf("SLIC power error\n");
		break;
	case 4:
	default:
		printf("unknown error 0x%x\n", reg.value);
		break;
	}

	return ret;
}

int start_dspimage(int fd_dsphpi)
{
	int ret;

	ret = write_dspstartaddr(fd_dsphpi);
	if (ret) {
		printf("startaddr cannot be written\n");
		return -1;
	}
	ret = dsp_start_waiting(fd_dsphpi);
	if (ret) {
		printf("start waiting is error.\n");
		return -1;
	}
	return 0;
}

int main(int argc, char *argv[])
{
	int ret = -1;
	int fd_dsphpi = -1;
	char *dsphpi_device = NULL;

	if (argc != 2) {
		printf("usage : %s [dsphpi device file]\n", argv[0]);
		goto err;
	}

	dsphpi_device = argv[1];

	fd_dsphpi = open(dsphpi_device, O_RDWR);
	if (fd_dsphpi == -1) {
		perror("open");
		goto err;
	}
	
	ret = start_dspimage(fd_dsphpi);
	if (ret) {
		printf("Failed in the start of dsp\n");
		goto err;
	}
	printf("Succeeded in the start of dsp\n");

err:
	if (fd_dsphpi >= 0) {
		close(fd_dsphpi);
	}

	return ret;
}
