#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>

#include "mifaxadp-dsphpi.h"

#define HEX_PREFIX "0x"
#define IS_SHORT(val) (SHRT_MIN <= val && val <= USHRT_MAX)

unsigned short dsphpi_read_register(int fd_dsphpi, unsigned int offset, int *err)
{
	DSPHPI_REGS reg;

	reg.offset = offset;

	*err = ioctl(fd_dsphpi, DSPHPI_REG_GET, (unsigned int)&reg);

	return reg.value;
}

unsigned short str_to_ushort(char *str, int *err)
{
	int base;
	long value;
	char *ep;

	if (!str || !err) {
		goto error;
	}

	if (strncmp(str, HEX_PREFIX, strlen(HEX_PREFIX)) == 0) {
		base = 16;
	} else {
		base = 10;
	}

	value = strtol(str, &ep, base);
	if (strncmp(ep, "", 1)) {
		goto error;
	}

	if (!IS_SHORT(value)) {
		goto error;
	}

	*err = 0;
	return (unsigned short)value;

error:
	*err = -1;
	return 0;
}

int main(int argc, char *argv[])
{
	int ret = -1;
	int fd_dsphpi = -1;
	char *dsphpi_device = NULL;
	unsigned int offset;
	unsigned short value;

	if (argc != 3) {
		printf("usage : %s [dsphpi device file] [register offset]\n", argv[0]);
		goto err;
	}

	dsphpi_device = argv[1];
	offset = str_to_ushort(argv[2], &ret);
	if (ret) {
		printf("[register offset] is an illegal value.\n");
		goto err;
	}

	fd_dsphpi = open(dsphpi_device, O_RDWR);
	if (fd_dsphpi == -1) {
		perror("open");
		goto err;
	}
	
	value = dsphpi_read_register(fd_dsphpi, offset, &ret);
	if (ret) {
		printf("Failed in reading in dsp.\n");
		printf(" register offset 0x%x\n", offset);
		goto err;
	}
	printf("register offset 0x%x value 0x%x\n", offset, value);

err:
	if (fd_dsphpi >= 0) {
		close(fd_dsphpi);
	}

	return ret;
}
